#!/bin/bash
#
# dm-finalize.sh
#
#    Finalization.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# load userful.keymap (disable kernel keyboard)
echo "`date +"%b %d %T"` $ProgramName: Load Userful keymap: /opt/userful/bin/userful.keymap" >>  $logfile
loadkeys /opt/userful/bin/userful.keymap 2>> $logfile

# Disable VT change
echo "`date +"%b %d %T"` $ProgramName: Disable VT change" >>  $logfile
/opt/userful/bin/vtlock -enable

# Add read permission for config files
if [[ -e /etc/usbinput ]]; then
    chmod 644 /etc/usbinput
fi
if [[ -e /etc/usbaudio ]]; then
    chmod 644 /etc/usbaudio
fi
if [[ -e /etc/multiuserdevices ]]; then
    chmod 644 /etc/multiuserdevices
fi
