#!/bin/bash
#
# dm-start-display-manager.sh
#
#    Start Display Manager based on DMTYPE and distro.
#
#    Copyright (c) 2005-2007 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# Called from: prefdm_multi
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# This is bug fix for locale problem in Educational Linux
if [[ -f /etc/default/locale ]]; then
    echo "`date +"%b %d %T"` [$ProgramName]: source locale" >> $logfile
    source /etc/default/locale 2>> $logfile
    while read line; do
        VARS_NAME=`echo $line | awk -F'=' '{print $1}'`
        export $VARS_NAME >> $logfile
    done < /etc/default/locale

    if [[ -f /etc/bash.bashrc ]]; then
        source /etc/bash.bashrc
    fi
    if [[ -f /etc/profile ]]; then
        source /etc/profile
    fi

    if [[ -f /root/.bashrc ]]; then
        source /root/.bashrc
    fi
    if [[ -f /root/.profile ]]; then
        source /root/.profile
    fi
fi

# Check the current configuration of Desktop Multiplier.
if [ -f /etc/userful/dm.conf ]; then
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
    source /tmp/dm.conf.tmp
fi
if [ "$DMTYPE" == "" ]; then
    DMTYPE="local"
fi

# Check current X type
if [ -f /etc/sysconfig/xtype ]; then
    source /etc/sysconfig/xtype
fi
if [ "$XTYPE" == "" ]; then
    XTYPE="SINGLE"
fi

echo "`date +"%b %d %T"` [$ProgramName]: Current XTYPE=$XTYPE, DMTYPE=$DMTYPE." >> $logfile

if [ "$XTYPE" == "MULTI" -a "$DMTYPE" == "auto" ]; then # Auto-Login session

    sleep 1
    exec /opt/userful/bin/userful-dm.sh auto

elif [ "$XTYPE" == "MULTI" -a "$DMTYPE" == "remote" ]; then # remote-Login session
    # Disable firewall
    # This may not be safe to disable firewall.
    if [ -f /etc/init.d/iptables ]; then
        /etc/init.d/iptables stop
    elif [ -f /etc/init.d/SuSEfirewall2_setup ]; then
        /etc/init.d/SuSEfirewall2_setup stop
    fi

    sleep 1
    exec /opt/userful/bin/userful-dm.sh remote

else # Nomal session

    # Check OSNAME, OSVER
    source /etc/userful/os-info

    if [ -f /etc/init.d/xdm.multi-save ]; then
        ### SuSE, Novell, JDS
		exec /etc/init.d/xdm.multi-save start

    elif [ -f /etc/init.d/kdm.multi-save ]; then
	    ### Xandros, Mepis ###
		exec /etc/init.d/kdm.multi-save start

    elif [ -f /etc/init.d/gdm.multi-save ]; then
	    ### Ubuntu, Linspire, Debian, Freespire, Dreamlinux
	    exec /etc/init.d/gdm.multi-save start

    elif [ -f /etc/init.d/xdm ]; then
        ### SuSE 10.2
		exec /etc/init.d/xdm start

    elif [ "$OSNAME" == "mandrake" ]; then
	    ### Mandrake ###
		exec /etc/X11/prefdm

    else
	    ### Fedora, Redhat, CentOS ###
		exec /etc/X11/prefdm -nodaemon
    fi

fi
