/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_ORSP.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_rspfile
su(bsystem): cmdline
ty(pe): L
sy(nopsis): 
sh(ort description): open a response file as input stream
he(ader files): 
lo(ng description): Opens a response file as input stream and create
	the necessary input stack item, but also makes sure that the
	current output stack item is a "large" one. If not, a new
	output stack item is created, which is associated to a file.
pr(erequistes): 
va(lue): 0: on failure --> the state is unchanged \item else: on success
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_orsp.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdio.h>
#endif
#include <portable.h>
#include <dynstr.h>
#include "supplio.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_ORSP.C 1.6 2001/02/27 01:28:04 ska Exp ska $";
#endif


int cfg_rspfile(struct Cfg_Getopt *optstru, const char * const file)
{	FILE *f;
	struct Cfg_oStackGetopt *p;

	DBG_ENTER("cfg_rspfile", Suppl_cmdline)

	assert(optstru);
	assert(C(_stk));
	assert(file);

	chkHeap
	if((f = Fxopen(file, "rt")) == 0)
		DBG_RETURN_I( 0)

	cfg_push(optstru);
	S(getArg) = f;
	S(getFct) = aF(cfg_rdFile);
	S(closeFct) = aF(cfg_clFile);

	chkHeap
	if(!C(_oHead) || !curOStk->C_large) {
		/* a response file might contain a great many number of arguments,
			to have some room, these arguments go into a temporary file */
		p = cfg_ostkNew();
		assert(p);
		cfg_ostkInitFile(p);
	}

	chkHeap
	DBG_RETURN_I( 1)
}
