/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_WSK.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_wrSetKey(const char * const name);
	int cfgi_wrSetCurKey(void);

 *	Modify the name of the section to be opened, when the output INI
 *	file is closed with success.
 *	"name" is duplicated into dynamic memory.
 *	SetCurKey() sets the currently opened section.

ob: cfgi_wrSetCurKey
ty: L
su: inifile/2
sh: Set the name of the section to be written
lo: Changes the name of the section that will be opened, when the INI
	file is successfully closed, to the current section.
re: cfgi_wrSetKey
fi: cfgi_wsk.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_WSK.C 1.4 2001/02/27 01:27:58 ska Exp ska $";
#endif

int cfgi_wrSetKey(const char * const name)
{	DBG_ENTER("cfgi_wrSetKey", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	if(name && (I(wrSection) = strdup(name)) == 0)
	 	DBG_RETURN_I( CFG_ERR_MEM)

	chkHeap
	DBG_RETURN_I( CFG_ERR_NONE)
}
int cfgi_wrSetCurKey(void)
{	DBG_ENTER("cfgi_wrSetCurKey", Suppl_inifile2)
	DBG_RETURN_BI( cfgi_wrSetKey(I(key)))
}
