/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICSEI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateSectionINI(char * section_name)

	create a new section within the currently opened INI file for writing.

	name == NULL is ignored; otherwise the name is not processed in
	any way, not even whitespaces are compressed.

ob(ject): cfgCreateSectionINI
su(bsystem): inifile/1
ty(pe): 
sy(nopsis): 
sh(ort description): Append a new section to an opened INI file
he(ader files): 
lo(ng description): Appends a new section to the already opened INI file.
	It is delimited by an empty line from the former section.
pr(erequistes): 
va(lue): 
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgicsei.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICSEI.C 1.4 1999/12/13 02:22:19 ska Exp ska $";
#endif

int cfgCreateSectionINI(const char * const section_name)
{	DBG_ENTER("cfgCreateSectionINI", Suppl_inifile1)

	if(!section_name)		DBG_RETURN_I( CFG_ERR_NONE)

	DBG_ARGUMENTS( ("name=\"%s\"", section_name) )

	if(!cfgi_ini)			DBG_RETURN_I( CFG_ERR_NOTOPEN)

	CFGI_NXTLINE

	chkHeap
	putc('\n', cfgi_ini);		/* separate two sections */

	putc('[', cfgi_ini);		/* identifier of section */
	fputs(section_name, cfgi_ini);	/* dump the name */
	putc(']', cfgi_ini);		/* close the section name */

	cfgi_nlwritten = 0;			/* mark to need a '\n' before next write */

	DBG_RETURN_I( CFG_ERR_NONE)
}
