/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIOS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgOpenSection(const char * const name);

	Open an existing section in both of the INI files.

ob(ject): cfgDynOpenSection
su(bsystem): inifile/3
sh(ort description): Open an existing section
lo(ng description): Open an existing section from any of the INI files.
	The passed section must be allocated within dynamic memory (heap)
	and is deallocated by \subsys{inifile/3} itself.
re(lated to): 
fi(le): cfgios.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIOS.C 1.4 2001/02/27 01:27:45 ska Exp ska $";
#endif

int cfgOpenSection(const char * const name)
{	char *secname;

	DBG_ENTER("cfgOpenSection", Suppl_inifile3)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	if(!name)	secname = 0;
	else if((secname = strdup(name)) == 0)
		DBG_RETURN_I( CFG_ERR_MEM)

	chkHeap
	DBG_RETURN_BI( cfgDynOpenSection(secname))
}


int cfgDynOpenSection(char * const secname)
{

	DBG_ENTER("cfgDynOpenSection", Suppl_inifile3)
	DBG_ARGUMENTS( ("name=\"%s\"", secname) )

		/* instruct opSec() to locate the section in both
			INI files */
	usrini.cfgi_avail =
	sysini.cfgi_avail = 0;

	DBG_RETURN_BI( cfgi_opSec(secname, 1))
}
