/*
   LABEL Create, modify or remove drive volume labels.
   Compile using Borland or Turbo C++.
   Copyright (C) 1994 Max Brante

   Version 1.3

   Modified by Joe Cosentino 2000.
   Modified by Brian E. Reifsnyder, August 2000.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


// D E F I N E S ////////////////////////////////////////////////////////////

#define VERSION "1.3"       //  Added the VERSION definition...BER

// I N C L U D E S //////////////////////////////////////////////////////////

#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int narg, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<narg;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

void error(int errnum)
{
    switch (errnum&0xFF)
	{
	case 0x00:
	    printf("Write protect error\n");
	    break;
	case 0x01:
	    printf("Unknown unit\n");
	    break;
	case 0x02:
	    printf("Drive not ready\n");
	    break;
	case 0x03:
	    printf("Unknown command\n");
	    break;
	case 0x04:
	    printf("Data error (bad CRC)\n");
	    break;
	case 0x05:
	    printf("Cannot label a network drive\n");
	    break;
	case 0x06:
	    printf("Seek error\n");
	    break;
	case 0x07:
	    printf("Unknown media type\n");
	    break;
	case 0x08:
	    printf("Sector not found\n");
	    break;
	case 0x0A:
	    printf("Write fault\n");
	    break;
	case 0x0B:
	    printf("Read fault\n");
	    break;
        case 0x0C:
            printf("General failure\n");
            break;

        } // end switch.

    exit(1);

} // end error.

/////////////////////////////////////////////////////////////////////////////

void usage()
{
    printf("\nLABEL Version %s\n",VERSION);  // Added...BER

    printf("Creates, changes or deletes the volume label of a disk.\n\n"
	   "LABEL [drive:][label]\n"
	   "  [drive:]  Specifies which drive you want to label\n"
	   "  [label]   Specifies the new label you want to label the drive\n");

} // end usage.

/////////////////////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
    char label[15], oldlabel[12], far *mdbptr, *fileargs[64], *optargs[64];
    unsigned char buf[512], ch, *dirent, buffer[512], sector_buffer[512];
    unsigned nument, serhi, serlo;
    int drive,haslabel=0,getlabel=1,savedlabel=0, result, nresult, n_options, n_files, jindex, help_flag=0;
    long dirstart,i,lsect;
    time_t timer;
    struct tm tblock;
    union REGS regs;

    int max_length=0,index=0; // BER

    n_options = classify_args(argc, argv, fileargs, optargs);
    for (jindex=0;jindex<n_options;jindex++)
        {
        if (optargs[jindex][0] == '?') help_flag=1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[jindex]));
            exit(1);
            } // end else.

        } // end for.

    if (help_flag)
        {
        usage();
        return 0;
        } // end if.

    // Changed label[] clearing routine...BER
    do
      {
      label[index]=0;
      index++;
      }while(index<15);

    if (argc == 1)
	drive=getdisk();     // Removed +'A' ...BER
    else if (argc == 2)
	{
	if (argv[1][1]==':' && strlen(argv[1])==2 && isalpha(argv[1][0]))
	    drive=toupper(argv[1][0])-'A';
	// Added the following "else if" to handle "label x:drivelabel"...BER
	else if (argv[1][1]==':' && strlen(argv[1])>2 && isalpha(argv[1][0]))
		 {
		 drive=toupper(argv[1][0])-'A';

		 index=0;
		 max_length=strlen(argv[1])-2;
		 if(max_length>11) max_length=11;

		 do
		   {
		   label[index]=argv[1][(index+2)];
		   index++;
		   }while(index<max_length);

		 getlabel=0;
		 }
	else if (argc==2)
	    {
	    memcpy(label,argv[1],11);
	    drive=getdisk()+'A';
	    getlabel=0;
	    } // end else.

	} // end else.
    else if (argc == 3)
	{
	if (argv[1][1]==':' && strlen(argv[1])==2 && isalpha(argv[1][0]))
	    drive=toupper(argv[1][0])-'A';
	else
	    {
	    printf("Syntax error\n");
	    exit(0);
	    } // end if.
	// Added the above lines to handle "label x: drive_label"...BER

	max_length=strlen(argv[2]);
	if(max_length>11) max_length=11;
	// Added the above lines to limit the maximum number of characters
	// copied below into label...BER

	strncpy(label,argv[2],max_length); // Changed to strncpy()...BER
	getlabel=0;
	} // end else.
    else
	{
	} // end else.

    // time() returns time of day in seconds, elapsed since 00:00:00 GMT,
    // January 1, 1970.
    timer = time(NULL);

    // localtime() converts date and time to a structure.
    memcpy(&tblock,localtime(&timer),sizeof(struct tm));

    // Get drive info.
    regs.h.ah=0x1c;
    regs.h.dl=drive+1;
    intdos(&regs,&regs);                // Generate a DOS interrupt.
    if (regs.h.al==0xFF)                // If drive not valid.
	error(2);

    // Check for write-protection and stop if it is.
    nresult = biosdisk(1, drive, 0, 0, 1, 1, sector_buffer);
    if (nresult == 3)
        {
        printf("Disk is write-protected\n");
        exit(0);
        } // end if.

    // Read boot record of logical disk.
    if (absread(drive,1,0,buf)==-1)
	error(errno);

    nument=*(unsigned *)&buf[0x11];     // Get number of root dir. entries.

    // Get the start block number of the root directory.
    dirstart=buf[0x10]*(*(unsigned *)&(buf[0x16]))+1;

    // Get volume serial number.
    serlo=*(unsigned *)&buf[0x27];
    serhi=*(unsigned *)&buf[0x29];

    // Loop through the entries in the root directory.
    for (i=0;i<nument*32;i+=32)
        {
        // If we crossed a block boundary, read next one.
        if ((i%512)==0)
	    {
            if (absread(drive,1,dirstart+i/512,buf)==-1)
                error(errno);

            drive=drive;
	    } // end if.

        // Point dirent at current entry in the root directory.
        dirent=&buf[i%512];

        // If first byte in directory entry is 0 no more entries.
        if (*dirent==0)
            break;

	// If volume label attribute is set, the label isn't deleted,
	// and the size is 0 we have found the volume label.
	if ((dirent[0x0B]&8)==8 && *dirent!=0xE5 && (dirent[0x0B])!=0x0F)
	// Changed the above line to make sure this isn't a LFN entry...BER
	    {
            // Get volume the label and the number of the block in which the
            // entry containing the label is.
            memcpy(oldlabel,dirent,11);
            oldlabel[11]=0;
            lsect=dirstart+i/512;
            haslabel=1;
            break;
            } // end if.

        } // end for.

    // If the user didn't enter a label on the command line, get one.
    if (getlabel)
        {
        if (haslabel)
	    printf("Volume in drive %c is %s\n",drive+'A',oldlabel);
        else
	    printf("Volume in drive %c has no label\n",drive+'A');

        printf("Volume Serial Number is %04X-%04X\n",serhi,serlo);
        printf("Volume label (11 characters, ENTER for none)? ");
	fgets(label,12,stdin);          // Changed to 12 to fix label
					// truncation bug...BER
	if (label[strlen(label)-1]=='\n')
	    label[strlen(label)-1]=0;

	} // end if.

    if ( (strlen(label)!=0) && (strlen(label)<11) )      // BER
	memset(&label[strlen(label)],32,11-strlen(label));

    strupr(label);
    if (getlabel && strlen(label)==0)   // If we didn't get a new label.
	{
	if (haslabel)
	    {
	    printf("\nDelete current volume label (Y/N)? ");
	    ch=tolower(getche());
	    if (ch=='y')
		{
		*dirent=0xE5;           // Delete the old label.
		if (abswrite(drive,1,lsect,buf)==-1)
		    error(errno);

		if (absread(drive,1,0,buf)==-1)
		    error(errno);

		// Change the label field in the boot block.
		memcpy(&buf[43],"NO NAME    ",11);
		if (abswrite(drive,1,0,buf)==-1)
		    error(errno);

		} // end if.

	    } // end if.

	} // end if.
    else
	{
	if (haslabel)           // If the volume had a old label, change it.
	    {
	    memcpy(dirent,label,11);
	    savedlabel=1;
	    } // end if.
	// The volume had no label so find a unused directory entry
	// and save the label.
	else
	    {
	    // Loop through the entries in the root directory.
	    for (i=0;i<nument*32;i+=32)
		{
		// If we crossed a block boundary, read next one.
		if ((i%512)==0)
		    {
		    if (absread(drive,1,dirstart+i/512,buf)==-1)
			error(errno);

		    drive=drive;
		    } // end if.

		// Point dirent at current entry in the root directory.
		dirent=&buf[i%512];

		// If the directory entry deleted or isn't used
		// and if the entry is not an LFN, save label there.
		if ( (*dirent==0xE5 || *dirent==0) && dirent[0x0B]!=0x0F)//BER
		    {
		    memset(dirent,0,32);
		    memcpy(dirent,label,11);
		    dirent[0x0B]=0x28;
		    lsect=dirstart+i/512;
		    savedlabel=1;
		    break;
		    } // end if.

		} // end for.

	    } // end else.

	if (savedlabel)
	    {
	    // Save the time and date of the change in the directory entry.
	    *(unsigned*)&dirent[0x16]=(tblock.tm_hour&31)<<11 | (tblock.tm_min&63)<<5 | (tblock.tm_sec&31);
	    *(unsigned*)&dirent[0x18]=((80-tblock.tm_year)&127)<<9 | ((1+tblock.tm_mon)&15)<<5 | (tblock.tm_mday&31);

	    // Write the directory entry to the volume.
	    if (abswrite(drive,1,lsect,buf)==-1)
		error(errno);

	    // Update the label field in the boot record.
	    if (absread(drive,1,0,buf)==-1)
		error(errno);

	    memcpy(&buf[43],label,11);
	    if (abswrite(drive,1,0,buf)==-1)
		error(errno);

	    } // end if.

	} // end else.

    return 0;

} // end main.
