/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_RWR.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfg_rspwr(struct Cfg_Getopt *optstru, FILE * const f
		, size_t len, char *buf)

	Write the next entry into the response file and terminate program
	on error

ob(ject): cfg_rspwr
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Write next entry into response output file
he(ader files): 
lo(ng description): Write the next entry into a response output file.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_rwr.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "supplio.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_RWR.C 1.7 1999/12/13 03:00:31 ska Exp ska $";
#endif

void cfg_rspwr(struct Cfg_Getopt * const optstru, FILE * const f
	, size_t len, const char * const buf)
{	DBG_ENTER("cfg_rspwr", Suppl_cmdline)

	assert(optstru);
	assert(f);
	assert(buf);

	Eput(&len, sizeof(len), f);
	Eput(buf, len, f);
	chkHeap

	DBG_EXIT
	/** Warning: opstru never used **/
}
