/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_NS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_nxtSec(FILE *fp, fpos_t * const pos)

	Skip to next section within this file
	If fp == NULL, the function always fails.
	On success the name of the section is returned in I(data).

	*pos is updated with position of the line actually read.

ob: cfgi_nxtSec
ty: L
su: inifile/2
sh: Skip to next section within the specified file
lo: Skips to the next section within the specified file.\par
	If \para{fp} == NULL, the function always fails.
	On success, the name of the next section is returned within
	\tok{cfgi_ini.data}.
re: 
fi: cfgi_ns.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_NS.C 1.5 2001/02/27 01:27:55 ska Exp ska $";
#endif

int cfgi_nxtSec(FILE * const fp)
{	DBG_ENTER("cfgi_nxtSec", Suppl_inifile2)

	if(!fp)			DBG_RETURN_BI( CFG_ERR_KEY)

	chkHeap
	I(value) = 0;	/* indicate there is no cur value */
	chkHeap

	do {
		chkHeap
		if(FFgetpos(fp, I(curpos)))
			DBG_RETURN_BI( CFG_ERR_ACC)
		chkHeap
		if(!StrRepl(I(buf), Fgetline(fp)))		/* out of memory */
			DBG_RETURN_BI( CFG_ERR_MEM)
		chkHeap
		if(!*I(buf))			/* EOF reached */
			DBG_RETURN_BI( CFG_ERR_KEY)
		chkHeap
	} while((I(data) = cfgi_isSection(I(buf))) == 0);
	chkHeap

	DBG_RETURN_BI( CFG_ERR_NONE)
}
