/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Test dfnfullpath() */

#include <stdio.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#endif
#define SUPPL_DBG_HEAP
#define SUPPL_LOG_MEMORY
#define SUPPL_LOG_FUNCTION
#include "suppldbg.h"

#include "dfn.h"

void hlpScreen()
{	exit(127);
}

void disp(char *fnam)
{	fputs(fnam, stdout);
	fputs(" = \"", stdout);
	if((fnam = dfnfullpath2(fnam)) == NULL)
		fputs("(null)", stdout);
	else {
		fputs(fnam, stdout);
		free(fnam);
	}
	puts("\"");
}

main(int argc, char **argv)
{
	if(argc > 1)
		for(argc = 0; argv[++argc];)
			disp(argv[argc]);
	else {
		disp(".");
		disp("c:.");
		disp("c:\\temp\\1\\.\\..");
	}
	return 0;
}
