/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.uml.xmi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMIEventWriter
extends PrintWriter
implements DocumentHandler,
ErrorHandler {
    protected int indentationLevel;
    private String indentationString = "  ";
    protected boolean complexElement = true;
    protected boolean textElement = false;
    protected boolean charPrinted = true;
    protected boolean nextEndElement = false;

    public String getIndentationString() {
        return this.indentationString;
    }

    public void setIndentationString(String arg) {
        this.indentationString = arg;
    }

    public void indent() {
        ++this.indentationLevel;
    }

    public void unindent() {
        --this.indentationLevel;
    }

    public void line(String ln) {
        this.sline(ln);
        this.println();
    }

    public void iline(String ln) {
        this.indent();
        this.line(ln);
    }

    public void uline(String ln) {
        this.unindent();
        this.line(ln);
    }

    public void ilineu(String ln) {
        this.iline(ln);
        this.unindent();
    }

    public void ulinei(String ln) {
        this.unindent();
        this.line(ln);
        this.indent();
    }

    public void sline(String s) {
        this.sline();
        this.print(s);
    }

    public void sline() {
        int i = 0;
        while (i < this.indentationLevel) {
            this.print(this.indentationString);
            ++i;
        }
    }

    private void printXMIChar(char ch) {
        switch (ch) {
            case '<': {
                this.print("&lt;");
                break;
            }
            case '>': {
                this.print("&gt;");
                break;
            }
            case '&': {
                this.print("&amp;");
                break;
            }
            case '\"': {
                this.print("&quot;");
                break;
            }
            case '\n': {
                this.println();
                break;
            }
            default: {
                this.print(ch);
            }
        }
    }

    protected void printXMIString(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.printXMIChar(s.charAt(i));
            ++i;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.sline("<?xml version=\"1.0\" encoding=\"");
        this.print("UTF-8");
        this.println("\"?>");
    }

    public void endDocument() throws SAXException {
        this.flush();
        this.close();
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        if (!this.complexElement) {
            this.print(">");
        }
        if (!this.charPrinted) {
            this.println();
        }
        if (this.textElement) {
            this.print("<");
        } else {
            this.sline("<");
        }
        this.print(name);
        int i = 0;
        while (i < atts.getLength()) {
            this.print(" ");
            this.print(atts.getName(i));
            this.print("=\"");
            this.printXMIString(atts.getValue(i));
            this.print("\"");
            ++i;
        }
        this.indent();
        this.complexElement = false;
        this.textElement = false;
        this.charPrinted = false;
        this.nextEndElement = false;
    }

    public void endElement(String name) throws SAXException {
        this.unindent();
        if (this.nextEndElement) {
            this.println();
        }
        if (this.complexElement) {
            if (this.textElement) {
                this.print("</");
            } else {
                this.sline("</");
            }
            this.print(name);
            this.print(">");
        } else {
            this.print("/>");
        }
        this.complexElement = true;
        this.textElement = false;
        this.charPrinted = false;
        this.nextEndElement = true;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.complexElement) {
            this.print(">");
        }
        int i = start;
        while (i < length) {
            this.printXMIChar(ch[i]);
            ++i;
        }
        this.complexElement = true;
        this.textElement = true;
        this.charPrinted = true;
        this.nextEndElement = false;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.complexElement) {
            this.print(">");
        }
        if (!this.charPrinted) {
            this.println();
        }
        this.print("<?");
        this.print(target);
        this.print(" ");
        this.print(data);
        this.print("?>");
        this.complexElement = true;
        this.textElement = true;
        this.charPrinted = false;
        this.nextEndElement = false;
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    protected String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public XMIEventWriter(Writer p_out) throws IOException {
        super(p_out);
        this.setIndentationString(System.getProperty("nsuml.xmiwriter.indentstring", "  "));
    }

    public XMIEventWriter(String p_filename, String p_encoding) throws IOException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(p_filename)), "UTF-8"));
    }

    public XMIEventWriter(String p_filename) throws IOException {
        this(p_filename, "UTF-8");
    }
}

