/////////////////////////////////////////////////////////////////////////////
// Name:        About.cpp
// Purpose:     About dialog
// Author:      Alex Thuering
// Created:     6.11.2003
// RCS-ID:      $Id: About.cpp,v 1.46 2009/02/25 19:40:57 ntalex Exp $
// Copyright:  (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "About.h"
#include <wxVillaLib/utils.h>
#include <wx/statline.h>
#include <wx/notebook.h>
#include <wx/hyperlink.h>
#include <wx/utils.h>
#include "rc/logo.png.h"

BEGIN_EVENT_TABLE(About, wxDialog)
	EVT_HTML_LINK_CLICKED(wxID_ANY, About::OnLinkClicked)
END_EVENT_TABLE()

About::About(wxWindow* parent): wxDialog(parent, -1, wxEmptyString,
		wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER) {
    // sets the application icon
    SetTitle(_("About ..."));
	
	wxNotebook* notebook = new wxNotebook(this, -1);
	wxPanel* aboutPanel = new wxPanel(notebook, -1);
	notebook->AddPage(aboutPanel, _("About"));
	wxBoxSizer* aboutSizer = new wxBoxSizer(wxVERTICAL);
	aboutPanel->SetAutoLayout(true);
	aboutPanel->SetSizer(aboutSizer);
	
    // about info
    wxGridSizer* aboutinfo = new wxFlexGridSizer(2, 3, 3);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Written by: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_MAINT), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Version: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_VERSION), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Licence type: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_LICENCE), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Copyright: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_COPYRIGHT), 1, wxEXPAND | wxALIGN_LEFT);

    // about title/info
    wxBoxSizer* abouttext = new wxBoxSizer(wxVERTICAL);
    wxStaticText* appname = new wxStaticText(aboutPanel, -1, APP_NAME);
    appname->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD));
    abouttext->Add(appname, 0, wxALIGN_LEFT);
    abouttext->Add(0, 10);
    abouttext->Add(aboutinfo, 1, wxEXPAND);

    // about icontitle//info
    wxBoxSizer* aboutpane = new wxBoxSizer(wxHORIZONTAL);
    wxBitmap bitmap = wxBITMAP_FROM_MEMORY(logo);
    aboutpane->Add(new wxStaticBitmap(aboutPanel, -1, bitmap), 0, wxALIGN_LEFT);
    aboutpane->Add(10, 0);
    aboutpane->Add(abouttext, 1, wxEXPAND);
	
    // about description
    aboutSizer->Add(aboutpane, 0, wxEXPAND | wxALL, 10);
    aboutSizer->Add(new wxStaticText(aboutPanel, -1,
	  _("DVDStyler is a crossplatform authoring system for Video DVD production.")),
	  0, wxALIGN_CENTER | wxLEFT | wxRIGHT, 10);
    aboutSizer->Add(0, 6);
    wxHyperlinkCtrl* website = new wxHyperlinkCtrl(aboutPanel, wxID_ANY, APP_WEBSITE, APP_WEBSITE);
    wxString url = APP_WEBSITE;
    website->SetURL(url);
    aboutSizer->Add(website, 0, wxALIGN_CENTER);
    
    // support
    wxHtmlWindow* supportPanel = new wxHtmlWindow(notebook, -1,
    		wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
    wxString page = wxT("<html><body>");
    page += wxT("<h5>") + wxString(_("Forum")) + wxT("</h5>");
    page += wxString::Format(_("Please use %sDVDStyler forum%s to get support, ask questions, or discuss this software."), wxT("<a href=\"http://sourceforge.net/forum/forum.php?forum_id=318795\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("<h5>") + wxString(_("WIKI")) + wxT("</h5>");
    page += wxString::Format(_("Some documentation and %sFAQ%s you can find in %sDVDStyler WIKI%s or you can publish there your comments or small guides."), wxT("<a href=\"http://dvdstyler.wiki.sourceforge.net/FAQ\" target=\"_blank\">"), wxT("</a>"), wxT("<a href=\"http://dvdstyler.wiki.sourceforge.net\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("<h5>") + wxString(_("Bugs & RFE")) + wxT("</h5>");
    page += wxString::Format(_("Please use %sSourceforge Bugtracing system%s to report bug and %sSourceforge RFE system%s to submit a new feature request."), wxT("<a href=\"http://sourceforge.net/tracker/?group_id=92301&atid=600266\" target=\"_blank\">"), wxT("</a>"), wxT("<a href=\"http://sourceforge.net/tracker/?group_id=92301&atid=600269\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("<h5>") + wxString(_("Mailinglists")) + wxT("</h5><p>");
    page += wxString::Format(_("There is a user mailing list which may also be used to get support. Use the Sourceforge %sDVDStyler-users mailing list%s page to subscribe to it."), wxT("<a href=\"http://lists.sourceforge.net/mailman/listinfo/dvdstyler-users\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("</p><p>");
    page += wxString::Format(_("To see the collection of prior postings to the list,visit the %sDVDStyler-users Archives"), wxT("<a href=\"http://sourceforge.net/mailarchive/forum.php?forum_id=36879\">")) + wxT("</a>.</p><p>");
    page += wxString::Format(_("To post a message to all the list members, send email to %s. Note: only list members can post messages."), wxT("<b>dvdstyler-users@lists.sourceforge.net</b>")) + wxT("</p>");

    page += wxT("</body></html>");
    supportPanel->SetPage(page);
    notebook->AddPage(supportPanel, _("Support"));
	
	// authors
	wxHtmlWindow* authorsPanel = new wxHtmlWindow(notebook, -1,
	  wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
	page = _T("<html><body>");
	page += _T("<table width='100%' cellspacing='1' cellpadding='0' border='0'>");
	
	page += _T("<tr><td colspan=3><b>");
	page += _("Author and Maintainer");
	page += _T("</b></td></tr>");
	page += _T("<tr><td width='16px'>&nbsp;</td><td colspan='2'>");
	page += _T("Alex Th&uuml;ring &lt;alex at thuering.biz&gt;");
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan='3'>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>");
	page += _("Doc Writer");
	page += _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td colspan='2'>");
	page += _T("Don Brett &lt;dlbrett at zoominternet.net&gt;");
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan='3'>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>");
	page += _("Packager (.deb)");
	page += _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td colspan='2'>");
	page += _T("Uwe Bugla &lt;uwe.bugla at gmx.de&gt;");
	page += _T("</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td colspan='2'>");
	page += _T("Fabrice Coutadeur &lt;coutadeurf at gmail.com&gt;");
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan='3'>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>");
	page += _("Translations");
	page += _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Czech</td><td width='100%'>Vlastimil Skácel &lt;vlastiks at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Danish</td><td width='100%'>Patrick Fust &lt;patrick_fust at hotmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>French</td><td width='100%'>Uwe Bugla</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>German</td><td>Alex Th&uuml;ring &lt;alex at thuering.biz&gt;, Uwe Bugla</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Greek</td><td>Aristotelis Pitaridis &lt;pitaridis at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Italian</td><td>Roberto Minotti &lt;khazad-dum at mail.orson.it&gt;, Paolo Rampino &lt;akir4d at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Korean</td><td>Jin-Hwan Jeon &lt;yongdoria at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Macedonian</td><td>Damjan Dimitrioski &lt;damjandimitrioski at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Polish</td><td>Michal Jusyk &lt;drewnozlasu at o2.pl&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Portuguese</td><td>Henrique Lopes Barone &lt;barone_henrique at yahoo.com.br&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Portuguese (Brazilian)</td><td>Henrique Lopes Barone &lt;barone_henrique at yahoo.com.br&gt;, Marco de Freitas &lt;marcodefreitas at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Russian</td><td>Alex Thuering &lt;alex at thuering.biz&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Slovenian</td><td>Martin Srebotnjak &lt;miles at filmsi.net&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Serbian</td><td>CICIC Ivana &lt;ozzii23 at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Spanish</td><td>Redy Rodriguez &lt;redy at telefonica.net&gt;, Fabrice Coutadeur &lt;coutadeurf at gmail.com&gt;</td></tr>");
	
	page += _T("<tr><td colspan='3'>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>");
	page += _("Libraries and Tools");
	page += _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>wxWidgets</td><td>Julian Smart, Robert Roebling and other</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>dvdauthor</td><td>Scott Smith</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>cdrtools</td><td>Joerg Schilling</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>dvd+rw-tools</td><td>Andy Polyakov</td></tr>");
	
	page += _T("</table>");
	page += _T("</body></html>");
	authorsPanel->SetPage(page);
	notebook->AddPage(authorsPanel, _("Authors"));
	
	// licence
	wxHtmlWindow* licencePanel = new wxHtmlWindow(notebook, -1,
	  wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
	page = _T("<html><body>");
	page += _T("<p>");
	page += _("DVDStyler is <a href='http://www.gnu.org/philosophy/free-sw.html'>free software</a> \
distributed under <a href='http://www.gnu.org/copyleft/gpl.html'>GNU General Public License (GPL)</a>. \
Please visit those sites for details of each agreement.");
	page += _T("</p>");
	page += _T("<p>");
	page += _("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, \
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, \
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS \
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, \
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR \
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
	page += _T("</p>");
	page += _T("</body></html>");
	licencePanel->SetPage(page);
	notebook->AddPage(licencePanel, _("Licence"));
	
	// buttons
	wxBoxSizer* totalpane = new wxBoxSizer(wxVERTICAL);
	totalpane->Add(notebook, 1, wxEXPAND|wxALL, 6);
    wxButton* okButton = new wxButton(this, wxID_OK, _("OK"));
    okButton->SetDefault();
    okButton->SetFocus();
    totalpane->Add(okButton, 0, wxALIGN_CENTER|wxLEFT|wxRIGHT|wxBOTTOM, 10);
	
    SetSizerAndFit(totalpane);
	Center();

    ShowModal();
}

void About::OnLinkClicked(wxHtmlLinkEvent& event) {
	wxLaunchDefaultBrowser(event.GetLinkInfo().GetHref());
}
