/////////////////////////////////////////////////////////////////////////////
// Name:        DonateDlg.cpp
// Purpose:     Donate dialog
// Author:      Alex Thuering
// Created:     20.04.2008
// RCS-ID:      $Id: DonateDlg.cpp,v 1.7 2009/07/22 06:36:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "DonateDlg.h"
#include <wx/hyperlink.h>
#include "Config.h"
#include <wxVillaLib/utils.h>
#include <wx/statline.h>

#define DONATE_LABEL wxT("http://www.dvdstyler.org")
#define DONATE_URL wxT("http://www.dvdstyler.org/donate.php")

DonateDlg::DonateDlg(wxWindow* parent) : wxPropDlg(parent) {
	SetTitle(_("DVDStyler Registration"));
	Create(false);
	SetSize(400, -1);
}

void DonateDlg::CreatePropPanel(wxSizer* sizer) {
	AddText(sizer, _("Development and maintaining DVDStyer requires a considerable"));
	sizer->Add(0, 6);
	AddText(sizer, _("amount of work and effort. Please make a donation to support"));
	sizer->Add(0, 6);
	AddText(sizer, _("continued development of DVDStyler!"));
	sizer->Add(0, 6);
	wxHyperlinkCtrl* website = new wxHyperlinkCtrl(this, -1, DONATE_LABEL, DONATE_URL);
	sizer->Add(website, 0, wxALIGN_CENTER);

	wxFlexGridSizer* grid = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
	grid->AddGrowableCol(1);
	sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
	AddCheckProp(grid, _("Do not show this message again"), false);
}

void DonateDlg::CreateButtonPane(wxSizer* sizer, bool resetButton, bool dontShowCheckbox) {
	wxBoxSizer* buttonPane = new wxBoxSizer(wxHORIZONTAL);
	buttonPane->Add(10, 10, 1, wxEXPAND);
	wxButton* okBt = new wxButton(this, wxID_OK, _("OK"));
	okBt->SetDefault();
	buttonPane->Add(okBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
	buttonPane->Add(10, 10, 1, wxEXPAND);
	sizer->Add(buttonPane, 0, wxEXPAND|wxLEFT|wxRIGHT|wxBOTTOM, 10);
}

bool DonateDlg::SetValues() {
	if (GetBool(0))
		s_config.SetKey(-50);
	return true;
}

int DonateDlg::ShowModal() {
	if (s_config.GetKey() < 7)
		return wxID_OK;
	return wxPropDlg::ShowModal();
}
