;-------------------------------------------------------------
; Script generated by the HM NIS Edit Script Wizard.
;
; Installer script for win32 EasyTAG (inspired of win32 Pidgin installer script
; Original Author: Jerome COUDERC <easytag@gmail.com>
;
; Install "NSIS 2.33" :
;         http://nsis.sourceforge.net/Download
; Install "HM NIS EDIT: A Free NSIS Editor/IDE"
;         http://prdownloads.sourceforge.net/hmne/nisedit2.0.3.exe?download
;
; Online documentation :
;        English : http://nsis.sourceforge.net/Docs/
;                  http://nsis.sourceforge.net/Docs/Modern%20UI/Readme.html
;                  http://forums.winamp.com/forumdisplay.php?s=&forumid=65
;        French  : http://www.veekee.net/wikinsis/docs/
;-------------------------------------------------------------

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME             "EasyTAG"
!define PRODUCT_VERSION          "2.1.5"
!define PRODUCT_PUBLISHER        "Jrme COUDERC"
!define PRODUCT_WEB_SITE         "http://easytag.sourceforge.net"
!define PRODUCT_DIR_REGKEY       "Software\Microsoft\Windows\CurrentVersion\App Paths\easytag.exe"
!define PRODUCT_UNINST_KEY       "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY  "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor /SOLID lzma
ShowInstDetails show
ShowUninstDetails show

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "Sections.nsh"
;!include "WinVer.nsh" ; Version of Windows used...

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_ICON                        ".\src\win32\nsis\easytag-install.ico"
!define MUI_UNICON                      "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico" ;".\pixmaps\EasyTAG.ico"

; Modern UI Configuration
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP_NOSTRETCH
!define MUI_HEADERIMAGE_BITMAP          ".\src\win32\nsis\easytag-header.bmp"
!define MUI_WELCOMEFINISHPAGE_BITMAP    ".\src\win32\nsis\easytag-install.bmp"
!define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH
!define MUI_UNWELCOMEFINISHPAGE_BITMAP  ".\src\win32\nsis\easytag-uninstall.bmp"


; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT      "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY       "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Version resource
VIProductVersion "0.0.0.0"
VIAddVersionKey "ProductName"     "${PRODUCT_NAME}"
VIAddVersionKey "FileVersion"     "${PRODUCT_VERSION}"
VIAddVersionKey "ProductVersion"  "${PRODUCT_VERSION}"
VIAddVersionKey "LegalCopyright"  ""
VIAddVersionKey "FileDescription" "${PRODUCT_NAME} Installer"

; Welcome page
!insertmacro MUI_PAGE_WELCOME

; License page
!insertmacro MUI_PAGE_LICENSE "./COPYING"

; Components page
!insertmacro MUI_PAGE_COMPONENTS

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER      "${PRODUCT_NAME}"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT      "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY       "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!define MUI_FINISHPAGE_RUN           "$INSTDIR\easytag.exe"
!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_SHOWREADME    "$INSTDIR\README.txt"
!define MUI_FINISHPAGE_LINK          "${PRODUCT_NAME} Web site"
!define MUI_FINISHPAGE_LINK_LOCATION "http://easytag.sourceforge.net"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "Afrikaans"
!insertmacro MUI_LANGUAGE "Albanian"
!insertmacro MUI_LANGUAGE "Arabic"
!insertmacro MUI_LANGUAGE "Basque"
!insertmacro MUI_LANGUAGE "Belarusian"
!insertmacro MUI_LANGUAGE "Bosnian"
!insertmacro MUI_LANGUAGE "Breton"
!insertmacro MUI_LANGUAGE "Bulgarian"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Croatian"
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Estonian"
!insertmacro MUI_LANGUAGE "Farsi"
!insertmacro MUI_LANGUAGE "Finnish"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Galician"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Greek"
!insertmacro MUI_LANGUAGE "Hebrew"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Icelandic"
!insertmacro MUI_LANGUAGE "Indonesian"
!insertmacro MUI_LANGUAGE "Irish"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Japanese"
!insertmacro MUI_LANGUAGE "Korean"
!insertmacro MUI_LANGUAGE "Kurdish"
!insertmacro MUI_LANGUAGE "Latvian"
!insertmacro MUI_LANGUAGE "Lithuanian"
!insertmacro MUI_LANGUAGE "Luxembourgish"
!insertmacro MUI_LANGUAGE "Macedonian"
!insertmacro MUI_LANGUAGE "Malay"
!insertmacro MUI_LANGUAGE "Mongolian"
!insertmacro MUI_LANGUAGE "Norwegian"
!insertmacro MUI_LANGUAGE "NorwegianNynorsk"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Romanian"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Serbian"
!insertmacro MUI_LANGUAGE "SerbianLatin"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "Slovak"
!insertmacro MUI_LANGUAGE "Slovenian"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "SpanishInternational"
!insertmacro MUI_LANGUAGE "Swedish"
!insertmacro MUI_LANGUAGE "Thai"
!insertmacro MUI_LANGUAGE "TradChinese"
!insertmacro MUI_LANGUAGE "Turkish"
!insertmacro MUI_LANGUAGE "Ukrainian"
!insertmacro MUI_LANGUAGE "Uzbek"
!insertmacro MUI_LANGUAGE "Welsh"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "easytag-${PRODUCT_VERSION}-setup.exe"
InstallDir "$PROGRAMFILES\EasyTAG"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY ; Open the language selection window
FunctionEnd


;------------------------------------
; EasyTAG executable install Section
;------------------------------------
Section "Program" SecProgram
  SectionIn 1 RO ; User can't remove it!
  
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "win32-install-dir\ChangeLog.txt"
  File "win32-install-dir\COPYING.txt"
  File "win32-install-dir\easytag.dll"
  File "win32-install-dir\easytag.exe"
  File "win32-install-dir\libogg-0.dll"
  File "win32-install-dir\libspeex-1.dll"
  File "win32-install-dir\libvorbis-0.dll"
  File "win32-install-dir\libvorbisfile-3.dll"
  File "win32-install-dir\libwavpack-1.dll"
  File "win32-install-dir\README.txt"
  File "win32-install-dir\README_win32.txt"

  ; Shortcuts
  ;!insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  ;CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  ;CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\EasyTAG ${PRODUCT_VERSION}.lnk" "$INSTDIR\easytag.exe"
  ;!insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

;------------------------------------
; EasyTAG shortcut install Section
;------------------------------------
SectionGroup /e "Shortcuts" SecShortcuts
  Section /o "Desktop" SecDesktopShortcut
    SetOverwrite on
    CreateShortCut "$DESKTOP\${PRODUCT_NAME} ${PRODUCT_VERSION}.lnk" "$INSTDIR\easytag.exe"
    SetOverwrite off
  SectionEnd
  
  Section "Start Menu" SecStartMenuShortcut
    SetOverwrite on
    !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
    CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
    CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\${PRODUCT_NAME} ${PRODUCT_VERSION}.lnk" "$INSTDIR\easytag.exe"
    !insertmacro MUI_STARTMENU_WRITE_END
    SetOverwrite off
  SectionEnd

  Section "Context Menu" SecContextMenuShortcut
    SetOverwrite on
    WriteRegStr HKCR "Directory\shell\EasyTAG"         "" "Browse with EasyTAG"
    WriteRegStr HKCR "Directory\shell\EasyTAG\command" "" '"$INSTDIR\easytag.exe" "%1"'
    SetOverwrite off
  SectionEnd
SectionGroupEnd


;------------------------------------
; Documentation install Section
;------------------------------------
Section "Documentation" SecDocumentation
  SetOutPath "$INSTDIR\documentation"
  SetOverwrite on
  File "doc\EasyTAG_Documentation*.html"
  File /r "doc\users_guide_*"

  ; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\EasyTAG Documentation.lnk" "$INSTDIR\documentation\EasyTAG_Documentation.html"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

;------------------------------------
; Translation install Section
;------------------------------------
Section "Translations" SecTranslations
  SetOutPath "$INSTDIR\locale"
  SetOverwrite on
  File /r "win32-install-dir\locale\"

  ; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\easytag.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\easytag.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecProgram}           "Main files"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDocumentation}     "Some documentation how to use the program"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecTranslations}      "Translation catalogs"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecShortcuts}         "Shortcuts to create"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDesktopShortcut}   "Create a shortcut to the program on the desktop"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecStartMenuShortcut} "Create a shortcuts in the start menu"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


;------------------------------------
; Uninstall Section
;------------------------------------
Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\ChangeLog.txt"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\easytag.dll"
  Delete "$INSTDIR\easytag.exe"
  Delete "$INSTDIR\libogg-0.dll"
  Delete "$INSTDIR\libspeex-1.dll"
  Delete "$INSTDIR\libvorbis-0.dll"
  Delete "$INSTDIR\libvorbisfile-3.dll"
  Delete "$INSTDIR\libwavpack-1.dll"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\README_win32.txt"
  RMDir /r "$INSTDIR\Documentation\" ; Remove all files in documentation directory...
  RMDir /r "$INSTDIR\locale\" 

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall ${PRODUCT_NAME}.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\EasyTAG ${PRODUCT_VERSION}.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\EasyTAG Documentation.lnk"

  Delete "$DESKTOP\EasyTAG ${PRODUCT_VERSION}.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  ; Delete "Browse with EasyTAG" context menu
  DeleteRegKey HKCR "Directory\shell\EasyTAG"

  ; Delete personnals settings?
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 \
             "Do you want to remove yours personnals settings?" IDYES deletesettings IDNO dontdeletesettings
  deletesettings:
    ; Get 'Application Data' user's directory
    ReadRegStr $R0 HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" "AppData"
    RMDir /r "$R0\.easytag"
  dontdeletesettings:

  SetAutoClose true
SectionEnd


;Function un.onUninstSuccess
;  HideWindow
;  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
;FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

