/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.policy.WSS4JPolicyToken;
import org.apache.ws.security.policy.WSS4JSupportingToken;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.AlgorithmSuite;
import org.apache.ws.security.policy.model.Header;
import org.apache.ws.security.policy.model.SignedEncryptedElements;
import org.apache.ws.security.policy.model.SignedEncryptedParts;
import org.apache.ws.security.policy.model.SupportingToken;
import org.apache.ws.security.policy.model.Token;
import org.apache.ws.security.policy.model.X509Token;

public class WSS4JPolicyData {
    private boolean symmetricBinding;
    private String layout;
    private boolean includeTimestamp;
    private boolean entireHeaderAndBodySignatures;
    private String protectionOrder;
    private boolean signatureProtection;
    private boolean tokenProtection;
    private boolean signatureConfirmation;
    private WSS4JPolicyToken encryptionToken;
    private WSS4JPolicyToken signatureToken;
    private WSS4JPolicyToken recipientToken;
    private WSS4JPolicyToken initiatorToken;
    private boolean signBody;
    private boolean encryptBody;
    private ArrayList signedParts;
    private ArrayList signedElements;
    private ArrayList encryptedParts;
    private ArrayList encryptedElements;
    private WSS4JSupportingToken supportingToken;
    private WSS4JSupportingToken signedSupportingToken;
    private WSS4JSupportingToken endorsingSupportingToken;
    private WSS4JSupportingToken signedEndorsingSupportingToken;

    public boolean isSymmetricBinding() {
        return this.symmetricBinding;
    }

    public void setSymmetricBinding(boolean symmetricBinding) {
        this.symmetricBinding = symmetricBinding;
    }

    public boolean isEntireHeaderAndBodySignatures() {
        return this.entireHeaderAndBodySignatures;
    }

    public void setEntireHeaderAndBodySignatures(boolean entireHeaderAndBodySignatures) {
        this.entireHeaderAndBodySignatures = entireHeaderAndBodySignatures;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getProtectionOrder() {
        return this.protectionOrder;
    }

    public void setProtectionOrder(String protectionOrder) {
        this.protectionOrder = protectionOrder;
    }

    public boolean isSignatureProtection() {
        return this.signatureProtection;
    }

    public void setSignatureProtection(boolean signatureProtection) {
        this.signatureProtection = signatureProtection;
    }

    public boolean isTokenProtection() {
        return this.tokenProtection;
    }

    public void setTokenProtection(boolean tokenProtection) {
        this.tokenProtection = tokenProtection;
    }

    public boolean isSignatureConfirmation() {
        return this.signatureConfirmation;
    }

    public void setSignatureConfirmation(boolean signatureConfirmation) {
        this.signatureConfirmation = signatureConfirmation;
    }

    public WSS4JPolicyToken getEncryptionToken() {
        if (this.encryptionToken == null) {
            this.encryptionToken = new WSS4JPolicyToken();
        }
        return this.encryptionToken;
    }

    public void setEncryptionToken(Token encToken, AlgorithmSuite suite) throws WSSPolicyException {
        if (encToken instanceof X509Token) {
            if (this.encryptionToken == null) {
                this.encryptionToken = new WSS4JPolicyToken();
            }
            WSS4JPolicyData.initializeWSS4JPolicyToken(this.encryptionToken, (X509Token)encToken, suite);
        }
    }

    public void setProtectionToken(Token protectionToken, AlgorithmSuite suite) throws WSSPolicyException {
        this.setEncryptionToken(protectionToken, suite);
        this.setSignatureToken(protectionToken, suite);
    }

    public WSS4JPolicyToken getSignatureToken() {
        if (this.signatureToken == null) {
            this.signatureToken = new WSS4JPolicyToken();
        }
        return this.signatureToken;
    }

    public void setSignatureToken(Token sigToken, AlgorithmSuite suite) throws WSSPolicyException {
        if (sigToken instanceof X509Token) {
            if (this.signatureToken == null) {
                this.signatureToken = new WSS4JPolicyToken();
            }
            WSS4JPolicyData.initializeWSS4JPolicyToken(this.signatureToken, (X509Token)sigToken, suite);
        }
    }

    public WSS4JPolicyToken getInitiatorToken() {
        if (this.initiatorToken == null) {
            this.initiatorToken = new WSS4JPolicyToken();
        }
        return this.initiatorToken;
    }

    public void setInitiatorToken(Token iniToken, AlgorithmSuite suite) throws WSSPolicyException {
        if (iniToken instanceof X509Token) {
            if (this.initiatorToken == null) {
                this.initiatorToken = new WSS4JPolicyToken();
            }
            WSS4JPolicyData.initializeWSS4JPolicyToken(this.initiatorToken, (X509Token)iniToken, suite);
        }
    }

    public WSS4JPolicyToken getRecipientToken() {
        if (this.recipientToken == null) {
            this.recipientToken = new WSS4JPolicyToken();
        }
        return this.recipientToken;
    }

    public void setRecipientToken(Token recToken, AlgorithmSuite suite) throws WSSPolicyException {
        if (recToken instanceof X509Token) {
            if (this.recipientToken == null) {
                this.recipientToken = new WSS4JPolicyToken();
            }
            WSS4JPolicyData.initializeWSS4JPolicyToken(this.recipientToken, (X509Token)recToken, suite);
        }
    }

    public ArrayList getEncryptedElements() {
        return this.encryptedElements;
    }

    public void setEncryptedElements(String encElement) {
        if (this.encryptedElements == null) {
            this.encryptedElements = new ArrayList();
        }
        this.encryptedElements.add(encElement);
    }

    public ArrayList getEncryptedParts() {
        return this.encryptedParts;
    }

    public void setEncryptedParts(String namespace, String element) {
        if (this.encryptedParts == null) {
            this.encryptedParts = new ArrayList();
        }
        WSEncryptionPart wep = new WSEncryptionPart(element, namespace, "Content");
        this.encryptedParts.add(wep);
    }

    public boolean isEncryptBody() {
        return this.encryptBody;
    }

    public void setEncryptBody(boolean encryptBody) {
        this.encryptBody = encryptBody;
    }

    public boolean isSignBody() {
        return this.signBody;
    }

    public void setSignBody(boolean signBody) {
        this.signBody = signBody;
    }

    public ArrayList getSignedElements() {
        return this.signedElements;
    }

    public void setSignedElements(String sigElement) {
        if (this.signedElements == null) {
            this.signedElements = new ArrayList();
        }
        this.signedElements.add(sigElement);
    }

    public ArrayList getSignedParts() {
        return this.signedParts;
    }

    public void setSignedParts(String namespace, String element) {
        if (this.signedParts == null) {
            this.signedParts = new ArrayList();
        }
        WSEncryptionPart wep = new WSEncryptionPart(element, namespace, "Content");
        this.signedParts.add(wep);
    }

    public void setSupportingToken(SupportingToken suppToken) throws WSSPolicyException {
        SignedEncryptedElements see;
        Header header;
        Iterator it = null;
        WSS4JSupportingToken wst = new WSS4JSupportingToken();
        SignedEncryptedParts sep = suppToken.getSignedParts();
        if (sep != null) {
            it = sep.getHeaders().iterator();
            if (wst.sigParts == null) {
                wst.sigParts = new ArrayList();
            }
            while (it.hasNext()) {
                header = (Header)it.next();
                wst.sigParts.add(new WSEncryptionPart(header.getName(), header.getNamespace(), "Content"));
            }
        }
        if ((sep = suppToken.getEncryptedParts()) != null) {
            it = sep.getHeaders().iterator();
            if (wst.encParts == null) {
                wst.encParts = new ArrayList();
            }
            while (it.hasNext()) {
                header = (Header)it.next();
                wst.encParts.add(new WSEncryptionPart(header.getName(), header.getNamespace(), "Content"));
            }
        }
        if ((see = suppToken.getSignedElements()) != null) {
            it = see.getXPathExpressions().iterator();
            if (wst.sigElements == null) {
                wst.sigElements = new ArrayList();
            }
            while (it.hasNext()) {
                wst.sigElements.add((String)it.next());
            }
        }
        if ((see = suppToken.getEncryptedElements()) != null) {
            it = see.getXPathExpressions().iterator();
            if (wst.encElements == null) {
                wst.encElements = new ArrayList();
            }
            while (it.hasNext()) {
                wst.encElements.add((String)it.next());
            }
        }
        AlgorithmSuite suite = suppToken.getAlgorithmSuite();
        it = suppToken.getToken().iterator();
        while (it.hasNext()) {
            Token tok;
            if (wst.supportTokens == null) {
                wst.supportTokens = new ArrayList();
            }
            if (!((tok = (Token)it.next()) instanceof X509Token)) continue;
            WSS4JPolicyToken wpt = new WSS4JPolicyToken();
            wst.supportTokens.add(wpt);
            WSS4JPolicyData.initializeWSS4JPolicyToken(wpt, (X509Token)tok, suite);
        }
        wst.tokenType = suppToken.getType();
        if (wst.tokenType == 1) {
            this.supportingToken = wst;
        } else if (wst.tokenType == 3) {
            this.signedSupportingToken = wst;
        } else if (wst.tokenType == 2) {
            this.endorsingSupportingToken = wst;
        } else if (wst.tokenType == 4) {
            this.signedEndorsingSupportingToken = wst;
        }
    }

    private static void initializeWSS4JPolicyToken(WSS4JPolicyToken tok, X509Token x509Tok, AlgorithmSuite suite) throws WSSPolicyException {
        tok.tokenType = WSS4JPolicyToken.X509Token;
        tok.encAlgorithm = suite.getEncryption();
        tok.sigAlgorithm = suite.getAsymmetricSignature();
        tok.encTransportAlgorithm = suite.getAsymmetricKeyWrap();
        if (x509Tok.isRequireIssuerSerialReference()) {
            tok.keyIdentifier = 2;
        } else if (x509Tok.isRequireThumbprintReference()) {
            tok.keyIdentifier = 8;
        } else if (x509Tok.isRequireEmbeddedTokenReference()) {
            tok.keyIdentifier = 1;
        } else {
            throw new WSSPolicyException("Unknown key reference specifier for X509Token");
        }
    }
}

