/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.InitiatorToken;
import org.apache.ws.security.policy.model.RecipientToken;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.X509TokenProcessor;

public class InitiatorRecipientTokenProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedInitiatorToken = false;
    private boolean initializedRecipientToken = false;

    private void initializeInitiatorToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod(new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    private void initializeRecipientToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod(new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    public Object doInitiatorToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedInitiatorToken) break;
                try {
                    this.initializeInitiatorToken(spt);
                    InitiatorToken initiatorToken = (InitiatorToken)spc.readCurrentPolicyEngineData();
                    ((AsymmetricBinding)spc.readPreviousPolicyEngineData()).setInitiatorToken(initiatorToken);
                    this.initializedInitiatorToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doRecipientToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedRecipientToken) break;
                try {
                    this.initializeRecipientToken(spt);
                    RecipientToken recipientToken = (RecipientToken)spc.readCurrentPolicyEngineData();
                    ((AsymmetricBinding)spc.readPreviousPolicyEngineData()).setRecipientToken(recipientToken);
                    this.initializedRecipientToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }
}

