/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteSubnet
extends BaseCmd {
    private String subnetId;

    public DeleteSubnet(String[] args) {
        super("ec2delsubnet", "ec2-delete-subnet");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "SUBNET";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a subnet from a VPC. You must terminate all running instances");
        System.out.println("     in the subnet before deleting it. The SUBNET parameter is the ID of the");
        System.out.println("     subnet you want to delete.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.subnetId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteSubnet(this.subnetId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "SUBNET", this.subnetId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("SUBNET");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteSubnet(args).invoke();
    }
}

