/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import org.apache.xml.security.exceptions.XMLSecurityRuntimeException;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInputDebugger;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLSignatureInput
implements Cloneable {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$signature$XMLSignatureInput == null ? (class$org$apache$xml$security$signature$XMLSignatureInput = XMLSignatureInput.class$("org.apache.xml.security.signature.XMLSignatureInput")) : class$org$apache$xml$security$signature$XMLSignatureInput).getName());
    InputStream _inputOctetStreamProxy = null;
    Set _inputNodeSet = null;
    Node _subNode = null;
    Node excludeNode = null;
    boolean excludeComments = false;
    boolean isNodeSet = false;
    byte[] bytes = null;
    private String _MIMEType = null;
    private String _SourceURI = null;
    List nodeFilters = new ArrayList();
    boolean needsToBeExpanded = false;
    OutputStream outputStream = null;
    static /* synthetic */ Class class$org$apache$xml$security$signature$XMLSignatureInput;

    public boolean isNeedsToBeExpanded() {
        return this.needsToBeExpanded;
    }

    public void setNeedsToBeExpanded(boolean bl) {
        this.needsToBeExpanded = bl;
    }

    public XMLSignatureInput(byte[] byArray) {
        this.bytes = byArray;
    }

    public XMLSignatureInput(InputStream inputStream) {
        this._inputOctetStreamProxy = inputStream;
    }

    public XMLSignatureInput(String string) {
        this(string.getBytes());
    }

    public XMLSignatureInput(String string, String string2) throws UnsupportedEncodingException {
        this(string.getBytes(string2));
    }

    public XMLSignatureInput(Node node) {
        this._subNode = node;
    }

    public XMLSignatureInput(Set set) {
        this._inputNodeSet = set;
    }

    public Set getNodeSet() throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        return this.getNodeSet(false);
    }

    public Set getNodeSet(boolean bl) throws ParserConfigurationException, IOException, SAXException, CanonicalizationException {
        if (this._inputNodeSet != null) {
            return this._inputNodeSet;
        }
        if (this.isElement()) {
            if (bl) {
                XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this._subNode));
            }
            this._inputNodeSet = new HashSet();
            XMLUtils.getSet(this._subNode, this._inputNodeSet, this.excludeNode, this.excludeComments);
            return this._inputNodeSet;
        }
        if (this.isOctetStream()) {
            this.convertToNodes();
            HashSet hashSet = new HashSet();
            XMLUtils.getSet(this._subNode, hashSet, null, false);
            return hashSet;
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException {
        return this.getResetableInputStream();
    }

    public InputStream getOctetStreamReal() {
        return this._inputOctetStreamProxy;
    }

    public byte[] getBytes() throws IOException, CanonicalizationException {
        if (this.bytes != null) {
            return this.bytes;
        }
        InputStream inputStream = this.getResetableInputStream();
        if (inputStream != null) {
            if (this.bytes == null) {
                inputStream.reset();
                this.bytes = JavaUtils.getBytesFromStream(inputStream);
            }
            return this.bytes;
        }
        Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
        this.bytes = canonicalizer20010315OmitComments.engineCanonicalize(this);
        return this.bytes;
    }

    public boolean isNodeSet() {
        return this._inputOctetStreamProxy == null && this._inputNodeSet != null || this.isNodeSet;
    }

    public boolean isElement() {
        return this._inputOctetStreamProxy == null && this._subNode != null && this._inputNodeSet == null && !this.isNodeSet;
    }

    public boolean isOctetStream() {
        return (this._inputOctetStreamProxy != null || this.bytes != null) && this._inputNodeSet == null && this._subNode == null;
    }

    public boolean isByteArray() {
        return this.bytes != null && this._inputNodeSet == null && this._subNode == null;
    }

    public boolean isInitialized() {
        return this.isOctetStream() || this.isNodeSet();
    }

    public String getMIMEType() {
        return this._MIMEType;
    }

    public void setMIMEType(String string) {
        this._MIMEType = string;
    }

    public String getSourceURI() {
        return this._SourceURI;
    }

    public void setSourceURI(String string) {
        this._SourceURI = string;
    }

    public String toString() {
        if (this.isNodeSet()) {
            return "XMLSignatureInput/NodeSet/" + this._inputNodeSet.size() + " nodes/" + this.getSourceURI();
        }
        if (this.isElement()) {
            return "XMLSignatureInput/Element/" + this._subNode + " exclude " + this.excludeNode + " comments:" + this.excludeComments + "/" + this.getSourceURI();
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (Exception exception) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public String getHTMLRepresentation(Set set) throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this, set);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public Node getExcludeNode() {
        return this.excludeNode;
    }

    public void setExcludeNode(Node node) {
        this.excludeNode = node;
    }

    public Node getSubNode() {
        return this._subNode;
    }

    public boolean isExcludeComments() {
        return this.excludeComments;
    }

    public void setExcludeComments(boolean bl) {
        this.excludeComments = bl;
    }

    public void updateOutputStream(OutputStream outputStream) throws CanonicalizationException, IOException {
        int n;
        if (outputStream == this.outputStream) {
            return;
        }
        if (this.bytes != null) {
            outputStream.write(this.bytes);
            return;
        }
        if (this._inputOctetStreamProxy == null) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            canonicalizer20010315OmitComments.setWriter(outputStream);
            canonicalizer20010315OmitComments.engineCanonicalize(this);
            return;
        }
        InputStream inputStream = this.getResetableInputStream();
        if (this.bytes != null) {
            outputStream.write(this.bytes, 0, this.bytes.length);
            return;
        }
        inputStream.reset();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected InputStream getResetableInputStream() throws IOException {
        if (this._inputOctetStreamProxy instanceof ByteArrayInputStream) {
            if (!this._inputOctetStreamProxy.markSupported()) {
                throw new RuntimeException("Accepted as Markable but not truly been" + this._inputOctetStreamProxy);
            }
            return this._inputOctetStreamProxy;
        }
        if (this.bytes != null) {
            this._inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
            return this._inputOctetStreamProxy;
        }
        if (this._inputOctetStreamProxy == null) {
            return null;
        }
        if (this._inputOctetStreamProxy.markSupported()) {
            log.info((Object)"Mark Suported but not used as reset");
        }
        this.bytes = JavaUtils.getBytesFromStream(this._inputOctetStreamProxy);
        this._inputOctetStreamProxy.close();
        this._inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
        return this._inputOctetStreamProxy;
    }

    public void addNodeFilter(NodeFilter nodeFilter) {
        if (this.isOctetStream()) {
            try {
                this.convertToNodes();
            }
            catch (Exception exception) {
                throw new XMLSecurityRuntimeException("signature.XMLSignatureInput.nodesetReference", exception);
            }
        }
        this.nodeFilters.add(nodeFilter);
    }

    public List getNodeFilters() {
        return this.nodeFilters;
    }

    public void setNodeSet(boolean bl) {
        this.isNodeSet = bl;
    }

    void convertToNodes() throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try {
            documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
            Document document = documentBuilder.parse(this.getOctetStream());
            XMLUtils.circumventBug2650(document);
            this._subNode = document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write("<container>".getBytes());
            byteArrayOutputStream.write(this.getBytes());
            byteArrayOutputStream.write("</container>".getBytes());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            this._subNode = document.getDocumentElement().getFirstChild().getFirstChild();
        }
        this._inputOctetStreamProxy = null;
        this.bytes = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

