/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AddressInfo;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeAddresses
extends BaseCmd {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public DescribeAddresses(String[] args) {
        super("ec2daddr", "ec2-describe-addresses");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        o.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withLongOpt((String)"allocation-id");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeAddresses.joinDescription(ALLOCATION_ID_DESC));
        o.addOption(OptionBuilder.create((String)"a"));
        return o;
    }

    protected String getOptionString() {
        return "[ { IP | ALLOCATION } [ { IP | ALLOCATION }  [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your allocated elastic IP addresses");
        System.out.println("     The IP parameter specifies the IP(s) to be described.");
        System.out.println("     If unspecified all addresses allocated to you will be returned.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] ipsOrAllocations = this.getNonOptions();
        ArrayList<String> allocations = new ArrayList<String>();
        ArrayList<String> ips = new ArrayList<String>();
        if (ipsOrAllocations != null && ipsOrAllocations.length > 0) {
            for (String ip : ipsOrAllocations) {
                if (!this.isIp(ip)) {
                    allocations.add(ip);
                    continue;
                }
                ips.add(ip);
            }
        }
        String[] allocationIds = new String[allocations.size()];
        allocationIds = allocations.toArray(allocationIds);
        String[] publicIps = new String[ips.size()];
        publicIps = ips.toArray(publicIps);
        RequestResultPair rsp = jec2.describeAddresses(publicIps, allocationIds, this.getFilters(true));
        for (AddressInfo kp : (List)rsp.getResponse()) {
            out.outputAddress(System.out, kp.publicIp, kp.instanceId, kp.domain, kp.allocationId, kp.associationId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    private boolean isIp(String input) {
        return IPV4_PATTERN.matcher(input).matches() || IPV6_STD_PATTERN.matcher(input).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    public static void main(String[] args) {
        new DescribeAddresses(args).invoke();
    }
}

