/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeSnapshots
extends BaseCmd {
    private static final String[] OWNER_DESC = new String[]{"Only snapshots owned by the specified users are described. OWNER may", "be: ", " - a user's account id for snapshots owned by that user, ", " - 'self' for snapshots owned by you, or", " - 'amazon' for snapshots owned by Amazon."};
    private static final String RESTORABLE_BY = "restorable-by";
    private static final String RESTORABLE_BY_ARG = "USER";
    private static final String[] RESTORABLE_BY_DESC = new String[]{"Only snapshsots with restorable permissions as specified are", "described. USER may be any of the following:", " a user's account id", "   snapshots owned by you for which you have granted explicit", "   CreateVolume permissions to that user.", " self", "   snapshots for which you have explicit CreateVolume permissions", " all", "   snapshots with public CreateVolume permissions."};
    private static final String[] ALL_DESC = new String[]{"Describe all snapshots, public, private or shared, to which you have", "access."};

    public DescribeSnapshots(String[] args) {
        super("ec2dsnap", "ec2-describe-snapshots");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"all");
        OptionBuilder.withDescription((String)DescribeSnapshots.joinDescription(ALL_DESC));
        result.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"owner");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeSnapshots.joinDescription(OWNER_DESC));
        OptionBuilder.withArgName((String)"OWNER");
        result.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)RESTORABLE_BY);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeSnapshots.joinDescription(RESTORABLE_BY_DESC));
        OptionBuilder.withArgName((String)RESTORABLE_BY_ARG);
        result.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        result.addOption(OptionBuilder.create((String)"F"));
        return result;
    }

    protected String getOptionString() {
        return "[SNAPSHOT [...]] [-a] [-o OWNER [...]] [-r USER [...]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe previously created snapshots and snapshots for which");
        System.out.println("     you have CreateVolume permissions. The SNAPSHOT parameters, if specified,");
        System.out.println("     list specific snapshot(s) to be described.");
        System.out.println("       If no parameters are specified, all snapshots owned by you or");
        System.out.println("     explicitely shared with you, are described.");
        System.out.println("       With parameters, the result set is the intersection of the snapshots");
        System.out.println("     explicitely named, the snapshots owned by the specified owner(s), and");
        System.out.println("     the snapshots with CreateVolume permissions as specified.");
        System.out.println("     Examples:");
        System.out.println("       -o        -r              returns");
        System.out.println("      ----------+---------------+--------------------------------------------");
        System.out.println("       self      self or <null>  only your snapshots");
        System.out.println("       self      all             snapshots you have shared publicly");
        System.out.println("       self      <userid>        snapshots you have shared with <userid>");
        System.out.println("       <userid>  self            snapshots <userid> has shared with you");
        System.out.println("       <userid>  all             snapshots <userid> has shared publicly");
        System.out.println("       <userid>  <null>          snapshots <userid> has shared publicly");
        System.out.println("                                   or with you");
        System.out.println("       <null>    self            your snapshots and snapshots any other user");
        System.out.println("                                   has shared with you");
        System.out.println("       <null>    all             all public snapshots");
        System.out.println("       <null>    <null>          your snapshots, public snapshots, and");
        System.out.println("                                   any other snapshots shared with you");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("all");
        this.printOption("owner");
        this.printOption(RESTORABLE_BY);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        if (this.isOptionSet("owner") && this.isOptionSet("all")) {
            throw new InvalidArgumentCombination("Owners (-o) may not be specified with the --all (-a) flag.");
        }
        if (this.isOptionSet(RESTORABLE_BY) && this.isOptionSet("all")) {
            throw new InvalidArgumentCombination("A restorable-by (-r) option may not be specified with the --all (-a) flag.");
        }
        ArrayList<String> snapshotIds = new ArrayList<String>(Arrays.asList(this.getNonOptions()));
        ArrayList<String> owners = new ArrayList<String>(Arrays.asList(this.getOptionValues("owner")));
        ArrayList<String> sharedWith = new ArrayList<String>(Arrays.asList(this.getOptionValues(RESTORABLE_BY)));
        if (snapshotIds.size() > 0 && this.isOptionSet("all")) {
            throw new InvalidArgumentCombination("Snapshot IDs may not be specified together with the --all (-a) flag.");
        }
        List<Filter> filters = this.getFilters(true);
        TreeSet<SnapshotDescription> snapshotSet = new TreeSet<SnapshotDescription>(new SnapshotComparator());
        if (!(snapshotIds.size() != 0 || this.isOptionSet("owner") || this.isOptionSet(RESTORABLE_BY) || this.isOptionSet("all"))) {
            sharedWith.add("self");
            rsp = jec2.describeSnapshots(new ArrayList(), owners, sharedWith, filters);
            snapshotSet.addAll((Collection)rsp.getResponse());
        } else if (this.isOptionSet("all")) {
            rsp = jec2.describeSnapshots(new ArrayList(), new ArrayList(), new ArrayList(), filters);
            snapshotSet.addAll((Collection)rsp.getResponse());
        } else {
            rsp = jec2.describeSnapshots(snapshotIds, owners, sharedWith, filters);
            snapshotSet.addAll((Collection)rsp.getResponse());
        }
        for (SnapshotDescription d : snapshotSet) {
            out.output(System.out, d);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeSnapshots(args).invoke();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SnapshotComparator
    implements Comparator<SnapshotDescription> {
        private SnapshotComparator() {
        }

        @Override
        public int compare(SnapshotDescription snap1, SnapshotDescription snap2) {
            int i = snap1.ownerId.compareTo(snap2.ownerId);
            if (i != 0) {
                return i;
            }
            return snap1.snapshotId.compareTo(snap2.snapshotId);
        }
    }
}

