/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.DynamicVHDVerifier;
import com.amazon.aes.webservices.client.vmconversion.ImageFormatVerifier;
import com.amazon.aes.webservices.client.vmconversion.RawImageVerifier;
import com.amazon.aes.webservices.client.vmconversion.StreamOptimizedVMDKVerifier;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import java.io.File;
import java.io.IOException;

public class VerifierFactory {
    static final String VMDK = "VMDK";
    static final String VHD = "VHD";
    static final String RAW = "RAW";
    protected final String formatType;

    public VerifierFactory(String formatType_) {
        this.formatType = formatType_.toUpperCase();
    }

    public ImageFormatVerifier getVerifier(File diskImage) throws VerificationException {
        if (this.formatType.equals(VMDK)) {
            return this.supportedVMDKImage(diskImage);
        }
        if (this.formatType.equals(VHD)) {
            return this.supportedVHDImage(diskImage);
        }
        if (this.formatType.equals(RAW)) {
            return new RawImageVerifier(diskImage);
        }
        throw new VerificationException("Unknown disk image format: " + this.formatType);
    }

    protected ImageFormatVerifier supportedVHDImage(File diskImage) throws VerificationException {
        int type;
        DynamicVHDVerifier.assertVHD(diskImage);
        try {
            type = DynamicVHDVerifier.diskType(diskImage);
        }
        catch (IOException e) {
            throw new VerificationException("Unable to determine the type of this VHD disk image: " + e.getMessage());
        }
        if (DynamicVHDVerifier.isDynamicType(type)) {
            return new DynamicVHDVerifier(diskImage);
        }
        if (DynamicVHDVerifier.isDifferencingType(type)) {
            throw new VerificationException("This file appears to be a VHD differencing disk, which is not supported.");
        }
        throw new VerificationException("This type of VHD disk is not supported (type: " + type + ").");
    }

    protected ImageFormatVerifier supportedVMDKImage(File diskImage) throws VerificationException {
        if (StreamOptimizedVMDKVerifier.isStreamOptimizedVMDK(diskImage)) {
            return new StreamOptimizedVMDKVerifier(diskImage);
        }
        if (StreamOptimizedVMDKVerifier.mayBeFlatVMDK(diskImage)) {
            throw new VerificationException("This file appears to be in RAW or flat-VMDK format. Please check the format parameter and the User Guide for more information.");
        }
        if (StreamOptimizedVMDKVerifier.isESXServerSparseVMDK(diskImage)) {
            throw new VerificationException("This file appears to be in Sparse VMDK format, which is not supported.");
        }
        throw new VerificationException("Unknown VMDK format");
    }
}

