/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tomcat.internal;
import java.io.*;
import java.net.*;

import org.apache.catalina.net.*;
public class PortTrackingServerSocketFactory implements ServerSocketFactory {
	private int assignedPort;
	public ServerSocket createSocket(int port)
		throws IOException {
		ServerSocket socket = new ServerSocket(port);
		listen(socket);
		assignedPort = socket.getLocalPort();
		return socket;
	}
	public ServerSocket createSocket(int port, int backlog)
		throws java.io.IOException {
		ServerSocket socket = new ServerSocket(port, backlog);
		listen(socket);
		assignedPort = socket.getLocalPort();
		return socket;
	}
	public ServerSocket createSocket(
		int port,
		int backlog,
		java.net.InetAddress ifAddress)
		throws java.io.IOException {
		ServerSocket socket = new ServerSocket(port, backlog, ifAddress);
		listen(socket);
		assignedPort = socket.getLocalPort();
		return socket;
	}
	/**
	 * Obtains port assigned to the last server socket created.
	 * @return Returns a int
	 */
	public int getAssignedPort() {
		return assignedPort;
	}
	/**
	 * Workaround for the absence of
	 * a listen() method on server socket.
	 */
	private void listen(ServerSocket ssocket) {
		try {
			ssocket.setSoTimeout(1);
			try {
				ssocket.accept();
			} catch (IOException exc) {
			}
			ssocket.setSoTimeout(0);
		} catch (SocketException sockEx) {
		}
	}
}
