/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service.aws;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.aws.AwsQueryCaller;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.processors.service.aws.AwsSoapCaller;
import amazon.fws.clicommando.security.SecurityKeys;

public class AwsServiceCallerFactory {
    public static AwsServiceCaller getInstance(Command command, ServiceCallConfig awsCallConfig) {
        if (!command.getCurrentCommandConfig().isCredentialsConfigured()) {
            throw new BadInputException(ErrorMessages.ErrorCode.NO_CREDENTIALS_PROVIDED, new String[0]);
        }
        if (command.getCurrentCommandConfig().getSecurityKeys().get(0).getKeyType() == SecurityKeys.KeyType.CERT_PRIVATE_KEY) {
            return new AwsSoapCaller(awsCallConfig);
        }
        return new AwsQueryCaller(awsCallConfig);
    }
}

