#!/usr/bin/env python
# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com

import sys
import os
from subprocess import Popen, PIPE
import urllib
from urllib import urlopen
import shutil
import re
import main
import objects
import classes
import xparse
import networkmanager
import glob
from httplib import HTTP 
from urlparse import urlparse 
import thread
import time

import apt
import apt_pkg
import aptsources
import aptsources.distro
from aptsources.sourceslist import SourcesList

import gettext, locale

from gettext import gettext as _


atimanlatest = '8-3'
atimannewlegacy = None
atimanlegacy = None

atidict = {'7-12' : '8.443.1'}

nvmanbeta = None
nvmanlatest = '169.12'
nvmannewlegacy = '96.43.05'
nvmanlegacy = '71.86.04'

#self.nvdistinction = 'linux-restricted-modules-' + str(os.uname()[2])
#newmethodos = ['feisty', 'gutsy']
newmethodos = ['feisty', 'gutsy', 'hardy']

##def isstr(f): return isinstance(f, type('')) or isinstance(f, type(u''))
##def islst(f): return isinstance(f, type(())) or isinstance(f, type([]))


def checkURL(url): 
    p = urlparse(url) 
    h = HTTP(p[1]) 
    h.putrequest('HEAD', p[2])
    try:
        h.endheaders()
        if h.getreply()[0] in [200, 302]:
            return 1 
        else:
            return 0 
    except:
        return 0

def connectionCheck():
    #checklist = ['http://www.google.com',
            #'http://www.yahoo.co.uk',
            #'http://www.yahoo.com',
            #'http://albertomilone.com',
            #'http://www.virgilio.it']
    
    #for url in checklist:
        #if checkURL(url):
            #return True
    #return False
    return networkmanager.getConnectionStatus()

class Vars():
    def __init__(self, web=None):
        if web == None:
            self.atimanlatest = atimanlatest
            self.atimannewlegacy = atimannewlegacy
            self.atimanlegacy = atimanlegacy
            self.nvmanbeta = nvmanbeta
            self.nvmanlatest = nvmanlatest
            self.nvmannewlegacy = nvmannewlegacy
            self.nvmanlegacy = nvmanlegacy
        else:
            thread.start_new_thread(self.fetchVersions, (None, None))
            # This is necessary as the background thread is still running when the main thread exits.
            time.sleep(2)
            try:
                if self.nvmanlatest:
                    pass
            except AttributeError:
                self.atimanlatest = atimanlatest
                self.atimannewlegacy = atimannewlegacy
                self.atimanlegacy = atimanlegacy
                self.nvmanbeta = nvmanbeta
                self.nvmanlatest = nvmanlatest
                self.nvmannewlegacy = nvmannewlegacy
                self.nvmanlegacy = nvmanlegacy
    
    def fetchVersions(self, useless=None, variable=None):
        try:
            webpage = urlopen('http://ppa.launchpad.net/albertomilone/ubuntu/dists/hardy/main/binary-i386/Packages')
            wherepackage = []
            whereversion = []
            packages = []
            versions = []
            c = webpage.readlines()
            b = c
            it = 0
            for line in b:
                if 'Package' in line:
                    wherepackage.append(it)
                    packages.append(line.strip()[line.strip().find(':')+1:].strip())
                elif 'Version' in line:
                    whereversion.append(it)
                    versions.append(line.strip()[line.strip().find(':')+1:].strip())
                it += 1
            
            alldetails = {}
            
            it = 0
            for elem in packages:
                if elem == 'nvidia-glx-beta':
                    alldetails[elem] = versions[it].strip()[versions[it].strip().find(':')+1: versions[it].strip().find('+')]
                elif elem == 'nvidia-glx-new':
                    alldetails[elem] = versions[it].strip()[versions[it].strip().find(':')+1: versions[it].strip().find('+')]
                elif elem == 'nvidia-glx':
                    alldetails[elem] = versions[it].strip()[versions[it].strip().find(':')+1: versions[it].strip().find('+')]
                elif elem == 'nvidia-glx-legacy':
                    alldetails[elem] = versions[it].strip()[versions[it].strip().find(':')+1: versions[it].strip().find('+')]
                elif elem == 'xorg-driver-fglrx':
                    alldetails[elem] = versions[it].strip()[versions[it].strip().find('7.1.0-')+6: versions[it].strip().find('+')]
                
                it += 1
        
            self.atimanlatest = alldetails['xorg-driver-fglrx']
            self.atimannewlegacy = atimannewlegacy
            self.atimanlegacy = atimanlegacy
            try:
                self.nvmanbeta = alldetails['nvidia-glx-beta']
            except KeyError:
                self.nvmanbeta = None
            self.nvmanlatest = alldetails['nvidia-glx-new']
            self.nvmannewlegacy = alldetails['nvidia-glx']
            self.nvmanlegacy = alldetails['nvidia-glx-legacy']
        except IOError:
            self.atimanlatest = atimanlatest
            self.atimannewlegacy = atimannewlegacy
            self.atimanlegacy = atimanlegacy
            self.nvmanbeta = nvmanbeta
            self.nvmanlatest = nvmanlatest
            self.nvmannewlegacy = nvmannewlegacy
            self.nvmanlegacy = nvmanlegacy


webver = Vars()



dependencies = ['build-essential', 'dkms', 'lsb-release']


class Replacement:
    def replaceline(self, filename, pattern, replacement):#replaces 1 line with another
        filename = glob.glob(filename)[0]
        lines = []
        pat1 = re.compile(pattern)
        text = open(filename, 'r')
        optext = text.readlines()
        for line in optext:
            m1 = pat1.match(line)
            if m1:
                line = replacement
                lines.append(line)
            else:
                lines.append(line)
        text.close()
        sep = ''
        modtext = open(filename, 'w')
        a = sep.join(lines)
        modtext.write(a)
        modtext.close()
        
        
    def replaceelem(self, filename, pattern, replacement):#replaces 1 element in a string
        filename = glob.glob(filename)[0]
        lines = []
        text = open(filename, 'r')
        optext = text.readlines()
        for line in optext:
            line = line.replace(pattern, replacement)
            #print line
            lines.append(line)
        text.close()
        sep = ''
        modtext = open(filename, 'w')
        a = sep.join(lines)
        modtext.write(a)
        modtext.close()

class Shutilities:#Debpackages
    def isstr(self, elem):
        return isinstance(elem, type('')) or isinstance(elem, type(u''))
    
    def islst(self, elem):
        return isinstance(elem, type(())) or isinstance(elem, type([]))
    
    def cmdoutput(self, command, verbose=None):
        '''
        USAGE: 
        * the command must be a string
        * you can pass 'noverbose' in order to make sure that stderr > /dev/null
        '''
        from subprocess import STDOUT
        if verbose == 'noverbose':
            NULL = open('/dev/null', 'w')
            comnd = Popen(command, shell=True, stdout=PIPE, stderr=NULL)
            sts = os.waitpid(comnd.pid, 0)
            NULL.close()
        else:
            comnd = Popen(command + ' 2>&1', shell=True)# stdout=PIPE)
            #comnd = Popen(command, shell=True, stdout=PIPE, stderr=STDOUT)
            sts = os.waitpid(comnd.pid, 0)
            #os.system(command)
        #commandnew = comnd.communicate()[0]

    def checkpkg(self, pkglist):
        '''
        USAGE:
            * pkglist is the list of packages  you want to check
            * use lists for one or more packages
            * use a string if it is only one package
            * lists will work well in both cases
        '''
        '''
        Checks whether all the packages in the list are installed
        and returns a list of the packages which are not installed
        '''
        lines = []
        notinstalled = []
        p1 = Popen(['dpkg', '--get-selections'], stdout=PIPE)
        p = p1.communicate()[0]
        c = p.split('\n')
        for line in c:
            if line.find('\tinstall') != -1:#the relevant lines
                lines.append(line.split('\t')[0])
        if self.isstr(pkglist) == True:#if it is a string
            try:
                if lines.index(pkglist):
                    pass
            except ValueError:
                notinstalled.append(pkglist)
        else:#if it is a list
            for pkg in pkglist:
                try:
                    if lines.index(pkg):
                        pass
                except ValueError:
                    notinstalled.append(pkg)

        return notinstalled

    def pkginstall(self, pkglist):
        '''
        If some of the packages in the list have not yet been installed
        pkginstall will:
        * attempt to install the missing packages
        '''
        sep = ' '
        notinstalled = self.checkpkg(pkglist)
        if len(notinstalled) != 0:
            print 'EnvyNG: The following packages are not installed:'
            print '\n'.join(notinstalled)#for x in a: print x
            print '\nEnvyNG: attempting to install the packages'
            if self.isstr(pkglist) == True:#if it is a string
                packages = pkglist
            else:#if it is a list
                packages = sep.join(notinstalled)
            self.cmdoutput('sudo apt-get --allow-unauthenticated --assume-yes install ' + packages)
        else:
            print '\nOK: All the packages are installed'
            
    def pkgupdate(self):
        self.cmdoutput('sudo apt-get update')
            
    def checkntry(self, pkglist):
        '''
        If some of the packages in the list have not yet been installed
        checkntry will:
        * attempt to install the missing packages
        * stop the application if installing these packages is not possible
        '''
        self.pkginstall(pkglist)
        notinstalled = self.checkpkg(pkglist)#check again
        if len(notinstalled) != 0:
            error = '\nEnvyNG ERROR: The following packages cannot be installed:', 
            '\n'.join(notinstalled)
            
            raise Exception(error)
            
    def checknstop(self, pkglist):
        '''
        If some of the packages in the list have not yet been installed
        checkntry will:
        * stop the application
        '''
        notinstalled = self.checkpkg(pkglist)#check again
        if len(notinstalled) != 0:
            error = '\nEnvyNG ERROR: The following packages cannot be installed:', 
            '\n'.join(notinstalled)
            
            raise Exception(error)
    
    def envydeps(self, more=[]):
        '''
        ONLY for the GUI
        tries to install the core dependencies and
        an additional list of packages
        '''
        packages = dependencies + more
        
        return self.checkntrygui(packages)
    
    def checkntrygui(self, pkglist):
        '''
        If some of the packages in the list have not yet been installed
        checkntry will:
        * attempt to install the missing packages
        * stop the application if installing these packages is not possible
        '''
        #self.pkginstall(pkglist)
        notinstalled = self.checkpkg(pkglist)#check again
        if len(notinstalled) != 0:
            errorstr = notinstalled
            #for x in a: print x#for y in a: print y
            #sys.exit()
        else:
            errorstr = None
        return errorstr
    
    def pkgremove(self, pkglist, deep=None):
        newpkglist = []#packages which are installed and have to be removed
        sep = ' '
        notinstalled = self.checkpkg(pkglist)
        if self.isstr(pkglist) == True:#if it is a string
            if pkglist not in notinstalled:#if it is installed
                newpkglist.append(pkg)
        else:#if it is a list
            for pkg in pkglist:
                if pkg not in notinstalled:#if it is installed
                    newpkglist.append(pkg)
        if deep != None:
            command = 'sudo apt-get --assume-yes remove --purge '
            #print command
        else:
            command = 'sudo apt-get  --assume-yes remove '
            #print command
        if len(newpkglist) != 0:
            print 'EnvyNG: The following packages will be removed:'
            print '\n'.join(newpkglist)#for y in newpkglist: print y
            print '\nEnvyNG: attempting to remove the packages'
            packages = sep.join(newpkglist)
            #print packages
            self.cmdoutput(command + packages, 'noverbose')

    def download(self, filename, directory):
        '''
        Download without installing anything
        '''
        self.cmdoutput('wget -c -P ' + '"' + directory + '" ' + filename)
        mystat = os.stat(directory)
        myuid = mystat[4]
        migid = mystat[5]
        directory = directory.strip()
        if len(directory) > 1 and directory[-1] != '/':
            sep = '/'
        else:
            sep = ''
        fullpath = directory + sep + filename.split('/')[-1]
        os.chown(fullpath, myuid, migid)
        
    def checkRepositories(self):
        '''
        See if the desired repository is available, otherwise
        enable it
        '''
        haveUniverse = False
        haveMultiverse = False
        cache = apt.Cache()
        try:
            if cache["dkms"].candidateDownloadable: haveUniverse = True
        except KeyError:
            pass
        try:
            if cache["flashplugin-nonfree"].candidateDownloadable: haveMultiverse = True
        except KeyError:
            pass
        if haveUniverse == False:
            component = "universe"
            sourceslist = SourcesList()
            distro = aptsources.distro.get_distro()
            distro.get_sources(sourceslist)
            distro.enable_component(component)
            sourceslist.save()
            print "EnvyNG: Enabled the %s repository" % component
        if haveMultiverse == False:
            component = "multiverse"
            sourceslist = SourcesList()
            distro = aptsources.distro.get_distro()
            distro.get_sources(sourceslist)
            distro.enable_component(component)
            sourceslist.save()
            print "EnvyNG: Enabled the %s repository" % component
        print "EnvyNG: Updating the packages list"
        self.pkgupdate()
        
        
##############PART TO BE LATER INTRODUCED
##    def checkpkg(self, pkglist):
##        '''
##        USAGE:
##            * pkglist is the list of packages  you want to check
##            * use lists for one or more packages
##            * use a string if it is only one package
##            * lists will work well in both cases
##        '''
##        '''
##        Checks whether all the packages in the list are installed
##        and returns a list of the packages which are not installed
##        '''
##        notinstalled = []
##        cache = apt.Cache(apt.progress.OpTextProgress())
##        if self.isstr(pkglist) == True:#if it is a string
##            packages = [pkglist]
##        else:#if it is a list
##            packages = pkglist
##        for pkgname in packages:
##            pkg = cache[pkgname]
##            if not pkg.isInstalled:#if it is not installed
##                notinstalled.append(pkgname)
##        
##        return notinstalled
##
##    def pkginstall(self, pkglist):
##        '''
##        If some of the packages in the list have not yet been installed
##        pkginstall will:
##        * attempt to install the missing packages
##        
##        "notinstalled" is a list
##        '''
##        notinstalled = self.checkpkg(pkglist)
##        if len(notinstalled) != 0:
##            print '\nEnvyNG: attempting to install the packages: '
##            print '\n'.join(notinstalled)
##            #for x in notinstalled: print x#use join????
##            cache = apt.Cache(apt.progress.OpTextProgress())
##            fprogress = apt.progress.TextFetchProgress()
##            iprogress = TextInstallProgress()
##            for pkgname in notinstalled:
##                pkg = cache[pkgname]
##                pkg.markInstall()
##            res = cache.commit(fprogress, iprogress)
##        else:
##            print '\nOK: All the packages are already installed'
##
##    def checkntry(self, pkglist):
##        '''
##        If some of the packages in the list have not yet been installed
##        checkntry will:
##        * attempt to install the missing packages
##        * stop the application if installing these packages is not possible
##        '''
##        self.pkginstall(pkglist)
##        a = self.checkpkg(pkglist)#check again
##        if len(a) != 0:
##            print '\nEnvyNG ERROR: The following packages cannot be installed:'
##            for y in a: print y
##            sys.exit()
##
##    def pkgremove(self, pkglist, deep=None):
##        newpkglist = []#packages which are installed and have to be removed
##        sep = ' '
##        notinstalled = self.checkpkg(pkglist)
##        if self.isstr(pkglist) == True:#if it is a string
##            if pkglist not in notinstalled:#if it is installed
##                newpkglist.append(pkg)
##        else:#if it is a list
##            for pkg in pkglist:
##                if pkg not in notinstalled:#if it is installed
##                    newpkglist.append(pkg)
##        if deep != None:
##            purge = True
##        else:
##            purge = False
##        if len(newpkglist) != 0:
##            print 'EnvyNG: The following packages will be removed:'
##            print '\n'.join(newpkglist)
##            print '\nEnvyNG: attempting to remove the packages'
##
##            cache = apt.Cache(apt.progress.OpTextProgress())
##            fprogress = apt.progress.TextFetchProgress()
##            iprogress = TextInstallProgress()
##            for pkgname in newpkglist:
##                pkg = cache[pkgname]
##                pkg.markDelete(True, purge)
##            res = cache.commit(fprogress, iprogress)
####################################



    def splitlist(self, files, action):
        '''
        method used by removedirs, copyfiles, etc.
        to execute a command.
        It supports UNIX filename expansion therefore:
        "/home/alberto/*finalpart" will be expanded
        
        Remove
        1) 'toremove'
        2) ['toremove1', 'toremove2', 'toremove3']
        
        Copy
        1) [['src1', 'dst1'], ['src2', 'dst2']]
        '''
        
        fileslist = []
        if self.isstr(files) == True:#if it is a string
            fileslist.append(files)
        else:#if it is a list, tuple, etc.
            for elem in files:
                fileslist.append(elem)
        
        if action == 'rm':
            for file in fileslist:
                '''
                explanation:
                ['toremove1', 'toremove2', 'toremove3']
                file = 'toremove1'
                '''
                myfile = glob.glob(file)
                for rmfile in myfile:
                    try:
                        self.command(rmfile)
                    except:
                        pass
        
        elif action == 'cp':#used for copy* and move*
            for file in fileslist:
                if len(file) % 2 != 0:
                    print file
                    raise OSError, 'incomplete command arguments'
                else:
                    source = glob.glob(file[0])
                    destination = glob.glob(file[1])
                    '''
                    at this point everything is a list
                    because of glob
                    
                    NOTE1: glob checks the existence of a file or path
                    therefore if such file or path does not exist we
                    set dst to file[1]
                    If source does not exist the program will fail
                    
                    NOTE2: obviously only 1 destination is admitted
                    '''
                    if len(destination) > 1:
                        raise OSError, 'There can\'t be more than one destination'
                        sys.exit()
                    else:
                        if len(destination) != 0:#destination is an existing path or file
                            dst = destination[0]
                        else:
                            dst = file[1]#destination is not an existing path or file
                    
                    sources = []
                    
                    if len(source) > 1:#more than one source thanks to filename expansion
                        for subsource in source:
                            sources.append(subsource)
                        
                    else:#only one source despite filename expansion
                        if len(source) != 0:#source is an existing path or file
                            #src = source[0]
                            sources.append(source[0])
                        else:
                            raise OSError, 'No existing source file or path found'
                            sys.exit()
                    
                    for src in sources:#execute the command
                        try:
                            self.command(src, dst)
                        except OSError, e:
                            print e
                            pass
    
    def removedirs(self, files):#pass noverbose
        '''
        Removes dirs recursively
        USAGE:
            * pass the path to the dir or a list of paths
            e.g. removedirs([dir1, dir2, etc.])
        '''
        self.command = shutil.rmtree
        self.splitlist(files, 'rm')

    def removefiles(self, files):
        '''
        Removes files
        USAGE:
            * pass the path to the file or a list of files
            e.g. removedirs([file1, file2, etc.])
        '''
        self.command = os.remove
        self.splitlist(files, 'rm')
        
    def copydirs(self, files):
        '''
        Copy dirs recursively
        USAGE:
            * pass a list containing one or more lists of 2 files [src, dst]
            [['/home/username/hello', '/home/username/hello1'], [..., ...] ]
        '''
        '''
        the destination must not already exist therefore, if it does,
        we make sure that the destination is a new dir with the same
        name as the source.
        e.g. let's suppose we need to copy '/home/username/hello' to
        '/home/username/hellos' (they are both dirs)
        hellos always exists therefore the destination will be:
        '/home/username/hellos/hello'
        
        HOW TO CALL IT:
        copydirs([['/home/username/hello', '/home/username/hellos'], [..., ...] ])
        '''
        for file in files:
            if os.path.isdir(file[1]):
                file[1] = file[1] + '/' + file[0].split('/')[-1]
        self.command = shutil.copytree
        self.splitlist(files, 'cp')
        
    def copyfiles(self, files):
        '''
        Copy files
        USAGE:
            * pass a list containing one or more lists of 2 files [src, dst]
            [['/home/username/hello', '/home/username/hello1'], [..., ...] ]
            or simply:
            ['/home/username/hello', '/home/username/hello1']
        '''
        self.command = shutil.copy
        self.splitlist(files, 'cp')
        
    def movefiles(self, files):
        '''
        Move files
        USAGE:
            * pass a list containing one or more lists of 2 files [src, dst]
            [['/home/username/hello', '/home/username/hello1'], [..., ...] ]
            or simply:
            ['/home/username/hello', '/home/username/hello1']
        '''
        self.command = shutil.move
        self.splitlist(files, 'cp')
        
        

class Compatibcheck:
        
    def check(self):#oldname "checkcompatib()"
        a1 = Popen(['lspci'], stdout=PIPE)
        a2 = Popen(['grep', 'VGA'], stdin=a1.stdout, stdout=PIPE)
        a = a2.communicate()[0]
        b = a.lower().split(' ')
        c = self.brandname.lower()
        if c not in b:#if there's no trace of either ati or nvidia in the output
            error = 'EnvyNG ERROR: ' + self.brandname + ' card not found'
            raise Exception(error)


class Specsdetect:

    def __init__(self):
        self.details = {}#all the details about the card, driver, arch are stored here
        self.build = 0
        self.save = 0
        self.savepath = None
    
    def codename(self):
        """
        Get system codename, can be warty/hoary/breezy/dapper/edgy/etch
        """
        package = 'lsb_release'
        p1 = Popen([package, '-c'], stdout=PIPE)
        p = p1.communicate()[0]
        try:
            codename = p.strip()
            tokens = codename.split("\t")
        except AttributeError:
            #print 
            error = 'ERROR: please install', package
            raise Exception(error)
            #sys.exit()
        self.details['osname'] = tokens[-1].lower()
        self.legacyos = ['dapper', 'etch', 'sid']
    
    def architecture(self):
        """
        Detect whether the architecture is x86/ppc/amd64 
        """
        arch = os.uname()[-1]
        if arch in ('ppc', 'ppc64'):
            arch = 'powerpc'
        elif arch =='x86_64':
            arch = 'x86_64'
        elif arch in ('i386','i686','i586','k7'):
            arch = 'x86'
        self.details['arch'] = arch#formerly known as "arca"
    
    def systemcheck(self):#It is based upon details[0] and details[1]
        if self.details['osname'] == 'hardy':#SUPPORT FOR Hardy
            self.details['osname'] = 'hardy'
            if self.details['arch'] == 'x86':
                print 'Ubuntu Hardy 32bit'
            elif self.details['arch'] == 'x86_64':
                print 'Ubuntu Hardy 64bit' 
            else:
                error = 'EnvyNG ERROR: Your architecture is not supported by Envy'
                raise Exception(error)
        else:
            error = "EnvyNG ERROR: Your Operating System does not seem to be supported by Envy"
            raise Exception(error)
    
    def drivertype(self):
        geforcego = ['0112', '0172', '0174', '0175', '0176', '0177', '0179', '0286', '017d' ]#need to use dfp
        availabledrv = []#the list of drivers which your system supports
        systemcards = []
        p1 = Popen(['lspci', '-n'], stdout=PIPE)
        p = p1.communicate()[0].split('\n')
        indentifier1 = re.compile('.*0300:.*:(.+) \(.+\)')
        indentifier2 = re.compile('.*0300:.*:(.+)')
        for line in p:#self.completetxt:#self.logged:
            m1 = indentifier1.match(line)
            m2 = indentifier2.match(line)
            if m1:
                id = m1.group(1).strip().lower()
                systemcards.append(id)
            elif m2:
                id = m2.group(1).strip().lower()
                systemcards.append(id)
        for card in systemcards:
            if card in geforcego:
                self.details['geforcego'] = 'true'#will be used by nvxorgset
            #detect the card and choose the driver accordingly
            if self.cards.setdefault(card, 'N/A') != 'N/A':
                print 'Your graphic card has been detected as a ' + self.cards[card]
                print 'Your graphic card is supported by the latest driver'
                drvtype = 'latest'
            elif self.middlecards.setdefault(card, 'N/A') != 'N/A':
                print 'Your graphic card has been detected as a ' + self.middlecards[card]
                print 'Your graphic card is supported by the new legacy driver'
                drvtype = 'middle'
            elif self.legacycards.setdefault(card, 'N/A') != 'N/A':
                print 'Your graphic card has been detected as a ' + self.legacycards[card]
                print 'Your graphic card is supported by the legacy Driver'
                drvtype = 'oldest'
            else:
                drvtype = 'unsupported'
            availabledrv.append(drvtype)
        if 'latest' in availabledrv:#select the driver following this priority: latest, middle, oldest
            self.details['drvtype'] = 'latest'
        else:
            if 'middle' in availabledrv:
                self.details['drvtype'] = 'middle'
            else:
                if 'oldest' in availabledrv:
                    self.details['drvtype'] = 'oldest'
                else:#if the CARD is NOT SUPPORTED
                    error = 'EnvyNG ERROR: Envy does not recognise your card as compatible with any version of the driver.\
this might happen because either your card is not supported by the driver or Envy\'s hardware\
detection failed. You can try the manual installation at your risk.'
                    raise Exception(error)
    
    
    def geforcegocheck(self):
        geforcego = ['0112', '0172', '0174', '0175', '0176', '0177', '0179', '0286', '017d' ]#need to use dfp
        availabledrv = []#the list of drivers which your system supports
        systemcards = []
        p1 = Popen(['lspci', '-n'], stdout=PIPE)
        p = p1.communicate()[0].split('\n')
        indentifier1 = re.compile('.*0300:.*:(.+) \(.+\)')
        indentifier2 = re.compile('.*0300:.*:(.+)')
        for line in p:#self.completetxt:#self.logged:
            m1 = indentifier1.match(line)
            m2 = indentifier2.match(line)
            if m1:
                id = m1.group(1).strip().lower()
                systemcards.append(id)
            elif m2:
                id = m2.group(1).strip().lower()
                systemcards.append(id)
        for card in systemcards:
            if card in geforcego:
                self.details['geforcego'] = 'true'#will be used by nvxorgset
    
    def driverpushback(self):
        availabledrv = []#the list of drivers which your system supports
        systemcards = []
        p1 = Popen(['lspci', '-n'], stdout=PIPE)
        p = p1.communicate()[0].split('\n')
        indentifier1 = re.compile('.*0300:.*:(.+) \(.+\)')
        indentifier2 = re.compile('.*0300:.*:(.+)')
        for line in p:#self.completetxt:#self.logged:
            m1 = indentifier1.match(line)
            m2 = indentifier2.match(line)
            if m1:
                id = m1.group(1).strip().lower()
                systemcards.append(id)
            elif m2:
                id = m2.group(1).strip().lower()
                systemcards.append(id)


        for card in systemcards:
            #detect the card and choose the driver accordingly
            if self.cards.setdefault(card, 'N/A') != 'N/A':
                #print 'Your graphic card has been detected as a ' + self.cards[card]
                #print 'Your graphic card is supported by the latest driver'
                drvtype = 'latest'
            elif self.middlecards.setdefault(card, 'N/A') != 'N/A':
                #print 'Your graphic card has been detected as a ' + self.middlecards[card]
                #print 'Your graphic card is supported by the new legacy driver'
                drvtype = 'middle'
            elif self.legacycards.setdefault(card, 'N/A') != 'N/A':
                #print 'Your graphic card has been detected as a ' + self.legacycards[card]
                #print 'Your graphic card is supported by the legacy Driver'
                drvtype = 'oldest'
            else:
                drvtype = 'unsupported'
            availabledrv.append(drvtype)
        if 'latest' in availabledrv:#select the driver following this priority: latest, middle, oldest
            self.details['drvtype'] = 'latest'
        else:
            if 'middle' in availabledrv:
                self.details['drvtype'] = 'middle'
            else:
                if 'oldest' in availabledrv:
                    self.details['drvtype'] = 'oldest'
    
    def atimanver(self):
        myver = Vars(1)
        
        while 1:
            try:
                drvchoice = raw_input(_('\n\
                    Select the version of the driver which would you like to install:\n\
                    1 - ') + myver.atimanlatest + _(' (latest)\n\
                    2 - ') + myver.atimannewlegacy + _(' (newlegacy)\n\
                    3 - ') + myver.atimanlegacy + _(' (legacy)\n\
                    4 - Back to main menu\n\
                    (Type 1, 2 or 3)\n')).strip()
            except TypeError:
                drvchoice = raw_input(_('\n\
                    Select the version of the driver which would you like to install:\n\
                    1 - ') + atimanlatest + _(' (latest)\n\
                    4 - Back to main menu\n\
                    (Type 1 or 4)\n')).strip()
                
            if drvchoice == '1':
                self.details['drvtype'] = 'latest'
                self.details['manualchoice2'] = 'notmenu'
                break
            elif drvchoice == '2':
                self.details['drvtype'] = 'middle'
                self.details['manualchoice2'] = 'notmenu'
                break
            elif drvchoice == '3':
                self.details['drvtype'] = 'oldest'
                self.details['manualchoice2'] = 'notmenu'
                break
            elif drvchoice == '4':
                self.details['drvtype'] = 'oldest'
                self.details['manualchoice2'] = 'menu'
                break
        if self.details['manualchoice2'] == 'menu':
            objects.mainmenu()
        else:
            self.atireleasenum()

    def nvidiamanver(self):
        myver = Vars(1)
        while 1:
            drvchoice = raw_input(_('\n\
                Select the version of the driver which would you like to install:\n\
                1 - ') + myver.nvmanlatest + _(' (latest)\n\
                2 - ') + myver.nvmannewlegacy + _(' (new legacy)\n\
                3 - ') + myver.nvmanlegacy + _(' (legacy)\n\
                4 - Back to main menu\n\
                (Type 1, 2, 3 or 4)\n')).strip()
            if drvchoice == '1':
                self.details['drvtype'] = 'latest'
                self.details['manualchoice1'] = 'notmenu'
                break
            elif drvchoice == '2':
                self.details['drvtype'] = 'middle'
                self.details['manualchoice1'] = 'notmenu'
                break
            elif drvchoice == '3':
                self.details['drvtype'] = 'oldest'
                self.details['manualchoice1'] = 'notmenu'
                break
            elif drvchoice == '4':
                self.details['manualchoice1'] = 'menu'
                break
        if self.details['manualchoice1'] == 'menu':
            objects.mainmenu()
        else:
            self.nvreleasenum()

    def manualdetails(self):
        while 1:
            drvchoice = raw_input(_('\n\
            Select the kind of driver which would you like to install:\n\
            1 - ATI\n\
            2 - NVIDIA\n\
            3 - Back to main menu\n\
            (Type either 1 or 2)\n')).strip()
            if drvchoice == '1':
                self.details['cardbrand'] = 'ati'
                self.details['manualchoice'] = 'notmenu'
                break
            elif drvchoice == '2':
                self.details['cardbrand'] = 'nvidia'
                self.details['manualchoice'] = 'notmenu'
                break
            elif drvchoice == '3':
                self.details['manualchoice'] = 'menu'
                break
        if self.details['manualchoice'] == 'menu':
            objects.mainmenu()
        else:
            if self.details['cardbrand'] == 'ati':
                self.atimanver()
            elif self.details['cardbrand'] == 'nvidia':
                self.nvidiamanver()
        
    
    
    def nvreleasenum(self):
        if self.details['drvtype'] == 'latest':
            version = nvmanlatest#100.14.03
            #version = '1.0-' + nvmanlatest#9746
        elif self.details['drvtype'] == 'middle':
            #version = '1.0-' + nvmannewlegacy#9631
            version = nvmannewlegacy#new name scheme
        elif self.details['drvtype'] == 'oldest':
            #version = '1.0-' + nvmanlegacy#7184
            version = nvmanlegacy#new name scheme
        self.details['ver'] = version#add the version of the driver (e.g. '1.0-9746') to the "details" list

    def atireleasenum(self):
        if self.details['drvtype'] == 'latest':
            if atidict.get(atimanlatest) != None and atidict.get(atimanlatest) != 'N/A':
                version = atidict[atimanlatest]
            else:
                version = atimanlatest#'8.33.6'
        elif self.details['drvtype'] == 'middle':#doesn't exist
            if atidict.get(atimannewlegacy) != None and atidict.get(atimannewlegacy) != 'N/A':
                version = atidict[atimannewlegacy]
            else:
                version = atimannewlegacy
        elif self.details['drvtype'] == 'oldest':
            if atidict.get(atimanlegacy) != None and atidict.get(atimanlegacy) != 'N/A':
                version = atidict[atimanlegacy]
            else:
                version = atimanlegacy#'8.28.8'
        self.details['ver'] = version#add the version of the driver (e.g. '1.0-9746') to the "details" list

    
    def cleanPackages(self):
        main.removediversion('libGL.so')
        check = Shutilities()
        check.cmdoutput('sudo apt-get install -f -y')

        toremove = [
        'nvidia-glx',
        'nvidia-glx-dev', 
        'nvidia-glx-new',
        'nvidia-glx-new-dev', 
        'nvidia-new-kernel-source', 
        'nvidia-kernel-source', 
        'nvidia-legacy-kernel-source', 
        'nvidia-glx-legacy', 
        'nvidia-settings',
        'nvidia-xconfig', 
        'fglrx-amdcccle',
        'fglrx-control',
        'fglrx-driver',
        'fglrx-driver-dev',
        'fglrx-kernel-source',
        'xorg-driver-fglrx',
        'xorg-driver-fglrx-dev'
        ]
        check.pkgremove(toremove, 'purge')
    
    
    def getPackagesPath(self):
        '''
        Get the version of each package available in the repository
        and return a dictionary such as
        
        {name_of_the_package: address_of_thedebfile, etc. }
        {'nvidia-glx': 'http://...'}
        
        '''
        prefix = 'http://ppa.launchpad.net/albertomilone/ubuntu/'
        if self.details['arch'] == 'x86_64':
            myarch = 'amd64'
        elif self.details['arch'] == 'x86':
            myarch = 'i386'
        webpage = urlopen('http://ppa.launchpad.net/albertomilone/ubuntu/dists/hardy/main/binary-' + myarch + '/Packages')
        wherepackage = []
        whereversion = []
        packages = []
        versions = []
        names = []
        c = webpage.readlines()
        b = c
        it = 0
        for line in b:
            if 'Package' in line:
                wherepackage.append(it)
                packages.append(line.strip()[line.strip().find(':')+1:].strip())
            elif 'Filename' in line:
                whereversion.append(it)
                names.append(line.strip()[line.strip().find('pool'):].strip())
            it += 1
        
        alldetails = {}
        
        it = 0
        for elem in packages:
            alldetails[elem] = prefix + names[it].strip()
            it += 1
        return alldetails
    
    def nvidiaInstall(self):
        check = Shutilities()
        if self.details['drvtype'] == 'latest':
            packages = ['nvidia-new-kernel-source',
                        'nvidia-glx-new',
                        'nvidia-glx-new-dev']
        elif self.details['drvtype'] == 'middle':
            packages = ['nvidia-kernel-source',
                        'nvidia-glx',
                        'nvidia-glx-dev']
        elif self.details['drvtype'] == 'oldest':
            packages = ['nvidia-legacy-kernel-source',
                        'nvidia-glx-legacy',
                        'nvidia-glx-legacy-dev']
        
        if self.build == 0:
            '''
            The packages are retrieved and installed
            '''
            self.cleanPackages()
            
            #Make sure that the packages are installed
            check.checkntry(packages)
            check.pkginstall(['nvidia-settings'])#nvidia-settings from the repo has been used since Hardy
            
        
        if self.save == 1:
            '''
            The packages are saved somewhere
            '''
            mydetails = self.getPackagesPath()
            for pkgname in packages:
                check.download(mydetails[pkgname], self.savepath)
    
    def atiInstall(self):
        check = Shutilities()
        if self.details['drvtype'] == 'latest':
            packages = ['fglrx-kernel-source',
                        'xorg-driver-fglrx',
                        'xorg-driver-fglrx-dev',
                        'fglrx-control',
                        'fglrx-amdcccle']
        if self.build == 0:
            '''
            The packages are retrieved and installed
            '''
            self.cleanPackages()
            
            #Make sure that the packages are installed
            check.checkntry(packages)
        
        if self.save == 1:
            '''
            The packages are saved somewhere
            '''
            mydetails = self.getPackagesPath()
            for pkgname in packages:
                check.download(mydetails[pkgname], self.savepath)
        
    
    def xorgbackup(self):
        check = Shutilities()
        check.cmdoutput('sudo cp /etc/X11/xorg.conf /etc/X11/xorg.conf_backup_`date +%Y%m%d%H%M`')
    
    def xorgset(self):
        answer = raw_input('Do you want your xorg.conf to be automatically configured? (y/n) \ "y" is the default answer\n').strip().lower()
        while 1:
            if answer == 'y' or answer == '':
                self.xorgreply = 'y'
                break
                #return 'y'
            elif answer == 'n':
                #return 'n'
                self.xorgreply = 'n'
                break
    
    def nvxorgset(self):
        check = Shutilities()
        distrolst = ['dapper']#THEY NEED COMPOSITE TO BE DISABLED ATM
        systemname = self.details['osname']
        xnvidia = xparse.EnvyParser()
        if systemname not in distrolst:
            if self.details['drvtype'] == 'latest' or self.details['drvtype'] == 'middle':
                xnvidia.removealloptions()
                xnvidia.addargbglxvisuals()
                xnvidia.enablecomposite()
                xnvidia.setdriver('nvidia')
                try:
                    if self.details['geforcego'] == 'true':#needed by geforce go 420 440
                        xnvidia.usedisplaydevicedfp()
                except KeyError:
                    pass
            elif self.details['drvtype'] == 'oldest':
                xnvidia.disablecomposite()
                xnvidia.setdriver('nvidia')
            else:
                xnvidia.addargbglxvisuals()
                xnvidia.enablecomposite()
                xnvidia.setdriver('nvidia')
            xparse.defaultdepth()#set defaultdepth to 24bit
        else:
            xnvidia.removealloptions()
            xnvidia.setdriver('nvidia')#for Dapper

    
    def atixorgset(self):
        distrolst = ['edgy', 'etch', 'feisty']#THEY NEED COMPOSITE and AIGLX TO BE DISABLED ATM
        systemname = self.details['osname']
        xati = xparse.EnvyParser()
        xati.removealloptions()
        if self.details['drvtype'] == 'latest' or self.details['drvtype'] == 'middle':
            xati.enablecomposite()
        else:
            xati.disablecomposite()
        xati.videooverlayon()
        xati.opengloverlayoff()
        xati.setdriver('fglrx')
        xparse.defaultdepth()#set defaultdepth to 24bit
    




if __name__ == '__main__':
    gettext.textdomain("envy")
