#!/usr/bin/env python
from Envy import ui
from Envy import packagemanager
from Envy import abstraction
from Envy.abstraction import *

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyKDE4.kdecore import *
from PyKDE4.kdeui import *

from Envyngqt import ui_envyngqt
from Envyngqt import ui_progressdialog
from Envyngqt import qtabout
from Envyngqt import qtlogger
from Envyngqt import network


import select
import os
import tempfile
import time
import urllib

import thread

EnvyNGVersion = '2.0'

class FakeBar(QThread):
    def __init__(self):
        super(FakeBar, self).__init__()
        self.translation = ui.AbstractUI()
        
    def updateLabel(self, currentItems, totalItems):
        message = '%s %d/%d...' % (self.translation.string_package_download, currentItems, totalItems)
        self.emit(SIGNAL("started(QString)"), message)
    
    def run(self):
        pass
    
    def updateUi(self, percent):
        self.percent = percent
        self.emit(SIGNAL("downloaded"), percent)

class PkgThread(QThread):
#    lock = QReadWriteLock()
    
    def __init__(self, package=None, operation=None, bar=None, abstract=None):
        super(PkgThread, self).__init__()
        self.package = package
        self.operation = operation
        self.abstraction = abstract#Abstraction(bar, text=None)
        self.translation = ui.AbstractUI()
        
    def run(self):
        if self.operation == 'install':
            try:
                self.emit(SIGNAL("started(QString)"), self.translation.string_synaptic_temp_msg)   
                self.abstraction.install(self.package)
            except(abstraction.LockException, abstraction.HeadersException, abstraction.PackageException, SystemError), e:
                error = str(e).strip()
                self.emit(SIGNAL("error(QString)"), error)
                #self.emit(SIGNAL("aptcomplete(bool)"), 1)
            except(select.error):
                #Here python-apt completes the operation but dies with select.error
                
                self.emit(SIGNAL("aptcomplete(bool)"), 1)
            else:
                self.emit(SIGNAL("aptcomplete(bool)"), 1)
        elif self.operation == 'remove':
            try:
                self.emit(SIGNAL("started(QString)"), self.translation.string_synaptic_temp_msg)   
                self.abstraction.uninstallAll()#(self.package)
            except:
                self.emit(SIGNAL("aptcomplete(bool)"), 1)
            else:
                self.emit(SIGNAL("aptcomplete(bool)"), 1)
            

class ProgressBar(QDialog, ui_progressdialog.Ui_progressDialog):
    def __init__(self, package, directory, parent=None, operation=None, abstract=None, bar=None, mainUi=None):
        super(ProgressBar, self).__init__(parent)
        self.setupUi(self)
        self.progressBar.setTextVisible(True)
        self.progressBar.setMinimum(0)
        self.progressBar.setMaximum(100)
        
        self.setWindowIcon(QIcon('/usr/share/envy/pixmaps/envyng.png'))
        
        self.mainUi = mainUi
        
        self.translation = ui.AbstractUI()
        
        self.abstraction = abstract
        
        self.operation = operation
        self.package = package
        
        self.network = network.Network(package, directory)
        if operation:
            self.connect(self.network, SIGNAL("complete(bool)"),
                         self.downloadFinishedSilent)
        else:
            self.connect(self.network, SIGNAL("complete(bool)"),
                         self.downloadFinished)
        self.connect(self.network, SIGNAL("error(bool)"),
                     self.downloadError)
        self.connect(self.network, SIGNAL("started(QString)"),
                     self.updateLabel)
        self.connect(self.network, SIGNAL("downloaded"),
                     self.updateUi)
        
        
        self.fake = bar
        
        self.installPkg = False
        
        self.pkgThread = PkgThread(package, operation, self.fake, abstract=abstract)
        
        
        #if self.pkgThread != None:
        if operation:
            self.connect(self.fake, SIGNAL("complete(bool)"),
                         self.finished)
            self.connect(self.fake, SIGNAL("error(bool)"),
                         self.downloadError)
            self.connect(self.fake, SIGNAL("started(QString)"),
                         self.updateLabel)
            self.connect(self.fake, SIGNAL("downloaded"),
                         self.updateUi)
            self.connect(self.pkgThread, SIGNAL("aptcomplete(bool)"),
                         self.finished)
            self.connect(self.pkgThread, SIGNAL("started(QString)"),
                         self.updateLabel)
            self.connect(self.pkgThread, SIGNAL("error(QString)"),
                         self.pkgError)
            self.connect(self.pkgThread, SIGNAL("aptcompletesilent(bool)"),
                         self.silentFinished)
        
        
    def download(self):#, package, directory):
        #self.abstraction.download(package, directory, self.updateLabel, self.callback)
        self.network.start()
    
    def install(self):
        if self.mainUi.savePackages == 1:
            '''
            Download
            '''
            #print 'Downloading first...'
            self.installPkg = True
            self.download()
        else:
            self.installPkg = False
            self.pkgThread.start()
    
    def uninstall(self):
        
        self.pkgThread.start()
    
    def silentFinished(self, *args):
        self.abstraction.setupX(self.operation, package=self.package)
    
    def downloadFinished(self, *args):
        self.hide()
        self.infoMessage(self.translation.string_text_success, self.translation.string_operation_complete)
    
    def downloadFinishedSilent(self, *args):
        #print 'Silent Download Finished'
        self.hide()
        #print 'InstallPkg is', self.installPkg
        if self.installPkg:
            #print 'Start Installation after Download'
            self.pkgThread.start()
    
    def finished(self, *args):
        #print 'THREAD Has finished'
        self.hide()
        self.abstraction.setupX(self.operation, package=self.package)
        
        if self.confirmMessage(self.translation.string_text_success, self.translation.string_operation_complete_gui_restart):
            self.abstraction.restartSystem()
        KApplication.processEvents()
        self.mainUi.abstract = abstraction.Abstraction(widget=self.mainUi.pbar, text=None)
        self.mainUi.updateTreeModel()
            
            
        #self.infoMessage(self.translation.string_text_error, error)
    
    def downloadError(self, *args):
        pass
        #print 'THREAD Has error'
    
    def pkgError(self, error):
#        print 'THREAD Has error:'
#        print error
        self.hide()
        self.errorMessage(self.translation.string_text_error, error)
        KApplication.processEvents()
        self.mainUi.abstract = abstraction.Abstraction(widget=self.mainUi.pbar, text=None)
        self.mainUi.updateTreeModel()
        
    
    def updateLabel(self, message):
#        print 'THREAD Has started'
        self.show()
        self.progressStatus.setText(message)
        self.progressBar.setValue(0)
    
    def updateUi(self, fraction):
        #print 'THREAD Has progressed'
        if fraction < 0: fraction = 0
        if fraction > 100: fraction = 100
        
        self.progressBar.setValue(int(fraction))
        
        #self.progressBar.set_text(str(fraction*100) + ' %')

    def infoMessage(self, title, text):
        '''Present an info message box.'''

        text = '<h3>' + title + '</h3>' + text

        msgbox = QMessageBox.information(self, title, text, QMessageBox.Ok )
        
        #msgbox.setIcon(QMessageBox.Information)
        
        # QMessageBox returns a StandardButton, output a boolean
        return msgbox == QMessageBox.Ok
    
    def errorMessage(self, title, text):
        '''Present an error message box.'''

        text = '<h3>' + title + '</h3>' + text

        msgbox = QMessageBox.warning(self, title, text, QMessageBox.Close )
        
        
        # QMessageBox returns a StandardButton, output a boolean
        return msgbox == QMessageBox.Close

    def confirmMessage(self, title, text, subtext=None, action=None):
        '''Present a confirmation dialog.

        If action is given, it is used as button label instead of the default
        'OK'.  Return True if the user confirms, False otherwise.
        '''
#        text = '<h3>%s</h3>' % title text
        text = '<h3>' + title + '</h3>' + text
        if subtext:
            text += subtext
        text = text.replace('\n', '<br/>')
        msgbox = QMessageBox(title, text, QMessageBox.Question,
                QMessageBox.Yes | QMessageBox.Default, 
                QMessageBox.No | QMessageBox.Escape, 
                QMessageBox.NoButton,
                self)
        
        
        
        msgbox.setText(text)
        msgbox.setWindowTitle(title)
        
        
        
        
        if action:
            msgbox.setButtonText(0, action)

        mb = msgbox.exec_()
        # QMessageBox returns a StandardButton, output a boolean
        return mb == QMessageBox.Yes


class EnvyTreeWidgetItem(QTreeWidgetItem):
    '''
    A subclassed QTreeWidgetItem that can store its handler.
    '''
    def __init__(self, parent, handler_id):
        self.handler_id = handler_id
        QTreeWidgetItem.__init__(self, parent)


class EnvyMainDlg(QDialog, ui_envyngqt.Ui_EnvyMainDlg):
    def __init__(self, parent=None):
        super(EnvyMainDlg, self).__init__(parent)
        self.setupUi(self)
        
        self.pbar = FakeBar()
        self.abstract = abstraction.Abstraction(widget=self.pbar, text=None)
        self.itemsCopy = self.abstract.uiDetails
        
        self.driverNames = ('fglrx', 'nvidia')
        self.currentStatus = {}.fromkeys(self.driverNames)
        
        self.installedDriver = {}.fromkeys(self.driverNames)
        
        self.downloadOnly = 0
        self.savePackages = 0
        
        '''
        Translations
        '''
        self.translation = ui.AbstractUI()
        self.save_checkbox.setText(self.translation.string_save_packages)
        self.build_checkbox.setText(self.translation.string_download_packages)

        self.tabWidget.setTabText(0, QString(self.translation.string_main_label))
        self.tabWidget.setTabText(1, QString(self.translation.string_options_label))
        
        self.about_button.setText(self.translation.string_close_button)
        self.apply_button.setText(self.translation.string_apply_button)
        self.quit_button.setText(self.translation.string_quit_button)
        self.save_button.setText(self.translation.string_save_button)
        self.about_button.setText(self.translation.string_about_button)
#        self.choice_label.setText(self.translation.string_request_selection)
        
        
        #self.headerLabel.setPixmap(QPixmap('/usr/share/envyng-qt/pixmaps/envyapp3.png'))
        self.setWindowIcon(QIcon('pixmaps/envyng.png'))
        
        self.yesIcon = QIcon('/usr/share/icons/oxygen/16x16/actions/dialog-ok-apply.png')
        self.noIcon = QIcon('/usr/share/icons/oxygen/16x16/actions/application-exit.png')

        
        #self.setIcon(QPixmap('/usr/share/envyng-qt/pixmaps/envyng.png'))
        
        # update tree model
        self.updateTreeModel()
        
        self.connect(self.treeview_drivers,
                        SIGNAL('itemChanged(QTreeWidgetItem*, int )'),
                        self.on_handler_changed)
    
    def updateTreeModel(self, selected=None, disableAll=None, isEnabled=None):       
        # it's not the user, disable checkbox toggling
        self.user = False

        # first clear the list
        self.treeview_drivers.clear()
        
        driverLabels = {'fglrx': 'ATI', 'nvidia': 'NVIDIA'}
        drivers = {'fglrx': None, 'nvidia': None}
        self.driversItems = {'fglrx': [], 'nvidia': []}
        
        
        for driver in drivers:
            drivers[driver] = QTreeWidgetItem(self.treeview_drivers)
            drivers[driver].setText(0, driverLabels[driver])
            parent = drivers[driver]
            it = 0
            for elem in self.itemsCopy[driver]:
                details = self.itemsCopy[driver][elem]
                
                candidate = self.abstract.uiDetails[driver][elem]['candidate']
                
                if self.abstract.uiDetails[driver][elem]['installed']:
                    installed = self.abstract.uiDetails[driver][elem]['installed']
                    enabled = True
                    self.currentStatus[driver] = installed
                    self.installedDriver[driver] = installed
                    
                else:
                    installed = ''
                    enabled = False
                    self.installedDriver[driver] = None
                

                if self.abstract.uiDetails[driver][elem]['compatible']:
                    compatible = self.yesIcon#QString('Yes')
                else:
                    compatible = self.noIcon#QString('No')
                
                if self.abstract.uiDetails[driver][elem]['recommended']:
                    recommended = self.yesIcon#QString('Yes')
                else:
                    recommended = self.noIcon#QString('No')
                
                i = EnvyTreeWidgetItem(parent, candidate)
                
                i.setText(0, candidate)
                
                if(enabled):
                    i.setCheckState(1, Qt.Checked)
                else:
                    i.setCheckState(1, Qt.Unchecked)
                
                i.setText(2, installed)
                
                i.setIcon(3, compatible)

                i.setIcon(4, recommended)
                
                
                self.driversItems[driver].append(i)
                
                
                #Adjust the columns and expand the tree
                self.treeview_drivers.expandAll()
                self.treeview_drivers.resizeColumnToContents(0)
                self.treeview_drivers.resizeColumnToContents(1)
                self.treeview_drivers.resizeColumnToContents(2)
                
                it += 1


        # user is allowed to click again
        self.user = True
    def on_handler_changed(self, item, column):
        '''Callback for flipping checkboxes.'''

        if self.user == False:
            pass
        else:
            # check if the click comes from a user
            # it may also have been the update_tree_model() function
            self.user = False
            
            drivers = {'fglrx': False, 'nvidia': False}
            
            for driver in self.driversItems:
                
                for myItem in self.driversItems[driver]:
                    if myItem != item:
                        myItem.setCheckState(1, Qt.Unchecked)
                    else:
                        if item.checkState(1):
                            myItem.setCheckState(1, Qt.Checked)
                            drivers[driver] = True
                            self.currentStatus[driver] = unicode(myItem.text(0))
                        else:
                            myItem.setCheckState(1, Qt.Unchecked)
                            drivers[driver] = False
            
            for driver in drivers:
                if not drivers[driver]:
                    self.currentStatus[driver] = None
            
            self.user = True
            
    def setLabels(self):
        self.automatic_button.setText(self.translation.string_auto_install %(self.curDriver))
        self.manual_button.setText(self.translation.string_man_install %(self.curDriver))
        self.uninstall_button.setText(self.translation.string_uninstall %(self.curDriver))
        for flavour in self.driverMap[self.curDriver]:
            if self.driverMap[self.curDriver][flavour] == None:
                self.radioFlavours[flavour].hide()
            else:
                self.radioFlavours[flavour].setText(self.driverMap[self.curDriver][flavour])
                self.radioFlavours[flavour].show()
    
    @pyqtSignature("int")
    def on_listWidget_currentRowChanged(self, pos):
        #print 'Driver',  self.driversList[pos], 'is selected'
        self.curDriver = self.driversList[pos]
        self.setLabels()
    
    @pyqtSignature("")
    def on_apply_button_clicked(self):
        #print "Applybutton clicked"
        print 'installed driver = %s, current status = %s'% (self.installedDriver, self.currentStatus)
#        if self.installedDriver != self.currentStatus:
        
        curDriver = None
        for driver in self.currentStatus:
            if self.currentStatus[driver] != self.installedDriver:
                if self.currentStatus[driver] != None:
                    #print  self.abstract.uiDetails[driver]
                    action = 'install ' + self.currentStatus[driver]
                    
                    for item in self.abstract.uiDetails[driver]:
                        if self.abstract.uiDetails[driver][item]['candidate'] == self.currentStatus[driver]:    
                            curDriver = self.abstract.uiDetails[driver][item]['name']
                            break

                else:
                    action = 'remove any ' + driver + ' driver'
                    driverType = driver
                #print action
        
        
        if curDriver != None:
            if self.downloadOnly == 0:
                #self.progressBar = ProgressBar('', '')
                if self.installedDriver != self.currentStatus:
                    savePath = self.getPath()
                    self.progressBar = ProgressBar(curDriver, savePath, operation='install', abstract=self.abstract, bar=self.pbar, mainUi=self)
                    
                    self.progressBar.updateUi(0)
                    self.progressBar.progressStatus.setText(self.translation.string_synaptic_temp_msg)
                    self.progressBar.show()
                    

                    KApplication.processEvents()
                    self.progressBar.install()
                
            else:
                '''
                Download
                '''
                savePath = self.getPath()
                self.progressBar = ProgressBar(curDriver, savePath)
                self.progressBar.show()
                self.progressBar.download()
                KApplication.processEvents()
                
        else:
            '''
            Uninstall
            '''
            self.progressBar = ProgressBar(curDriver, '', operation='remove', abstract=self.abstract, bar=self.pbar, mainUi=self)
                
            self.progressBar.updateUi(0)
            self.progressBar.progressStatus.setText(self.translation.string_synaptic_temp_msg)
            self.progressBar.show()
            KApplication.processEvents()
            self.progressBar.uninstall()

    
    def path_dialog(self):
        response = self.translation.string_ok_button
        # buttons texts
        OK = self.translation.string_ok_button

        dialog = QMessageBox(self)
        dialog.setText(self.translation.string_invalid_path)
        dialog.setWindowTitle(self.translation.string_directory_error_title)
        dialog.setIcon(QMessageBox.Critical)
        dialog.addButton(OK, QMessageBox.AcceptRole)
        dialog.exec_()
        response = dialog.clickedButton().text()
        if response == self.translation.string_ok_button:
            dialog.hide()
    
    def infoMessage(self, title, text):
        '''Present an error message box.'''

        text = '<h3>' + title + '</h3>' + text

        msgbox = QMessageBox.info(self, title, text, QMessageBox.Close )

        # QMessageBox returns a StandardButton, output a boolean
        return msgbox == QMessageBox.Close
    
    def errorMessage(self, title, text):
        '''Present an error message box.'''

        text = '<h3>' + title + '</h3>' + text

        msgbox = QMessageBox.warning(self, title, text, QMessageBox.Close )
        
        msgbox.setIcon(QIcon('pixmaps/envyng.png'))
        
        # QMessageBox returns a StandardButton, output a boolean
        return msgbox == QMessageBox.Close


    def confirmMessage(self, title, text, subtext=None, action=None):
        '''Present a confirmation dialog.

        If action is given, it is used as button label instead of the default
        'OK'.  Return True if the user confirms, False otherwise.
        '''
        text = '<h3>%s</h3>' % text
        if subtext:
            text += subtext
        text = text.replace('\n', '<br/>')
        msgbox = QMessageBox(title, text, QMessageBox.Question,
                QMessageBox.Ok | QMessageBox.Default, 
                QMessageBox.Cancel | QMessageBox.Escape, 
                QMessageBox.NoButton,
                self)
        if action:
            msgbox.setButtonText(0, action)

        mb = msgbox.exec_()
        # QMessageBox returns a StandardButton, output a boolean
        return mb == QMessageBox.Ok
    
    
    
    def applyChanges(self):
        '''
        Execute the command and let qtlogger do the rest
        
        self.drv    -> ATI or NVIDIA
        self.ver    -> e.g. 169.09, etc.
        self.save -> save the packages
        self.build -> build the packages without installing them
        self.curAction -> e.g. automatic, install, uninstall
        '''
        self.drv = self.curDriver.lower()
        self.ver = self.curFlavour
        self.save = self.savePackages
        self.build = self.downloadOnly
        self.completetxt = []
        logtxtfile = QString('/var/log/envy-installer.log')
        dir = QString('/usr/share/envy')
        
        '''
        QProcess bits
        '''
        
        #self.myProcess = QProcess()
        #self.connect(self.myProcess, SIGNAL("readyReadStandardOutput()"), self.readOutput)
        #self.connect(self.myProcess, SIGNAL("readyReadStandardError()"), self.readErrors)
        #self.connect(self.myProcess, SIGNAL("finished(int)"), self.endCommand)
        
        
        
        '''
        Installation Process
        '''
        
        self.canStart = 1
        
        
        
        if self.build == 0:
            self.mustRestart = 1#it needs a system restart
        else:
            self.mustRestart = 0#it doesn't need a system restart
        
        if self.curAction == 'automatic':
            if self.save == 1:#Save the packages
                '''
                self.savePath may exist even when self.save=0
                '''

                '''
                Automatic selection
                4 arguments
                '''
                self.getPath()#get self.savePath
                
                if not os.path.isdir(self.savePath):
                    self.canStart = 0
                    self.path_dialog()
                else:
                    command = QString('sudo python pulse.py %s %i %i %s' % (self.drv, self.save, self.build, self.savePath))
                    print 'python pulse.py %s %i %i %s \n' % (self.drv, self.save, self.build, self.savePath)
            else:#Do not Save the packages
                '''
                Automatic selection
                1 argument
                '''
                command = QString('sudo python pulse.py %s' % (self.drv))
                print 'python pulse.py %s \n' % (self.drv)
        
        elif self.curAction == 'manual':
            if self.save == 1:#Save the packages
                '''
                self.savePath may exist even when self.save=0
                '''
                self.getPath()#get self.savePath
                '''
                Manual selection
                5 arguments
                '''
                if not os.path.isdir(self.savePath):
                    self.canStart = 0
                    self.path_dialog()
                else:
                    command = QString('sudo python pulse.py %s %s %i %i %s' % (self.drv, self.ver, self.save, self.build, self.savePath))
                    print 'python pulse.py %s %s %i %i %s \n' % (self.drv, self.ver, self.save, self.build, self.savePath)
            
            else:#Do not Save the packages
                '''
                Manual selection
                2 arguments
                '''
                command = QString('sudo python pulse.py %s %s' % (self.drv, self.ver))
                print 'python pulse.py %s %s \n' % (self.drv, self.ver)
        
        elif self.curAction == 'uninstall':
            command = QString('sudo python pulse.py %s %s' % (self.drv, 'uninstall'))
            print 'python pulse.py %s %s \n' % (self.drv, 'uninstall')
            
        if self.canStart == 1:
            #self.mycommand = command
            #self.filename = logtxtfile
            #launch = qtlogger.EnvyTerm()
            #launch.show()
            launch = qtlogger.EnvyTerm(command, dir, logtxtfile, self.mustRestart, self)
            #launch.startCommand()
            launch.show()
            launch.startCommand()
    
    
    def getPath(self):
        '''
        Get self.savePath from the lineEdit
        '''
        self.savePath = self.lineEdit.text()
        #print 'My savePath is ' + self.savePath
        return self.savePath
    
    @pyqtSignature("")
    def on_save_button_clicked(self):
        dir = '.'
        formats = ["*.%s" % unicode(format).lower() \
                   for format in QImageWriter.supportedImageFormats()]
        dir = unicode(QFileDialog.getExistingDirectory(self,
                        self.translation.string_select_dir, "/home", QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks))
        if dir:
            self.savePath = dir
            self.lineEdit.setText(self.savePath)
    
    @pyqtSignature("bool")
    def on_save_checkbox_toggled(self, istoggled):
        if istoggled == 1:
            print "Save enabled"
        elif istoggled == 0:
            print "Save disabled"
            self.build_checkbox.setChecked(istoggled)
        self.savePackages = istoggled
            
    
    @pyqtSignature("bool")
    def on_build_checkbox_toggled(self, istoggled):
        if istoggled == 1:
            print "Build Only enabled"
        elif istoggled == 0:
            print "Build Only disabled"
        self.downloadOnly = istoggled
    
    @pyqtSignature("")
    def on_about_button_clicked(self):
        version = QString(EnvyNGVersion)
        about = qtabout.AboutDlg(version, self)
        #about.label.setPixmap(QPixmap('/usr/share/envyng-qt/pixmaps/envyng.png'))
        about.headerLabel.setPixmap(QPixmap('/usr/share/envyng-qt/pixmaps/logo.png'))
        about.setWindowIcon(QIcon('/usr/share/envyng-qt/pixmaps/envyng.png'))
        about.show()

    def depTryNot(self):
        #self.sessioncheck()
        testme = classes.Shutilities()
        self.missingpkgs = testme.envydeps(self.qtdeps)
        if self.missingpkgs != None:#missing dependencies
            self.deperror()
        else:
            self.show()

        
    def depTry(self):
        self.sessioncheck()
        testme = classes.Shutilities()
        self.missingpkgs = testme.envydeps(self.qtdeps)
        if self.missingpkgs != None:#missing dependencies
            self.deperror()
        else:
            self.show()
    
    def deperror(self):
        pkgs = classes.Shutilities()
        errpkgs = pkgs.envydeps(self.qtdeps)
        #errpkgs = ['pacchetto1', 'pacchetto2', 'pacchetto3']

        response = False
        # buttons texts
        CLOSE = self.translation.string_close_button

        message = QMessageBox(self)
        message.setText(self.translation.string_connection_error)
        message.setWindowTitle(self.translation.string_error_title)
        message.setIcon(QMessageBox.Critical)
        message.addButton(CLOSE, QMessageBox.RejectRole)
        message.exec_()
        response = message.clickedButton().text()
#        if response == CLOSE:
#            self.depTry()
            #print response
        
        
    
    def initdepStart(self):#,  widget
        response = False
        # buttons texts
        YES = self.translation.string_yes
        NO = self.translation.string_no

        message = QMessageBox(self)
        message.setText(self.translation.string_install_deps)
        message.setWindowTitle('EnvyNG')
        message.setIcon(QMessageBox.Question)
        message.addButton(YES, QMessageBox.AcceptRole)
        message.addButton(NO, QMessageBox.RejectRole)
        #message.setDetailedText('(EnvyNG won\'t work without them)')
        message.exec_()
        response = message.clickedButton().text()
        if response == YES:
            self.depTry()
            #print response
        elif response == NO:
            self.depTryNot()
            #print response
        
    def depcheck(self, data=None):
        testme = classes.Shutilities()
        #self.missingpkgs = testme.envydeps(self.qtdeps)
        
        #if self.missingpkgs != None:#missing dependencies
        print 'TESTING CONNECTION'
        if classes.connectionCheck():
            print 'OK: Connection is available'
            self.show()
            self.checkLatest()

        else:
            print 'ERROR: Connection is not available'
            self.deperror()
        #else:
            #self.show()
        
    def kderefresh(self, data=None):
        '''
        dependency > make sure adept-batch is installed
        
        it uses apt-get like syntax
        
        adept_batch install, adept_batch remove
        '''
        commd = classes.Shutilities()
        commd.cmdoutput('kdesu /usr/bin/adept_batch update')
        
    def kdeinstall(self, data=None):
        commd = classes.Shutilities()
        commd.cmdoutput('kdesu /usr/bin/adept_batch install ' + \
        ' '.join(self.missingpkgs))
        
    def sessioncheck(self, data=None):
        '''
        FIX ME
        '''
        if os.path.isfile('/usr/bin/adept_batch') == True:
            self.kderefresh()
            self.kdeinstall()
        #elif self.session == 'kde' and os.path.isfile('/usr/bin/adept_batch') == True:
            #self.kderefresh()
            #self.kdeinstall()
    
    def osdetect(self, data=None):
        getver = classes.Specsdetect()
        getver.codename()
        self.osver = getver.details['osname']
    
    def checkLatest(self, data=None):
        variables = classes.Vars(1)
        self.atilatest = variables.atimanlatest
        self.atinewlegacy = variables.atimannewlegacy
        self.atilegacy = variables.atimanlegacy
        self.nvbeta = variables.nvmanbeta
        self.nvlatest = variables.nvmanlatest
        self.nvnewlegacy = variables.nvmannewlegacy
        self.nvlegacy = variables.nvmanlegacy
        
        self.atiVersions = {'latest': self.atilatest,  'middle': self.atinewlegacy, 'oldest': self.atilegacy,  'beta': None}
        self.nvidiaVersions = {'latest': self.nvlatest,  'middle': self.nvnewlegacy, 'oldest': self.nvlegacy,  'beta': self.nvbeta}
        self.driverMap = {'ATI': self.atiVersions, 'NVIDIA': self.nvidiaVersions}
        self.setLabels()

appName = "envyng"
catalog = ""
programName = ki18n ("EnvyNG")
version = "2.0"
description = ki18n ("EnvyNG")
license = KAboutData.License_GPL
copyright = ki18n("(c) 2007 Alberto Milone")
text = ki18n ("none")
homePage = "http://www.albertomilone.com/nvidia_scripts1.html"
#bugEmail = ""

#generates the about data entry from the provided information.
aboutData = KAboutData(appName, catalog, programName, version, description, license, copyright, text, homePage)

aboutData.addAuthor(ki18n("Alberto Milone"), ki18n("Main developer"))

if __name__ == '__main__':
    import sys
    os.chdir('/usr/share/envy')
    argscopy = sys.argv
    sys.argv = [""]
    KCmdLineArgs.init(sys.argv, aboutData)
    app = KApplication()
    form = EnvyMainDlg()
    form.show()
    app.exec_()
