#include <stdint.h>
#include "ft2_intrp_table.h"

// 4-tap cubic spline table

#if defined __amd64__ || defined _WIN64

// 15-bit precision, 8192 phases (slightly harder on the CPU cache)

const int16_t cubicSplineTable[CUBIC_WIDTH * CUBIC_PHASES] =
{
	    0, 32767,     0,     0,    -2, 32767,     2,     0,    -4, 32767,     4,     0,    -6, 32767,     6,     0,
	   -8, 32767,     8,     0,   -10, 32767,    10,     0,   -12, 32767,    12,     0,   -14, 32767,    14,     0,
	  -16, 32767,    16,     0,   -18, 32767,    18,     0,   -20, 32767,    20,     0,   -22, 32767,    22,     0,
	  -24, 32767,    24,     0,   -26, 32767,    26,     0,   -28, 32767,    28,     0,   -30, 32767,    30,     0,
	  -32, 32767,    32,     0,   -34, 32767,    34,     0,   -36, 32767,    36,     0,   -38, 32767,    38,     0,
	  -40, 32767,    40,     0,   -42, 32767,    42,     0,   -44, 32767,    44,     0,   -46, 32767,    47,     0,
	  -48, 32767,    49,     0,   -50, 32767,    51,     0,   -52, 32767,    53,     0,   -54, 32767,    55,     0,
	  -56, 32767,    57,     0,   -58, 32767,    59,     0,   -60, 32767,    61,     0,   -62, 32767,    63,     0,
	  -64, 32767,    65,     0,   -65, 32766,    67,     0,   -67, 32766,    69,     0,   -69, 32766,    71,     0,
	  -71, 32766,    73,     0,   -73, 32766,    75,     0,   -75, 32766,    77,     0,   -77, 32766,    79,     0,
	  -79, 32765,    82,     0,   -81, 32765,    84,     0,   -83, 32765,    86,     0,   -85, 32765,    88,     0,
	  -87, 32765,    90,     0,   -89, 32765,    92,     0,   -91, 32766,    94,    -1,   -93, 32766,    96,    -1,
	  -95, 32766,    98,    -1,   -97, 32766,   100,    -1,   -99, 32766,   102,    -1,  -101, 32765,   105,    -1,
	 -103, 32765,   107,    -1,  -105, 32765,   109,    -1,  -107, 32765,   111,    -1,  -109, 32765,   113,    -1,
	 -110, 32764,   115,    -1,  -112, 32764,   117,    -1,  -114, 32764,   119,    -1,  -116, 32764,   121,    -1,
	 -118, 32764,   123,    -1,  -120, 32763,   126,    -1,  -122, 32763,   128,    -1,  -124, 32763,   130,    -1,
	 -126, 32763,   132,    -1,  -128, 32763,   134,    -1,  -130, 32763,   136,    -1,  -132, 32763,   138,    -1,
	 -134, 32763,   140,    -1,  -136, 32762,   143,    -1,  -138, 32762,   145,    -1,  -140, 32762,   147,    -1,
	 -141, 32761,   149,    -1,  -143, 32761,   151,    -1,  -145, 32761,   153,    -1,  -147, 32761,   155,    -1,
	 -149, 32760,   158,    -1,  -151, 32760,   160,    -1,  -153, 32760,   162,    -1,  -155, 32761,   164,    -2,
	 -157, 32761,   166,    -2,  -159, 32761,   168,    -2,  -161, 32760,   171,    -2,  -163, 32760,   173,    -2,
	 -165, 32760,   175,    -2,  -166, 32759,   177,    -2,  -168, 32759,   179,    -2,  -170, 32759,   181,    -2,
	 -172, 32758,   184,    -2,  -174, 32758,   186,    -2,  -176, 32758,   188,    -2,  -178, 32758,   190,    -2,
	 -180, 32758,   192,    -2,  -182, 32758,   194,    -2,  -184, 32757,   197,    -2,  -186, 32757,   199,    -2,
	 -188, 32757,   201,    -2,  -189, 32756,   203,    -2,  -191, 32756,   205,    -2,  -193, 32756,   207,    -2,
	 -195, 32755,   210,    -2,  -197, 32755,   212,    -2,  -199, 32756,   214,    -3,  -201, 32756,   216,    -3,
	 -203, 32756,   218,    -3,  -205, 32755,   221,    -3,  -207, 32755,   223,    -3,  -208, 32754,   225,    -3,
	 -210, 32754,   227,    -3,  -212, 32754,   229,    -3,  -214, 32753,   232,    -3,  -216, 32753,   234,    -3,
	 -218, 32753,   236,    -3,  -220, 32753,   238,    -3,  -222, 32752,   241,    -3,  -224, 32752,   243,    -3,
	 -225, 32751,   245,    -3,  -227, 32751,   247,    -3,  -229, 32751,   249,    -3,  -231, 32750,   252,    -3,
	 -233, 32750,   254,    -3,  -235, 32751,   256,    -4,  -237, 32751,   258,    -4,  -239, 32750,   261,    -4,
	 -241, 32750,   263,    -4,  -242, 32749,   265,    -4,  -244, 32749,   267,    -4,  -246, 32748,   270,    -4,
	 -248, 32748,   272,    -4,  -250, 32748,   274,    -4,  -252, 32748,   276,    -4,  -254, 32747,   279,    -4,
	 -256, 32747,   281,    -4,  -257, 32746,   283,    -4,  -259, 32746,   285,    -4,  -261, 32745,   288,    -4,
	 -263, 32745,   290,    -4,  -265, 32746,   292,    -5,  -267, 32746,   294,    -5,  -269, 32745,   297,    -5,
	 -271, 32745,   299,    -5,  -272, 32744,   301,    -5,  -274, 32744,   303,    -5,  -276, 32743,   306,    -5,
	 -278, 32743,   308,    -5,  -280, 32743,   310,    -5,  -282, 32742,   313,    -5,  -284, 32742,   315,    -5,
	 -285, 32741,   317,    -5,  -287, 32741,   319,    -5,  -289, 32740,   322,    -5,  -291, 32740,   324,    -5,
	 -293, 32741,   326,    -6,  -295, 32740,   329,    -6,  -297, 32740,   331,    -6,  -298, 32739,   333,    -6,
	 -300, 32739,   335,    -6,  -302, 32738,   338,    -6,  -304, 32738,   340,    -6,  -306, 32738,   342,    -6,
	 -308, 32737,   345,    -6,  -309, 32736,   347,    -6,  -311, 32736,   349,    -6,  -313, 32735,   352,    -6,
	 -315, 32735,   354,    -6,  -317, 32736,   356,    -7,  -319, 32735,   359,    -7,  -321, 32735,   361,    -7,
	 -322, 32734,   363,    -7,  -324, 32734,   365,    -7,  -326, 32733,   368,    -7,  -328, 32733,   370,    -7,
	 -330, 32733,   372,    -7,  -332, 32732,   375,    -7,  -333, 32731,   377,    -7,  -335, 32731,   379,    -7,
	 -337, 32730,   382,    -7,  -339, 32730,   384,    -7,  -341, 32731,   386,    -8,  -343, 32730,   389,    -8,
	 -344, 32729,   391,    -8,  -346, 32729,   393,    -8,  -348, 32728,   396,    -8,  -350, 32728,   398,    -8,
	 -352, 32727,   401,    -8,  -353, 32726,   403,    -8,  -355, 32726,   405,    -8,  -357, 32725,   408,    -8,
	 -359, 32725,   410,    -8,  -361, 32726,   412,    -9,  -363, 32725,   415,    -9,  -364, 32724,   417,    -9,
	 -366, 32724,   419,    -9,  -368, 32723,   422,    -9,  -370, 32723,   424,    -9,  -372, 32723,   426,    -9,
	 -373, 32721,   429,    -9,  -375, 32721,   431,    -9,  -377, 32720,   434,    -9,  -379, 32720,   436,    -9,
	 -381, 32721,   438,   -10,  -383, 32720,   441,   -10,  -384, 32719,   443,   -10,  -386, 32719,   445,   -10,
	 -388, 32718,   448,   -10,  -390, 32718,   450,   -10,  -392, 32717,   453,   -10,  -393, 32716,   455,   -10,
	 -395, 32716,   457,   -10,  -397, 32715,   460,   -10,  -399, 32715,   462,   -10,  -401, 32715,   465,   -11,
	 -402, 32714,   467,   -11,  -404, 32714,   469,   -11,  -406, 32713,   472,   -11,  -408, 32713,   474,   -11,
	 -410, 32712,   477,   -11,  -411, 32711,   479,   -11,  -413, 32711,   481,   -11,  -415, 32710,   484,   -11,
	 -417, 32710,   486,   -11,  -418, 32709,   489,   -12,  -420, 32709,   491,   -12,  -422, 32708,   494,   -12,
	 -424, 32708,   496,   -12,  -426, 32708,   498,   -12,  -427, 32706,   501,   -12,  -429, 32706,   503,   -12,
	 -431, 32705,   506,   -12,  -433, 32705,   508,   -12,  -435, 32705,   511,   -13,  -436, 32704,   513,   -13,
	 -438, 32704,   515,   -13,  -440, 32703,   518,   -13,  -442, 32703,   520,   -13,  -443, 32701,   523,   -13,
	 -445, 32701,   525,   -13,  -447, 32700,   528,   -13,  -449, 32700,   530,   -13,  -451, 32700,   533,   -14,
	 -452, 32699,   535,   -14,  -454, 32699,   537,   -14,  -456, 32698,   540,   -14,  -458, 32698,   542,   -14,
	 -459, 32696,   545,   -14,  -461, 32696,   547,   -14,  -463, 32695,   550,   -14,  -465, 32695,   552,   -14,
	 -466, 32694,   555,   -15,  -468, 32694,   557,   -15,  -470, 32693,   560,   -15,  -472, 32693,   562,   -15,
	 -473, 32691,   565,   -15,  -475, 32691,   567,   -15,  -477, 32690,   570,   -15,  -479, 32690,   572,   -15,
	 -481, 32690,   575,   -16,  -482, 32689,   577,   -16,  -484, 32689,   579,   -16,  -486, 32688,   582,   -16,
	 -488, 32688,   584,   -16,  -489, 32686,   587,   -16,  -491, 32686,   589,   -16,  -493, 32685,   592,   -16,
	 -495, 32685,   594,   -16,  -496, 32684,   597,   -17,  -498, 32684,   599,   -17,  -500, 32683,   602,   -17,
	 -502, 32683,   604,   -17,  -503, 32681,   607,   -17,  -505, 32681,   609,   -17,  -507, 32680,   612,   -17,
	 -508, 32679,   614,   -17,  -510, 32679,   617,   -18,  -512, 32679,   619,   -18,  -514, 32678,   622,   -18,
	 -515, 32676,   625,   -18,  -517, 32676,   627,   -18,  -519, 32675,   630,   -18,  -521, 32675,   632,   -18,
	 -522, 32673,   635,   -18,  -524, 32674,   637,   -19,  -526, 32673,   640,   -19,  -528, 32673,   642,   -19,
	 -529, 32671,   645,   -19,  -531, 32671,   647,   -19,  -533, 32670,   650,   -19,  -534, 32669,   652,   -19,
	 -536, 32669,   655,   -20,  -538, 32669,   657,   -20,  -540, 32668,   660,   -20,  -541, 32667,   662,   -20,
	 -543, 32666,   665,   -20,  -545, 32665,   668,   -20,  -547, 32665,   670,   -20,  -548, 32663,   673,   -20,
	 -550, 32664,   675,   -21,  -552, 32663,   678,   -21,  -553, 32662,   680,   -21,  -555, 32661,   683,   -21,
	 -557, 32661,   685,   -21,  -559, 32660,   688,   -21,  -560, 32658,   691,   -21,  -562, 32659,   693,   -22,
	 -564, 32658,   696,   -22,  -565, 32657,   698,   -22,  -567, 32656,   701,   -22,  -569, 32656,   703,   -22,
	 -571, 32655,   706,   -22,  -572, 32653,   709,   -22,  -574, 32654,   711,   -23,  -576, 32653,   714,   -23,
	 -577, 32652,   716,   -23,  -579, 32651,   719,   -23,  -581, 32650,   722,   -23,  -582, 32649,   724,   -23,
	 -584, 32648,   727,   -23,  -586, 32649,   729,   -24,  -588, 32648,   732,   -24,  -589, 32647,   734,   -24,
	 -591, 32646,   737,   -24,  -593, 32645,   740,   -24,  -594, 32644,   742,   -24,  -596, 32643,   745,   -24,
	 -598, 32644,   747,   -25,  -599, 32642,   750,   -25,  -601, 32641,   753,   -25,  -603, 32641,   755,   -25,
	 -605, 32640,   758,   -25,  -606, 32638,   761,   -25,  -608, 32639,   763,   -26,  -610, 32638,   766,   -26,
	 -611, 32637,   768,   -26,  -613, 32636,   771,   -26,  -615, 32635,   774,   -26,  -616, 32634,   776,   -26,
	 -618, 32633,   779,   -26,  -620, 32634,   781,   -27,  -621, 32632,   784,   -27,  -623, 32631,   787,   -27,
	 -625, 32631,   789,   -27,  -626, 32629,   792,   -27,  -628, 32628,   795,   -27,  -630, 32629,   797,   -28,
	 -631, 32627,   800,   -28,  -633, 32626,   803,   -28,  -635, 32626,   805,   -28,  -636, 32624,   808,   -28,
	 -638, 32624,   810,   -28,  -640, 32623,   813,   -28,  -641, 32622,   816,   -29,  -643, 32622,   818,   -29,
	 -645, 32621,   821,   -29,  -646, 32619,   824,   -29,  -648, 32619,   826,   -29,  -650, 32618,   829,   -29,
	 -651, 32617,   832,   -30,  -653, 32617,   834,   -30,  -655, 32616,   837,   -30,  -656, 32614,   840,   -30,
	 -658, 32614,   842,   -30,  -660, 32613,   845,   -30,  -661, 32612,   848,   -31,  -663, 32612,   850,   -31,
	 -665, 32611,   853,   -31,  -666, 32609,   856,   -31,  -668, 32609,   858,   -31,  -670, 32608,   861,   -31,
	 -671, 32607,   864,   -32,  -673, 32607,   866,   -32,  -675, 32606,   869,   -32,  -676, 32604,   872,   -32,
	 -678, 32603,   875,   -32,  -680, 32603,   877,   -32,  -681, 32602,   880,   -33,  -683, 32601,   883,   -33,
	 -685, 32601,   885,   -33,  -686, 32599,   888,   -33,  -688, 32598,   891,   -33,  -689, 32597,   893,   -33,
	 -691, 32597,   896,   -34,  -693, 32596,   899,   -34,  -694, 32594,   902,   -34,  -696, 32594,   904,   -34,
	 -698, 32593,   907,   -34,  -699, 32591,   910,   -34,  -701, 32592,   912,   -35,  -703, 32591,   915,   -35,
	 -704, 32589,   918,   -35,  -706, 32588,   921,   -35,  -708, 32588,   923,   -35,  -709, 32587,   926,   -36,
	 -711, 32586,   929,   -36,  -712, 32585,   931,   -36,  -714, 32584,   934,   -36,  -716, 32583,   937,   -36,
	 -717, 32581,   940,   -36,  -719, 32582,   942,   -37,  -721, 32581,   945,   -37,  -722, 32579,   948,   -37,
	 -724, 32578,   951,   -37,  -725, 32577,   953,   -37,  -727, 32577,   956,   -38,  -729, 32576,   959,   -38,
	 -730, 32575,   961,   -38,  -732, 32574,   964,   -38,  -734, 32573,   967,   -38,  -735, 32571,   970,   -38,
	 -737, 32572,   972,   -39,  -738, 32570,   975,   -39,  -740, 32569,   978,   -39,  -742, 32568,   981,   -39,
	 -743, 32566,   984,   -39,  -745, 32567,   986,   -40,  -746, 32565,   989,   -40,  -748, 32564,   992,   -40,
	 -750, 32563,   995,   -40,  -751, 32562,   997,   -40,  -753, 32561,  1000,   -40,  -754, 32560,  1003,   -41,
	 -756, 32559,  1006,   -41,  -758, 32559,  1008,   -41,  -759, 32557,  1011,   -41,  -761, 32556,  1014,   -41,
	 -762, 32555,  1017,   -42,  -764, 32554,  1020,   -42,  -766, 32554,  1022,   -42,  -767, 32552,  1025,   -42,
	 -769, 32551,  1028,   -42,  -770, 32550,  1031,   -43,  -772, 32550,  1033,   -43,  -774, 32549,  1036,   -43,
	 -775, 32547,  1039,   -43,  -777, 32546,  1042,   -43,  -778, 32545,  1045,   -44,  -780, 32545,  1047,   -44,
	 -782, 32544,  1050,   -44,  -783, 32542,  1053,   -44,  -785, 32541,  1056,   -44,  -786, 32540,  1059,   -45,
	 -788, 32540,  1061,   -45,  -790, 32539,  1064,   -45,  -791, 32537,  1067,   -45,  -793, 32536,  1070,   -45,
	 -794, 32535,  1073,   -46,  -796, 32534,  1076,   -46,  -798, 32534,  1078,   -46,  -799, 32532,  1081,   -46,
	 -801, 32531,  1084,   -46,  -802, 32530,  1087,   -47,  -804, 32529,  1090,   -47,  -805, 32528,  1092,   -47,
	 -807, 32527,  1095,   -47,  -809, 32526,  1098,   -47,  -810, 32525,  1101,   -48,  -812, 32524,  1104,   -48,
	 -813, 32522,  1107,   -48,  -815, 32522,  1109,   -48,  -816, 32520,  1112,   -48,  -818, 32520,  1115,   -49,
	 -820, 32519,  1118,   -49,  -821, 32517,  1121,   -49,  -823, 32516,  1124,   -49,  -824, 32515,  1126,   -49,
	 -826, 32515,  1129,   -50,  -827, 32513,  1132,   -50,  -829, 32512,  1135,   -50,  -831, 32511,  1138,   -50,
	 -832, 32509,  1141,   -50,  -834, 32509,  1144,   -51,  -835, 32508,  1146,   -51,  -837, 32507,  1149,   -51,
	 -838, 32505,  1152,   -51,  -840, 32504,  1155,   -51,  -841, 32503,  1158,   -52,  -843, 32502,  1161,   -52,
	 -845, 32501,  1164,   -52,  -846, 32500,  1166,   -52,  -848, 32500,  1169,   -53,  -849, 32498,  1172,   -53,
	 -851, 32497,  1175,   -53,  -852, 32495,  1178,   -53,  -854, 32494,  1181,   -53,  -855, 32493,  1184,   -54,
	 -857, 32492,  1187,   -54,  -859, 32491,  1190,   -54,  -860, 32490,  1192,   -54,  -862, 32489,  1195,   -54,
	 -863, 32488,  1198,   -55,  -865, 32487,  1201,   -55,  -866, 32485,  1204,   -55,  -868, 32484,  1207,   -55,
	 -869, 32483,  1210,   -56,  -871, 32482,  1213,   -56,  -872, 32480,  1216,   -56,  -874, 32480,  1218,   -56,
	 -876, 32479,  1221,   -56,  -877, 32478,  1224,   -57,  -879, 32477,  1227,   -57,  -880, 32475,  1230,   -57,
	 -882, 32474,  1233,   -57,  -883, 32473,  1236,   -58,  -885, 32472,  1239,   -58,  -886, 32470,  1242,   -58,
	 -888, 32469,  1245,   -58,  -889, 32467,  1248,   -58,  -891, 32468,  1250,   -59,  -892, 32466,  1253,   -59,
	 -894, 32465,  1256,   -59,  -895, 32463,  1259,   -59,  -897, 32463,  1262,   -60,  -898, 32461,  1265,   -60,
	 -900, 32460,  1268,   -60,  -902, 32459,  1271,   -60,  -903, 32457,  1274,   -60,  -905, 32457,  1277,   -61,
	 -906, 32455,  1280,   -61,  -908, 32454,  1283,   -61,  -909, 32452,  1286,   -61,  -911, 32452,  1289,   -62,
	 -912, 32451,  1291,   -62,  -914, 32450,  1294,   -62,  -915, 32448,  1297,   -62,  -917, 32448,  1300,   -63,
	 -918, 32446,  1303,   -63,  -920, 32445,  1306,   -63,  -921, 32443,  1309,   -63,  -923, 32442,  1312,   -63,
	 -924, 32441,  1315,   -64,  -926, 32440,  1318,   -64,  -927, 32438,  1321,   -64,  -929, 32437,  1324,   -64,
	 -930, 32436,  1327,   -65,  -932, 32435,  1330,   -65,  -933, 32433,  1333,   -65,  -935, 32432,  1336,   -65,
	 -936, 32431,  1339,   -66,  -938, 32430,  1342,   -66,  -939, 32428,  1345,   -66,  -941, 32427,  1348,   -66,
	 -942, 32425,  1351,   -66,  -944, 32425,  1354,   -67,  -945, 32423,  1357,   -67,  -947, 32422,  1360,   -67,
	 -948, 32420,  1363,   -67,  -950, 32420,  1366,   -68,  -951, 32418,  1369,   -68,  -953, 32417,  1372,   -68,
	 -954, 32415,  1375,   -68,  -956, 32415,  1378,   -69,  -957, 32413,  1381,   -69,  -959, 32412,  1384,   -69,
	 -960, 32410,  1387,   -69,  -962, 32410,  1390,   -70,  -963, 32408,  1393,   -70,  -965, 32407,  1396,   -70,
	 -966, 32405,  1399,   -70,  -968, 32405,  1402,   -71,  -969, 32403,  1405,   -71,  -971, 32402,  1408,   -71,
	 -972, 32400,  1411,   -71,  -974, 32400,  1414,   -72,  -975, 32398,  1417,   -72,  -977, 32397,  1420,   -72,
	 -978, 32395,  1423,   -72,  -980, 32395,  1426,   -73,  -981, 32393,  1429,   -73,  -982, 32391,  1432,   -73,
	 -984, 32390,  1435,   -73,  -985, 32389,  1438,   -74,  -987, 32388,  1441,   -74,  -988, 32386,  1444,   -74,
	 -990, 32385,  1447,   -74,  -991, 32384,  1450,   -75,  -993, 32383,  1453,   -75,  -994, 32381,  1456,   -75,
	 -996, 32380,  1459,   -75,  -997, 32379,  1462,   -76,  -999, 32378,  1465,   -76, -1000, 32376,  1468,   -76,
	-1002, 32375,  1471,   -76, -1003, 32374,  1474,   -77, -1004, 32372,  1477,   -77, -1006, 32371,  1480,   -77,
	-1007, 32369,  1483,   -77, -1009, 32369,  1486,   -78, -1010, 32367,  1489,   -78, -1012, 32366,  1492,   -78,
	-1013, 32364,  1495,   -78, -1015, 32363,  1499,   -79, -1016, 32361,  1502,   -79, -1018, 32360,  1505,   -79,
	-1019, 32358,  1508,   -79, -1021, 32358,  1511,   -80, -1022, 32356,  1514,   -80, -1023, 32354,  1517,   -80,
	-1025, 32353,  1520,   -80, -1026, 32352,  1523,   -81, -1028, 32351,  1526,   -81, -1029, 32349,  1529,   -81,
	-1031, 32348,  1532,   -81, -1032, 32347,  1535,   -82, -1034, 32346,  1538,   -82, -1035, 32344,  1541,   -82,
	-1036, 32341,  1545,   -82, -1038, 32341,  1548,   -83, -1039, 32339,  1551,   -83, -1041, 32338,  1554,   -83,
	-1042, 32337,  1557,   -84, -1044, 32336,  1560,   -84, -1045, 32334,  1563,   -84, -1047, 32333,  1566,   -84,
	-1048, 32332,  1569,   -85, -1049, 32330,  1572,   -85, -1051, 32329,  1575,   -85, -1052, 32326,  1579,   -85,
	-1054, 32326,  1582,   -86, -1055, 32324,  1585,   -86, -1057, 32323,  1588,   -86, -1058, 32321,  1591,   -86,
	-1059, 32320,  1594,   -87, -1061, 32319,  1597,   -87, -1062, 32317,  1600,   -87, -1064, 32317,  1603,   -88,
	-1065, 32314,  1607,   -88, -1067, 32313,  1610,   -88, -1068, 32311,  1613,   -88, -1069, 32310,  1616,   -89,
	-1071, 32309,  1619,   -89, -1072, 32307,  1622,   -89, -1074, 32306,  1625,   -89, -1075, 32305,  1628,   -90,
	-1076, 32303,  1631,   -90, -1078, 32301,  1635,   -90, -1079, 32300,  1638,   -91, -1081, 32299,  1641,   -91,
	-1082, 32297,  1644,   -91, -1084, 32296,  1647,   -91, -1085, 32295,  1650,   -92, -1086, 32293,  1653,   -92,
	-1088, 32291,  1657,   -92, -1089, 32289,  1660,   -92, -1091, 32289,  1663,   -93, -1092, 32287,  1666,   -93,
	-1093, 32285,  1669,   -93, -1095, 32285,  1672,   -94, -1096, 32283,  1675,   -94, -1098, 32281,  1679,   -94,
	-1099, 32279,  1682,   -94, -1100, 32278,  1685,   -95, -1102, 32277,  1688,   -95, -1103, 32275,  1691,   -95,
	-1105, 32275,  1694,   -96, -1106, 32272,  1698,   -96, -1107, 32270,  1701,   -96, -1109, 32269,  1704,   -96,
	-1110, 32268,  1707,   -97, -1112, 32267,  1710,   -97, -1113, 32265,  1713,   -97, -1114, 32262,  1717,   -97,
	-1116, 32262,  1720,   -98, -1117, 32260,  1723,   -98, -1119, 32259,  1726,   -98, -1120, 32258,  1729,   -99,
	-1121, 32256,  1732,   -99, -1123, 32254,  1736,   -99, -1124, 32252,  1739,   -99, -1126, 32252,  1742,  -100,
	-1127, 32250,  1745,  -100, -1128, 32248,  1748,  -100, -1130, 32248,  1751,  -101, -1131, 32245,  1755,  -101,
	-1133, 32244,  1758,  -101, -1134, 32242,  1761,  -101, -1135, 32241,  1764,  -102, -1137, 32240,  1767,  -102,
	-1138, 32237,  1771,  -102, -1139, 32236,  1774,  -103, -1141, 32235,  1777,  -103, -1142, 32233,  1780,  -103,
	-1144, 32233,  1783,  -104, -1145, 32230,  1787,  -104, -1146, 32228,  1790,  -104, -1148, 32227,  1793,  -104,
	-1149, 32226,  1796,  -105, -1150, 32224,  1799,  -105, -1152, 32222,  1803,  -105, -1153, 32221,  1806,  -106,
	-1155, 32220,  1809,  -106, -1156, 32218,  1812,  -106, -1157, 32215,  1816,  -106, -1159, 32215,  1819,  -107,
	-1160, 32213,  1822,  -107, -1161, 32211,  1825,  -107, -1163, 32211,  1828,  -108, -1164, 32208,  1832,  -108,
	-1166, 32207,  1835,  -108, -1167, 32206,  1838,  -109, -1168, 32204,  1841,  -109, -1170, 32202,  1845,  -109,
	-1171, 32200,  1848,  -109, -1172, 32199,  1851,  -110, -1174, 32198,  1854,  -110, -1175, 32195,  1858,  -110,
	-1176, 32194,  1861,  -111, -1178, 32193,  1864,  -111, -1179, 32191,  1867,  -111, -1180, 32189,  1871,  -112,
	-1182, 32188,  1874,  -112, -1183, 32186,  1877,  -112, -1185, 32185,  1880,  -112, -1186, 32183,  1884,  -113,
	-1187, 32181,  1887,  -113, -1189, 32180,  1890,  -113, -1190, 32179,  1893,  -114, -1191, 32176,  1897,  -114,
	-1193, 32175,  1900,  -114, -1194, 32174,  1903,  -115, -1195, 32172,  1906,  -115, -1197, 32170,  1910,  -115,
	-1198, 32168,  1913,  -115, -1199, 32167,  1916,  -116, -1201, 32166,  1919,  -116, -1202, 32163,  1923,  -116,
	-1203, 32162,  1926,  -117, -1205, 32161,  1929,  -117, -1206, 32158,  1933,  -117, -1207, 32157,  1936,  -118,
	-1209, 32156,  1939,  -118, -1210, 32154,  1942,  -118, -1211, 32152,  1946,  -119, -1213, 32151,  1949,  -119,
	-1214, 32149,  1952,  -119, -1215, 32147,  1955,  -119, -1217, 32146,  1959,  -120, -1218, 32144,  1962,  -120,
	-1219, 32142,  1965,  -120, -1221, 32141,  1969,  -121, -1222, 32139,  1972,  -121, -1223, 32137,  1975,  -121,
	-1225, 32136,  1979,  -122, -1226, 32134,  1982,  -122, -1227, 32132,  1985,  -122, -1229, 32132,  1988,  -123,
	-1230, 32129,  1992,  -123, -1231, 32127,  1995,  -123, -1233, 32126,  1998,  -123, -1234, 32124,  2002,  -124,
	-1235, 32122,  2005,  -124, -1237, 32121,  2008,  -124, -1238, 32119,  2012,  -125, -1239, 32117,  2015,  -125,
	-1241, 32116,  2018,  -125, -1242, 32114,  2022,  -126, -1243, 32112,  2025,  -126, -1244, 32110,  2028,  -126,
	-1246, 32109,  2032,  -127, -1247, 32107,  2035,  -127, -1248, 32105,  2038,  -127, -1250, 32105,  2041,  -128,
	-1251, 32102,  2045,  -128, -1252, 32100,  2048,  -128, -1254, 32100,  2051,  -129, -1255, 32097,  2055,  -129,
	-1256, 32095,  2058,  -129, -1258, 32095,  2061,  -130, -1259, 32092,  2065,  -130, -1260, 32090,  2068,  -130,
	-1262, 32089,  2072,  -131, -1263, 32087,  2075,  -131, -1264, 32085,  2078,  -131, -1265, 32082,  2082,  -131,
	-1267, 32082,  2085,  -132, -1268, 32080,  2088,  -132, -1269, 32077,  2092,  -132, -1271, 32077,  2095,  -133,
	-1272, 32075,  2098,  -133, -1273, 32072,  2102,  -133, -1274, 32071,  2105,  -134, -1276, 32070,  2108,  -134,
	-1277, 32067,  2112,  -134, -1278, 32066,  2115,  -135, -1280, 32065,  2118,  -135, -1281, 32062,  2122,  -135,
	-1282, 32061,  2125,  -136, -1284, 32059,  2129,  -136, -1285, 32057,  2132,  -136, -1286, 32056,  2135,  -137,
	-1287, 32053,  2139,  -137, -1289, 32052,  2142,  -137, -1290, 32051,  2145,  -138, -1291, 32048,  2149,  -138,
	-1293, 32047,  2152,  -138, -1294, 32045,  2156,  -139, -1295, 32043,  2159,  -139, -1296, 32041,  2162,  -139,
	-1298, 32040,  2166,  -140, -1299, 32038,  2169,  -140, -1300, 32036,  2172,  -140, -1301, 32034,  2176,  -141,
	-1303, 32033,  2179,  -141, -1304, 32030,  2183,  -141, -1305, 32029,  2186,  -142, -1307, 32028,  2189,  -142,
	-1308, 32025,  2193,  -142, -1309, 32024,  2196,  -143, -1310, 32021,  2200,  -143, -1312, 32020,  2203,  -143,
	-1313, 32019,  2206,  -144, -1314, 32016,  2210,  -144, -1315, 32014,  2213,  -144, -1317, 32013,  2217,  -145,
	-1318, 32011,  2220,  -145, -1319, 32009,  2223,  -145, -1321, 32008,  2227,  -146, -1322, 32006,  2230,  -146,
	-1323, 32003,  2234,  -146, -1324, 32002,  2237,  -147, -1326, 32000,  2241,  -147, -1327, 31998,  2244,  -147,
	-1328, 31997,  2247,  -148, -1329, 31994,  2251,  -148, -1331, 31993,  2254,  -148, -1332, 31991,  2258,  -149,
	-1333, 31989,  2261,  -149, -1334, 31987,  2264,  -149, -1336, 31986,  2268,  -150, -1337, 31984,  2271,  -150,
	-1338, 31981,  2275,  -150, -1339, 31980,  2278,  -151, -1341, 31978,  2282,  -151, -1342, 31976,  2285,  -151,
	-1343, 31974,  2289,  -152, -1344, 31972,  2292,  -152, -1346, 31972,  2295,  -153, -1347, 31969,  2299,  -153,
	-1348, 31967,  2302,  -153, -1349, 31965,  2306,  -154, -1351, 31964,  2309,  -154, -1352, 31961,  2313,  -154,
	-1353, 31960,  2316,  -155, -1354, 31957,  2320,  -155, -1356, 31956,  2323,  -155, -1357, 31955,  2326,  -156,
	-1358, 31952,  2330,  -156, -1359, 31950,  2333,  -156, -1361, 31949,  2337,  -157, -1362, 31947,  2340,  -157,
	-1363, 31944,  2344,  -157, -1364, 31943,  2347,  -158, -1366, 31941,  2351,  -158, -1367, 31939,  2354,  -158,
	-1368, 31937,  2358,  -159, -1369, 31935,  2361,  -159, -1370, 31932,  2365,  -159, -1372, 31932,  2368,  -160,
	-1373, 31930,  2371,  -160, -1374, 31928,  2375,  -161, -1375, 31926,  2378,  -161, -1377, 31924,  2382,  -161,
	-1378, 31923,  2385,  -162, -1379, 31920,  2389,  -162, -1380, 31918,  2392,  -162, -1381, 31916,  2396,  -163,
	-1383, 31915,  2399,  -163, -1384, 31912,  2403,  -163, -1385, 31911,  2406,  -164, -1386, 31908,  2410,  -164,
	-1388, 31907,  2413,  -164, -1389, 31905,  2417,  -165, -1390, 31903,  2420,  -165, -1391, 31901,  2424,  -166,
	-1392, 31899,  2427,  -166, -1394, 31897,  2431,  -166, -1395, 31896,  2434,  -167, -1396, 31893,  2438,  -167,
	-1397, 31891,  2441,  -167, -1399, 31890,  2445,  -168, -1400, 31888,  2448,  -168, -1401, 31885,  2452,  -168,
	-1402, 31884,  2455,  -169, -1403, 31881,  2459,  -169, -1405, 31880,  2462,  -169, -1406, 31878,  2466,  -170,
	-1407, 31876,  2469,  -170, -1408, 31874,  2473,  -171, -1409, 31872,  2476,  -171, -1411, 31870,  2480,  -171,
	-1412, 31869,  2483,  -172, -1413, 31866,  2487,  -172, -1414, 31863,  2491,  -172, -1415, 31862,  2494,  -173,
	-1417, 31860,  2498,  -173, -1418, 31858,  2501,  -173, -1419, 31856,  2505,  -174, -1420, 31854,  2508,  -174,
	-1421, 31852,  2512,  -175, -1423, 31851,  2515,  -175, -1424, 31848,  2519,  -175, -1425, 31847,  2522,  -176,
	-1426, 31844,  2526,  -176, -1427, 31842,  2529,  -176, -1429, 31841,  2533,  -177, -1430, 31839,  2536,  -177,
	-1431, 31836,  2540,  -177, -1432, 31834,  2544,  -178, -1433, 31832,  2547,  -178, -1435, 31831,  2551,  -179,
	-1436, 31829,  2554,  -179, -1437, 31826,  2558,  -179, -1438, 31825,  2561,  -180, -1439, 31822,  2565,  -180,
	-1440, 31820,  2568,  -180, -1442, 31819,  2572,  -181, -1443, 31816,  2576,  -181, -1444, 31815,  2579,  -182,
	-1445, 31812,  2583,  -182, -1446, 31810,  2586,  -182, -1448, 31809,  2590,  -183, -1449, 31807,  2593,  -183,
	-1450, 31804,  2597,  -183, -1451, 31802,  2601,  -184, -1452, 31800,  2604,  -184, -1453, 31798,  2608,  -185,
	-1455, 31797,  2611,  -185, -1456, 31794,  2615,  -185, -1457, 31793,  2618,  -186, -1458, 31790,  2622,  -186,
	-1459, 31787,  2626,  -186, -1460, 31786,  2629,  -187, -1462, 31784,  2633,  -187, -1463, 31783,  2636,  -188,
	-1464, 31780,  2640,  -188, -1465, 31778,  2643,  -188, -1466, 31776,  2647,  -189, -1467, 31773,  2651,  -189,
	-1469, 31772,  2654,  -189, -1470, 31770,  2658,  -190, -1471, 31768,  2661,  -190, -1472, 31766,  2665,  -191,
	-1473, 31763,  2669,  -191, -1474, 31761,  2672,  -191, -1476, 31760,  2676,  -192, -1477, 31758,  2679,  -192,
	-1478, 31755,  2683,  -192, -1479, 31753,  2687,  -193, -1480, 31751,  2690,  -193, -1481, 31749,  2694,  -194,
	-1483, 31748,  2697,  -194, -1484, 31745,  2701,  -194, -1485, 31743,  2705,  -195, -1486, 31741,  2708,  -195,
	-1487, 31739,  2712,  -196, -1488, 31736,  2716,  -196, -1489, 31734,  2719,  -196, -1491, 31733,  2723,  -197,
	-1492, 31731,  2726,  -197, -1493, 31728,  2730,  -197, -1494, 31726,  2734,  -198, -1495, 31724,  2737,  -198,
	-1496, 31722,  2741,  -199, -1498, 31720,  2745,  -199, -1499, 31718,  2748,  -199, -1500, 31716,  2752,  -200,
	-1501, 31714,  2755,  -200, -1502, 31712,  2759,  -201, -1503, 31709,  2763,  -201, -1504, 31707,  2766,  -201,
	-1506, 31706,  2770,  -202, -1507, 31703,  2774,  -202, -1508, 31702,  2777,  -203, -1509, 31699,  2781,  -203,
	-1510, 31696,  2785,  -203, -1511, 31695,  2788,  -204, -1512, 31692,  2792,  -204, -1513, 31690,  2795,  -204,
	-1515, 31689,  2799,  -205, -1516, 31686,  2803,  -205, -1517, 31685,  2806,  -206, -1518, 31682,  2810,  -206,
	-1519, 31679,  2814,  -206, -1520, 31678,  2817,  -207, -1521, 31675,  2821,  -207, -1522, 31673,  2825,  -208,
	-1524, 31672,  2828,  -208, -1525, 31669,  2832,  -208, -1526, 31667,  2836,  -209, -1527, 31665,  2839,  -209,
	-1528, 31663,  2843,  -210, -1529, 31660,  2847,  -210, -1530, 31658,  2850,  -210, -1531, 31656,  2854,  -211,
	-1533, 31654,  2858,  -211, -1534, 31653,  2861,  -212, -1535, 31650,  2865,  -212, -1536, 31647,  2869,  -212,
	-1537, 31646,  2872,  -213, -1538, 31643,  2876,  -213, -1539, 31641,  2880,  -214, -1540, 31639,  2883,  -214,
	-1542, 31637,  2887,  -214, -1543, 31635,  2891,  -215, -1544, 31632,  2895,  -215, -1545, 31631,  2898,  -216,
	-1546, 31628,  2902,  -216, -1547, 31625,  2906,  -216, -1548, 31624,  2909,  -217, -1549, 31621,  2913,  -217,
	-1550, 31619,  2917,  -218, -1552, 31618,  2920,  -218, -1553, 31615,  2924,  -218, -1554, 31613,  2928,  -219,
	-1555, 31611,  2931,  -219, -1556, 31609,  2935,  -220, -1557, 31606,  2939,  -220, -1558, 31603,  2943,  -220,
	-1559, 31602,  2946,  -221, -1560, 31599,  2950,  -221, -1561, 31597,  2954,  -222, -1563, 31596,  2957,  -222,
	-1564, 31593,  2961,  -222, -1565, 31591,  2965,  -223, -1566, 31588,  2969,  -223, -1567, 31587,  2972,  -224,
	-1568, 31584,  2976,  -224, -1569, 31581,  2980,  -224, -1570, 31580,  2983,  -225, -1571, 31577,  2987,  -225,
	-1572, 31575,  2991,  -226, -1573, 31572,  2995,  -226, -1575, 31571,  2998,  -226, -1576, 31569,  3002,  -227,
	-1577, 31566,  3006,  -227, -1578, 31564,  3010,  -228, -1579, 31562,  3013,  -228, -1580, 31559,  3017,  -228,
	-1581, 31557,  3021,  -229, -1582, 31555,  3024,  -229, -1583, 31553,  3028,  -230, -1584, 31550,  3032,  -230,
	-1585, 31548,  3036,  -231, -1586, 31546,  3039,  -231, -1588, 31544,  3043,  -231, -1589, 31542,  3047,  -232,
	-1590, 31539,  3051,  -232, -1591, 31538,  3054,  -233, -1592, 31535,  3058,  -233, -1593, 31532,  3062,  -233,
	-1594, 31530,  3066,  -234, -1595, 31528,  3069,  -234, -1596, 31526,  3073,  -235, -1597, 31523,  3077,  -235,
	-1598, 31520,  3081,  -235, -1599, 31519,  3084,  -236, -1600, 31516,  3088,  -236, -1602, 31515,  3092,  -237,
	-1603, 31512,  3096,  -237, -1604, 31511,  3099,  -238, -1605, 31508,  3103,  -238, -1606, 31505,  3107,  -238,
	-1607, 31503,  3111,  -239, -1608, 31500,  3115,  -239, -1609, 31499,  3118,  -240, -1610, 31496,  3122,  -240,
	-1611, 31493,  3126,  -240, -1612, 31491,  3130,  -241, -1613, 31489,  3133,  -241, -1614, 31487,  3137,  -242,
	-1615, 31484,  3141,  -242, -1616, 31482,  3145,  -243, -1617, 31479,  3149,  -243, -1619, 31478,  3152,  -243,
	-1620, 31476,  3156,  -244, -1621, 31473,  3160,  -244, -1622, 31471,  3164,  -245, -1623, 31469,  3167,  -245,
	-1624, 31467,  3171,  -246, -1625, 31464,  3175,  -246, -1626, 31461,  3179,  -246, -1627, 31459,  3183,  -247,
	-1628, 31457,  3186,  -247, -1629, 31455,  3190,  -248, -1630, 31452,  3194,  -248, -1631, 31449,  3198,  -248,
	-1632, 31447,  3202,  -249, -1633, 31445,  3205,  -249, -1634, 31443,  3209,  -250, -1635, 31440,  3213,  -250,
	-1636, 31438,  3217,  -251, -1637, 31435,  3221,  -251, -1638, 31433,  3224,  -251, -1640, 31432,  3228,  -252,
	-1641, 31429,  3232,  -252, -1642, 31427,  3236,  -253, -1643, 31424,  3240,  -253, -1644, 31422,  3244,  -254,
	-1645, 31420,  3247,  -254, -1646, 31417,  3251,  -254, -1647, 31415,  3255,  -255, -1648, 31412,  3259,  -255,
	-1649, 31410,  3263,  -256, -1650, 31408,  3266,  -256, -1651, 31406,  3270,  -257, -1652, 31403,  3274,  -257,
	-1653, 31400,  3278,  -257, -1654, 31398,  3282,  -258, -1655, 31395,  3286,  -258, -1656, 31394,  3289,  -259,
	-1657, 31391,  3293,  -259, -1658, 31389,  3297,  -260, -1659, 31386,  3301,  -260, -1660, 31383,  3305,  -260,
	-1661, 31381,  3309,  -261, -1662, 31379,  3312,  -261, -1663, 31377,  3316,  -262, -1664, 31374,  3320,  -262,
	-1665, 31372,  3324,  -263, -1666, 31369,  3328,  -263, -1667, 31367,  3332,  -264, -1668, 31364,  3336,  -264,
	-1669, 31362,  3339,  -264, -1670, 31360,  3343,  -265, -1671, 31357,  3347,  -265, -1672, 31355,  3351,  -266,
	-1673, 31352,  3355,  -266, -1674, 31350,  3359,  -267, -1675, 31347,  3363,  -267, -1676, 31345,  3366,  -267,
	-1677, 31343,  3370,  -268, -1679, 31341,  3374,  -268, -1680, 31339,  3378,  -269, -1681, 31336,  3382,  -269,
	-1682, 31334,  3386,  -270, -1683, 31331,  3390,  -270, -1684, 31329,  3393,  -270, -1685, 31327,  3397,  -271,
	-1686, 31324,  3401,  -271, -1687, 31322,  3405,  -272, -1688, 31319,  3409,  -272, -1689, 31317,  3413,  -273,
	-1690, 31314,  3417,  -273, -1691, 31312,  3421,  -274, -1692, 31310,  3424,  -274, -1693, 31307,  3428,  -274,
	-1694, 31305,  3432,  -275, -1695, 31302,  3436,  -275, -1696, 31300,  3440,  -276, -1697, 31297,  3444,  -276,
	-1698, 31295,  3448,  -277, -1699, 31292,  3452,  -277, -1700, 31290,  3456,  -278, -1701, 31288,  3459,  -278,
	-1702, 31285,  3463,  -278, -1703, 31283,  3467,  -279, -1704, 31280,  3471,  -279, -1705, 31278,  3475,  -280,
	-1706, 31275,  3479,  -280, -1707, 31273,  3483,  -281, -1708, 31270,  3487,  -281, -1708, 31267,  3491,  -282,
	-1709, 31264,  3495,  -282, -1710, 31262,  3498,  -282, -1711, 31260,  3502,  -283, -1712, 31257,  3506,  -283,
	-1713, 31255,  3510,  -284, -1714, 31252,  3514,  -284, -1715, 31250,  3518,  -285, -1716, 31247,  3522,  -285,
	-1717, 31245,  3526,  -286, -1718, 31242,  3530,  -286, -1719, 31239,  3534,  -286, -1720, 31237,  3538,  -287,
	-1721, 31235,  3541,  -287, -1722, 31233,  3545,  -288, -1723, 31230,  3549,  -288, -1724, 31228,  3553,  -289,
	-1725, 31225,  3557,  -289, -1726, 31223,  3561,  -290, -1727, 31220,  3565,  -290, -1728, 31218,  3569,  -291,
	-1729, 31215,  3573,  -291, -1730, 31212,  3577,  -291, -1731, 31210,  3581,  -292, -1732, 31207,  3585,  -292,
	-1733, 31205,  3589,  -293, -1734, 31202,  3593,  -293, -1735, 31201,  3596,  -294, -1736, 31198,  3600,  -294,
	-1737, 31196,  3604,  -295, -1738, 31193,  3608,  -295, -1739, 31191,  3612,  -296, -1740, 31188,  3616,  -296,
	-1741, 31185,  3620,  -296, -1742, 31183,  3624,  -297, -1743, 31180,  3628,  -297, -1744, 31178,  3632,  -298,
	-1745, 31175,  3636,  -298, -1745, 31172,  3640,  -299, -1746, 31169,  3644,  -299, -1747, 31167,  3648,  -300,
	-1748, 31164,  3652,  -300, -1749, 31162,  3656,  -301, -1750, 31159,  3660,  -301, -1751, 31156,  3664,  -301,
	-1752, 31154,  3668,  -302, -1753, 31151,  3672,  -302, -1754, 31149,  3676,  -303, -1755, 31147,  3679,  -303,
	-1756, 31145,  3683,  -304, -1757, 31142,  3687,  -304, -1758, 31140,  3691,  -305, -1759, 31137,  3695,  -305,
	-1760, 31135,  3699,  -306, -1761, 31132,  3703,  -306, -1762, 31129,  3707,  -306, -1763, 31127,  3711,  -307,
	-1764, 31124,  3715,  -307, -1765, 31122,  3719,  -308, -1765, 31118,  3723,  -308, -1766, 31116,  3727,  -309,
	-1767, 31113,  3731,  -309, -1768, 31111,  3735,  -310, -1769, 31108,  3739,  -310, -1770, 31106,  3743,  -311,
	-1771, 31103,  3747,  -311, -1772, 31101,  3751,  -312, -1773, 31098,  3755,  -312, -1774, 31096,  3759,  -313,
	-1775, 31093,  3763,  -313, -1776, 31090,  3767,  -313, -1777, 31088,  3771,  -314, -1778, 31085,  3775,  -314,
	-1779, 31083,  3779,  -315, -1780, 31080,  3783,  -315, -1780, 31077,  3787,  -316, -1781, 31074,  3791,  -316,
	-1782, 31072,  3795,  -317, -1783, 31069,  3799,  -317, -1784, 31067,  3803,  -318, -1785, 31064,  3807,  -318,
	-1786, 31062,  3811,  -319, -1787, 31059,  3815,  -319, -1788, 31057,  3819,  -320, -1789, 31054,  3823,  -320,
	-1790, 31051,  3827,  -320, -1791, 31049,  3831,  -321, -1792, 31046,  3835,  -321, -1793, 31044,  3839,  -322,
	-1793, 31040,  3843,  -322, -1794, 31038,  3847,  -323, -1795, 31035,  3851,  -323, -1796, 31033,  3855,  -324,
	-1797, 31030,  3859,  -324, -1798, 31028,  3863,  -325, -1799, 31025,  3867,  -325, -1800, 31023,  3871,  -326,
	-1801, 31020,  3875,  -326, -1802, 31018,  3879,  -327, -1803, 31015,  3883,  -327, -1804, 31012,  3888,  -328,
	-1804, 31008,  3892,  -328, -1805, 31005,  3896,  -328, -1806, 31003,  3900,  -329, -1807, 31000,  3904,  -329,
	-1808, 30998,  3908,  -330, -1809, 30995,  3912,  -330, -1810, 30993,  3916,  -331, -1811, 30990,  3920,  -331,
	-1812, 30988,  3924,  -332, -1813, 30985,  3928,  -332, -1813, 30982,  3932,  -333, -1814, 30979,  3936,  -333,
	-1815, 30977,  3940,  -334, -1816, 30974,  3944,  -334, -1817, 30972,  3948,  -335, -1818, 30969,  3952,  -335,
	-1819, 30967,  3956,  -336, -1820, 30964,  3960,  -336, -1821, 30962,  3964,  -337, -1822, 30959,  3968,  -337,
	-1823, 30956,  3973,  -338, -1823, 30952,  3977,  -338, -1824, 30949,  3981,  -338, -1825, 30947,  3985,  -339,
	-1826, 30944,  3989,  -339, -1827, 30942,  3993,  -340, -1828, 30939,  3997,  -340, -1829, 30937,  4001,  -341,
	-1830, 30934,  4005,  -341, -1831, 30932,  4009,  -342, -1831, 30928,  4013,  -342, -1832, 30926,  4017,  -343,
	-1833, 30923,  4021,  -343, -1834, 30921,  4025,  -344, -1835, 30918,  4029,  -344, -1836, 30915,  4034,  -345,
	-1837, 30912,  4038,  -345, -1838, 30910,  4042,  -346, -1839, 30907,  4046,  -346, -1839, 30904,  4050,  -347,
	-1840, 30901,  4054,  -347, -1841, 30899,  4058,  -348, -1842, 30896,  4062,  -348, -1843, 30894,  4066,  -349,
	-1844, 30891,  4070,  -349, -1845, 30889,  4074,  -350, -1846, 30885,  4079,  -350, -1846, 30882,  4083,  -351,
	-1847, 30879,  4087,  -351, -1848, 30876,  4091,  -351, -1849, 30874,  4095,  -352, -1850, 30871,  4099,  -352,
	-1851, 30869,  4103,  -353, -1852, 30866,  4107,  -353, -1853, 30864,  4111,  -354, -1853, 30860,  4115,  -354,
	-1854, 30858,  4119,  -355, -1855, 30854,  4124,  -355, -1856, 30852,  4128,  -356, -1857, 30849,  4132,  -356,
	-1858, 30847,  4136,  -357, -1859, 30844,  4140,  -357, -1859, 30841,  4144,  -358, -1860, 30838,  4148,  -358,
	-1861, 30836,  4152,  -359, -1862, 30833,  4156,  -359, -1863, 30830,  4161,  -360, -1864, 30827,  4165,  -360,
	-1865, 30825,  4169,  -361, -1866, 30822,  4173,  -361, -1866, 30819,  4177,  -362, -1867, 30816,  4181,  -362,
	-1868, 30814,  4185,  -363, -1869, 30811,  4189,  -363, -1870, 30808,  4194,  -364, -1871, 30805,  4198,  -364,
	-1872, 30803,  4202,  -365, -1872, 30799,  4206,  -365, -1873, 30797,  4210,  -366, -1874, 30794,  4214,  -366,
	-1875, 30792,  4218,  -367, -1876, 30788,  4223,  -367, -1877, 30786,  4227,  -368, -1878, 30783,  4231,  -368,
	-1878, 30780,  4235,  -369, -1879, 30777,  4239,  -369, -1880, 30775,  4243,  -370, -1881, 30772,  4247,  -370,
	-1882, 30769,  4252,  -371, -1883, 30766,  4256,  -371, -1883, 30763,  4260,  -372, -1884, 30760,  4264,  -372,
	-1885, 30758,  4268,  -373, -1886, 30755,  4272,  -373, -1887, 30753,  4276,  -374, -1888, 30749,  4281,  -374,
	-1888, 30746,  4285,  -375, -1889, 30743,  4289,  -375, -1890, 30741,  4293,  -376, -1891, 30738,  4297,  -376,
	-1892, 30736,  4301,  -377, -1893, 30732,  4306,  -377, -1894, 30730,  4310,  -378, -1894, 30726,  4314,  -378,
	-1895, 30724,  4318,  -379, -1896, 30721,  4322,  -379, -1897, 30719,  4326,  -380, -1898, 30715,  4331,  -380,
	-1899, 30713,  4335,  -381, -1899, 30709,  4339,  -381, -1900, 30707,  4343,  -382, -1901, 30704,  4347,  -382,
	-1902, 30702,  4351,  -383, -1903, 30698,  4356,  -383, -1903, 30695,  4360,  -384, -1904, 30692,  4364,  -384,
	-1905, 30690,  4368,  -385, -1906, 30687,  4372,  -385, -1907, 30685,  4376,  -386, -1908, 30681,  4381,  -386,
	-1908, 30678,  4385,  -387, -1909, 30675,  4389,  -387, -1910, 30673,  4393,  -388, -1911, 30670,  4397,  -388,
	-1912, 30667,  4402,  -389, -1913, 30664,  4406,  -389, -1913, 30661,  4410,  -390, -1914, 30658,  4414,  -390,
	-1915, 30656,  4418,  -391, -1916, 30652,  4423,  -391, -1917, 30650,  4427,  -392, -1917, 30646,  4431,  -392,
	-1918, 30644,  4435,  -393, -1919, 30641,  4439,  -393, -1920, 30639,  4443,  -394, -1921, 30635,  4448,  -394,
	-1922, 30633,  4452,  -395, -1922, 30629,  4456,  -395, -1923, 30627,  4460,  -396, -1924, 30623,  4465,  -396,
	-1925, 30621,  4469,  -397, -1926, 30618,  4473,  -397, -1926, 30615,  4477,  -398, -1927, 30612,  4481,  -398,
	-1928, 30609,  4486,  -399, -1929, 30606,  4490,  -399, -1930, 30604,  4494,  -400, -1930, 30600,  4498,  -400,
	-1931, 30598,  4502,  -401, -1932, 30594,  4507,  -401, -1933, 30592,  4511,  -402, -1934, 30589,  4515,  -402,
	-1934, 30586,  4519,  -403, -1935, 30582,  4524,  -403, -1936, 30580,  4528,  -404, -1937, 30577,  4532,  -404,
	-1938, 30575,  4536,  -405, -1938, 30571,  4540,  -405, -1939, 30568,  4545,  -406, -1940, 30565,  4549,  -406,
	-1941, 30563,  4553,  -407, -1942, 30560,  4557,  -407, -1942, 30556,  4562,  -408, -1943, 30553,  4566,  -408,
	-1944, 30551,  4570,  -409, -1945, 30549,  4574,  -410, -1946, 30545,  4579,  -410, -1946, 30542,  4583,  -411,
	-1947, 30539,  4587,  -411, -1948, 30537,  4591,  -412, -1949, 30533,  4596,  -412, -1949, 30530,  4600,  -413,
	-1950, 30527,  4604,  -413, -1951, 30525,  4608,  -414, -1952, 30521,  4613,  -414, -1953, 30519,  4617,  -415,
	-1953, 30515,  4621,  -415, -1954, 30513,  4625,  -416, -1955, 30509,  4630,  -416, -1956, 30507,  4634,  -417,
	-1956, 30503,  4638,  -417, -1957, 30501,  4642,  -418, -1958, 30497,  4647,  -418, -1959, 30495,  4651,  -419,
	-1960, 30492,  4655,  -419, -1960, 30489,  4659,  -420, -1961, 30485,  4664,  -420, -1962, 30483,  4668,  -421,
	-1963, 30480,  4672,  -421, -1963, 30477,  4676,  -422, -1964, 30473,  4681,  -422, -1965, 30471,  4685,  -423,
	-1966, 30468,  4689,  -423, -1967, 30466,  4693,  -424, -1967, 30462,  4698,  -425, -1968, 30459,  4702,  -425,
	-1969, 30457,  4706,  -426, -1970, 30453,  4711,  -426, -1970, 30450,  4715,  -427, -1971, 30447,  4719,  -427,
	-1972, 30445,  4723,  -428, -1973, 30441,  4728,  -428, -1973, 30438,  4732,  -429, -1974, 30435,  4736,  -429,
	-1975, 30432,  4741,  -430, -1976, 30429,  4745,  -430, -1977, 30427,  4749,  -431, -1977, 30423,  4753,  -431,
	-1978, 30420,  4758,  -432, -1979, 30417,  4762,  -432, -1980, 30415,  4766,  -433, -1980, 30410,  4771,  -433,
	-1981, 30408,  4775,  -434, -1982, 30405,  4779,  -434, -1983, 30403,  4783,  -435, -1983, 30399,  4788,  -436,
	-1984, 30396,  4792,  -436, -1985, 30394,  4796,  -437, -1986, 30390,  4801,  -437, -1986, 30387,  4805,  -438,
	-1987, 30384,  4809,  -438, -1988, 30381,  4814,  -439, -1989, 30378,  4818,  -439, -1989, 30375,  4822,  -440,
	-1990, 30372,  4826,  -440, -1991, 30369,  4831,  -441, -1992, 30366,  4835,  -441, -1992, 30363,  4839,  -442,
	-1993, 30359,  4844,  -442, -1994, 30357,  4848,  -443, -1995, 30354,  4852,  -443, -1995, 30350,  4857,  -444,
	-1996, 30347,  4861,  -444, -1997, 30345,  4865,  -445, -1998, 30342,  4870,  -446, -1998, 30338,  4874,  -446,
	-1999, 30336,  4878,  -447, -2000, 30332,  4883,  -447, -2000, 30329,  4887,  -448, -2001, 30326,  4891,  -448,
	-2002, 30323,  4896,  -449, -2003, 30320,  4900,  -449, -2003, 30317,  4904,  -450, -2004, 30313,  4909,  -450,
	-2005, 30311,  4913,  -451, -2006, 30308,  4917,  -451, -2006, 30305,  4921,  -452, -2007, 30301,  4926,  -452,
	-2008, 30299,  4930,  -453, -2009, 30297,  4934,  -454, -2009, 30292,  4939,  -454, -2010, 30290,  4943,  -455,
	-2011, 30286,  4948,  -455, -2011, 30283,  4952,  -456, -2012, 30280,  4956,  -456, -2013, 30277,  4961,  -457,
	-2014, 30274,  4965,  -457, -2014, 30271,  4969,  -458, -2015, 30267,  4974,  -458, -2016, 30265,  4978,  -459,
	-2017, 30262,  4982,  -459, -2017, 30258,  4987,  -460, -2018, 30255,  4991,  -460, -2019, 30253,  4995,  -461,
	-2019, 30249,  5000,  -462, -2020, 30246,  5004,  -462, -2021, 30244,  5008,  -463, -2022, 30240,  5013,  -463,
	-2022, 30237,  5017,  -464, -2023, 30234,  5021,  -464, -2024, 30231,  5026,  -465, -2024, 30227,  5030,  -465,
	-2025, 30224,  5035,  -466, -2026, 30221,  5039,  -466, -2027, 30219,  5043,  -467, -2027, 30214,  5048,  -467,
	-2028, 30212,  5052,  -468, -2029, 30210,  5056,  -469, -2029, 30205,  5061,  -469, -2030, 30203,  5065,  -470,
	-2031, 30200,  5069,  -470, -2032, 30197,  5074,  -471, -2032, 30193,  5078,  -471, -2033, 30190,  5083,  -472,
	-2034, 30187,  5087,  -472, -2034, 30184,  5091,  -473, -2035, 30180,  5096,  -473, -2036, 30178,  5100,  -474,
	-2036, 30174,  5104,  -474, -2037, 30171,  5109,  -475, -2038, 30169,  5113,  -476, -2039, 30165,  5118,  -476,
	-2039, 30162,  5122,  -477, -2040, 30159,  5126,  -477, -2041, 30156,  5131,  -478, -2041, 30152,  5135,  -478,
	-2042, 30149,  5140,  -479, -2043, 30146,  5144,  -479, -2043, 30143,  5148,  -480, -2044, 30139,  5153,  -480,
	-2045, 30137,  5157,  -481, -2046, 30134,  5162,  -482, -2046, 30130,  5166,  -482, -2047, 30128,  5170,  -483,
	-2048, 30124,  5175,  -483, -2048, 30121,  5179,  -484, -2049, 30117,  5184,  -484, -2050, 30115,  5188,  -485,
	-2050, 30111,  5192,  -485, -2051, 30108,  5197,  -486, -2052, 30105,  5201,  -486, -2052, 30101,  5206,  -487,
	-2053, 30099,  5210,  -488, -2054, 30096,  5214,  -488, -2055, 30093,  5219,  -489, -2055, 30089,  5223,  -489,
	-2056, 30086,  5228,  -490, -2057, 30083,  5232,  -490, -2057, 30080,  5236,  -491, -2058, 30076,  5241,  -491,
	-2059, 30074,  5245,  -492, -2059, 30069,  5250,  -492, -2060, 30067,  5254,  -493, -2061, 30065,  5258,  -494,
	-2061, 30060,  5263,  -494, -2062, 30058,  5267,  -495, -2063, 30054,  5272,  -495, -2063, 30051,  5276,  -496,
	-2064, 30047,  5281,  -496, -2065, 30045,  5285,  -497, -2065, 30041,  5289,  -497, -2066, 30038,  5294,  -498,
	-2067, 30036,  5298,  -499, -2067, 30031,  5303,  -499, -2068, 30029,  5307,  -500, -2069, 30025,  5312,  -500,
	-2069, 30022,  5316,  -501, -2070, 30019,  5320,  -501, -2071, 30016,  5325,  -502, -2071, 30012,  5329,  -502,
	-2072, 30009,  5334,  -503, -2073, 30006,  5338,  -503, -2073, 30002,  5343,  -504, -2074, 30000,  5347,  -505,
	-2075, 29996,  5352,  -505, -2075, 29993,  5356,  -506, -2076, 29990,  5360,  -506, -2077, 29987,  5365,  -507,
	-2077, 29983,  5369,  -507, -2078, 29980,  5374,  -508, -2079, 29977,  5378,  -508, -2079, 29973,  5383,  -509,
	-2080, 29971,  5387,  -510, -2081, 29967,  5392,  -510, -2081, 29964,  5396,  -511, -2082, 29961,  5400,  -511,
	-2083, 29958,  5405,  -512, -2083, 29954,  5409,  -512, -2084, 29951,  5414,  -513, -2085, 29948,  5418,  -513,
	-2085, 29944,  5423,  -514, -2086, 29942,  5427,  -515, -2087, 29938,  5432,  -515, -2087, 29935,  5436,  -516,
	-2088, 29931,  5441,  -516, -2089, 29929,  5445,  -517, -2089, 29924,  5450,  -517, -2090, 29922,  5454,  -518,
	-2090, 29918,  5458,  -518, -2091, 29915,  5463,  -519, -2092, 29913,  5467,  -520, -2092, 29908,  5472,  -520,
	-2093, 29906,  5476,  -521, -2094, 29902,  5481,  -521, -2094, 29899,  5485,  -522, -2095, 29895,  5490,  -522,
	-2096, 29893,  5494,  -523, -2096, 29889,  5499,  -524, -2097, 29886,  5503,  -524, -2098, 29883,  5508,  -525,
	-2098, 29879,  5512,  -525, -2099, 29876,  5517,  -526, -2099, 29872,  5521,  -526, -2100, 29869,  5526,  -527,
	-2101, 29866,  5530,  -527, -2101, 29862,  5535,  -528, -2102, 29860,  5539,  -529, -2103, 29856,  5544,  -529,
	-2103, 29853,  5548,  -530, -2104, 29849,  5553,  -530, -2105, 29847,  5557,  -531, -2105, 29842,  5562,  -531,
	-2106, 29840,  5566,  -532, -2106, 29835,  5571,  -532, -2107, 29833,  5575,  -533, -2108, 29830,  5580,  -534,
	-2108, 29826,  5584,  -534, -2109, 29823,  5589,  -535, -2110, 29820,  5593,  -535, -2110, 29816,  5598,  -536,
	-2111, 29813,  5602,  -536, -2111, 29809,  5607,  -537, -2112, 29807,  5611,  -538, -2113, 29803,  5616,  -538,
	-2113, 29800,  5620,  -539, -2114, 29796,  5625,  -539, -2115, 29794,  5629,  -540, -2115, 29789,  5634,  -540,
	-2116, 29787,  5638,  -541, -2116, 29783,  5643,  -542, -2117, 29780,  5647,  -542, -2118, 29777,  5652,  -543,
	-2118, 29773,  5656,  -543, -2119, 29770,  5661,  -544, -2120, 29767,  5665,  -544, -2120, 29763,  5670,  -545,
	-2121, 29760,  5674,  -545, -2121, 29756,  5679,  -546, -2122, 29754,  5683,  -547, -2123, 29750,  5688,  -547,
	-2123, 29747,  5692,  -548, -2124, 29743,  5697,  -548, -2124, 29740,  5701,  -549, -2125, 29736,  5706,  -549,
	-2126, 29734,  5710,  -550, -2126, 29730,  5715,  -551, -2127, 29727,  5719,  -551, -2127, 29723,  5724,  -552,
	-2128, 29719,  5729,  -552, -2129, 29717,  5733,  -553, -2129, 29712,  5738,  -553, -2130, 29710,  5742,  -554,
	-2130, 29706,  5747,  -555, -2131, 29703,  5751,  -555, -2132, 29700,  5756,  -556, -2132, 29696,  5760,  -556,
	-2133, 29693,  5765,  -557, -2133, 29689,  5769,  -557, -2134, 29686,  5774,  -558, -2135, 29684,  5778,  -559,
	-2135, 29679,  5783,  -559, -2136, 29676,  5788,  -560, -2136, 29672,  5792,  -560, -2137, 29669,  5797,  -561,
	-2138, 29666,  5801,  -561, -2138, 29662,  5806,  -562, -2139, 29660,  5810,  -563, -2139, 29655,  5815,  -563,
	-2140, 29653,  5819,  -564, -2141, 29649,  5824,  -564, -2141, 29645,  5829,  -565, -2142, 29642,  5833,  -565,
	-2142, 29638,  5838,  -566, -2143, 29636,  5842,  -567, -2144, 29632,  5847,  -567, -2144, 29629,  5851,  -568,
	-2145, 29625,  5856,  -568, -2145, 29622,  5860,  -569, -2146, 29618,  5865,  -569, -2147, 29615,  5870,  -570,
	-2147, 29612,  5874,  -571, -2148, 29608,  5879,  -571, -2148, 29605,  5883,  -572, -2149, 29601,  5888,  -572,
	-2149, 29598,  5892,  -573, -2150, 29594,  5897,  -573, -2151, 29591,  5902,  -574, -2151, 29588,  5906,  -575,
	-2152, 29584,  5911,  -575, -2152, 29581,  5915,  -576, -2153, 29577,  5920,  -576, -2154, 29575,  5924,  -577,
	-2154, 29571,  5929,  -578, -2155, 29567,  5934,  -578, -2155, 29564,  5938,  -579, -2156, 29560,  5943,  -579,
	-2156, 29557,  5947,  -580, -2157, 29553,  5952,  -580, -2158, 29551,  5956,  -581, -2158, 29547,  5961,  -582,
	-2159, 29543,  5966,  -582, -2159, 29540,  5970,  -583, -2160, 29536,  5975,  -583, -2160, 29533,  5979,  -584,
	-2161, 29529,  5984,  -584, -2162, 29526,  5989,  -585, -2162, 29523,  5993,  -586, -2163, 29519,  5998,  -586,
	-2163, 29516,  6002,  -587, -2164, 29512,  6007,  -587, -2164, 29508,  6012,  -588, -2165, 29506,  6016,  -589,
	-2165, 29501,  6021,  -589, -2166, 29499,  6025,  -590, -2167, 29495,  6030,  -590, -2167, 29491,  6035,  -591,
	-2168, 29488,  6039,  -591, -2168, 29484,  6044,  -592, -2169, 29482,  6048,  -593, -2169, 29477,  6053,  -593,
	-2170, 29474,  6058,  -594, -2171, 29471,  6062,  -594, -2171, 29467,  6067,  -595, -2172, 29465,  6071,  -596,
	-2172, 29460,  6076,  -596, -2173, 29457,  6081,  -597, -2173, 29453,  6085,  -597, -2174, 29450,  6090,  -598,
	-2174, 29446,  6094,  -598, -2175, 29443,  6099,  -599, -2176, 29440,  6104,  -600, -2176, 29436,  6108,  -600,
	-2177, 29433,  6113,  -601, -2177, 29428,  6118,  -601, -2178, 29426,  6122,  -602, -2178, 29422,  6127,  -603,
	-2179, 29419,  6131,  -603, -2179, 29415,  6136,  -604, -2180, 29411,  6141,  -604, -2180, 29408,  6145,  -605,
	-2181, 29404,  6150,  -605, -2182, 29401,  6155,  -606, -2182, 29398,  6159,  -607, -2183, 29394,  6164,  -607,
	-2183, 29391,  6168,  -608, -2184, 29387,  6173,  -608, -2184, 29383,  6178,  -609, -2185, 29381,  6182,  -610,
	-2185, 29376,  6187,  -610, -2186, 29373,  6192,  -611, -2186, 29369,  6196,  -611, -2187, 29366,  6201,  -612,
	-2188, 29363,  6206,  -613, -2188, 29359,  6210,  -613, -2189, 29356,  6215,  -614, -2189, 29352,  6219,  -614,
	-2190, 29349,  6224,  -615, -2190, 29344,  6229,  -615, -2191, 29342,  6233,  -616, -2191, 29338,  6238,  -617,
	-2192, 29334,  6243,  -617, -2192, 29331,  6247,  -618, -2193, 29327,  6252,  -618, -2193, 29323,  6257,  -619,
	-2194, 29321,  6261,  -620, -2194, 29316,  6266,  -620, -2195, 29313,  6271,  -621, -2195, 29309,  6275,  -621,
	-2196, 29306,  6280,  -622, -2197, 29303,  6285,  -623, -2197, 29299,  6289,  -623, -2198, 29296,  6294,  -624,
	-2198, 29292,  6298,  -624, -2199, 29289,  6303,  -625, -2199, 29284,  6308,  -625, -2200, 29282,  6312,  -626,
	-2200, 29278,  6317,  -627, -2201, 29274,  6322,  -627, -2201, 29271,  6326,  -628, -2202, 29267,  6331,  -628,
	-2202, 29263,  6336,  -629, -2203, 29261,  6340,  -630, -2203, 29256,  6345,  -630, -2204, 29253,  6350,  -631,
	-2204, 29249,  6354,  -631, -2205, 29246,  6359,  -632, -2205, 29242,  6364,  -633, -2206, 29239,  6368,  -633,
	-2206, 29235,  6373,  -634, -2207, 29231,  6378,  -634, -2207, 29228,  6382,  -635, -2208, 29225,  6387,  -636,
	-2208, 29220,  6392,  -636, -2209, 29217,  6397,  -637, -2209, 29213,  6401,  -637, -2210, 29210,  6406,  -638,
	-2211, 29207,  6411,  -639, -2211, 29203,  6415,  -639, -2212, 29200,  6420,  -640, -2212, 29195,  6425,  -640,
	-2213, 29193,  6429,  -641, -2213, 29189,  6434,  -642, -2214, 29185,  6439,  -642, -2214, 29182,  6443,  -643,
	-2215, 29178,  6448,  -643, -2215, 29174,  6453,  -644, -2216, 29171,  6457,  -644, -2216, 29167,  6462,  -645,
	-2217, 29164,  6467,  -646, -2217, 29160,  6471,  -646, -2218, 29157,  6476,  -647, -2218, 29152,  6481,  -647,
	-2219, 29149,  6486,  -648, -2219, 29146,  6490,  -649, -2220, 29142,  6495,  -649, -2220, 29138,  6500,  -650,
	-2221, 29135,  6504,  -650, -2221, 29131,  6509,  -651, -2222, 29128,  6514,  -652, -2222, 29124,  6518,  -652,
	-2223, 29121,  6523,  -653, -2223, 29116,  6528,  -653, -2224, 29113,  6533,  -654, -2224, 29110,  6537,  -655,
	-2224, 29105,  6542,  -655, -2225, 29102,  6547,  -656, -2225, 29098,  6551,  -656, -2226, 29095,  6556,  -657,
	-2226, 29091,  6561,  -658, -2227, 29087,  6566,  -658, -2227, 29084,  6570,  -659, -2228, 29080,  6575,  -659,
	-2228, 29076,  6580,  -660, -2229, 29074,  6584,  -661, -2229, 29069,  6589,  -661, -2230, 29066,  6594,  -662,
	-2230, 29061,  6599,  -662, -2231, 29059,  6603,  -663, -2231, 29055,  6608,  -664, -2232, 29051,  6613,  -664,
	-2232, 29048,  6617,  -665, -2233, 29044,  6622,  -665, -2233, 29040,  6627,  -666, -2234, 29037,  6632,  -667,
	-2234, 29033,  6636,  -667, -2235, 29030,  6641,  -668, -2235, 29025,  6646,  -668, -2236, 29022,  6651,  -669,
	-2236, 29019,  6655,  -670, -2237, 29015,  6660,  -670, -2237, 29011,  6665,  -671, -2237, 29006,  6670,  -671,
	-2238, 29004,  6674,  -672, -2238, 29000,  6679,  -673, -2239, 28996,  6684,  -673, -2239, 28993,  6688,  -674,
	-2240, 28990,  6693,  -675, -2240, 28985,  6698,  -675, -2241, 28982,  6703,  -676, -2241, 28978,  6707,  -676,
	-2242, 28975,  6712,  -677, -2242, 28971,  6717,  -678, -2243, 28967,  6722,  -678, -2243, 28964,  6726,  -679,
	-2244, 28960,  6731,  -679, -2244, 28956,  6736,  -680, -2245, 28953,  6741,  -681, -2245, 28949,  6745,  -681,
	-2245, 28945,  6750,  -682, -2246, 28941,  6755,  -682, -2246, 28937,  6760,  -683, -2247, 28935,  6764,  -684,
	-2247, 28930,  6769,  -684, -2248, 28927,  6774,  -685, -2248, 28922,  6779,  -685, -2249, 28920,  6783,  -686,
	-2249, 28916,  6788,  -687, -2250, 28912,  6793,  -687, -2250, 28908,  6798,  -688, -2250, 28904,  6802,  -688,
	-2251, 28901,  6807,  -689, -2251, 28897,  6812,  -690, -2252, 28893,  6817,  -690, -2252, 28890,  6821,  -691,
	-2253, 28886,  6826,  -691, -2253, 28882,  6831,  -692, -2254, 28879,  6836,  -693, -2254, 28874,  6841,  -693,
	-2255, 28872,  6845,  -694, -2255, 28868,  6850,  -695, -2255, 28863,  6855,  -695, -2256, 28860,  6860,  -696,
	-2256, 28856,  6864,  -696, -2257, 28853,  6869,  -697, -2257, 28849,  6874,  -698, -2258, 28845,  6879,  -698,
	-2258, 28842,  6883,  -699, -2259, 28838,  6888,  -699, -2259, 28834,  6893,  -700, -2259, 28830,  6898,  -701,
	-2260, 28826,  6903,  -701, -2260, 28823,  6907,  -702, -2261, 28819,  6912,  -702, -2261, 28815,  6917,  -703,
	-2262, 28812,  6922,  -704, -2262, 28807,  6927,  -704, -2263, 28805,  6931,  -705, -2263, 28801,  6936,  -706,
	-2263, 28796,  6941,  -706, -2264, 28793,  6946,  -707, -2264, 28789,  6950,  -707, -2265, 28786,  6955,  -708,
	-2265, 28782,  6960,  -709, -2266, 28778,  6965,  -709, -2266, 28774,  6970,  -710, -2266, 28770,  6974,  -710,
	-2267, 28767,  6979,  -711, -2267, 28763,  6984,  -712, -2268, 28759,  6989,  -712, -2268, 28755,  6994,  -713,
	-2269, 28752,  6998,  -713, -2269, 28748,  7003,  -714, -2269, 28744,  7008,  -715, -2270, 28740,  7013,  -715,
	-2270, 28736,  7018,  -716, -2271, 28734,  7022,  -717, -2271, 28729,  7027,  -717, -2272, 28726,  7032,  -718,
	-2272, 28721,  7037,  -718, -2272, 28717,  7042,  -719, -2273, 28715,  7046,  -720, -2273, 28710,  7051,  -720,
	-2274, 28707,  7056,  -721, -2274, 28702,  7061,  -721, -2275, 28699,  7066,  -722, -2275, 28696,  7070,  -723,
	-2275, 28691,  7075,  -723, -2276, 28688,  7080,  -724, -2276, 28684,  7085,  -725, -2277, 28680,  7090,  -725,
	-2277, 28676,  7095,  -726, -2277, 28672,  7099,  -726, -2278, 28669,  7104,  -727, -2278, 28665,  7109,  -728,
	-2279, 28661,  7114,  -728, -2279, 28657,  7119,  -729, -2280, 28654,  7123,  -729, -2280, 28650,  7128,  -730,
	-2280, 28646,  7133,  -731, -2281, 28642,  7138,  -731, -2281, 28638,  7143,  -732, -2282, 28635,  7148,  -733,
	-2282, 28631,  7152,  -733, -2282, 28627,  7157,  -734, -2283, 28623,  7162,  -734, -2283, 28619,  7167,  -735,
	-2284, 28616,  7172,  -736, -2284, 28612,  7176,  -736, -2284, 28608,  7181,  -737, -2285, 28605,  7186,  -738,
	-2285, 28600,  7191,  -738, -2286, 28597,  7196,  -739, -2286, 28592,  7201,  -739, -2287, 28590,  7205,  -740,
	-2287, 28586,  7210,  -741, -2287, 28581,  7215,  -741, -2288, 28578,  7220,  -742, -2288, 28573,  7225,  -742,
	-2289, 28570,  7230,  -743, -2289, 28566,  7235,  -744, -2289, 28562,  7239,  -744, -2290, 28559,  7244,  -745,
	-2290, 28555,  7249,  -746, -2290, 28550,  7254,  -746, -2291, 28547,  7259,  -747, -2291, 28542,  7264,  -747,
	-2292, 28540,  7268,  -748, -2292, 28536,  7273,  -749, -2292, 28531,  7278,  -749, -2293, 28528,  7283,  -750,
	-2293, 28524,  7288,  -751, -2294, 28520,  7293,  -751, -2294, 28516,  7298,  -752, -2294, 28512,  7302,  -752,
	-2295, 28509,  7307,  -753, -2295, 28505,  7312,  -754, -2296, 28501,  7317,  -754, -2296, 28497,  7322,  -755,
	-2296, 28493,  7327,  -756, -2297, 28489,  7332,  -756, -2297, 28486,  7336,  -757, -2298, 28482,  7341,  -757,
	-2298, 28478,  7346,  -758, -2298, 28474,  7351,  -759, -2299, 28470,  7356,  -759, -2299, 28466,  7361,  -760,
	-2299, 28462,  7366,  -761, -2300, 28459,  7370,  -761, -2300, 28455,  7375,  -762, -2301, 28451,  7380,  -762,
	-2301, 28447,  7385,  -763, -2301, 28443,  7390,  -764, -2302, 28439,  7395,  -764, -2302, 28435,  7400,  -765,
	-2302, 28431,  7405,  -766, -2303, 28428,  7409,  -766, -2303, 28424,  7414,  -767, -2304, 28420,  7419,  -767,
	-2304, 28416,  7424,  -768, -2304, 28412,  7429,  -769, -2305, 28408,  7434,  -769, -2305, 28404,  7439,  -770,
	-2305, 28400,  7444,  -771, -2306, 28397,  7448,  -771, -2306, 28393,  7453,  -772, -2307, 28389,  7458,  -772,
	-2307, 28385,  7463,  -773, -2307, 28381,  7468,  -774, -2308, 28377,  7473,  -774, -2308, 28373,  7478,  -775,
	-2308, 28369,  7483,  -776, -2309, 28366,  7487,  -776, -2309, 28362,  7492,  -777, -2310, 28358,  7497,  -777,
	-2310, 28354,  7502,  -778, -2310, 28350,  7507,  -779, -2311, 28346,  7512,  -779, -2311, 28342,  7517,  -780,
	-2311, 28338,  7522,  -781, -2312, 28334,  7527,  -781, -2312, 28331,  7531,  -782, -2312, 28326,  7536,  -782,
	-2313, 28323,  7541,  -783, -2313, 28319,  7546,  -784, -2314, 28315,  7551,  -784, -2314, 28311,  7556,  -785,
	-2314, 28307,  7561,  -786, -2315, 28303,  7566,  -786, -2315, 28299,  7571,  -787, -2315, 28294,  7576,  -787,
	-2316, 28292,  7580,  -788, -2316, 28288,  7585,  -789, -2316, 28283,  7590,  -789, -2317, 28280,  7595,  -790,
	-2317, 28276,  7600,  -791, -2317, 28271,  7605,  -791, -2318, 28268,  7610,  -792, -2318, 28263,  7615,  -792,
	-2319, 28260,  7620,  -793, -2319, 28256,  7625,  -794, -2319, 28252,  7629,  -794, -2320, 28249,  7634,  -795,
	-2320, 28245,  7639,  -796, -2320, 28240,  7644,  -796, -2321, 28237,  7649,  -797, -2321, 28233,  7654,  -798,
	-2321, 28228,  7659,  -798, -2322, 28225,  7664,  -799, -2322, 28220,  7669,  -799, -2322, 28216,  7674,  -800,
	-2323, 28213,  7679,  -801, -2323, 28208,  7684,  -801, -2323, 28205,  7688,  -802, -2324, 28202,  7693,  -803,
	-2324, 28197,  7698,  -803, -2324, 28193,  7703,  -804, -2325, 28189,  7708,  -804, -2325, 28185,  7713,  -805,
	-2325, 28181,  7718,  -806, -2326, 28177,  7723,  -806, -2326, 28173,  7728,  -807, -2326, 28169,  7733,  -808,
	-2327, 28165,  7738,  -808, -2327, 28161,  7743,  -809, -2327, 28157,  7748,  -810, -2328, 28153,  7753,  -810,
	-2328, 28150,  7757,  -811, -2328, 28145,  7762,  -811, -2329, 28142,  7767,  -812, -2329, 28138,  7772,  -813,
	-2329, 28133,  7777,  -813, -2330, 28130,  7782,  -814, -2330, 28126,  7787,  -815, -2330, 28121,  7792,  -815,
	-2331, 28118,  7797,  -816, -2331, 28113,  7802,  -816, -2331, 28109,  7807,  -817, -2332, 28106,  7812,  -818,
	-2332, 28101,  7817,  -818, -2332, 28097,  7822,  -819, -2333, 28094,  7827,  -820, -2333, 28089,  7832,  -820,
	-2333, 28086,  7836,  -821, -2334, 28083,  7841,  -822, -2334, 28078,  7846,  -822, -2334, 28074,  7851,  -823,
	-2335, 28070,  7856,  -823, -2335, 28066,  7861,  -824, -2335, 28062,  7866,  -825, -2336, 28058,  7871,  -825,
	-2336, 28054,  7876,  -826, -2336, 28050,  7881,  -827, -2337, 28046,  7886,  -827, -2337, 28042,  7891,  -828,
	-2337, 28038,  7896,  -829, -2338, 28034,  7901,  -829, -2338, 28030,  7906,  -830, -2338, 28025,  7911,  -830,
	-2338, 28021,  7916,  -831, -2339, 28018,  7921,  -832, -2339, 28013,  7926,  -832, -2339, 28009,  7931,  -833,
	-2340, 28006,  7936,  -834, -2340, 28002,  7940,  -834, -2340, 27998,  7945,  -835, -2341, 27995,  7950,  -836,
	-2341, 27990,  7955,  -836, -2341, 27986,  7960,  -837, -2342, 27982,  7965,  -837, -2342, 27978,  7970,  -838,
	-2342, 27974,  7975,  -839, -2343, 27970,  7980,  -839, -2343, 27966,  7985,  -840, -2343, 27962,  7990,  -841,
	-2343, 27957,  7995,  -841, -2344, 27954,  8000,  -842, -2344, 27950,  8005,  -843, -2344, 27945,  8010,  -843,
	-2345, 27942,  8015,  -844, -2345, 27937,  8020,  -844, -2345, 27933,  8025,  -845, -2346, 27930,  8030,  -846,
	-2346, 27925,  8035,  -846, -2346, 27921,  8040,  -847, -2346, 27917,  8045,  -848, -2347, 27913,  8050,  -848,
	-2347, 27909,  8055,  -849, -2347, 27905,  8060,  -850, -2348, 27901,  8065,  -850, -2348, 27897,  8070,  -851,
	-2348, 27892,  8075,  -851, -2349, 27889,  8080,  -852, -2349, 27885,  8085,  -853, -2349, 27880,  8090,  -853,
	-2349, 27876,  8095,  -854, -2350, 27873,  8100,  -855, -2350, 27868,  8105,  -855, -2350, 27864,  8110,  -856,
	-2351, 27861,  8115,  -857, -2351, 27856,  8120,  -857, -2351, 27852,  8125,  -858, -2351, 27848,  8130,  -859,
	-2352, 27844,  8135,  -859, -2352, 27840,  8140,  -860, -2352, 27835,  8145,  -860, -2353, 27832,  8150,  -861,
	-2353, 27828,  8155,  -862, -2353, 27823,  8160,  -862, -2353, 27819,  8165,  -863, -2354, 27816,  8170,  -864,
	-2354, 27811,  8175,  -864, -2354, 27807,  8180,  -865, -2355, 27804,  8185,  -866, -2355, 27799,  8190,  -866,
	-2355, 27795,  8195,  -867, -2355, 27791,  8200,  -868, -2356, 27787,  8205,  -868, -2356, 27783,  8210,  -869,
	-2356, 27778,  8215,  -869, -2357, 27775,  8220,  -870, -2357, 27771,  8225,  -871, -2357, 27766,  8230,  -871,
	-2357, 27762,  8235,  -872, -2358, 27759,  8240,  -873, -2358, 27754,  8245,  -873, -2358, 27750,  8250,  -874,
	-2359, 27747,  8255,  -875, -2359, 27742,  8260,  -875, -2359, 27738,  8265,  -876, -2359, 27734,  8270,  -877,
	-2360, 27730,  8275,  -877, -2360, 27726,  8280,  -878, -2360, 27721,  8285,  -878, -2360, 27717,  8290,  -879,
	-2361, 27714,  8295,  -880, -2361, 27709,  8300,  -880, -2361, 27705,  8305,  -881, -2362, 27702,  8310,  -882,
	-2362, 27697,  8315,  -882, -2362, 27693,  8320,  -883, -2362, 27689,  8325,  -884, -2363, 27685,  8330,  -884,
	-2363, 27681,  8335,  -885, -2363, 27677,  8340,  -886, -2363, 27672,  8345,  -886, -2364, 27669,  8350,  -887,
	-2364, 27664,  8355,  -887, -2364, 27660,  8360,  -888, -2364, 27656,  8365,  -889, -2365, 27652,  8370,  -889,
	-2365, 27648,  8375,  -890, -2365, 27644,  8380,  -891, -2365, 27639,  8385,  -891, -2366, 27636,  8390,  -892,
	-2366, 27632,  8395,  -893, -2366, 27627,  8400,  -893, -2367, 27624,  8405,  -894, -2367, 27620,  8410,  -895,
	-2367, 27615,  8415,  -895, -2367, 27611,  8420,  -896, -2368, 27607,  8425,  -896, -2368, 27603,  8430,  -897,
	-2368, 27598,  8436,  -898, -2368, 27593,  8441,  -898, -2369, 27590,  8446,  -899, -2369, 27586,  8451,  -900,
	-2369, 27581,  8456,  -900, -2369, 27577,  8461,  -901, -2370, 27574,  8466,  -902, -2370, 27569,  8471,  -902,
	-2370, 27565,  8476,  -903, -2370, 27561,  8481,  -904, -2371, 27557,  8486,  -904, -2371, 27553,  8491,  -905,
	-2371, 27549,  8496,  -906, -2371, 27544,  8501,  -906, -2372, 27541,  8506,  -907, -2372, 27536,  8511,  -907,
	-2372, 27532,  8516,  -908, -2372, 27528,  8521,  -909, -2373, 27524,  8526,  -909, -2373, 27520,  8531,  -910,
	-2373, 27516,  8536,  -911, -2373, 27511,  8541,  -911, -2374, 27507,  8547,  -912, -2374, 27503,  8552,  -913,
	-2374, 27498,  8557,  -913, -2374, 27494,  8562,  -914, -2374, 27490,  8567,  -915, -2375, 27486,  8572,  -915,
	-2375, 27482,  8577,  -916, -2375, 27478,  8582,  -917, -2375, 27473,  8587,  -917, -2376, 27470,  8592,  -918,
	-2376, 27466,  8597,  -919, -2376, 27461,  8602,  -919, -2376, 27457,  8607,  -920, -2377, 27453,  8612,  -920,
	-2377, 27449,  8617,  -921, -2377, 27445,  8622,  -922, -2377, 27439,  8628,  -922, -2378, 27436,  8633,  -923,
	-2378, 27432,  8638,  -924, -2378, 27427,  8643,  -924, -2378, 27423,  8648,  -925, -2378, 27419,  8653,  -926,
	-2379, 27415,  8658,  -926, -2379, 27411,  8663,  -927, -2379, 27407,  8668,  -928, -2379, 27402,  8673,  -928,
	-2380, 27399,  8678,  -929, -2380, 27395,  8683,  -930, -2380, 27390,  8688,  -930, -2380, 27386,  8693,  -931,
	-2381, 27382,  8699,  -932, -2381, 27377,  8704,  -932, -2381, 27373,  8709,  -933, -2381, 27368,  8714,  -933,
	-2381, 27364,  8719,  -934, -2382, 27361,  8724,  -935, -2382, 27356,  8729,  -935, -2382, 27352,  8734,  -936,
	-2382, 27348,  8739,  -937, -2382, 27343,  8744,  -937, -2383, 27340,  8749,  -938, -2383, 27336,  8754,  -939,
	-2383, 27331,  8759,  -939, -2383, 27326,  8765,  -940, -2384, 27323,  8770,  -941, -2384, 27318,  8775,  -941,
	-2384, 27314,  8780,  -942, -2384, 27310,  8785,  -943, -2384, 27305,  8790,  -943, -2385, 27302,  8795,  -944,
	-2385, 27298,  8800,  -945, -2385, 27293,  8805,  -945, -2385, 27289,  8810,  -946, -2386, 27285,  8815,  -946,
	-2386, 27280,  8821,  -947, -2386, 27276,  8826,  -948, -2386, 27271,  8831,  -948, -2386, 27267,  8836,  -949,
	-2387, 27264,  8841,  -950, -2387, 27259,  8846,  -950, -2387, 27255,  8851,  -951, -2387, 27251,  8856,  -952,
	-2387, 27246,  8861,  -952, -2388, 27243,  8866,  -953, -2388, 27238,  8872,  -954, -2388, 27233,  8877,  -954,
	-2388, 27229,  8882,  -955, -2388, 27225,  8887,  -956, -2389, 27221,  8892,  -956, -2389, 27217,  8897,  -957,
	-2389, 27213,  8902,  -958, -2389, 27208,  8907,  -958, -2389, 27204,  8912,  -959, -2390, 27201,  8917,  -960,
	-2390, 27195,  8923,  -960, -2390, 27191,  8928,  -961, -2390, 27186,  8933,  -961, -2390, 27182,  8938,  -962,
	-2391, 27179,  8943,  -963, -2391, 27174,  8948,  -963, -2391, 27170,  8953,  -964, -2391, 27166,  8958,  -965,
	-2391, 27161,  8963,  -965, -2392, 27157,  8969,  -966, -2392, 27153,  8974,  -967, -2392, 27148,  8979,  -967,
	-2392, 27144,  8984,  -968, -2392, 27140,  8989,  -969, -2393, 27136,  8994,  -969, -2393, 27132,  8999,  -970,
	-2393, 27128,  9004,  -971, -2393, 27123,  9009,  -971, -2393, 27118,  9015,  -972, -2394, 27115,  9020,  -973,
	-2394, 27110,  9025,  -973, -2394, 27106,  9030,  -974, -2394, 27102,  9035,  -975, -2394, 27097,  9040,  -975,
	-2394, 27093,  9045,  -976, -2395, 27090,  9050,  -977, -2395, 27084,  9056,  -977, -2395, 27080,  9061,  -978,
	-2395, 27076,  9066,  -979, -2395, 27071,  9071,  -979, -2396, 27068,  9076,  -980, -2396, 27063,  9081,  -980,
	-2396, 27059,  9086,  -981, -2396, 27055,  9091,  -982, -2396, 27049,  9097,  -982, -2396, 27045,  9102,  -983,
	-2397, 27042,  9107,  -984, -2397, 27037,  9112,  -984, -2397, 27033,  9117,  -985, -2397, 27029,  9122,  -986,
	-2397, 27024,  9127,  -986, -2398, 27020,  9133,  -987, -2398, 27016,  9138,  -988, -2398, 27011,  9143,  -988,
	-2398, 27007,  9148,  -989, -2398, 27003,  9153,  -990, -2398, 26998,  9158,  -990, -2399, 26995,  9163,  -991,
	-2399, 26991,  9168,  -992, -2399, 26985,  9174,  -992, -2399, 26981,  9179,  -993, -2399, 26977,  9184,  -994,
	-2399, 26972,  9189,  -994, -2400, 26969,  9194,  -995, -2400, 26965,  9199,  -996, -2400, 26960,  9204,  -996,
	-2400, 26955,  9210,  -997, -2400, 26951,  9215,  -998, -2401, 26947,  9220,  -998, -2401, 26943,  9225,  -999,
	-2401, 26939,  9230, -1000, -2401, 26934,  9235, -1000, -2401, 26930,  9240, -1001, -2401, 26924,  9246, -1001,
	-2402, 26921,  9251, -1002, -2402, 26917,  9256, -1003, -2402, 26912,  9261, -1003, -2402, 26908,  9266, -1004,
	-2402, 26904,  9271, -1005, -2402, 26898,  9277, -1005, -2402, 26894,  9282, -1006, -2403, 26891,  9287, -1007,
	-2403, 26886,  9292, -1007, -2403, 26882,  9297, -1008, -2403, 26878,  9302, -1009, -2403, 26873,  9307, -1009,
	-2403, 26868,  9313, -1010, -2404, 26865,  9318, -1011, -2404, 26860,  9323, -1011, -2404, 26856,  9328, -1012,
	-2404, 26852,  9333, -1013, -2404, 26847,  9338, -1013, -2404, 26842,  9344, -1014, -2405, 26839,  9349, -1015,
	-2405, 26834,  9354, -1015, -2405, 26830,  9359, -1016, -2405, 26826,  9364, -1017, -2405, 26821,  9369, -1017,
	-2405, 26816,  9375, -1018, -2405, 26812,  9380, -1019, -2406, 26808,  9385, -1019, -2406, 26804,  9390, -1020,
	-2406, 26800,  9395, -1021, -2406, 26795,  9400, -1021, -2406, 26790,  9406, -1022, -2406, 26786,  9411, -1023,
	-2406, 26781,  9416, -1023, -2407, 26778,  9421, -1024, -2407, 26774,  9426, -1025, -2407, 26769,  9431, -1025,
	-2407, 26764,  9437, -1026, -2407, 26760,  9442, -1027, -2407, 26755,  9447, -1027, -2408, 26752,  9452, -1028,
	-2408, 26747,  9457, -1028, -2408, 26742,  9463, -1029, -2408, 26738,  9468, -1030, -2408, 26733,  9473, -1030,
	-2408, 26729,  9478, -1031, -2408, 26725,  9483, -1032, -2409, 26721,  9488, -1032, -2409, 26716,  9494, -1033,
	-2409, 26712,  9499, -1034, -2409, 26707,  9504, -1034, -2409, 26703,  9509, -1035, -2409, 26699,  9514, -1036,
	-2409, 26693,  9520, -1036, -2409, 26689,  9525, -1037, -2410, 26686,  9530, -1038, -2410, 26681,  9535, -1038,
	-2410, 26677,  9540, -1039, -2410, 26673,  9545, -1040, -2410, 26667,  9551, -1040, -2410, 26663,  9556, -1041,
	-2410, 26659,  9561, -1042, -2411, 26655,  9566, -1042, -2411, 26651,  9571, -1043, -2411, 26646,  9577, -1044,
	-2411, 26641,  9582, -1044, -2411, 26637,  9587, -1045, -2411, 26633,  9592, -1046, -2411, 26628,  9597, -1046,
	-2411, 26623,  9603, -1047, -2412, 26620,  9608, -1048, -2412, 26615,  9613, -1048, -2412, 26611,  9618, -1049,
	-2412, 26607,  9623, -1050, -2412, 26601,  9629, -1050, -2412, 26597,  9634, -1051, -2412, 26593,  9639, -1052,
	-2412, 26588,  9644, -1052, -2413, 26585,  9649, -1053, -2413, 26581,  9654, -1054, -2413, 26575,  9660, -1054,
	-2413, 26571,  9665, -1055, -2413, 26567,  9670, -1056, -2413, 26562,  9675, -1056, -2413, 26557,  9681, -1057,
	-2413, 26553,  9686, -1058, -2414, 26549,  9691, -1058, -2414, 26545,  9696, -1059, -2414, 26541,  9701, -1060,
	-2414, 26535,  9707, -1060, -2414, 26531,  9712, -1061, -2414, 26527,  9717, -1062, -2414, 26522,  9722, -1062,
	-2414, 26518,  9727, -1063, -2414, 26513,  9733, -1064, -2415, 26509,  9738, -1064, -2415, 26505,  9743, -1065,
	-2415, 26501,  9748, -1066, -2415, 26496,  9753, -1066, -2415, 26491,  9759, -1067, -2415, 26487,  9764, -1068,
	-2415, 26482,  9769, -1068, -2415, 26478,  9774, -1069, -2415, 26473,  9779, -1069, -2416, 26469,  9785, -1070,
	-2416, 26465,  9790, -1071, -2416, 26460,  9795, -1071, -2416, 26456,  9800, -1072, -2416, 26451,  9806, -1073,
	-2416, 26446,  9811, -1073, -2416, 26442,  9816, -1074, -2416, 26438,  9821, -1075, -2416, 26433,  9826, -1075,
	-2417, 26429,  9832, -1076, -2417, 26425,  9837, -1077, -2417, 26420,  9842, -1077, -2417, 26416,  9847, -1078,
	-2417, 26411,  9853, -1079, -2417, 26406,  9858, -1079, -2417, 26402,  9863, -1080, -2417, 26398,  9868, -1081,
	-2417, 26393,  9873, -1081, -2417, 26388,  9879, -1082, -2418, 26385,  9884, -1083, -2418, 26380,  9889, -1083,
	-2418, 26376,  9894, -1084, -2418, 26371,  9900, -1085, -2418, 26366,  9905, -1085, -2418, 26362,  9910, -1086,
	-2418, 26358,  9915, -1087, -2418, 26352,  9921, -1087, -2418, 26348,  9926, -1088, -2418, 26344,  9931, -1089,
	-2419, 26340,  9936, -1089, -2419, 26336,  9941, -1090, -2419, 26331,  9947, -1091, -2419, 26326,  9952, -1091,
	-2419, 26322,  9957, -1092, -2419, 26318,  9962, -1093, -2419, 26312,  9968, -1093, -2419, 26308,  9973, -1094,
	-2419, 26304,  9978, -1095, -2419, 26299,  9983, -1095, -2419, 26294,  9989, -1096, -2420, 26291,  9994, -1097,
	-2420, 26286,  9999, -1097, -2420, 26282, 10004, -1098, -2420, 26277, 10010, -1099, -2420, 26272, 10015, -1099,
	-2420, 26268, 10020, -1100, -2420, 26264, 10025, -1101, -2420, 26259, 10030, -1101, -2420, 26254, 10036, -1102,
	-2420, 26250, 10041, -1103, -2420, 26245, 10046, -1103, -2421, 26242, 10051, -1104, -2421, 26237, 10057, -1105,
	-2421, 26232, 10062, -1105, -2421, 26228, 10067, -1106, -2421, 26224, 10072, -1107, -2421, 26218, 10078, -1107,
	-2421, 26214, 10083, -1108, -2421, 26210, 10088, -1109, -2421, 26205, 10093, -1109, -2421, 26200, 10099, -1110,
	-2421, 26196, 10104, -1111, -2421, 26191, 10109, -1111, -2421, 26187, 10114, -1112, -2422, 26183, 10120, -1113,
	-2422, 26178, 10125, -1113, -2422, 26174, 10130, -1114, -2422, 26170, 10135, -1115, -2422, 26164, 10141, -1115,
	-2422, 26160, 10146, -1116, -2422, 26156, 10151, -1117, -2422, 26151, 10156, -1117, -2422, 26146, 10162, -1118,
	-2422, 26142, 10167, -1119, -2422, 26137, 10172, -1119, -2422, 26132, 10178, -1120, -2422, 26128, 10183, -1121,
	-2422, 26123, 10188, -1121, -2423, 26120, 10193, -1122, -2423, 26115, 10199, -1123, -2423, 26110, 10204, -1123,
	-2423, 26106, 10209, -1124, -2423, 26102, 10214, -1125, -2423, 26096, 10220, -1125, -2423, 26092, 10225, -1126,
	-2423, 26088, 10230, -1127, -2423, 26083, 10235, -1127, -2423, 26078, 10241, -1128, -2423, 26074, 10246, -1129,
	-2423, 26069, 10251, -1129, -2423, 26065, 10256, -1130, -2423, 26060, 10262, -1131, -2423, 26055, 10267, -1131,
	-2424, 26052, 10272, -1132, -2424, 26047, 10278, -1133, -2424, 26042, 10283, -1133, -2424, 26038, 10288, -1134,
	-2424, 26034, 10293, -1135, -2424, 26028, 10299, -1135, -2424, 26024, 10304, -1136, -2424, 26020, 10309, -1137,
	-2424, 26015, 10314, -1137, -2424, 26010, 10320, -1138, -2424, 26006, 10325, -1139, -2424, 26001, 10330, -1139,
	-2424, 25996, 10336, -1140, -2424, 25992, 10341, -1141, -2424, 25987, 10346, -1141, -2424, 25983, 10351, -1142,
	-2424, 25978, 10357, -1143, -2424, 25973, 10362, -1143, -2425, 25970, 10367, -1144, -2425, 25965, 10373, -1145,
	-2425, 25960, 10378, -1145, -2425, 25956, 10383, -1146, -2425, 25952, 10388, -1147, -2425, 25946, 10394, -1147,
	-2425, 25942, 10399, -1148, -2425, 25938, 10404, -1149, -2425, 25933, 10409, -1149, -2425, 25928, 10415, -1150,
	-2425, 25924, 10420, -1151, -2425, 25919, 10425, -1151, -2425, 25914, 10431, -1152, -2425, 25910, 10436, -1153,
	-2425, 25905, 10441, -1153, -2425, 25901, 10446, -1154, -2425, 25896, 10452, -1155, -2425, 25891, 10457, -1155,
	-2425, 25887, 10462, -1156, -2425, 25882, 10468, -1157, -2425, 25877, 10473, -1157, -2426, 25874, 10478, -1158,
	-2426, 25870, 10483, -1159, -2426, 25864, 10489, -1159, -2426, 25860, 10494, -1160, -2426, 25856, 10499, -1161,
	-2426, 25850, 10505, -1161, -2426, 25846, 10510, -1162, -2426, 25842, 10515, -1163, -2426, 25836, 10521, -1163,
	-2426, 25832, 10526, -1164, -2426, 25828, 10531, -1165, -2426, 25823, 10536, -1165, -2426, 25818, 10542, -1166,
	-2426, 25814, 10547, -1167, -2426, 25809, 10552, -1167, -2426, 25804, 10558, -1168, -2426, 25800, 10563, -1169,
	-2426, 25795, 10568, -1169, -2426, 25790, 10574, -1170, -2426, 25786, 10579, -1171, -2426, 25781, 10584, -1171,
	-2426, 25777, 10589, -1172, -2426, 25772, 10595, -1173, -2426, 25767, 10600, -1173, -2426, 25763, 10605, -1174,
	-2426, 25758, 10611, -1175, -2426, 25753, 10616, -1175, -2426, 25749, 10621, -1176, -2426, 25744, 10627, -1177,
	-2427, 25740, 10632, -1177, -2427, 25736, 10637, -1178, -2427, 25732, 10642, -1179, -2427, 25726, 10648, -1179,
	-2427, 25722, 10653, -1180, -2427, 25718, 10658, -1181, -2427, 25712, 10664, -1181, -2427, 25708, 10669, -1182,
	-2427, 25704, 10674, -1183, -2427, 25698, 10680, -1183, -2427, 25694, 10685, -1184, -2427, 25690, 10690, -1185,
	-2427, 25684, 10696, -1185, -2427, 25680, 10701, -1186, -2427, 25676, 10706, -1187, -2427, 25670, 10712, -1187,
	-2427, 25666, 10717, -1188, -2427, 25662, 10722, -1189, -2427, 25657, 10727, -1189, -2427, 25652, 10733, -1190,
	-2427, 25648, 10738, -1191, -2427, 25643, 10743, -1191, -2427, 25638, 10749, -1192, -2427, 25634, 10754, -1193,
	-2427, 25629, 10759, -1193, -2427, 25624, 10765, -1194, -2427, 25620, 10770, -1195, -2427, 25615, 10775, -1195,
	-2427, 25610, 10781, -1196, -2427, 25606, 10786, -1197, -2427, 25601, 10791, -1197, -2427, 25596, 10797, -1198,
	-2427, 25592, 10802, -1199, -2427, 25587, 10807, -1199, -2427, 25582, 10813, -1200, -2427, 25578, 10818, -1201,
	-2427, 25573, 10823, -1201, -2427, 25568, 10829, -1202, -2427, 25564, 10834, -1203, -2427, 25559, 10839, -1203,
	-2427, 25555, 10844, -1204, -2427, 25550, 10850, -1205, -2427, 25545, 10855, -1205, -2427, 25541, 10860, -1206,
	-2427, 25536, 10866, -1207, -2427, 25531, 10871, -1207, -2427, 25527, 10876, -1208, -2427, 25522, 10882, -1209,
	-2427, 25517, 10887, -1209, -2427, 25513, 10892, -1210, -2427, 25508, 10898, -1211, -2427, 25503, 10903, -1211,
	-2427, 25499, 10908, -1212, -2427, 25494, 10914, -1213, -2427, 25489, 10919, -1213, -2427, 25485, 10924, -1214,
	-2427, 25480, 10930, -1215, -2427, 25475, 10935, -1215, -2427, 25471, 10940, -1216, -2427, 25466, 10946, -1217,
	-2427, 25461, 10951, -1217, -2427, 25457, 10956, -1218, -2427, 25452, 10962, -1219, -2427, 25447, 10967, -1219,
	-2427, 25443, 10972, -1220, -2427, 25438, 10978, -1221, -2427, 25433, 10983, -1221, -2427, 25429, 10988, -1222,
	-2427, 25424, 10994, -1223, -2427, 25419, 10999, -1223, -2427, 25414, 11005, -1224, -2427, 25410, 11010, -1225,
	-2427, 25405, 11015, -1225, -2427, 25400, 11021, -1226, -2427, 25396, 11026, -1227, -2427, 25391, 11031, -1227,
	-2427, 25386, 11037, -1228, -2427, 25382, 11042, -1229, -2427, 25377, 11047, -1229, -2427, 25372, 11053, -1230,
	-2427, 25368, 11058, -1231, -2427, 25363, 11063, -1231, -2427, 25358, 11069, -1232, -2427, 25354, 11074, -1233,
	-2427, 25349, 11079, -1233, -2427, 25344, 11085, -1234, -2427, 25340, 11090, -1235, -2427, 25335, 11095, -1235,
	-2427, 25330, 11101, -1236, -2427, 25326, 11106, -1237, -2427, 25321, 11111, -1237, -2427, 25316, 11117, -1238,
	-2427, 25312, 11122, -1239, -2427, 25307, 11127, -1239, -2427, 25302, 11133, -1240, -2427, 25298, 11138, -1241,
	-2427, 25292, 11144, -1241, -2427, 25288, 11149, -1242, -2427, 25284, 11154, -1243, -2427, 25278, 11160, -1243,
	-2427, 25274, 11165, -1244, -2427, 25270, 11170, -1245, -2427, 25264, 11176, -1245, -2427, 25260, 11181, -1246,
	-2427, 25256, 11186, -1247, -2427, 25250, 11192, -1247, -2427, 25246, 11197, -1248, -2427, 25242, 11202, -1249,
	-2427, 25236, 11208, -1249, -2427, 25232, 11213, -1250, -2427, 25227, 11219, -1251, -2426, 25221, 11224, -1251,
	-2426, 25217, 11229, -1252, -2426, 25212, 11235, -1253, -2426, 25207, 11240, -1253, -2426, 25203, 11245, -1254,
	-2426, 25198, 11251, -1255, -2426, 25193, 11256, -1255, -2426, 25189, 11261, -1256, -2426, 25184, 11267, -1257,
	-2426, 25179, 11272, -1257, -2426, 25175, 11277, -1258, -2426, 25170, 11283, -1259, -2426, 25165, 11288, -1259,
	-2426, 25160, 11294, -1260, -2426, 25156, 11299, -1261, -2426, 25151, 11304, -1261, -2426, 25146, 11310, -1262,
	-2426, 25142, 11315, -1263, -2426, 25137, 11320, -1263, -2426, 25132, 11326, -1264, -2426, 25128, 11331, -1265,
	-2426, 25122, 11337, -1265, -2426, 25118, 11342, -1266, -2426, 25114, 11347, -1267, -2426, 25108, 11353, -1267,
	-2426, 25104, 11358, -1268, -2426, 25100, 11363, -1269, -2426, 25094, 11369, -1269, -2426, 25090, 11374, -1270,
	-2426, 25085, 11380, -1271, -2425, 25079, 11385, -1271, -2425, 25075, 11390, -1272, -2425, 25069, 11396, -1272,
	-2425, 25065, 11401, -1273, -2425, 25061, 11406, -1274, -2425, 25055, 11412, -1274, -2425, 25051, 11417, -1275,
	-2425, 25047, 11422, -1276, -2425, 25041, 11428, -1276, -2425, 25037, 11433, -1277, -2425, 25032, 11439, -1278,
	-2425, 25027, 11444, -1278, -2425, 25023, 11449, -1279, -2425, 25018, 11455, -1280, -2425, 25013, 11460, -1280,
	-2425, 25008, 11466, -1281, -2425, 25004, 11471, -1282, -2425, 24999, 11476, -1282, -2425, 24994, 11482, -1283,
	-2425, 24990, 11487, -1284, -2425, 24985, 11492, -1284, -2424, 24979, 11498, -1285, -2424, 24975, 11503, -1286,
	-2424, 24969, 11509, -1286, -2424, 24965, 11514, -1287, -2424, 24961, 11519, -1288, -2424, 24955, 11525, -1288,
	-2424, 24951, 11530, -1289, -2424, 24946, 11536, -1290, -2424, 24941, 11541, -1290, -2424, 24937, 11546, -1291,
	-2424, 24932, 11552, -1292, -2424, 24927, 11557, -1292, -2424, 24923, 11562, -1293, -2424, 24918, 11568, -1294,
	-2424, 24913, 11573, -1294, -2424, 24908, 11579, -1295, -2424, 24904, 11584, -1296, -2424, 24899, 11589, -1296,
	-2423, 24893, 11595, -1297, -2423, 24889, 11600, -1298, -2423, 24883, 11606, -1298, -2423, 24879, 11611, -1299,
	-2423, 24875, 11616, -1300, -2423, 24869, 11622, -1300, -2423, 24865, 11627, -1301, -2423, 24860, 11633, -1302,
	-2423, 24855, 11638, -1302, -2423, 24851, 11643, -1303, -2423, 24846, 11649, -1304, -2423, 24841, 11654, -1304,
	-2423, 24837, 11659, -1305, -2423, 24832, 11665, -1306, -2423, 24827, 11670, -1306, -2423, 24822, 11676, -1307,
	-2422, 24817, 11681, -1308, -2422, 24812, 11686, -1308, -2422, 24807, 11692, -1309, -2422, 24803, 11697, -1310,
	-2422, 24797, 11703, -1310, -2422, 24793, 11708, -1311, -2422, 24789, 11713, -1312, -2422, 24783, 11719, -1312,
	-2422, 24779, 11724, -1313, -2422, 24774, 11730, -1314, -2422, 24769, 11735, -1314, -2422, 24765, 11740, -1315,
	-2422, 24760, 11746, -1316, -2422, 24755, 11751, -1316, -2421, 24749, 11757, -1317, -2421, 24745, 11762, -1318,
	-2421, 24740, 11767, -1318, -2421, 24735, 11773, -1319, -2421, 24731, 11778, -1320, -2421, 24725, 11784, -1320,
	-2421, 24721, 11789, -1321, -2421, 24717, 11794, -1322, -2421, 24711, 11800, -1322, -2421, 24707, 11805, -1323,
	-2421, 24702, 11811, -1324, -2421, 24697, 11816, -1324, -2421, 24692, 11822, -1325, -2420, 24687, 11827, -1326,
	-2420, 24682, 11832, -1326, -2420, 24677, 11838, -1327, -2420, 24673, 11843, -1328, -2420, 24667, 11849, -1328,
	-2420, 24663, 11854, -1329, -2420, 24659, 11859, -1330, -2420, 24653, 11865, -1330, -2420, 24649, 11870, -1331,
	-2420, 24644, 11876, -1332, -2420, 24639, 11881, -1332, -2420, 24635, 11886, -1333, -2419, 24629, 11892, -1334,
	-2419, 24624, 11897, -1334, -2419, 24619, 11903, -1335, -2419, 24615, 11908, -1336, -2419, 24609, 11914, -1336,
	-2419, 24605, 11919, -1337, -2419, 24601, 11924, -1338, -2419, 24595, 11930, -1338, -2419, 24591, 11935, -1339,
	-2419, 24586, 11941, -1340, -2419, 24581, 11946, -1340, -2419, 24577, 11951, -1341, -2418, 24571, 11957, -1342,
	-2418, 24566, 11962, -1342, -2418, 24561, 11968, -1343, -2418, 24557, 11973, -1344, -2418, 24551, 11979, -1344,
	-2418, 24547, 11984, -1345, -2418, 24543, 11989, -1346, -2418, 24537, 11995, -1346, -2418, 24533, 12000, -1347,
	-2418, 24528, 12006, -1348, -2418, 24523, 12011, -1348, -2417, 24518, 12016, -1349, -2417, 24513, 12022, -1350,
	-2417, 24508, 12027, -1350, -2417, 24503, 12033, -1351, -2417, 24499, 12038, -1352, -2417, 24493, 12044, -1352,
	-2417, 24489, 12049, -1353, -2417, 24485, 12054, -1354, -2417, 24479, 12060, -1354, -2417, 24475, 12065, -1355,
	-2416, 24469, 12071, -1356, -2416, 24464, 12076, -1356, -2416, 24459, 12082, -1357, -2416, 24455, 12087, -1358,
	-2416, 24450, 12092, -1358, -2416, 24445, 12098, -1359, -2416, 24441, 12103, -1360, -2416, 24435, 12109, -1360,
	-2416, 24431, 12114, -1361, -2416, 24426, 12120, -1362, -2415, 24420, 12125, -1362, -2415, 24416, 12130, -1363,
	-2415, 24411, 12136, -1364, -2415, 24406, 12141, -1364, -2415, 24401, 12147, -1365, -2415, 24396, 12152, -1365,
	-2415, 24391, 12158, -1366, -2415, 24387, 12163, -1367, -2415, 24382, 12168, -1367, -2414, 24376, 12174, -1368,
	-2414, 24372, 12179, -1369, -2414, 24366, 12185, -1369, -2414, 24362, 12190, -1370, -2414, 24357, 12196, -1371,
	-2414, 24352, 12201, -1371, -2414, 24348, 12206, -1372, -2414, 24343, 12212, -1373, -2414, 24338, 12217, -1373,
	-2413, 24332, 12223, -1374, -2413, 24328, 12228, -1375, -2413, 24322, 12234, -1375, -2413, 24318, 12239, -1376,
	-2413, 24314, 12244, -1377, -2413, 24308, 12250, -1377, -2413, 24304, 12255, -1378, -2413, 24299, 12261, -1379,
	-2413, 24294, 12266, -1379, -2412, 24288, 12272, -1380, -2412, 24284, 12277, -1381, -2412, 24278, 12283, -1381,
	-2412, 24274, 12288, -1382, -2412, 24270, 12293, -1383, -2412, 24264, 12299, -1383, -2412, 24260, 12304, -1384,
	-2412, 24255, 12310, -1385, -2411, 24249, 12315, -1385, -2411, 24244, 12321, -1386, -2411, 24240, 12326, -1387,
	-2411, 24234, 12332, -1387, -2411, 24230, 12337, -1388, -2411, 24226, 12342, -1389, -2411, 24220, 12348, -1389,
	-2411, 24216, 12353, -1390, -2411, 24211, 12359, -1391, -2410, 24205, 12364, -1391, -2410, 24200, 12370, -1392,
	-2410, 24196, 12375, -1393, -2410, 24190, 12381, -1393, -2410, 24186, 12386, -1394, -2410, 24182, 12391, -1395,
	-2410, 24176, 12397, -1395, -2410, 24172, 12402, -1396, -2409, 24166, 12408, -1397, -2409, 24161, 12413, -1397,
	-2409, 24156, 12419, -1398, -2409, 24152, 12424, -1399, -2409, 24146, 12430, -1399, -2409, 24142, 12435, -1400,
	-2409, 24138, 12440, -1401, -2408, 24131, 12446, -1401, -2408, 24127, 12451, -1402, -2408, 24122, 12457, -1403,
	-2408, 24117, 12462, -1403, -2408, 24112, 12468, -1404, -2408, 24107, 12473, -1404, -2408, 24102, 12479, -1405,
	-2408, 24098, 12484, -1406, -2407, 24091, 12490, -1406, -2407, 24087, 12495, -1407, -2407, 24083, 12500, -1408,
	-2407, 24077, 12506, -1408, -2407, 24073, 12511, -1409, -2407, 24068, 12517, -1410, -2407, 24063, 12522, -1410,
	-2406, 24057, 12528, -1411, -2406, 24053, 12533, -1412, -2406, 24047, 12539, -1412, -2406, 24043, 12544, -1413,
	-2406, 24039, 12549, -1414, -2406, 24033, 12555, -1414, -2406, 24029, 12560, -1415, -2405, 24023, 12566, -1416,
	-2405, 24018, 12571, -1416, -2405, 24013, 12577, -1417, -2405, 24009, 12582, -1418, -2405, 24003, 12588, -1418,
	-2405, 23999, 12593, -1419, -2405, 23994, 12599, -1420, -2404, 23988, 12604, -1420, -2404, 23983, 12610, -1421,
	-2404, 23979, 12615, -1422, -2404, 23974, 12620, -1422, -2404, 23969, 12626, -1423, -2404, 23965, 12631, -1424,
	-2404, 23959, 12637, -1424, -2403, 23954, 12642, -1425, -2403, 23949, 12648, -1426, -2403, 23944, 12653, -1426,
	-2403, 23939, 12659, -1427, -2403, 23935, 12664, -1428, -2403, 23929, 12670, -1428, -2403, 23925, 12675, -1429,
	-2402, 23918, 12681, -1429, -2402, 23914, 12686, -1430, -2402, 23910, 12691, -1431, -2402, 23904, 12697, -1431,
	-2402, 23900, 12702, -1432, -2402, 23895, 12708, -1433, -2402, 23890, 12713, -1433, -2401, 23884, 12719, -1434,
	-2401, 23880, 12724, -1435, -2401, 23874, 12730, -1435, -2401, 23870, 12735, -1436, -2401, 23865, 12741, -1437,
	-2401, 23860, 12746, -1437, -2400, 23854, 12752, -1438, -2400, 23850, 12757, -1439, -2400, 23844, 12763, -1439,
	-2400, 23840, 12768, -1440, -2400, 23836, 12773, -1441, -2400, 23830, 12779, -1441, -2400, 23826, 12784, -1442,
	-2399, 23820, 12790, -1443, -2399, 23815, 12795, -1443, -2399, 23810, 12801, -1444, -2399, 23806, 12806, -1445,
	-2399, 23800, 12812, -1445, -2399, 23796, 12817, -1446, -2398, 23790, 12823, -1447, -2398, 23785, 12828, -1447,
	-2398, 23780, 12834, -1448, -2398, 23776, 12839, -1449, -2398, 23770, 12845, -1449, -2398, 23766, 12850, -1450,
	-2397, 23759, 12856, -1450, -2397, 23755, 12861, -1451, -2397, 23751, 12866, -1452, -2397, 23745, 12872, -1452,
	-2397, 23741, 12877, -1453, -2397, 23736, 12883, -1454, -2396, 23730, 12888, -1454, -2396, 23725, 12894, -1455,
	-2396, 23721, 12899, -1456, -2396, 23715, 12905, -1456, -2396, 23711, 12910, -1457, -2396, 23706, 12916, -1458,
	-2395, 23700, 12921, -1458, -2395, 23695, 12927, -1459, -2395, 23691, 12932, -1460, -2395, 23685, 12938, -1460,
	-2395, 23681, 12943, -1461, -2395, 23676, 12949, -1462, -2394, 23670, 12954, -1462, -2394, 23665, 12960, -1463,
	-2394, 23661, 12965, -1464, -2394, 23655, 12971, -1464, -2394, 23651, 12976, -1465, -2394, 23646, 12982, -1466,
	-2393, 23640, 12987, -1466, -2393, 23636, 12992, -1467, -2393, 23631, 12998, -1468, -2393, 23626, 13003, -1468,
	-2393, 23621, 13009, -1469, -2393, 23616, 13014, -1469, -2392, 23610, 13020, -1470, -2392, 23606, 13025, -1471,
	-2392, 23600, 13031, -1471, -2392, 23596, 13036, -1472, -2392, 23591, 13042, -1473, -2391, 23585, 13047, -1473,
	-2391, 23580, 13053, -1474, -2391, 23576, 13058, -1475, -2391, 23570, 13064, -1475, -2391, 23566, 13069, -1476,
	-2391, 23561, 13075, -1477, -2390, 23555, 13080, -1477, -2390, 23550, 13086, -1478, -2390, 23546, 13091, -1479,
	-2390, 23540, 13097, -1479, -2390, 23536, 13102, -1480, -2389, 23530, 13108, -1481, -2389, 23525, 13113, -1481,
	-2389, 23520, 13119, -1482, -2389, 23516, 13124, -1483, -2389, 23510, 13130, -1483, -2389, 23506, 13135, -1484,
	-2388, 23499, 13141, -1484, -2388, 23495, 13146, -1485, -2388, 23490, 13152, -1486, -2388, 23485, 13157, -1486,
	-2388, 23480, 13163, -1487, -2387, 23475, 13168, -1488, -2387, 23470, 13173, -1488, -2387, 23465, 13179, -1489,
	-2387, 23461, 13184, -1490, -2387, 23455, 13190, -1490, -2387, 23451, 13195, -1491, -2386, 23445, 13201, -1492,
	-2386, 23440, 13206, -1492, -2386, 23435, 13212, -1493, -2386, 23431, 13217, -1494, -2386, 23425, 13223, -1494,
	-2385, 23420, 13228, -1495, -2385, 23415, 13234, -1496, -2385, 23410, 13239, -1496, -2385, 23405, 13245, -1497,
	-2385, 23400, 13250, -1497, -2384, 23394, 13256, -1498, -2384, 23390, 13261, -1499, -2384, 23384, 13267, -1499,
	-2384, 23380, 13272, -1500, -2384, 23375, 13278, -1501, -2383, 23369, 13283, -1501, -2383, 23364, 13289, -1502,
	-2383, 23360, 13294, -1503, -2383, 23354, 13300, -1503, -2383, 23350, 13305, -1504, -2382, 23344, 13311, -1505,
	-2382, 23339, 13316, -1505, -2382, 23334, 13322, -1506, -2382, 23330, 13327, -1507, -2382, 23324, 13333, -1507,
	-2381, 23319, 13338, -1508, -2381, 23314, 13344, -1509, -2381, 23309, 13349, -1509, -2381, 23304, 13355, -1510,
	-2381, 23299, 13360, -1510, -2380, 23293, 13366, -1511, -2380, 23289, 13371, -1512, -2380, 23283, 13377, -1512,
	-2380, 23279, 13382, -1513, -2380, 23274, 13388, -1514, -2379, 23268, 13393, -1514, -2379, 23263, 13399, -1515,
	-2379, 23259, 13404, -1516, -2379, 23253, 13410, -1516, -2379, 23249, 13415, -1517, -2378, 23243, 13421, -1518,
	-2378, 23238, 13426, -1518, -2378, 23233, 13432, -1519, -2378, 23229, 13437, -1520, -2378, 23223, 13443, -1520,
	-2377, 23218, 13448, -1521, -2377, 23212, 13454, -1521, -2377, 23208, 13459, -1522, -2377, 23203, 13465, -1523,
	-2377, 23198, 13470, -1523, -2376, 23192, 13476, -1524, -2376, 23188, 13481, -1525, -2376, 23182, 13487, -1525,
	-2376, 23178, 13492, -1526, -2376, 23173, 13498, -1527, -2375, 23167, 13503, -1527, -2375, 23162, 13509, -1528,
	-2375, 23158, 13514, -1529, -2375, 23152, 13520, -1529, -2374, 23147, 13525, -1530, -2374, 23142, 13531, -1531,
	-2374, 23137, 13536, -1531, -2374, 23132, 13542, -1532, -2374, 23127, 13547, -1532, -2373, 23121, 13553, -1533,
	-2373, 23117, 13558, -1534, -2373, 23111, 13564, -1534, -2373, 23107, 13569, -1535, -2373, 23102, 13575, -1536,
	-2372, 23096, 13580, -1536, -2372, 23091, 13586, -1537, -2372, 23087, 13591, -1538, -2372, 23081, 13597, -1538,
	-2371, 23076, 13602, -1539, -2371, 23071, 13608, -1540, -2371, 23066, 13613, -1540, -2371, 23061, 13619, -1541,
	-2371, 23057, 13624, -1542, -2370, 23050, 13630, -1542, -2370, 23045, 13636, -1543, -2370, 23040, 13641, -1543,
	-2370, 23035, 13647, -1544, -2369, 23030, 13652, -1545, -2369, 23024, 13658, -1545, -2369, 23020, 13663, -1546,
	-2369, 23015, 13669, -1547, -2369, 23010, 13674, -1547, -2368, 23004, 13680, -1548, -2368, 23000, 13685, -1549,
	-2368, 22994, 13691, -1549, -2368, 22990, 13696, -1550, -2367, 22984, 13702, -1551, -2367, 22979, 13707, -1551,
	-2367, 22974, 13713, -1552, -2367, 22969, 13718, -1552, -2367, 22964, 13724, -1553, -2366, 22959, 13729, -1554,
	-2366, 22953, 13735, -1554, -2366, 22949, 13740, -1555, -2366, 22944, 13746, -1556, -2365, 22938, 13751, -1556,
	-2365, 22933, 13757, -1557, -2365, 22929, 13762, -1558, -2365, 22923, 13768, -1558, -2364, 22918, 13773, -1559,
	-2364, 22913, 13779, -1560, -2364, 22908, 13784, -1560, -2364, 22903, 13790, -1561, -2364, 22898, 13795, -1561,
	-2363, 22892, 13801, -1562, -2363, 22888, 13806, -1563, -2363, 22882, 13812, -1563, -2363, 22878, 13817, -1564,
	-2362, 22872, 13823, -1565, -2362, 22866, 13829, -1565, -2362, 22862, 13834, -1566, -2362, 22857, 13840, -1567,
	-2361, 22851, 13845, -1567, -2361, 22846, 13851, -1568, -2361, 22842, 13856, -1569, -2361, 22836, 13862, -1569,
	-2360, 22831, 13867, -1570, -2360, 22825, 13873, -1570, -2360, 22821, 13878, -1571, -2360, 22816, 13884, -1572,
	-2359, 22810, 13889, -1572, -2359, 22805, 13895, -1573, -2359, 22801, 13900, -1574, -2359, 22795, 13906, -1574,
	-2359, 22791, 13911, -1575, -2358, 22785, 13917, -1576, -2358, 22780, 13922, -1576, -2358, 22775, 13928, -1577,
	-2358, 22770, 13933, -1577, -2357, 22764, 13939, -1578, -2357, 22760, 13944, -1579, -2357, 22754, 13950, -1579,
	-2357, 22750, 13955, -1580, -2356, 22744, 13961, -1581, -2356, 22738, 13967, -1581, -2356, 22734, 13972, -1582,
	-2356, 22729, 13978, -1583, -2355, 22723, 13983, -1583, -2355, 22718, 13989, -1584, -2355, 22713, 13994, -1584,
	-2355, 22708, 14000, -1585, -2354, 22703, 14005, -1586, -2354, 22697, 14011, -1586, -2354, 22693, 14016, -1587,
	-2354, 22688, 14022, -1588, -2353, 22682, 14027, -1588, -2353, 22677, 14033, -1589, -2353, 22673, 14038, -1590,
	-2353, 22667, 14044, -1590, -2352, 22662, 14049, -1591, -2352, 22657, 14055, -1592, -2352, 22652, 14060, -1592,
	-2352, 22647, 14066, -1593, -2351, 22641, 14071, -1593, -2351, 22636, 14077, -1594, -2351, 22631, 14083, -1595,
	-2351, 22626, 14088, -1595, -2350, 22620, 14094, -1596, -2350, 22616, 14099, -1597, -2350, 22610, 14105, -1597,
	-2350, 22606, 14110, -1598, -2349, 22600, 14116, -1599, -2349, 22595, 14121, -1599, -2349, 22590, 14127, -1600,
	-2349, 22585, 14132, -1600, -2348, 22579, 14138, -1601, -2348, 22575, 14143, -1602, -2348, 22569, 14149, -1602,
	-2348, 22565, 14154, -1603, -2347, 22559, 14160, -1604, -2347, 22554, 14165, -1604, -2347, 22549, 14171, -1605,
	-2347, 22544, 14177, -1606, -2346, 22538, 14182, -1606, -2346, 22533, 14188, -1607, -2346, 22528, 14193, -1607,
	-2345, 22522, 14199, -1608, -2345, 22518, 14204, -1609, -2345, 22512, 14210, -1609, -2345, 22508, 14215, -1610,
	-2344, 22502, 14221, -1611, -2344, 22497, 14226, -1611, -2344, 22492, 14232, -1612, -2344, 22487, 14237, -1612,
	-2343, 22481, 14243, -1613, -2343, 22477, 14248, -1614, -2343, 22471, 14254, -1614, -2343, 22467, 14259, -1615,
	-2342, 22461, 14265, -1616, -2342, 22455, 14271, -1616, -2342, 22451, 14276, -1617, -2341, 22445, 14282, -1618,
	-2341, 22440, 14287, -1618, -2341, 22435, 14293, -1619, -2341, 22430, 14298, -1619, -2340, 22424, 14304, -1620,
	-2340, 22420, 14309, -1621, -2340, 22414, 14315, -1621, -2340, 22410, 14320, -1622, -2339, 22404, 14326, -1623,
	-2339, 22399, 14331, -1623, -2339, 22394, 14337, -1624, -2339, 22389, 14342, -1624, -2338, 22383, 14348, -1625,
	-2338, 22378, 14354, -1626, -2338, 22373, 14359, -1626, -2337, 22367, 14365, -1627, -2337, 22363, 14370, -1628,
	-2337, 22357, 14376, -1628, -2337, 22353, 14381, -1629, -2336, 22347, 14387, -1630, -2336, 22342, 14392, -1630,
	-2336, 22337, 14398, -1631, -2336, 22332, 14403, -1631, -2335, 22326, 14409, -1632, -2335, 22322, 14414, -1633,
	-2335, 22316, 14420, -1633, -2334, 22311, 14425, -1634, -2334, 22306, 14431, -1635, -2334, 22300, 14437, -1635,
	-2334, 22296, 14442, -1636, -2333, 22289, 14448, -1636, -2333, 22285, 14453, -1637, -2333, 22280, 14459, -1638,
	-2332, 22274, 14464, -1638, -2332, 22269, 14470, -1639, -2332, 22265, 14475, -1640, -2332, 22259, 14481, -1640,
	-2331, 22254, 14486, -1641, -2331, 22249, 14492, -1642, -2331, 22244, 14497, -1642, -2331, 22239, 14503, -1643,
	-2330, 22232, 14509, -1643, -2330, 22228, 14514, -1644, -2330, 22223, 14520, -1645, -2329, 22217, 14525, -1645,
	-2329, 22212, 14531, -1646, -2329, 22208, 14536, -1647, -2329, 22202, 14542, -1647, -2328, 22197, 14547, -1648,
	-2328, 22191, 14553, -1648, -2328, 22187, 14558, -1649, -2327, 22181, 14564, -1650, -2327, 22176, 14569, -1650,
	-2327, 22171, 14575, -1651, -2327, 22166, 14581, -1652, -2326, 22160, 14586, -1652, -2326, 22155, 14592, -1653,
	-2326, 22150, 14597, -1653, -2325, 22144, 14603, -1654, -2325, 22140, 14608, -1655, -2325, 22134, 14614, -1655,
	-2325, 22130, 14619, -1656, -2324, 22124, 14625, -1657, -2324, 22119, 14630, -1657, -2324, 22114, 14636, -1658,
	-2323, 22107, 14642, -1658, -2323, 22103, 14647, -1659, -2323, 22098, 14653, -1660, -2322, 22092, 14658, -1660,
	-2322, 22087, 14664, -1661, -2322, 22083, 14669, -1662, -2322, 22077, 14675, -1662, -2321, 22072, 14680, -1663,
	-2321, 22066, 14686, -1663, -2321, 22062, 14691, -1664, -2320, 22056, 14697, -1665, -2320, 22051, 14702, -1665,
	-2320, 22046, 14708, -1666, -2320, 22041, 14714, -1667, -2319, 22035, 14719, -1667, -2319, 22030, 14725, -1668,
	-2319, 22025, 14730, -1668, -2318, 22019, 14736, -1669, -2318, 22015, 14741, -1670, -2318, 22009, 14747, -1670,
	-2317, 22004, 14752, -1671, -2317, 21999, 14758, -1672, -2317, 21994, 14763, -1672, -2317, 21989, 14769, -1673,
	-2316, 21982, 14775, -1673, -2316, 21978, 14780, -1674, -2316, 21973, 14786, -1675, -2315, 21967, 14791, -1675,
	-2315, 21962, 14797, -1676, -2315, 21958, 14802, -1677, -2314, 21951, 14808, -1677, -2314, 21947, 14813, -1678,
	-2314, 21941, 14819, -1678, -2314, 21937, 14824, -1679, -2313, 21931, 14830, -1680, -2313, 21925, 14836, -1680,
	-2313, 21921, 14841, -1681, -2312, 21914, 14847, -1681, -2312, 21910, 14852, -1682, -2312, 21905, 14858, -1683,
	-2311, 21899, 14863, -1683, -2311, 21894, 14869, -1684, -2311, 21890, 14874, -1685, -2310, 21883, 14880, -1685,
	-2310, 21879, 14885, -1686, -2310, 21873, 14891, -1686, -2310, 21868, 14897, -1687, -2309, 21863, 14902, -1688,
	-2309, 21857, 14908, -1688, -2309, 21853, 14913, -1689, -2308, 21847, 14919, -1690, -2308, 21842, 14924, -1690,
	-2308, 21837, 14930, -1691, -2307, 21831, 14935, -1691, -2307, 21826, 14941, -1692, -2307, 21822, 14946, -1693,
	-2306, 21815, 14952, -1693, -2306, 21810, 14958, -1694, -2306, 21805, 14963, -1694, -2306, 21800, 14969, -1695,
	-2305, 21795, 14974, -1696, -2305, 21789, 14980, -1696, -2305, 21785, 14985, -1697, -2304, 21779, 14991, -1698,
	-2304, 21774, 14996, -1698, -2304, 21769, 15002, -1699, -2303, 21763, 15007, -1699, -2303, 21758, 15013, -1700,
	-2303, 21753, 15019, -1701, -2302, 21747, 15024, -1701, -2302, 21742, 15030, -1702, -2302, 21737, 15035, -1702,
	-2301, 21731, 15041, -1703, -2301, 21727, 15046, -1704, -2301, 21721, 15052, -1704, -2300, 21716, 15057, -1705,
	-2300, 21711, 15063, -1706, -2300, 21705, 15069, -1706, -2300, 21701, 15074, -1707, -2299, 21694, 15080, -1707,
	-2299, 21690, 15085, -1708, -2299, 21685, 15091, -1709, -2298, 21679, 15096, -1709, -2298, 21674, 15102, -1710,
	-2298, 21669, 15107, -1710, -2297, 21663, 15113, -1711, -2297, 21659, 15118, -1712, -2297, 21653, 15124, -1712,
	-2296, 21647, 15130, -1713, -2296, 21643, 15135, -1714, -2296, 21637, 15141, -1714, -2295, 21632, 15146, -1715,
	-2295, 21626, 15152, -1715, -2295, 21622, 15157, -1716, -2294, 21616, 15163, -1717, -2294, 21611, 15168, -1717,
	-2294, 21606, 15174, -1718, -2293, 21599, 15180, -1718, -2293, 21595, 15185, -1719, -2293, 21590, 15191, -1720,
	-2292, 21584, 15196, -1720, -2292, 21579, 15202, -1721, -2292, 21575, 15207, -1722, -2291, 21568, 15213, -1722,
	-2291, 21564, 15218, -1723, -2291, 21558, 15224, -1723, -2290, 21553, 15229, -1724, -2290, 21548, 15235, -1725,
	-2290, 21542, 15241, -1725, -2289, 21537, 15246, -1726, -2289, 21531, 15252, -1726, -2289, 21527, 15257, -1727,
	-2288, 21521, 15263, -1728, -2288, 21516, 15268, -1728, -2288, 21511, 15274, -1729, -2287, 21505, 15279, -1729,
	-2287, 21500, 15285, -1730, -2287, 21495, 15291, -1731, -2286, 21489, 15296, -1731, -2286, 21484, 15302, -1732,
	-2286, 21480, 15307, -1733, -2285, 21473, 15313, -1733, -2285, 21469, 15318, -1734, -2285, 21463, 15324, -1734,
	-2284, 21458, 15329, -1735, -2284, 21453, 15335, -1736, -2284, 21447, 15341, -1736, -2283, 21442, 15346, -1737,
	-2283, 21436, 15352, -1737, -2283, 21432, 15357, -1738, -2282, 21426, 15363, -1739, -2282, 21421, 15368, -1739,
	-2282, 21416, 15374, -1740, -2281, 21410, 15379, -1740, -2281, 21405, 15385, -1741, -2281, 21400, 15391, -1742,
	-2280, 21394, 15396, -1742, -2280, 21389, 15402, -1743, -2280, 21384, 15407, -1743, -2279, 21378, 15413, -1744,
	-2279, 21374, 15418, -1745, -2279, 21368, 15424, -1745, -2278, 21363, 15429, -1746, -2278, 21357, 15435, -1746,
	-2278, 21353, 15440, -1747, -2277, 21347, 15446, -1748, -2277, 21341, 15452, -1748, -2277, 21337, 15457, -1749,
	-2276, 21331, 15463, -1750, -2276, 21326, 15468, -1750, -2276, 21321, 15474, -1751, -2275, 21315, 15479, -1751,
	-2275, 21310, 15485, -1752, -2275, 21306, 15490, -1753, -2274, 21299, 15496, -1753, -2274, 21294, 15502, -1754,
	-2274, 21289, 15507, -1754, -2273, 21283, 15513, -1755, -2273, 21279, 15518, -1756, -2273, 21273, 15524, -1756,
	-2272, 21268, 15529, -1757, -2272, 21262, 15535, -1757, -2271, 21257, 15540, -1758, -2271, 21252, 15546, -1759,
	-2271, 21246, 15552, -1759, -2270, 21241, 15557, -1760, -2270, 21235, 15563, -1760, -2270, 21231, 15568, -1761,
	-2269, 21225, 15574, -1762, -2269, 21220, 15579, -1762, -2269, 21215, 15585, -1763, -2268, 21209, 15590, -1763,
	-2268, 21204, 15596, -1764, -2268, 21199, 15602, -1765, -2267, 21193, 15607, -1765, -2267, 21188, 15613, -1766,
	-2267, 21183, 15618, -1766, -2266, 21177, 15624, -1767, -2266, 21173, 15629, -1768, -2266, 21167, 15635, -1768,
	-2265, 21162, 15640, -1769, -2265, 21156, 15646, -1769, -2264, 21150, 15652, -1770, -2264, 21146, 15657, -1771,
	-2264, 21140, 15663, -1771, -2263, 21135, 15668, -1772, -2263, 21129, 15674, -1772, -2263, 21125, 15679, -1773,
	-2262, 21119, 15685, -1774, -2262, 21114, 15690, -1774, -2262, 21109, 15696, -1775, -2261, 21102, 15702, -1775,
	-2261, 21098, 15707, -1776, -2261, 21093, 15713, -1777, -2260, 21087, 15718, -1777, -2260, 21082, 15724, -1778,
	-2259, 21076, 15729, -1778, -2259, 21071, 15735, -1779, -2259, 21067, 15740, -1780, -2258, 21060, 15746, -1780,
	-2258, 21055, 15752, -1781, -2258, 21050, 15757, -1781, -2257, 21044, 15763, -1782, -2257, 21040, 15768, -1783,
	-2257, 21034, 15774, -1783, -2256, 21029, 15779, -1784, -2256, 21023, 15785, -1784, -2255, 21018, 15790, -1785,
	-2255, 21013, 15796, -1786, -2255, 21007, 15802, -1786, -2254, 21002, 15807, -1787, -2254, 20996, 15813, -1787,
	-2254, 20992, 15818, -1788, -2253, 20986, 15824, -1789, -2253, 20981, 15829, -1789, -2253, 20976, 15835, -1790,
	-2252, 20970, 15840, -1790, -2252, 20965, 15846, -1791, -2251, 20959, 15852, -1792, -2251, 20954, 15857, -1792,
	-2251, 20949, 15863, -1793, -2250, 20943, 15868, -1793, -2250, 20938, 15874, -1794, -2250, 20933, 15879, -1794,
	-2249, 20927, 15885, -1795, -2249, 20923, 15890, -1796, -2249, 20917, 15896, -1796, -2248, 20911, 15902, -1797,
	-2248, 20906, 15907, -1797, -2247, 20900, 15913, -1798, -2247, 20896, 15918, -1799, -2247, 20890, 15924, -1799,
	-2246, 20885, 15929, -1800, -2246, 20879, 15935, -1800, -2246, 20875, 15940, -1801, -2245, 20869, 15946, -1802,
	-2245, 20863, 15952, -1802, -2244, 20858, 15957, -1803, -2244, 20852, 15963, -1803, -2244, 20848, 15968, -1804,
	-2243, 20842, 15974, -1805, -2243, 20837, 15979, -1805, -2243, 20832, 15985, -1806, -2242, 20826, 15990, -1806,
	-2242, 20821, 15996, -1807, -2241, 20814, 16002, -1807, -2241, 20810, 16007, -1808, -2241, 20805, 16013, -1809,
	-2240, 20799, 16018, -1809, -2240, 20794, 16024, -1810, -2240, 20789, 16029, -1810, -2239, 20783, 16035, -1811,
	-2239, 20779, 16040, -1812, -2238, 20772, 16046, -1812, -2238, 20767, 16052, -1813, -2238, 20762, 16057, -1813,
	-2237, 20756, 16063, -1814, -2237, 20752, 16068, -1815, -2237, 20746, 16074, -1815, -2236, 20741, 16079, -1816,
	-2236, 20735, 16085, -1816, -2235, 20730, 16090, -1817, -2235, 20725, 16096, -1818, -2235, 20719, 16102, -1818,
	-2234, 20714, 16107, -1819, -2234, 20708, 16113, -1819, -2233, 20703, 16118, -1820, -2233, 20697, 16124, -1820,
	-2233, 20693, 16129, -1821, -2232, 20687, 16135, -1822, -2232, 20682, 16140, -1822, -2232, 20677, 16146, -1823,
	-2231, 20670, 16152, -1823, -2231, 20666, 16157, -1824, -2230, 20660, 16163, -1825, -2230, 20655, 16168, -1825,
	-2230, 20650, 16174, -1826, -2229, 20644, 16179, -1826, -2229, 20639, 16185, -1827, -2228, 20633, 16190, -1827,
	-2228, 20628, 16196, -1828, -2228, 20623, 16202, -1829, -2227, 20617, 16207, -1829, -2227, 20612, 16213, -1830,
	-2227, 20607, 16218, -1830, -2226, 20601, 16224, -1831, -2226, 20597, 16229, -1832, -2225, 20590, 16235, -1832,
	-2225, 20586, 16240, -1833, -2225, 20580, 16246, -1833, -2224, 20574, 16252, -1834, -2224, 20569, 16257, -1834,
	-2223, 20563, 16263, -1835, -2223, 20559, 16268, -1836, -2223, 20553, 16274, -1836, -2222, 20548, 16279, -1837,
	-2222, 20542, 16285, -1837, -2221, 20537, 16290, -1838, -2221, 20532, 16296, -1839, -2221, 20526, 16302, -1839,
	-2220, 20521, 16307, -1840, -2220, 20515, 16313, -1840, -2220, 20511, 16318, -1841, -2219, 20504, 16324, -1841,
	-2219, 20500, 16329, -1842, -2218, 20494, 16335, -1843, -2218, 20489, 16340, -1843, -2218, 20484, 16346, -1844,
	-2217, 20478, 16351, -1844, -2217, 20473, 16357, -1845, -2216, 20466, 16363, -1845, -2216, 20462, 16368, -1846,
	-2216, 20457, 16374, -1847, -2215, 20451, 16379, -1847, -2215, 20446, 16385, -1848, -2214, 20440, 16390, -1848,
	-2214, 20435, 16396, -1849, -2214, 20431, 16401, -1850, -2213, 20424, 16407, -1850, -2213, 20419, 16413, -1851,
	-2212, 20413, 16418, -1851, -2212, 20408, 16424, -1852, -2212, 20403, 16429, -1852, -2211, 20397, 16435, -1853,
	-2211, 20393, 16440, -1854, -2210, 20386, 16446, -1854, -2210, 20382, 16451, -1855, -2210, 20376, 16457, -1855,
	-2209, 20370, 16463, -1856, -2209, 20365, 16468, -1856, -2208, 20359, 16474, -1857, -2208, 20355, 16479, -1858,
	-2208, 20349, 16485, -1858, -2207, 20344, 16490, -1859, -2207, 20338, 16496, -1859, -2206, 20333, 16501, -1860,
	-2206, 20327, 16507, -1860, -2206, 20322, 16513, -1861, -2205, 20317, 16518, -1862, -2205, 20311, 16524, -1862,
	-2204, 20306, 16529, -1863, -2204, 20300, 16535, -1863, -2204, 20296, 16540, -1864, -2203, 20289, 16546, -1864,
	-2203, 20285, 16551, -1865, -2202, 20279, 16557, -1866, -2202, 20273, 16563, -1866, -2201, 20268, 16568, -1867,
	-2201, 20262, 16574, -1867, -2201, 20258, 16579, -1868, -2200, 20251, 16585, -1868, -2200, 20247, 16590, -1869,
	-2199, 20241, 16596, -1870, -2199, 20236, 16601, -1870, -2199, 20231, 16607, -1871, -2198, 20225, 16612, -1871,
	-2198, 20220, 16618, -1872, -2197, 20213, 16624, -1872, -2197, 20209, 16629, -1873, -2197, 20204, 16635, -1874,
	-2196, 20198, 16640, -1874, -2196, 20193, 16646, -1875, -2195, 20187, 16651, -1875, -2195, 20182, 16657, -1876,
	-2195, 20177, 16662, -1876, -2194, 20171, 16668, -1877, -2194, 20166, 16674, -1878, -2193, 20160, 16679, -1878,
	-2193, 20155, 16685, -1879, -2192, 20149, 16690, -1879, -2192, 20144, 16696, -1880, -2192, 20139, 16701, -1880,
	-2191, 20133, 16707, -1881, -2191, 20129, 16712, -1882, -2190, 20122, 16718, -1882, -2190, 20118, 16723, -1883,
	-2190, 20112, 16729, -1883, -2189, 20106, 16735, -1884, -2189, 20101, 16740, -1884, -2188, 20095, 16746, -1885,
	-2188, 20091, 16751, -1886, -2187, 20084, 16757, -1886, -2187, 20080, 16762, -1887, -2187, 20074, 16768, -1887,
	-2186, 20069, 16773, -1888, -2186, 20063, 16779, -1888, -2185, 20057, 16785, -1889, -2185, 20053, 16790, -1890,
	-2185, 20047, 16796, -1890, -2184, 20042, 16801, -1891, -2184, 20036, 16807, -1891, -2183, 20031, 16812, -1892,
	-2183, 20025, 16818, -1892, -2182, 20020, 16823, -1893, -2182, 20014, 16829, -1893, -2182, 20010, 16834, -1894,
	-2181, 20004, 16840, -1895, -2181, 19998, 16846, -1895, -2180, 19993, 16851, -1896, -2180, 19987, 16857, -1896,
	-2179, 19982, 16862, -1897, -2179, 19976, 16868, -1897, -2179, 19972, 16873, -1898, -2178, 19966, 16879, -1899,
	-2178, 19961, 16884, -1899, -2177, 19955, 16890, -1900, -2177, 19950, 16895, -1900, -2177, 19945, 16901, -1901,
	-2176, 19938, 16907, -1901, -2176, 19934, 16912, -1902, -2175, 19927, 16918, -1902, -2175, 19923, 16923, -1903,
	-2174, 19917, 16929, -1904, -2174, 19912, 16934, -1904, -2174, 19907, 16940, -1905, -2173, 19901, 16945, -1905,
	-2173, 19896, 16951, -1906, -2172, 19890, 16956, -1906, -2172, 19885, 16962, -1907, -2171, 19878, 16968, -1907,
	-2171, 19874, 16973, -1908, -2171, 19869, 16979, -1909, -2170, 19863, 16984, -1909, -2170, 19858, 16990, -1910,
	-2169, 19852, 16995, -1910, -2169, 19847, 17001, -1911, -2168, 19841, 17006, -1911, -2168, 19836, 17012, -1912,
	-2168, 19831, 17018, -1913, -2167, 19825, 17023, -1913, -2167, 19820, 17029, -1914, -2166, 19814, 17034, -1914,
	-2166, 19809, 17040, -1915, -2165, 19803, 17045, -1915, -2165, 19798, 17051, -1916, -2164, 19792, 17056, -1916,
	-2164, 19787, 17062, -1917, -2164, 19783, 17067, -1918, -2163, 19776, 17073, -1918, -2163, 19772, 17078, -1919,
	-2162, 19765, 17084, -1919, -2162, 19760, 17090, -1920, -2161, 19754, 17095, -1920, -2161, 19749, 17101, -1921,
	-2161, 19744, 17106, -1921, -2160, 19738, 17112, -1922, -2160, 19733, 17117, -1922, -2159, 19727, 17123, -1923,
	-2159, 19723, 17128, -1924, -2158, 19716, 17134, -1924, -2158, 19712, 17139, -1925, -2157, 19705, 17145, -1925,
	-2157, 19700, 17151, -1926, -2157, 19695, 17156, -1926, -2156, 19689, 17162, -1927, -2156, 19684, 17167, -1927,
	-2155, 19678, 17173, -1928, -2155, 19674, 17178, -1929, -2154, 19667, 17184, -1929, -2154, 19663, 17189, -1930,
	-2154, 19657, 17195, -1930, -2153, 19652, 17200, -1931, -2153, 19646, 17206, -1931, -2152, 19640, 17212, -1932,
	-2152, 19635, 17217, -1932, -2151, 19629, 17223, -1933, -2151, 19625, 17228, -1934, -2150, 19618, 17234, -1934,
	-2150, 19614, 17239, -1935, -2150, 19608, 17245, -1935, -2149, 19603, 17250, -1936, -2149, 19597, 17256, -1936,
	-2148, 19592, 17261, -1937, -2148, 19586, 17267, -1937, -2147, 19581, 17272, -1938, -2147, 19575, 17278, -1938,
	-2146, 19569, 17284, -1939, -2146, 19565, 17289, -1940, -2146, 19559, 17295, -1940, -2145, 19554, 17300, -1941,
	-2145, 19548, 17306, -1941, -2144, 19543, 17311, -1942, -2144, 19537, 17317, -1942, -2143, 19532, 17322, -1943,
	-2143, 19526, 17328, -1943, -2142, 19521, 17333, -1944, -2142, 19515, 17339, -1944, -2142, 19511, 17344, -1945,
	-2141, 19505, 17350, -1946, -2141, 19499, 17356, -1946, -2140, 19494, 17361, -1947, -2140, 19488, 17367, -1947,
	-2139, 19483, 17372, -1948, -2139, 19477, 17378, -1948, -2138, 19472, 17383, -1949, -2138, 19466, 17389, -1949,
	-2137, 19461, 17394, -1950, -2137, 19455, 17400, -1950, -2137, 19451, 17405, -1951, -2136, 19445, 17411, -1952,
	-2136, 19440, 17416, -1952, -2135, 19434, 17422, -1953, -2135, 19429, 17427, -1953, -2134, 19423, 17433, -1954,
	-2134, 19417, 17439, -1954, -2133, 19412, 17444, -1955, -2133, 19406, 17450, -1955, -2133, 19402, 17455, -1956,
	-2132, 19395, 17461, -1956, -2132, 19391, 17466, -1957, -2131, 19384, 17472, -1957, -2131, 19380, 17477, -1958,
	-2130, 19374, 17483, -1959, -2130, 19369, 17488, -1959, -2129, 19363, 17494, -1960, -2129, 19358, 17499, -1960,
	-2128, 19352, 17505, -1961, -2128, 19346, 17511, -1961, -2127, 19341, 17516, -1962, -2127, 19335, 17522, -1962,
	-2127, 19331, 17527, -1963, -2126, 19324, 17533, -1963, -2126, 19320, 17538, -1964, -2125, 19313, 17544, -1964,
	-2125, 19309, 17549, -1965, -2124, 19303, 17555, -1966, -2124, 19298, 17560, -1966, -2123, 19292, 17566, -1967,
	-2123, 19287, 17571, -1967, -2122, 19281, 17577, -1968, -2122, 19276, 17582, -1968, -2122, 19271, 17588, -1969,
	-2121, 19265, 17593, -1969, -2121, 19260, 17599, -1970, -2120, 19253, 17605, -1970, -2120, 19249, 17610, -1971,
	-2119, 19242, 17616, -1971, -2119, 19238, 17621, -1972, -2118, 19231, 17627, -1972, -2118, 19227, 17632, -1973,
	-2117, 19221, 17638, -1974, -2117, 19216, 17643, -1974, -2116, 19210, 17649, -1975, -2116, 19205, 17654, -1975,
	-2116, 19200, 17660, -1976, -2115, 19194, 17665, -1976, -2115, 19189, 17671, -1977, -2114, 19183, 17676, -1977,
	-2114, 19178, 17682, -1978, -2113, 19172, 17687, -1978, -2113, 19167, 17693, -1979, -2112, 19160, 17699, -1979,
	-2112, 19156, 17704, -1980, -2111, 19149, 17710, -1980, -2111, 19145, 17715, -1981, -2110, 19139, 17721, -1982,
	-2110, 19134, 17726, -1982, -2109, 19128, 17732, -1983, -2109, 19123, 17737, -1983, -2109, 19118, 17743, -1984,
	-2108, 19112, 17748, -1984, -2108, 19107, 17754, -1985, -2107, 19101, 17759, -1985, -2107, 19096, 17765, -1986,
	-2106, 19090, 17770, -1986, -2106, 19085, 17776, -1987, -2105, 19079, 17781, -1987, -2105, 19074, 17787, -1988,
	-2104, 19068, 17792, -1988, -2104, 19063, 17798, -1989, -2103, 19056, 17804, -1989, -2103, 19052, 17809, -1990,
	-2102, 19046, 17815, -1991, -2102, 19041, 17820, -1991, -2101, 19035, 17826, -1992, -2101, 19030, 17831, -1992,
	-2101, 19025, 17837, -1993, -2100, 19019, 17842, -1993, -2100, 19014, 17848, -1994, -2099, 19008, 17853, -1994,
	-2099, 19003, 17859, -1995, -2098, 18997, 17864, -1995, -2098, 18992, 17870, -1996, -2097, 18986, 17875, -1996,
	-2097, 18981, 17881, -1997, -2096, 18975, 17886, -1997, -2096, 18970, 17892, -1998, -2095, 18964, 17897, -1998,
	-2095, 18959, 17903, -1999, -2094, 18953, 17908, -1999, -2094, 18948, 17914, -2000, -2093, 18941, 17920, -2000,
	-2093, 18937, 17925, -2001, -2092, 18931, 17931, -2002, -2092, 18926, 17936, -2002, -2092, 18921, 17942, -2003,
	-2091, 18915, 17947, -2003, -2091, 18910, 17953, -2004, -2090, 18904, 17958, -2004, -2090, 18899, 17964, -2005,
	-2089, 18893, 17969, -2005, -2089, 18888, 17975, -2006, -2088, 18882, 17980, -2006, -2088, 18877, 17986, -2007,
	-2087, 18871, 17991, -2007, -2087, 18866, 17997, -2008, -2086, 18860, 18002, -2008, -2086, 18855, 18008, -2009,
	-2085, 18849, 18013, -2009, -2085, 18844, 18019, -2010, -2084, 18838, 18024, -2010, -2084, 18833, 18030, -2011,
	-2083, 18827, 18035, -2011, -2083, 18822, 18041, -2012, -2082, 18816, 18046, -2012, -2082, 18811, 18052, -2013,
	-2081, 18805, 18057, -2013, -2081, 18800, 18063, -2014, -2080, 18794, 18068, -2014, -2080, 18789, 18074, -2015,
	-2079, 18783, 18080, -2016, -2079, 18778, 18085, -2016, -2079, 18773, 18091, -2017, -2078, 18767, 18096, -2017,
	-2078, 18762, 18102, -2018, -2077, 18756, 18107, -2018, -2077, 18751, 18113, -2019, -2076, 18745, 18118, -2019,
	-2076, 18740, 18124, -2020, -2075, 18734, 18129, -2020, -2075, 18729, 18135, -2021, -2074, 18723, 18140, -2021,
	-2074, 18718, 18146, -2022, -2073, 18712, 18151, -2022, -2073, 18707, 18157, -2023, -2072, 18701, 18162, -2023,
	-2072, 18696, 18168, -2024, -2071, 18690, 18173, -2024, -2071, 18685, 18179, -2025, -2070, 18679, 18184, -2025,
	-2070, 18674, 18190, -2026, -2069, 18668, 18195, -2026, -2069, 18663, 18201, -2027, -2068, 18657, 18206, -2027,
	-2068, 18652, 18212, -2028, -2067, 18646, 18217, -2028, -2067, 18641, 18223, -2029, -2066, 18635, 18228, -2029,
	-2066, 18630, 18234, -2030, -2065, 18624, 18239, -2030, -2065, 18619, 18245, -2031, -2064, 18613, 18250, -2031,
	-2064, 18608, 18256, -2032, -2063, 18602, 18261, -2032, -2063, 18597, 18267, -2033, -2062, 18591, 18272, -2033,
	-2062, 18586, 18278, -2034, -2061, 18580, 18283, -2034, -2061, 18575, 18289, -2035, -2060, 18569, 18294, -2035,
	-2060, 18564, 18300, -2036, -2059, 18558, 18305, -2036, -2059, 18553, 18311, -2037, -2058, 18547, 18316, -2037,
	-2058, 18542, 18322, -2038, -2057, 18536, 18327, -2038, -2057, 18531, 18333, -2039, -2056, 18525, 18338, -2039,
	-2056, 18520, 18344, -2040, -2055, 18514, 18349, -2040, -2055, 18509, 18355, -2041, -2054, 18503, 18360, -2041,
	-2054, 18498, 18366, -2042, -2053, 18492, 18371, -2042, -2053, 18487, 18377, -2043, -2052, 18481, 18382, -2043,
	-2052, 18476, 18388, -2044, -2051, 18470, 18393, -2044, -2051, 18465, 18399, -2045, -2050, 18459, 18404, -2045,
	-2050, 18454, 18410, -2046, -2049, 18448, 18415, -2046, -2049, 18443, 18421, -2047, -2048, 18437, 18426, -2047,
	-2048, 18432, 18432, -2048, -2047, 18426, 18437, -2048, -2047, 18421, 18443, -2049, -2046, 18415, 18448, -2049,
	-2046, 18410, 18454, -2050, -2045, 18404, 18459, -2050, -2045, 18399, 18465, -2051, -2044, 18393, 18470, -2051,
	-2044, 18388, 18476, -2052, -2043, 18382, 18481, -2052, -2043, 18377, 18487, -2053, -2042, 18371, 18492, -2053,
	-2042, 18366, 18498, -2054, -2041, 18360, 18503, -2054, -2041, 18355, 18509, -2055, -2040, 18349, 18514, -2055,
	-2040, 18344, 18520, -2056, -2039, 18338, 18525, -2056, -2039, 18333, 18531, -2057, -2038, 18327, 18536, -2057,
	-2038, 18322, 18542, -2058, -2037, 18316, 18547, -2058, -2037, 18311, 18553, -2059, -2036, 18305, 18558, -2059,
	-2036, 18300, 18564, -2060, -2035, 18294, 18569, -2060, -2035, 18289, 18575, -2061, -2034, 18283, 18580, -2061,
	-2034, 18278, 18586, -2062, -2033, 18272, 18591, -2062, -2033, 18267, 18597, -2063, -2032, 18261, 18602, -2063,
	-2032, 18256, 18608, -2064, -2031, 18250, 18613, -2064, -2031, 18245, 18619, -2065, -2030, 18239, 18624, -2065,
	-2030, 18234, 18630, -2066, -2029, 18228, 18635, -2066, -2029, 18223, 18641, -2067, -2028, 18217, 18646, -2067,
	-2028, 18212, 18652, -2068, -2027, 18206, 18657, -2068, -2027, 18201, 18663, -2069, -2026, 18195, 18668, -2069,
	-2026, 18190, 18674, -2070, -2025, 18184, 18679, -2070, -2025, 18179, 18685, -2071, -2024, 18173, 18690, -2071,
	-2024, 18168, 18696, -2072, -2023, 18162, 18701, -2072, -2023, 18157, 18707, -2073, -2022, 18151, 18712, -2073,
	-2022, 18146, 18718, -2074, -2021, 18140, 18723, -2074, -2021, 18135, 18729, -2075, -2020, 18129, 18734, -2075,
	-2020, 18124, 18740, -2076, -2019, 18118, 18745, -2076, -2019, 18113, 18751, -2077, -2018, 18107, 18756, -2077,
	-2018, 18102, 18762, -2078, -2017, 18096, 18767, -2078, -2017, 18091, 18773, -2079, -2016, 18085, 18778, -2079,
	-2016, 18080, 18783, -2079, -2015, 18074, 18789, -2080, -2014, 18068, 18794, -2080, -2014, 18063, 18800, -2081,
	-2013, 18057, 18805, -2081, -2013, 18052, 18811, -2082, -2012, 18046, 18816, -2082, -2012, 18041, 18822, -2083,
	-2011, 18035, 18827, -2083, -2011, 18030, 18833, -2084, -2010, 18024, 18838, -2084, -2010, 18019, 18844, -2085,
	-2009, 18013, 18849, -2085, -2009, 18008, 18855, -2086, -2008, 18002, 18860, -2086, -2008, 17997, 18866, -2087,
	-2007, 17991, 18871, -2087, -2007, 17986, 18877, -2088, -2006, 17980, 18882, -2088, -2006, 17975, 18888, -2089,
	-2005, 17969, 18893, -2089, -2005, 17964, 18899, -2090, -2004, 17958, 18904, -2090, -2004, 17953, 18910, -2091,
	-2003, 17947, 18915, -2091, -2003, 17942, 18921, -2092, -2002, 17936, 18926, -2092, -2002, 17931, 18931, -2092,
	-2001, 17925, 18937, -2093, -2000, 17920, 18941, -2093, -2000, 17914, 18948, -2094, -1999, 17908, 18953, -2094,
	-1999, 17903, 18959, -2095, -1998, 17897, 18964, -2095, -1998, 17892, 18970, -2096, -1997, 17886, 18975, -2096,
	-1997, 17881, 18981, -2097, -1996, 17875, 18986, -2097, -1996, 17870, 18992, -2098, -1995, 17864, 18997, -2098,
	-1995, 17859, 19003, -2099, -1994, 17853, 19008, -2099, -1994, 17848, 19014, -2100, -1993, 17842, 19019, -2100,
	-1993, 17837, 19025, -2101, -1992, 17831, 19030, -2101, -1992, 17826, 19035, -2101, -1991, 17820, 19041, -2102,
	-1991, 17815, 19046, -2102, -1990, 17809, 19052, -2103, -1989, 17804, 19056, -2103, -1989, 17798, 19063, -2104,
	-1988, 17792, 19068, -2104, -1988, 17787, 19074, -2105, -1987, 17781, 19079, -2105, -1987, 17776, 19085, -2106,
	-1986, 17770, 19090, -2106, -1986, 17765, 19096, -2107, -1985, 17759, 19101, -2107, -1985, 17754, 19107, -2108,
	-1984, 17748, 19112, -2108, -1984, 17743, 19118, -2109, -1983, 17737, 19123, -2109, -1983, 17732, 19128, -2109,
	-1982, 17726, 19134, -2110, -1982, 17721, 19139, -2110, -1981, 17715, 19145, -2111, -1980, 17710, 19149, -2111,
	-1980, 17704, 19156, -2112, -1979, 17699, 19160, -2112, -1979, 17693, 19167, -2113, -1978, 17687, 19172, -2113,
	-1978, 17682, 19178, -2114, -1977, 17676, 19183, -2114, -1977, 17671, 19189, -2115, -1976, 17665, 19194, -2115,
	-1976, 17660, 19200, -2116, -1975, 17654, 19205, -2116, -1975, 17649, 19210, -2116, -1974, 17643, 19216, -2117,
	-1974, 17638, 19221, -2117, -1973, 17632, 19227, -2118, -1972, 17627, 19231, -2118, -1972, 17621, 19238, -2119,
	-1971, 17616, 19242, -2119, -1971, 17610, 19249, -2120, -1970, 17605, 19253, -2120, -1970, 17599, 19260, -2121,
	-1969, 17593, 19265, -2121, -1969, 17588, 19271, -2122, -1968, 17582, 19276, -2122, -1968, 17577, 19281, -2122,
	-1967, 17571, 19287, -2123, -1967, 17566, 19292, -2123, -1966, 17560, 19298, -2124, -1966, 17555, 19303, -2124,
	-1965, 17549, 19309, -2125, -1964, 17544, 19313, -2125, -1964, 17538, 19320, -2126, -1963, 17533, 19324, -2126,
	-1963, 17527, 19331, -2127, -1962, 17522, 19335, -2127, -1962, 17516, 19341, -2127, -1961, 17511, 19346, -2128,
	-1961, 17505, 19352, -2128, -1960, 17499, 19358, -2129, -1960, 17494, 19363, -2129, -1959, 17488, 19369, -2130,
	-1959, 17483, 19374, -2130, -1958, 17477, 19380, -2131, -1957, 17472, 19384, -2131, -1957, 17466, 19391, -2132,
	-1956, 17461, 19395, -2132, -1956, 17455, 19402, -2133, -1955, 17450, 19406, -2133, -1955, 17444, 19412, -2133,
	-1954, 17439, 19417, -2134, -1954, 17433, 19423, -2134, -1953, 17427, 19429, -2135, -1953, 17422, 19434, -2135,
	-1952, 17416, 19440, -2136, -1952, 17411, 19445, -2136, -1951, 17405, 19451, -2137, -1950, 17400, 19455, -2137,
	-1950, 17394, 19461, -2137, -1949, 17389, 19466, -2138, -1949, 17383, 19472, -2138, -1948, 17378, 19477, -2139,
	-1948, 17372, 19483, -2139, -1947, 17367, 19488, -2140, -1947, 17361, 19494, -2140, -1946, 17356, 19499, -2141,
	-1946, 17350, 19505, -2141, -1945, 17344, 19511, -2142, -1944, 17339, 19515, -2142, -1944, 17333, 19521, -2142,
	-1943, 17328, 19526, -2143, -1943, 17322, 19532, -2143, -1942, 17317, 19537, -2144, -1942, 17311, 19543, -2144,
	-1941, 17306, 19548, -2145, -1941, 17300, 19554, -2145, -1940, 17295, 19559, -2146, -1940, 17289, 19565, -2146,
	-1939, 17284, 19569, -2146, -1938, 17278, 19575, -2147, -1938, 17272, 19581, -2147, -1937, 17267, 19586, -2148,
	-1937, 17261, 19592, -2148, -1936, 17256, 19597, -2149, -1936, 17250, 19603, -2149, -1935, 17245, 19608, -2150,
	-1935, 17239, 19614, -2150, -1934, 17234, 19618, -2150, -1934, 17228, 19625, -2151, -1933, 17223, 19629, -2151,
	-1932, 17217, 19635, -2152, -1932, 17212, 19640, -2152, -1931, 17206, 19646, -2153, -1931, 17200, 19652, -2153,
	-1930, 17195, 19657, -2154, -1930, 17189, 19663, -2154, -1929, 17184, 19667, -2154, -1929, 17178, 19674, -2155,
	-1928, 17173, 19678, -2155, -1927, 17167, 19684, -2156, -1927, 17162, 19689, -2156, -1926, 17156, 19695, -2157,
	-1926, 17151, 19700, -2157, -1925, 17145, 19705, -2157, -1925, 17139, 19712, -2158, -1924, 17134, 19716, -2158,
	-1924, 17128, 19723, -2159, -1923, 17123, 19727, -2159, -1922, 17117, 19733, -2160, -1922, 17112, 19738, -2160,
	-1921, 17106, 19744, -2161, -1921, 17101, 19749, -2161, -1920, 17095, 19754, -2161, -1920, 17090, 19760, -2162,
	-1919, 17084, 19765, -2162, -1919, 17078, 19772, -2163, -1918, 17073, 19776, -2163, -1918, 17067, 19783, -2164,
	-1917, 17062, 19787, -2164, -1916, 17056, 19792, -2164, -1916, 17051, 19798, -2165, -1915, 17045, 19803, -2165,
	-1915, 17040, 19809, -2166, -1914, 17034, 19814, -2166, -1914, 17029, 19820, -2167, -1913, 17023, 19825, -2167,
	-1913, 17018, 19831, -2168, -1912, 17012, 19836, -2168, -1911, 17006, 19841, -2168, -1911, 17001, 19847, -2169,
	-1910, 16995, 19852, -2169, -1910, 16990, 19858, -2170, -1909, 16984, 19863, -2170, -1909, 16979, 19869, -2171,
	-1908, 16973, 19874, -2171, -1907, 16968, 19878, -2171, -1907, 16962, 19885, -2172, -1906, 16956, 19890, -2172,
	-1906, 16951, 19896, -2173, -1905, 16945, 19901, -2173, -1905, 16940, 19907, -2174, -1904, 16934, 19912, -2174,
	-1904, 16929, 19917, -2174, -1903, 16923, 19923, -2175, -1902, 16918, 19927, -2175, -1902, 16912, 19934, -2176,
	-1901, 16907, 19938, -2176, -1901, 16901, 19945, -2177, -1900, 16895, 19950, -2177, -1900, 16890, 19955, -2177,
	-1899, 16884, 19961, -2178, -1899, 16879, 19966, -2178, -1898, 16873, 19972, -2179, -1897, 16868, 19976, -2179,
	-1897, 16862, 19982, -2179, -1896, 16857, 19987, -2180, -1896, 16851, 19993, -2180, -1895, 16846, 19998, -2181,
	-1895, 16840, 20004, -2181, -1894, 16834, 20010, -2182, -1893, 16829, 20014, -2182, -1893, 16823, 20020, -2182,
	-1892, 16818, 20025, -2183, -1892, 16812, 20031, -2183, -1891, 16807, 20036, -2184, -1891, 16801, 20042, -2184,
	-1890, 16796, 20047, -2185, -1890, 16790, 20053, -2185, -1889, 16785, 20057, -2185, -1888, 16779, 20063, -2186,
	-1888, 16773, 20069, -2186, -1887, 16768, 20074, -2187, -1887, 16762, 20080, -2187, -1886, 16757, 20084, -2187,
	-1886, 16751, 20091, -2188, -1885, 16746, 20095, -2188, -1884, 16740, 20101, -2189, -1884, 16735, 20106, -2189,
	-1883, 16729, 20112, -2190, -1883, 16723, 20118, -2190, -1882, 16718, 20122, -2190, -1882, 16712, 20129, -2191,
	-1881, 16707, 20133, -2191, -1880, 16701, 20139, -2192, -1880, 16696, 20144, -2192, -1879, 16690, 20149, -2192,
	-1879, 16685, 20155, -2193, -1878, 16679, 20160, -2193, -1878, 16674, 20166, -2194, -1877, 16668, 20171, -2194,
	-1876, 16662, 20177, -2195, -1876, 16657, 20182, -2195, -1875, 16651, 20187, -2195, -1875, 16646, 20193, -2196,
	-1874, 16640, 20198, -2196, -1874, 16635, 20204, -2197, -1873, 16629, 20209, -2197, -1872, 16624, 20213, -2197,
	-1872, 16618, 20220, -2198, -1871, 16612, 20225, -2198, -1871, 16607, 20231, -2199, -1870, 16601, 20236, -2199,
	-1870, 16596, 20241, -2199, -1869, 16590, 20247, -2200, -1868, 16585, 20251, -2200, -1868, 16579, 20258, -2201,
	-1867, 16574, 20262, -2201, -1867, 16568, 20268, -2201, -1866, 16563, 20273, -2202, -1866, 16557, 20279, -2202,
	-1865, 16551, 20285, -2203, -1864, 16546, 20289, -2203, -1864, 16540, 20296, -2204, -1863, 16535, 20300, -2204,
	-1863, 16529, 20306, -2204, -1862, 16524, 20311, -2205, -1862, 16518, 20317, -2205, -1861, 16513, 20322, -2206,
	-1860, 16507, 20327, -2206, -1860, 16501, 20333, -2206, -1859, 16496, 20338, -2207, -1859, 16490, 20344, -2207,
	-1858, 16485, 20349, -2208, -1858, 16479, 20355, -2208, -1857, 16474, 20359, -2208, -1856, 16468, 20365, -2209,
	-1856, 16463, 20370, -2209, -1855, 16457, 20376, -2210, -1855, 16451, 20382, -2210, -1854, 16446, 20386, -2210,
	-1854, 16440, 20393, -2211, -1853, 16435, 20397, -2211, -1852, 16429, 20403, -2212, -1852, 16424, 20408, -2212,
	-1851, 16418, 20413, -2212, -1851, 16413, 20419, -2213, -1850, 16407, 20424, -2213, -1850, 16401, 20431, -2214,
	-1849, 16396, 20435, -2214, -1848, 16390, 20440, -2214, -1848, 16385, 20446, -2215, -1847, 16379, 20451, -2215,
	-1847, 16374, 20457, -2216, -1846, 16368, 20462, -2216, -1845, 16363, 20466, -2216, -1845, 16357, 20473, -2217,
	-1844, 16351, 20478, -2217, -1844, 16346, 20484, -2218, -1843, 16340, 20489, -2218, -1843, 16335, 20494, -2218,
	-1842, 16329, 20500, -2219, -1841, 16324, 20504, -2219, -1841, 16318, 20511, -2220, -1840, 16313, 20515, -2220,
	-1840, 16307, 20521, -2220, -1839, 16302, 20526, -2221, -1839, 16296, 20532, -2221, -1838, 16290, 20537, -2221,
	-1837, 16285, 20542, -2222, -1837, 16279, 20548, -2222, -1836, 16274, 20553, -2223, -1836, 16268, 20559, -2223,
	-1835, 16263, 20563, -2223, -1834, 16257, 20569, -2224, -1834, 16252, 20574, -2224, -1833, 16246, 20580, -2225,
	-1833, 16240, 20586, -2225, -1832, 16235, 20590, -2225, -1832, 16229, 20597, -2226, -1831, 16224, 20601, -2226,
	-1830, 16218, 20607, -2227, -1830, 16213, 20612, -2227, -1829, 16207, 20617, -2227, -1829, 16202, 20623, -2228,
	-1828, 16196, 20628, -2228, -1827, 16190, 20633, -2228, -1827, 16185, 20639, -2229, -1826, 16179, 20644, -2229,
	-1826, 16174, 20650, -2230, -1825, 16168, 20655, -2230, -1825, 16163, 20660, -2230, -1824, 16157, 20666, -2231,
	-1823, 16152, 20670, -2231, -1823, 16146, 20677, -2232, -1822, 16140, 20682, -2232, -1822, 16135, 20687, -2232,
	-1821, 16129, 20693, -2233, -1820, 16124, 20697, -2233, -1820, 16118, 20703, -2233, -1819, 16113, 20708, -2234,
	-1819, 16107, 20714, -2234, -1818, 16102, 20719, -2235, -1818, 16096, 20725, -2235, -1817, 16090, 20730, -2235,
	-1816, 16085, 20735, -2236, -1816, 16079, 20741, -2236, -1815, 16074, 20746, -2237, -1815, 16068, 20752, -2237,
	-1814, 16063, 20756, -2237, -1813, 16057, 20762, -2238, -1813, 16052, 20767, -2238, -1812, 16046, 20772, -2238,
	-1812, 16040, 20779, -2239, -1811, 16035, 20783, -2239, -1810, 16029, 20789, -2240, -1810, 16024, 20794, -2240,
	-1809, 16018, 20799, -2240, -1809, 16013, 20805, -2241, -1808, 16007, 20810, -2241, -1807, 16002, 20814, -2241,
	-1807, 15996, 20821, -2242, -1806, 15990, 20826, -2242, -1806, 15985, 20832, -2243, -1805, 15979, 20837, -2243,
	-1805, 15974, 20842, -2243, -1804, 15968, 20848, -2244, -1803, 15963, 20852, -2244, -1803, 15957, 20858, -2244,
	-1802, 15952, 20863, -2245, -1802, 15946, 20869, -2245, -1801, 15940, 20875, -2246, -1800, 15935, 20879, -2246,
	-1800, 15929, 20885, -2246, -1799, 15924, 20890, -2247, -1799, 15918, 20896, -2247, -1798, 15913, 20900, -2247,
	-1797, 15907, 20906, -2248, -1797, 15902, 20911, -2248, -1796, 15896, 20917, -2249, -1796, 15890, 20923, -2249,
	-1795, 15885, 20927, -2249, -1794, 15879, 20933, -2250, -1794, 15874, 20938, -2250, -1793, 15868, 20943, -2250,
	-1793, 15863, 20949, -2251, -1792, 15857, 20954, -2251, -1792, 15852, 20959, -2251, -1791, 15846, 20965, -2252,
	-1790, 15840, 20970, -2252, -1790, 15835, 20976, -2253, -1789, 15829, 20981, -2253, -1789, 15824, 20986, -2253,
	-1788, 15818, 20992, -2254, -1787, 15813, 20996, -2254, -1787, 15807, 21002, -2254, -1786, 15802, 21007, -2255,
	-1786, 15796, 21013, -2255, -1785, 15790, 21018, -2255, -1784, 15785, 21023, -2256, -1784, 15779, 21029, -2256,
	-1783, 15774, 21034, -2257, -1783, 15768, 21040, -2257, -1782, 15763, 21044, -2257, -1781, 15757, 21050, -2258,
	-1781, 15752, 21055, -2258, -1780, 15746, 21060, -2258, -1780, 15740, 21067, -2259, -1779, 15735, 21071, -2259,
	-1778, 15729, 21076, -2259, -1778, 15724, 21082, -2260, -1777, 15718, 21087, -2260, -1777, 15713, 21093, -2261,
	-1776, 15707, 21098, -2261, -1775, 15702, 21102, -2261, -1775, 15696, 21109, -2262, -1774, 15690, 21114, -2262,
	-1774, 15685, 21119, -2262, -1773, 15679, 21125, -2263, -1772, 15674, 21129, -2263, -1772, 15668, 21135, -2263,
	-1771, 15663, 21140, -2264, -1771, 15657, 21146, -2264, -1770, 15652, 21150, -2264, -1769, 15646, 21156, -2265,
	-1769, 15640, 21162, -2265, -1768, 15635, 21167, -2266, -1768, 15629, 21173, -2266, -1767, 15624, 21177, -2266,
	-1766, 15618, 21183, -2267, -1766, 15613, 21188, -2267, -1765, 15607, 21193, -2267, -1765, 15602, 21199, -2268,
	-1764, 15596, 21204, -2268, -1763, 15590, 21209, -2268, -1763, 15585, 21215, -2269, -1762, 15579, 21220, -2269,
	-1762, 15574, 21225, -2269, -1761, 15568, 21231, -2270, -1760, 15563, 21235, -2270, -1760, 15557, 21241, -2270,
	-1759, 15552, 21246, -2271, -1759, 15546, 21252, -2271, -1758, 15540, 21257, -2271, -1757, 15535, 21262, -2272,
	-1757, 15529, 21268, -2272, -1756, 15524, 21273, -2273, -1756, 15518, 21279, -2273, -1755, 15513, 21283, -2273,
	-1754, 15507, 21289, -2274, -1754, 15502, 21294, -2274, -1753, 15496, 21299, -2274, -1753, 15490, 21306, -2275,
	-1752, 15485, 21310, -2275, -1751, 15479, 21315, -2275, -1751, 15474, 21321, -2276, -1750, 15468, 21326, -2276,
	-1750, 15463, 21331, -2276, -1749, 15457, 21337, -2277, -1748, 15452, 21341, -2277, -1748, 15446, 21347, -2277,
	-1747, 15440, 21353, -2278, -1746, 15435, 21357, -2278, -1746, 15429, 21363, -2278, -1745, 15424, 21368, -2279,
	-1745, 15418, 21374, -2279, -1744, 15413, 21378, -2279, -1743, 15407, 21384, -2280, -1743, 15402, 21389, -2280,
	-1742, 15396, 21394, -2280, -1742, 15391, 21400, -2281, -1741, 15385, 21405, -2281, -1740, 15379, 21410, -2281,
	-1740, 15374, 21416, -2282, -1739, 15368, 21421, -2282, -1739, 15363, 21426, -2282, -1738, 15357, 21432, -2283,
	-1737, 15352, 21436, -2283, -1737, 15346, 21442, -2283, -1736, 15341, 21447, -2284, -1736, 15335, 21453, -2284,
	-1735, 15329, 21458, -2284, -1734, 15324, 21463, -2285, -1734, 15318, 21469, -2285, -1733, 15313, 21473, -2285,
	-1733, 15307, 21480, -2286, -1732, 15302, 21484, -2286, -1731, 15296, 21489, -2286, -1731, 15291, 21495, -2287,
	-1730, 15285, 21500, -2287, -1729, 15279, 21505, -2287, -1729, 15274, 21511, -2288, -1728, 15268, 21516, -2288,
	-1728, 15263, 21521, -2288, -1727, 15257, 21527, -2289, -1726, 15252, 21531, -2289, -1726, 15246, 21537, -2289,
	-1725, 15241, 21542, -2290, -1725, 15235, 21548, -2290, -1724, 15229, 21553, -2290, -1723, 15224, 21558, -2291,
	-1723, 15218, 21564, -2291, -1722, 15213, 21568, -2291, -1722, 15207, 21575, -2292, -1721, 15202, 21579, -2292,
	-1720, 15196, 21584, -2292, -1720, 15191, 21590, -2293, -1719, 15185, 21595, -2293, -1718, 15180, 21599, -2293,
	-1718, 15174, 21606, -2294, -1717, 15168, 21611, -2294, -1717, 15163, 21616, -2294, -1716, 15157, 21622, -2295,
	-1715, 15152, 21626, -2295, -1715, 15146, 21632, -2295, -1714, 15141, 21637, -2296, -1714, 15135, 21643, -2296,
	-1713, 15130, 21647, -2296, -1712, 15124, 21653, -2297, -1712, 15118, 21659, -2297, -1711, 15113, 21663, -2297,
	-1710, 15107, 21669, -2298, -1710, 15102, 21674, -2298, -1709, 15096, 21679, -2298, -1709, 15091, 21685, -2299,
	-1708, 15085, 21690, -2299, -1707, 15080, 21694, -2299, -1707, 15074, 21701, -2300, -1706, 15069, 21705, -2300,
	-1706, 15063, 21711, -2300, -1705, 15057, 21716, -2300, -1704, 15052, 21721, -2301, -1704, 15046, 21727, -2301,
	-1703, 15041, 21731, -2301, -1702, 15035, 21737, -2302, -1702, 15030, 21742, -2302, -1701, 15024, 21747, -2302,
	-1701, 15019, 21753, -2303, -1700, 15013, 21758, -2303, -1699, 15007, 21763, -2303, -1699, 15002, 21769, -2304,
	-1698, 14996, 21774, -2304, -1698, 14991, 21779, -2304, -1697, 14985, 21785, -2305, -1696, 14980, 21789, -2305,
	-1696, 14974, 21795, -2305, -1695, 14969, 21800, -2306, -1694, 14963, 21805, -2306, -1694, 14958, 21810, -2306,
	-1693, 14952, 21815, -2306, -1693, 14946, 21822, -2307, -1692, 14941, 21826, -2307, -1691, 14935, 21831, -2307,
	-1691, 14930, 21837, -2308, -1690, 14924, 21842, -2308, -1690, 14919, 21847, -2308, -1689, 14913, 21853, -2309,
	-1688, 14908, 21857, -2309, -1688, 14902, 21863, -2309, -1687, 14897, 21868, -2310, -1686, 14891, 21873, -2310,
	-1686, 14885, 21879, -2310, -1685, 14880, 21883, -2310, -1685, 14874, 21890, -2311, -1684, 14869, 21894, -2311,
	-1683, 14863, 21899, -2311, -1683, 14858, 21905, -2312, -1682, 14852, 21910, -2312, -1681, 14847, 21914, -2312,
	-1681, 14841, 21921, -2313, -1680, 14836, 21925, -2313, -1680, 14830, 21931, -2313, -1679, 14824, 21937, -2314,
	-1678, 14819, 21941, -2314, -1678, 14813, 21947, -2314, -1677, 14808, 21951, -2314, -1677, 14802, 21958, -2315,
	-1676, 14797, 21962, -2315, -1675, 14791, 21967, -2315, -1675, 14786, 21973, -2316, -1674, 14780, 21978, -2316,
	-1673, 14775, 21982, -2316, -1673, 14769, 21989, -2317, -1672, 14763, 21994, -2317, -1672, 14758, 21999, -2317,
	-1671, 14752, 22004, -2317, -1670, 14747, 22009, -2318, -1670, 14741, 22015, -2318, -1669, 14736, 22019, -2318,
	-1668, 14730, 22025, -2319, -1668, 14725, 22030, -2319, -1667, 14719, 22035, -2319, -1667, 14714, 22041, -2320,
	-1666, 14708, 22046, -2320, -1665, 14702, 22051, -2320, -1665, 14697, 22056, -2320, -1664, 14691, 22062, -2321,
	-1663, 14686, 22066, -2321, -1663, 14680, 22072, -2321, -1662, 14675, 22077, -2322, -1662, 14669, 22083, -2322,
	-1661, 14664, 22087, -2322, -1660, 14658, 22092, -2322, -1660, 14653, 22098, -2323, -1659, 14647, 22103, -2323,
	-1658, 14642, 22107, -2323, -1658, 14636, 22114, -2324, -1657, 14630, 22119, -2324, -1657, 14625, 22124, -2324,
	-1656, 14619, 22130, -2325, -1655, 14614, 22134, -2325, -1655, 14608, 22140, -2325, -1654, 14603, 22144, -2325,
	-1653, 14597, 22150, -2326, -1653, 14592, 22155, -2326, -1652, 14586, 22160, -2326, -1652, 14581, 22166, -2327,
	-1651, 14575, 22171, -2327, -1650, 14569, 22176, -2327, -1650, 14564, 22181, -2327, -1649, 14558, 22187, -2328,
	-1648, 14553, 22191, -2328, -1648, 14547, 22197, -2328, -1647, 14542, 22202, -2329, -1647, 14536, 22208, -2329,
	-1646, 14531, 22212, -2329, -1645, 14525, 22217, -2329, -1645, 14520, 22223, -2330, -1644, 14514, 22228, -2330,
	-1643, 14509, 22232, -2330, -1643, 14503, 22239, -2331, -1642, 14497, 22244, -2331, -1642, 14492, 22249, -2331,
	-1641, 14486, 22254, -2331, -1640, 14481, 22259, -2332, -1640, 14475, 22265, -2332, -1639, 14470, 22269, -2332,
	-1638, 14464, 22274, -2332, -1638, 14459, 22280, -2333, -1637, 14453, 22285, -2333, -1636, 14448, 22289, -2333,
	-1636, 14442, 22296, -2334, -1635, 14437, 22300, -2334, -1635, 14431, 22306, -2334, -1634, 14425, 22311, -2334,
	-1633, 14420, 22316, -2335, -1633, 14414, 22322, -2335, -1632, 14409, 22326, -2335, -1631, 14403, 22332, -2336,
	-1631, 14398, 22337, -2336, -1630, 14392, 22342, -2336, -1630, 14387, 22347, -2336, -1629, 14381, 22353, -2337,
	-1628, 14376, 22357, -2337, -1628, 14370, 22363, -2337, -1627, 14365, 22367, -2337, -1626, 14359, 22373, -2338,
	-1626, 14354, 22378, -2338, -1625, 14348, 22383, -2338, -1624, 14342, 22389, -2339, -1624, 14337, 22394, -2339,
	-1623, 14331, 22399, -2339, -1623, 14326, 22404, -2339, -1622, 14320, 22410, -2340, -1621, 14315, 22414, -2340,
	-1621, 14309, 22420, -2340, -1620, 14304, 22424, -2340, -1619, 14298, 22430, -2341, -1619, 14293, 22435, -2341,
	-1618, 14287, 22440, -2341, -1618, 14282, 22445, -2341, -1617, 14276, 22451, -2342, -1616, 14271, 22455, -2342,
	-1616, 14265, 22461, -2342, -1615, 14259, 22467, -2343, -1614, 14254, 22471, -2343, -1614, 14248, 22477, -2343,
	-1613, 14243, 22481, -2343, -1612, 14237, 22487, -2344, -1612, 14232, 22492, -2344, -1611, 14226, 22497, -2344,
	-1611, 14221, 22502, -2344, -1610, 14215, 22508, -2345, -1609, 14210, 22512, -2345, -1609, 14204, 22518, -2345,
	-1608, 14199, 22522, -2345, -1607, 14193, 22528, -2346, -1607, 14188, 22533, -2346, -1606, 14182, 22538, -2346,
	-1606, 14177, 22544, -2347, -1605, 14171, 22549, -2347, -1604, 14165, 22554, -2347, -1604, 14160, 22559, -2347,
	-1603, 14154, 22565, -2348, -1602, 14149, 22569, -2348, -1602, 14143, 22575, -2348, -1601, 14138, 22579, -2348,
	-1600, 14132, 22585, -2349, -1600, 14127, 22590, -2349, -1599, 14121, 22595, -2349, -1599, 14116, 22600, -2349,
	-1598, 14110, 22606, -2350, -1597, 14105, 22610, -2350, -1597, 14099, 22616, -2350, -1596, 14094, 22620, -2350,
	-1595, 14088, 22626, -2351, -1595, 14083, 22631, -2351, -1594, 14077, 22636, -2351, -1593, 14071, 22641, -2351,
	-1593, 14066, 22647, -2352, -1592, 14060, 22652, -2352, -1592, 14055, 22657, -2352, -1591, 14049, 22662, -2352,
	-1590, 14044, 22667, -2353, -1590, 14038, 22673, -2353, -1589, 14033, 22677, -2353, -1588, 14027, 22682, -2353,
	-1588, 14022, 22688, -2354, -1587, 14016, 22693, -2354, -1586, 14011, 22697, -2354, -1586, 14005, 22703, -2354,
	-1585, 14000, 22708, -2355, -1584, 13994, 22713, -2355, -1584, 13989, 22718, -2355, -1583, 13983, 22723, -2355,
	-1583, 13978, 22729, -2356, -1582, 13972, 22734, -2356, -1581, 13967, 22738, -2356, -1581, 13961, 22744, -2356,
	-1580, 13955, 22750, -2357, -1579, 13950, 22754, -2357, -1579, 13944, 22760, -2357, -1578, 13939, 22764, -2357,
	-1577, 13933, 22770, -2358, -1577, 13928, 22775, -2358, -1576, 13922, 22780, -2358, -1576, 13917, 22785, -2358,
	-1575, 13911, 22791, -2359, -1574, 13906, 22795, -2359, -1574, 13900, 22801, -2359, -1573, 13895, 22805, -2359,
	-1572, 13889, 22810, -2359, -1572, 13884, 22816, -2360, -1571, 13878, 22821, -2360, -1570, 13873, 22825, -2360,
	-1570, 13867, 22831, -2360, -1569, 13862, 22836, -2361, -1569, 13856, 22842, -2361, -1568, 13851, 22846, -2361,
	-1567, 13845, 22851, -2361, -1567, 13840, 22857, -2362, -1566, 13834, 22862, -2362, -1565, 13829, 22866, -2362,
	-1565, 13823, 22872, -2362, -1564, 13817, 22878, -2363, -1563, 13812, 22882, -2363, -1563, 13806, 22888, -2363,
	-1562, 13801, 22892, -2363, -1561, 13795, 22898, -2364, -1561, 13790, 22903, -2364, -1560, 13784, 22908, -2364,
	-1560, 13779, 22913, -2364, -1559, 13773, 22918, -2364, -1558, 13768, 22923, -2365, -1558, 13762, 22929, -2365,
	-1557, 13757, 22933, -2365, -1556, 13751, 22938, -2365, -1556, 13746, 22944, -2366, -1555, 13740, 22949, -2366,
	-1554, 13735, 22953, -2366, -1554, 13729, 22959, -2366, -1553, 13724, 22964, -2367, -1552, 13718, 22969, -2367,
	-1552, 13713, 22974, -2367, -1551, 13707, 22979, -2367, -1551, 13702, 22984, -2367, -1550, 13696, 22990, -2368,
	-1549, 13691, 22994, -2368, -1549, 13685, 23000, -2368, -1548, 13680, 23004, -2368, -1547, 13674, 23010, -2369,
	-1547, 13669, 23015, -2369, -1546, 13663, 23020, -2369, -1545, 13658, 23024, -2369, -1545, 13652, 23030, -2369,
	-1544, 13647, 23035, -2370, -1543, 13641, 23040, -2370, -1543, 13636, 23045, -2370, -1542, 13630, 23050, -2370,
	-1542, 13624, 23057, -2371, -1541, 13619, 23061, -2371, -1540, 13613, 23066, -2371, -1540, 13608, 23071, -2371,
	-1539, 13602, 23076, -2371, -1538, 13597, 23081, -2372, -1538, 13591, 23087, -2372, -1537, 13586, 23091, -2372,
	-1536, 13580, 23096, -2372, -1536, 13575, 23102, -2373, -1535, 13569, 23107, -2373, -1534, 13564, 23111, -2373,
	-1534, 13558, 23117, -2373, -1533, 13553, 23121, -2373, -1532, 13547, 23127, -2374, -1532, 13542, 23132, -2374,
	-1531, 13536, 23137, -2374, -1531, 13531, 23142, -2374, -1530, 13525, 23147, -2374, -1529, 13520, 23152, -2375,
	-1529, 13514, 23158, -2375, -1528, 13509, 23162, -2375, -1527, 13503, 23167, -2375, -1527, 13498, 23173, -2376,
	-1526, 13492, 23178, -2376, -1525, 13487, 23182, -2376, -1525, 13481, 23188, -2376, -1524, 13476, 23192, -2376,
	-1523, 13470, 23198, -2377, -1523, 13465, 23203, -2377, -1522, 13459, 23208, -2377, -1521, 13454, 23212, -2377,
	-1521, 13448, 23218, -2377, -1520, 13443, 23223, -2378, -1520, 13437, 23229, -2378, -1519, 13432, 23233, -2378,
	-1518, 13426, 23238, -2378, -1518, 13421, 23243, -2378, -1517, 13415, 23249, -2379, -1516, 13410, 23253, -2379,
	-1516, 13404, 23259, -2379, -1515, 13399, 23263, -2379, -1514, 13393, 23268, -2379, -1514, 13388, 23274, -2380,
	-1513, 13382, 23279, -2380, -1512, 13377, 23283, -2380, -1512, 13371, 23289, -2380, -1511, 13366, 23293, -2380,
	-1510, 13360, 23299, -2381, -1510, 13355, 23304, -2381, -1509, 13349, 23309, -2381, -1509, 13344, 23314, -2381,
	-1508, 13338, 23319, -2381, -1507, 13333, 23324, -2382, -1507, 13327, 23330, -2382, -1506, 13322, 23334, -2382,
	-1505, 13316, 23339, -2382, -1505, 13311, 23344, -2382, -1504, 13305, 23350, -2383, -1503, 13300, 23354, -2383,
	-1503, 13294, 23360, -2383, -1502, 13289, 23364, -2383, -1501, 13283, 23369, -2383, -1501, 13278, 23375, -2384,
	-1500, 13272, 23380, -2384, -1499, 13267, 23384, -2384, -1499, 13261, 23390, -2384, -1498, 13256, 23394, -2384,
	-1497, 13250, 23400, -2385, -1497, 13245, 23405, -2385, -1496, 13239, 23410, -2385, -1496, 13234, 23415, -2385,
	-1495, 13228, 23420, -2385, -1494, 13223, 23425, -2386, -1494, 13217, 23431, -2386, -1493, 13212, 23435, -2386,
	-1492, 13206, 23440, -2386, -1492, 13201, 23445, -2386, -1491, 13195, 23451, -2387, -1490, 13190, 23455, -2387,
	-1490, 13184, 23461, -2387, -1489, 13179, 23465, -2387, -1488, 13173, 23470, -2387, -1488, 13168, 23475, -2387,
	-1487, 13163, 23480, -2388, -1486, 13157, 23485, -2388, -1486, 13152, 23490, -2388, -1485, 13146, 23495, -2388,
	-1484, 13141, 23499, -2388, -1484, 13135, 23506, -2389, -1483, 13130, 23510, -2389, -1483, 13124, 23516, -2389,
	-1482, 13119, 23520, -2389, -1481, 13113, 23525, -2389, -1481, 13108, 23530, -2389, -1480, 13102, 23536, -2390,
	-1479, 13097, 23540, -2390, -1479, 13091, 23546, -2390, -1478, 13086, 23550, -2390, -1477, 13080, 23555, -2390,
	-1477, 13075, 23561, -2391, -1476, 13069, 23566, -2391, -1475, 13064, 23570, -2391, -1475, 13058, 23576, -2391,
	-1474, 13053, 23580, -2391, -1473, 13047, 23585, -2391, -1473, 13042, 23591, -2392, -1472, 13036, 23596, -2392,
	-1471, 13031, 23600, -2392, -1471, 13025, 23606, -2392, -1470, 13020, 23610, -2392, -1469, 13014, 23616, -2393,
	-1469, 13009, 23621, -2393, -1468, 13003, 23626, -2393, -1468, 12998, 23631, -2393, -1467, 12992, 23636, -2393,
	-1466, 12987, 23640, -2393, -1466, 12982, 23646, -2394, -1465, 12976, 23651, -2394, -1464, 12971, 23655, -2394,
	-1464, 12965, 23661, -2394, -1463, 12960, 23665, -2394, -1462, 12954, 23670, -2394, -1462, 12949, 23676, -2395,
	-1461, 12943, 23681, -2395, -1460, 12938, 23685, -2395, -1460, 12932, 23691, -2395, -1459, 12927, 23695, -2395,
	-1458, 12921, 23700, -2395, -1458, 12916, 23706, -2396, -1457, 12910, 23711, -2396, -1456, 12905, 23715, -2396,
	-1456, 12899, 23721, -2396, -1455, 12894, 23725, -2396, -1454, 12888, 23730, -2396, -1454, 12883, 23736, -2397,
	-1453, 12877, 23741, -2397, -1452, 12872, 23745, -2397, -1452, 12866, 23751, -2397, -1451, 12861, 23755, -2397,
	-1450, 12856, 23759, -2397, -1450, 12850, 23766, -2398, -1449, 12845, 23770, -2398, -1449, 12839, 23776, -2398,
	-1448, 12834, 23780, -2398, -1447, 12828, 23785, -2398, -1447, 12823, 23790, -2398, -1446, 12817, 23796, -2399,
	-1445, 12812, 23800, -2399, -1445, 12806, 23806, -2399, -1444, 12801, 23810, -2399, -1443, 12795, 23815, -2399,
	-1443, 12790, 23820, -2399, -1442, 12784, 23826, -2400, -1441, 12779, 23830, -2400, -1441, 12773, 23836, -2400,
	-1440, 12768, 23840, -2400, -1439, 12763, 23844, -2400, -1439, 12757, 23850, -2400, -1438, 12752, 23854, -2400,
	-1437, 12746, 23860, -2401, -1437, 12741, 23865, -2401, -1436, 12735, 23870, -2401, -1435, 12730, 23874, -2401,
	-1435, 12724, 23880, -2401, -1434, 12719, 23884, -2401, -1433, 12713, 23890, -2402, -1433, 12708, 23895, -2402,
	-1432, 12702, 23900, -2402, -1431, 12697, 23904, -2402, -1431, 12691, 23910, -2402, -1430, 12686, 23914, -2402,
	-1429, 12681, 23918, -2402, -1429, 12675, 23925, -2403, -1428, 12670, 23929, -2403, -1428, 12664, 23935, -2403,
	-1427, 12659, 23939, -2403, -1426, 12653, 23944, -2403, -1426, 12648, 23949, -2403, -1425, 12642, 23954, -2403,
	-1424, 12637, 23959, -2404, -1424, 12631, 23965, -2404, -1423, 12626, 23969, -2404, -1422, 12620, 23974, -2404,
	-1422, 12615, 23979, -2404, -1421, 12610, 23983, -2404, -1420, 12604, 23988, -2404, -1420, 12599, 23994, -2405,
	-1419, 12593, 23999, -2405, -1418, 12588, 24003, -2405, -1418, 12582, 24009, -2405, -1417, 12577, 24013, -2405,
	-1416, 12571, 24018, -2405, -1416, 12566, 24023, -2405, -1415, 12560, 24029, -2406, -1414, 12555, 24033, -2406,
	-1414, 12549, 24039, -2406, -1413, 12544, 24043, -2406, -1412, 12539, 24047, -2406, -1412, 12533, 24053, -2406,
	-1411, 12528, 24057, -2406, -1410, 12522, 24063, -2407, -1410, 12517, 24068, -2407, -1409, 12511, 24073, -2407,
	-1408, 12506, 24077, -2407, -1408, 12500, 24083, -2407, -1407, 12495, 24087, -2407, -1406, 12490, 24091, -2407,
	-1406, 12484, 24098, -2408, -1405, 12479, 24102, -2408, -1404, 12473, 24107, -2408, -1404, 12468, 24112, -2408,
	-1403, 12462, 24117, -2408, -1403, 12457, 24122, -2408, -1402, 12451, 24127, -2408, -1401, 12446, 24131, -2408,
	-1401, 12440, 24138, -2409, -1400, 12435, 24142, -2409, -1399, 12430, 24146, -2409, -1399, 12424, 24152, -2409,
	-1398, 12419, 24156, -2409, -1397, 12413, 24161, -2409, -1397, 12408, 24166, -2409, -1396, 12402, 24172, -2410,
	-1395, 12397, 24176, -2410, -1395, 12391, 24182, -2410, -1394, 12386, 24186, -2410, -1393, 12381, 24190, -2410,
	-1393, 12375, 24196, -2410, -1392, 12370, 24200, -2410, -1391, 12364, 24205, -2410, -1391, 12359, 24211, -2411,
	-1390, 12353, 24216, -2411, -1389, 12348, 24220, -2411, -1389, 12342, 24226, -2411, -1388, 12337, 24230, -2411,
	-1387, 12332, 24234, -2411, -1387, 12326, 24240, -2411, -1386, 12321, 24244, -2411, -1385, 12315, 24249, -2411,
	-1385, 12310, 24255, -2412, -1384, 12304, 24260, -2412, -1383, 12299, 24264, -2412, -1383, 12293, 24270, -2412,
	-1382, 12288, 24274, -2412, -1381, 12283, 24278, -2412, -1381, 12277, 24284, -2412, -1380, 12272, 24288, -2412,
	-1379, 12266, 24294, -2413, -1379, 12261, 24299, -2413, -1378, 12255, 24304, -2413, -1377, 12250, 24308, -2413,
	-1377, 12244, 24314, -2413, -1376, 12239, 24318, -2413, -1375, 12234, 24322, -2413, -1375, 12228, 24328, -2413,
	-1374, 12223, 24332, -2413, -1373, 12217, 24338, -2414, -1373, 12212, 24343, -2414, -1372, 12206, 24348, -2414,
	-1371, 12201, 24352, -2414, -1371, 12196, 24357, -2414, -1370, 12190, 24362, -2414, -1369, 12185, 24366, -2414,
	-1369, 12179, 24372, -2414, -1368, 12174, 24376, -2414, -1367, 12168, 24382, -2415, -1367, 12163, 24387, -2415,
	-1366, 12158, 24391, -2415, -1365, 12152, 24396, -2415, -1365, 12147, 24401, -2415, -1364, 12141, 24406, -2415,
	-1364, 12136, 24411, -2415, -1363, 12130, 24416, -2415, -1362, 12125, 24420, -2415, -1362, 12120, 24426, -2416,
	-1361, 12114, 24431, -2416, -1360, 12109, 24435, -2416, -1360, 12103, 24441, -2416, -1359, 12098, 24445, -2416,
	-1358, 12092, 24450, -2416, -1358, 12087, 24455, -2416, -1357, 12082, 24459, -2416, -1356, 12076, 24464, -2416,
	-1356, 12071, 24469, -2416, -1355, 12065, 24475, -2417, -1354, 12060, 24479, -2417, -1354, 12054, 24485, -2417,
	-1353, 12049, 24489, -2417, -1352, 12044, 24493, -2417, -1352, 12038, 24499, -2417, -1351, 12033, 24503, -2417,
	-1350, 12027, 24508, -2417, -1350, 12022, 24513, -2417, -1349, 12016, 24518, -2417, -1348, 12011, 24523, -2418,
	-1348, 12006, 24528, -2418, -1347, 12000, 24533, -2418, -1346, 11995, 24537, -2418, -1346, 11989, 24543, -2418,
	-1345, 11984, 24547, -2418, -1344, 11979, 24551, -2418, -1344, 11973, 24557, -2418, -1343, 11968, 24561, -2418,
	-1342, 11962, 24566, -2418, -1342, 11957, 24571, -2418, -1341, 11951, 24577, -2419, -1340, 11946, 24581, -2419,
	-1340, 11941, 24586, -2419, -1339, 11935, 24591, -2419, -1338, 11930, 24595, -2419, -1338, 11924, 24601, -2419,
	-1337, 11919, 24605, -2419, -1336, 11914, 24609, -2419, -1336, 11908, 24615, -2419, -1335, 11903, 24619, -2419,
	-1334, 11897, 24624, -2419, -1334, 11892, 24629, -2419, -1333, 11886, 24635, -2420, -1332, 11881, 24639, -2420,
	-1332, 11876, 24644, -2420, -1331, 11870, 24649, -2420, -1330, 11865, 24653, -2420, -1330, 11859, 24659, -2420,
	-1329, 11854, 24663, -2420, -1328, 11849, 24667, -2420, -1328, 11843, 24673, -2420, -1327, 11838, 24677, -2420,
	-1326, 11832, 24682, -2420, -1326, 11827, 24687, -2420, -1325, 11822, 24692, -2421, -1324, 11816, 24697, -2421,
	-1324, 11811, 24702, -2421, -1323, 11805, 24707, -2421, -1322, 11800, 24711, -2421, -1322, 11794, 24717, -2421,
	-1321, 11789, 24721, -2421, -1320, 11784, 24725, -2421, -1320, 11778, 24731, -2421, -1319, 11773, 24735, -2421,
	-1318, 11767, 24740, -2421, -1318, 11762, 24745, -2421, -1317, 11757, 24749, -2421, -1316, 11751, 24755, -2422,
	-1316, 11746, 24760, -2422, -1315, 11740, 24765, -2422, -1314, 11735, 24769, -2422, -1314, 11730, 24774, -2422,
	-1313, 11724, 24779, -2422, -1312, 11719, 24783, -2422, -1312, 11713, 24789, -2422, -1311, 11708, 24793, -2422,
	-1310, 11703, 24797, -2422, -1310, 11697, 24803, -2422, -1309, 11692, 24807, -2422, -1308, 11686, 24812, -2422,
	-1308, 11681, 24817, -2422, -1307, 11676, 24822, -2423, -1306, 11670, 24827, -2423, -1306, 11665, 24832, -2423,
	-1305, 11659, 24837, -2423, -1304, 11654, 24841, -2423, -1304, 11649, 24846, -2423, -1303, 11643, 24851, -2423,
	-1302, 11638, 24855, -2423, -1302, 11633, 24860, -2423, -1301, 11627, 24865, -2423, -1300, 11622, 24869, -2423,
	-1300, 11616, 24875, -2423, -1299, 11611, 24879, -2423, -1298, 11606, 24883, -2423, -1298, 11600, 24889, -2423,
	-1297, 11595, 24893, -2423, -1296, 11589, 24899, -2424, -1296, 11584, 24904, -2424, -1295, 11579, 24908, -2424,
	-1294, 11573, 24913, -2424, -1294, 11568, 24918, -2424, -1293, 11562, 24923, -2424, -1292, 11557, 24927, -2424,
	-1292, 11552, 24932, -2424, -1291, 11546, 24937, -2424, -1290, 11541, 24941, -2424, -1290, 11536, 24946, -2424,
	-1289, 11530, 24951, -2424, -1288, 11525, 24955, -2424, -1288, 11519, 24961, -2424, -1287, 11514, 24965, -2424,
	-1286, 11509, 24969, -2424, -1286, 11503, 24975, -2424, -1285, 11498, 24979, -2424, -1284, 11492, 24985, -2425,
	-1284, 11487, 24990, -2425, -1283, 11482, 24994, -2425, -1282, 11476, 24999, -2425, -1282, 11471, 25004, -2425,
	-1281, 11466, 25008, -2425, -1280, 11460, 25013, -2425, -1280, 11455, 25018, -2425, -1279, 11449, 25023, -2425,
	-1278, 11444, 25027, -2425, -1278, 11439, 25032, -2425, -1277, 11433, 25037, -2425, -1276, 11428, 25041, -2425,
	-1276, 11422, 25047, -2425, -1275, 11417, 25051, -2425, -1274, 11412, 25055, -2425, -1274, 11406, 25061, -2425,
	-1273, 11401, 25065, -2425, -1272, 11396, 25069, -2425, -1272, 11390, 25075, -2425, -1271, 11385, 25079, -2425,
	-1271, 11380, 25085, -2426, -1270, 11374, 25090, -2426, -1269, 11369, 25094, -2426, -1269, 11363, 25100, -2426,
	-1268, 11358, 25104, -2426, -1267, 11353, 25108, -2426, -1267, 11347, 25114, -2426, -1266, 11342, 25118, -2426,
	-1265, 11337, 25122, -2426, -1265, 11331, 25128, -2426, -1264, 11326, 25132, -2426, -1263, 11320, 25137, -2426,
	-1263, 11315, 25142, -2426, -1262, 11310, 25146, -2426, -1261, 11304, 25151, -2426, -1261, 11299, 25156, -2426,
	-1260, 11294, 25160, -2426, -1259, 11288, 25165, -2426, -1259, 11283, 25170, -2426, -1258, 11277, 25175, -2426,
	-1257, 11272, 25179, -2426, -1257, 11267, 25184, -2426, -1256, 11261, 25189, -2426, -1255, 11256, 25193, -2426,
	-1255, 11251, 25198, -2426, -1254, 11245, 25203, -2426, -1253, 11240, 25207, -2426, -1253, 11235, 25212, -2426,
	-1252, 11229, 25217, -2426, -1251, 11224, 25221, -2426, -1251, 11219, 25227, -2427, -1250, 11213, 25232, -2427,
	-1249, 11208, 25236, -2427, -1249, 11202, 25242, -2427, -1248, 11197, 25246, -2427, -1247, 11192, 25250, -2427,
	-1247, 11186, 25256, -2427, -1246, 11181, 25260, -2427, -1245, 11176, 25264, -2427, -1245, 11170, 25270, -2427,
	-1244, 11165, 25274, -2427, -1243, 11160, 25278, -2427, -1243, 11154, 25284, -2427, -1242, 11149, 25288, -2427,
	-1241, 11144, 25292, -2427, -1241, 11138, 25298, -2427, -1240, 11133, 25302, -2427, -1239, 11127, 25307, -2427,
	-1239, 11122, 25312, -2427, -1238, 11117, 25316, -2427, -1237, 11111, 25321, -2427, -1237, 11106, 25326, -2427,
	-1236, 11101, 25330, -2427, -1235, 11095, 25335, -2427, -1235, 11090, 25340, -2427, -1234, 11085, 25344, -2427,
	-1233, 11079, 25349, -2427, -1233, 11074, 25354, -2427, -1232, 11069, 25358, -2427, -1231, 11063, 25363, -2427,
	-1231, 11058, 25368, -2427, -1230, 11053, 25372, -2427, -1229, 11047, 25377, -2427, -1229, 11042, 25382, -2427,
	-1228, 11037, 25386, -2427, -1227, 11031, 25391, -2427, -1227, 11026, 25396, -2427, -1226, 11021, 25400, -2427,
	-1225, 11015, 25405, -2427, -1225, 11010, 25410, -2427, -1224, 11005, 25414, -2427, -1223, 10999, 25419, -2427,
	-1223, 10994, 25424, -2427, -1222, 10988, 25429, -2427, -1221, 10983, 25433, -2427, -1221, 10978, 25438, -2427,
	-1220, 10972, 25443, -2427, -1219, 10967, 25447, -2427, -1219, 10962, 25452, -2427, -1218, 10956, 25457, -2427,
	-1217, 10951, 25461, -2427, -1217, 10946, 25466, -2427, -1216, 10940, 25471, -2427, -1215, 10935, 25475, -2427,
	-1215, 10930, 25480, -2427, -1214, 10924, 25485, -2427, -1213, 10919, 25489, -2427, -1213, 10914, 25494, -2427,
	-1212, 10908, 25499, -2427, -1211, 10903, 25503, -2427, -1211, 10898, 25508, -2427, -1210, 10892, 25513, -2427,
	-1209, 10887, 25517, -2427, -1209, 10882, 25522, -2427, -1208, 10876, 25527, -2427, -1207, 10871, 25531, -2427,
	-1207, 10866, 25536, -2427, -1206, 10860, 25541, -2427, -1205, 10855, 25545, -2427, -1205, 10850, 25550, -2427,
	-1204, 10844, 25555, -2427, -1203, 10839, 25559, -2427, -1203, 10834, 25564, -2427, -1202, 10829, 25568, -2427,
	-1201, 10823, 25573, -2427, -1201, 10818, 25578, -2427, -1200, 10813, 25582, -2427, -1199, 10807, 25587, -2427,
	-1199, 10802, 25592, -2427, -1198, 10797, 25596, -2427, -1197, 10791, 25601, -2427, -1197, 10786, 25606, -2427,
	-1196, 10781, 25610, -2427, -1195, 10775, 25615, -2427, -1195, 10770, 25620, -2427, -1194, 10765, 25624, -2427,
	-1193, 10759, 25629, -2427, -1193, 10754, 25634, -2427, -1192, 10749, 25638, -2427, -1191, 10743, 25643, -2427,
	-1191, 10738, 25648, -2427, -1190, 10733, 25652, -2427, -1189, 10727, 25657, -2427, -1189, 10722, 25662, -2427,
	-1188, 10717, 25666, -2427, -1187, 10712, 25670, -2427, -1187, 10706, 25676, -2427, -1186, 10701, 25680, -2427,
	-1185, 10696, 25684, -2427, -1185, 10690, 25690, -2427, -1184, 10685, 25694, -2427, -1183, 10680, 25698, -2427,
	-1183, 10674, 25704, -2427, -1182, 10669, 25708, -2427, -1181, 10664, 25712, -2427, -1181, 10658, 25718, -2427,
	-1180, 10653, 25722, -2427, -1179, 10648, 25726, -2427, -1179, 10642, 25732, -2427, -1178, 10637, 25736, -2427,
	-1177, 10632, 25740, -2427, -1177, 10627, 25744, -2426, -1176, 10621, 25749, -2426, -1175, 10616, 25753, -2426,
	-1175, 10611, 25758, -2426, -1174, 10605, 25763, -2426, -1173, 10600, 25767, -2426, -1173, 10595, 25772, -2426,
	-1172, 10589, 25777, -2426, -1171, 10584, 25781, -2426, -1171, 10579, 25786, -2426, -1170, 10574, 25790, -2426,
	-1169, 10568, 25795, -2426, -1169, 10563, 25800, -2426, -1168, 10558, 25804, -2426, -1167, 10552, 25809, -2426,
	-1167, 10547, 25814, -2426, -1166, 10542, 25818, -2426, -1165, 10536, 25823, -2426, -1165, 10531, 25828, -2426,
	-1164, 10526, 25832, -2426, -1163, 10521, 25836, -2426, -1163, 10515, 25842, -2426, -1162, 10510, 25846, -2426,
	-1161, 10505, 25850, -2426, -1161, 10499, 25856, -2426, -1160, 10494, 25860, -2426, -1159, 10489, 25864, -2426,
	-1159, 10483, 25870, -2426, -1158, 10478, 25874, -2426, -1157, 10473, 25877, -2425, -1157, 10468, 25882, -2425,
	-1156, 10462, 25887, -2425, -1155, 10457, 25891, -2425, -1155, 10452, 25896, -2425, -1154, 10446, 25901, -2425,
	-1153, 10441, 25905, -2425, -1153, 10436, 25910, -2425, -1152, 10431, 25914, -2425, -1151, 10425, 25919, -2425,
	-1151, 10420, 25924, -2425, -1150, 10415, 25928, -2425, -1149, 10409, 25933, -2425, -1149, 10404, 25938, -2425,
	-1148, 10399, 25942, -2425, -1147, 10394, 25946, -2425, -1147, 10388, 25952, -2425, -1146, 10383, 25956, -2425,
	-1145, 10378, 25960, -2425, -1145, 10373, 25965, -2425, -1144, 10367, 25970, -2425, -1143, 10362, 25973, -2424,
	-1143, 10357, 25978, -2424, -1142, 10351, 25983, -2424, -1141, 10346, 25987, -2424, -1141, 10341, 25992, -2424,
	-1140, 10336, 25996, -2424, -1139, 10330, 26001, -2424, -1139, 10325, 26006, -2424, -1138, 10320, 26010, -2424,
	-1137, 10314, 26015, -2424, -1137, 10309, 26020, -2424, -1136, 10304, 26024, -2424, -1135, 10299, 26028, -2424,
	-1135, 10293, 26034, -2424, -1134, 10288, 26038, -2424, -1133, 10283, 26042, -2424, -1133, 10278, 26047, -2424,
	-1132, 10272, 26052, -2424, -1131, 10267, 26055, -2423, -1131, 10262, 26060, -2423, -1130, 10256, 26065, -2423,
	-1129, 10251, 26069, -2423, -1129, 10246, 26074, -2423, -1128, 10241, 26078, -2423, -1127, 10235, 26083, -2423,
	-1127, 10230, 26088, -2423, -1126, 10225, 26092, -2423, -1125, 10220, 26096, -2423, -1125, 10214, 26102, -2423,
	-1124, 10209, 26106, -2423, -1123, 10204, 26110, -2423, -1123, 10199, 26115, -2423, -1122, 10193, 26120, -2423,
	-1121, 10188, 26123, -2422, -1121, 10183, 26128, -2422, -1120, 10178, 26132, -2422, -1119, 10172, 26137, -2422,
	-1119, 10167, 26142, -2422, -1118, 10162, 26146, -2422, -1117, 10156, 26151, -2422, -1117, 10151, 26156, -2422,
	-1116, 10146, 26160, -2422, -1115, 10141, 26164, -2422, -1115, 10135, 26170, -2422, -1114, 10130, 26174, -2422,
	-1113, 10125, 26178, -2422, -1113, 10120, 26183, -2422, -1112, 10114, 26187, -2421, -1111, 10109, 26191, -2421,
	-1111, 10104, 26196, -2421, -1110, 10099, 26200, -2421, -1109, 10093, 26205, -2421, -1109, 10088, 26210, -2421,
	-1108, 10083, 26214, -2421, -1107, 10078, 26218, -2421, -1107, 10072, 26224, -2421, -1106, 10067, 26228, -2421,
	-1105, 10062, 26232, -2421, -1105, 10057, 26237, -2421, -1104, 10051, 26242, -2421, -1103, 10046, 26245, -2420,
	-1103, 10041, 26250, -2420, -1102, 10036, 26254, -2420, -1101, 10030, 26259, -2420, -1101, 10025, 26264, -2420,
	-1100, 10020, 26268, -2420, -1099, 10015, 26272, -2420, -1099, 10010, 26277, -2420, -1098, 10004, 26282, -2420,
	-1097,  9999, 26286, -2420, -1097,  9994, 26291, -2420, -1096,  9989, 26294, -2419, -1095,  9983, 26299, -2419,
	-1095,  9978, 26304, -2419, -1094,  9973, 26308, -2419, -1093,  9968, 26312, -2419, -1093,  9962, 26318, -2419,
	-1092,  9957, 26322, -2419, -1091,  9952, 26326, -2419, -1091,  9947, 26331, -2419, -1090,  9941, 26336, -2419,
	-1089,  9936, 26340, -2419, -1089,  9931, 26344, -2418, -1088,  9926, 26348, -2418, -1087,  9921, 26352, -2418,
	-1087,  9915, 26358, -2418, -1086,  9910, 26362, -2418, -1085,  9905, 26366, -2418, -1085,  9900, 26371, -2418,
	-1084,  9894, 26376, -2418, -1083,  9889, 26380, -2418, -1083,  9884, 26385, -2418, -1082,  9879, 26388, -2417,
	-1081,  9873, 26393, -2417, -1081,  9868, 26398, -2417, -1080,  9863, 26402, -2417, -1079,  9858, 26406, -2417,
	-1079,  9853, 26411, -2417, -1078,  9847, 26416, -2417, -1077,  9842, 26420, -2417, -1077,  9837, 26425, -2417,
	-1076,  9832, 26429, -2417, -1075,  9826, 26433, -2416, -1075,  9821, 26438, -2416, -1074,  9816, 26442, -2416,
	-1073,  9811, 26446, -2416, -1073,  9806, 26451, -2416, -1072,  9800, 26456, -2416, -1071,  9795, 26460, -2416,
	-1071,  9790, 26465, -2416, -1070,  9785, 26469, -2416, -1069,  9779, 26473, -2415, -1069,  9774, 26478, -2415,
	-1068,  9769, 26482, -2415, -1068,  9764, 26487, -2415, -1067,  9759, 26491, -2415, -1066,  9753, 26496, -2415,
	-1066,  9748, 26501, -2415, -1065,  9743, 26505, -2415, -1064,  9738, 26509, -2415, -1064,  9733, 26513, -2414,
	-1063,  9727, 26518, -2414, -1062,  9722, 26522, -2414, -1062,  9717, 26527, -2414, -1061,  9712, 26531, -2414,
	-1060,  9707, 26535, -2414, -1060,  9701, 26541, -2414, -1059,  9696, 26545, -2414, -1058,  9691, 26549, -2414,
	-1058,  9686, 26553, -2413, -1057,  9681, 26557, -2413, -1056,  9675, 26562, -2413, -1056,  9670, 26567, -2413,
	-1055,  9665, 26571, -2413, -1054,  9660, 26575, -2413, -1054,  9654, 26581, -2413, -1053,  9649, 26585, -2413,
	-1052,  9644, 26588, -2412, -1052,  9639, 26593, -2412, -1051,  9634, 26597, -2412, -1050,  9629, 26601, -2412,
	-1050,  9623, 26607, -2412, -1049,  9618, 26611, -2412, -1048,  9613, 26615, -2412, -1048,  9608, 26620, -2412,
	-1047,  9603, 26623, -2411, -1046,  9597, 26628, -2411, -1046,  9592, 26633, -2411, -1045,  9587, 26637, -2411,
	-1044,  9582, 26641, -2411, -1044,  9577, 26646, -2411, -1043,  9571, 26651, -2411, -1042,  9566, 26655, -2411,
	-1042,  9561, 26659, -2410, -1041,  9556, 26663, -2410, -1040,  9551, 26667, -2410, -1040,  9545, 26673, -2410,
	-1039,  9540, 26677, -2410, -1038,  9535, 26681, -2410, -1038,  9530, 26686, -2410, -1037,  9525, 26689, -2409,
	-1036,  9520, 26693, -2409, -1036,  9514, 26699, -2409, -1035,  9509, 26703, -2409, -1034,  9504, 26707, -2409,
	-1034,  9499, 26712, -2409, -1033,  9494, 26716, -2409, -1032,  9488, 26721, -2409, -1032,  9483, 26725, -2408,
	-1031,  9478, 26729, -2408, -1030,  9473, 26733, -2408, -1030,  9468, 26738, -2408, -1029,  9463, 26742, -2408,
	-1028,  9457, 26747, -2408, -1028,  9452, 26752, -2408, -1027,  9447, 26755, -2407, -1027,  9442, 26760, -2407,
	-1026,  9437, 26764, -2407, -1025,  9431, 26769, -2407, -1025,  9426, 26774, -2407, -1024,  9421, 26778, -2407,
	-1023,  9416, 26781, -2406, -1023,  9411, 26786, -2406, -1022,  9406, 26790, -2406, -1021,  9400, 26795, -2406,
	-1021,  9395, 26800, -2406, -1020,  9390, 26804, -2406, -1019,  9385, 26808, -2406, -1019,  9380, 26812, -2405,
	-1018,  9375, 26816, -2405, -1017,  9369, 26821, -2405, -1017,  9364, 26826, -2405, -1016,  9359, 26830, -2405,
	-1015,  9354, 26834, -2405, -1015,  9349, 26839, -2405, -1014,  9344, 26842, -2404, -1013,  9338, 26847, -2404,
	-1013,  9333, 26852, -2404, -1012,  9328, 26856, -2404, -1011,  9323, 26860, -2404, -1011,  9318, 26865, -2404,
	-1010,  9313, 26868, -2403, -1009,  9307, 26873, -2403, -1009,  9302, 26878, -2403, -1008,  9297, 26882, -2403,
	-1007,  9292, 26886, -2403, -1007,  9287, 26891, -2403, -1006,  9282, 26894, -2402, -1005,  9277, 26898, -2402,
	-1005,  9271, 26904, -2402, -1004,  9266, 26908, -2402, -1003,  9261, 26912, -2402, -1003,  9256, 26917, -2402,
	-1002,  9251, 26921, -2402, -1001,  9246, 26924, -2401, -1001,  9240, 26930, -2401, -1000,  9235, 26934, -2401,
	-1000,  9230, 26939, -2401,  -999,  9225, 26943, -2401,  -998,  9220, 26947, -2401,  -998,  9215, 26951, -2400,
	 -997,  9210, 26955, -2400,  -996,  9204, 26960, -2400,  -996,  9199, 26965, -2400,  -995,  9194, 26969, -2400,
	 -994,  9189, 26972, -2399,  -994,  9184, 26977, -2399,  -993,  9179, 26981, -2399,  -992,  9174, 26985, -2399,
	 -992,  9168, 26991, -2399,  -991,  9163, 26995, -2399,  -990,  9158, 26998, -2398,  -990,  9153, 27003, -2398,
	 -989,  9148, 27007, -2398,  -988,  9143, 27011, -2398,  -988,  9138, 27016, -2398,  -987,  9133, 27020, -2398,
	 -986,  9127, 27024, -2397,  -986,  9122, 27029, -2397,  -985,  9117, 27033, -2397,  -984,  9112, 27037, -2397,
	 -984,  9107, 27042, -2397,  -983,  9102, 27045, -2396,  -982,  9097, 27049, -2396,  -982,  9091, 27055, -2396,
	 -981,  9086, 27059, -2396,  -980,  9081, 27063, -2396,  -980,  9076, 27068, -2396,  -979,  9071, 27071, -2395,
	 -979,  9066, 27076, -2395,  -978,  9061, 27080, -2395,  -977,  9056, 27084, -2395,  -977,  9050, 27090, -2395,
	 -976,  9045, 27093, -2394,  -975,  9040, 27097, -2394,  -975,  9035, 27102, -2394,  -974,  9030, 27106, -2394,
	 -973,  9025, 27110, -2394,  -973,  9020, 27115, -2394,  -972,  9015, 27118, -2393,  -971,  9009, 27123, -2393,
	 -971,  9004, 27128, -2393,  -970,  8999, 27132, -2393,  -969,  8994, 27136, -2393,  -969,  8989, 27140, -2392,
	 -968,  8984, 27144, -2392,  -967,  8979, 27148, -2392,  -967,  8974, 27153, -2392,  -966,  8969, 27157, -2392,
	 -965,  8963, 27161, -2391,  -965,  8958, 27166, -2391,  -964,  8953, 27170, -2391,  -963,  8948, 27174, -2391,
	 -963,  8943, 27179, -2391,  -962,  8938, 27182, -2390,  -961,  8933, 27186, -2390,  -961,  8928, 27191, -2390,
	 -960,  8923, 27195, -2390,  -960,  8917, 27201, -2390,  -959,  8912, 27204, -2389,  -958,  8907, 27208, -2389,
	 -958,  8902, 27213, -2389,  -957,  8897, 27217, -2389,  -956,  8892, 27221, -2389,  -956,  8887, 27225, -2388,
	 -955,  8882, 27229, -2388,  -954,  8877, 27233, -2388,  -954,  8872, 27238, -2388,  -953,  8866, 27243, -2388,
	 -952,  8861, 27246, -2387,  -952,  8856, 27251, -2387,  -951,  8851, 27255, -2387,  -950,  8846, 27259, -2387,
	 -950,  8841, 27264, -2387,  -949,  8836, 27267, -2386,  -948,  8831, 27271, -2386,  -948,  8826, 27276, -2386,
	 -947,  8821, 27280, -2386,  -946,  8815, 27285, -2386,  -946,  8810, 27289, -2385,  -945,  8805, 27293, -2385,
	 -945,  8800, 27298, -2385,  -944,  8795, 27302, -2385,  -943,  8790, 27305, -2384,  -943,  8785, 27310, -2384,
	 -942,  8780, 27314, -2384,  -941,  8775, 27318, -2384,  -941,  8770, 27323, -2384,  -940,  8765, 27326, -2383,
	 -939,  8759, 27331, -2383,  -939,  8754, 27336, -2383,  -938,  8749, 27340, -2383,  -937,  8744, 27343, -2382,
	 -937,  8739, 27348, -2382,  -936,  8734, 27352, -2382,  -935,  8729, 27356, -2382,  -935,  8724, 27361, -2382,
	 -934,  8719, 27364, -2381,  -933,  8714, 27368, -2381,  -933,  8709, 27373, -2381,  -932,  8704, 27377, -2381,
	 -932,  8699, 27382, -2381,  -931,  8693, 27386, -2380,  -930,  8688, 27390, -2380,  -930,  8683, 27395, -2380,
	 -929,  8678, 27399, -2380,  -928,  8673, 27402, -2379,  -928,  8668, 27407, -2379,  -927,  8663, 27411, -2379,
	 -926,  8658, 27415, -2379,  -926,  8653, 27419, -2378,  -925,  8648, 27423, -2378,  -924,  8643, 27427, -2378,
	 -924,  8638, 27432, -2378,  -923,  8633, 27436, -2378,  -922,  8628, 27439, -2377,  -922,  8622, 27445, -2377,
	 -921,  8617, 27449, -2377,  -920,  8612, 27453, -2377,  -920,  8607, 27457, -2376,  -919,  8602, 27461, -2376,
	 -919,  8597, 27466, -2376,  -918,  8592, 27470, -2376,  -917,  8587, 27473, -2375,  -917,  8582, 27478, -2375,
	 -916,  8577, 27482, -2375,  -915,  8572, 27486, -2375,  -915,  8567, 27490, -2374,  -914,  8562, 27494, -2374,
	 -913,  8557, 27498, -2374,  -913,  8552, 27503, -2374,  -912,  8547, 27507, -2374,  -911,  8541, 27511, -2373,
	 -911,  8536, 27516, -2373,  -910,  8531, 27520, -2373,  -909,  8526, 27524, -2373,  -909,  8521, 27528, -2372,
	 -908,  8516, 27532, -2372,  -907,  8511, 27536, -2372,  -907,  8506, 27541, -2372,  -906,  8501, 27544, -2371,
	 -906,  8496, 27549, -2371,  -905,  8491, 27553, -2371,  -904,  8486, 27557, -2371,  -904,  8481, 27561, -2370,
	 -903,  8476, 27565, -2370,  -902,  8471, 27569, -2370,  -902,  8466, 27574, -2370,  -901,  8461, 27577, -2369,
	 -900,  8456, 27581, -2369,  -900,  8451, 27586, -2369,  -899,  8446, 27590, -2369,  -898,  8441, 27593, -2368,
	 -898,  8436, 27598, -2368,  -897,  8430, 27603, -2368,  -896,  8425, 27607, -2368,  -896,  8420, 27611, -2367,
	 -895,  8415, 27615, -2367,  -895,  8410, 27620, -2367,  -894,  8405, 27624, -2367,  -893,  8400, 27627, -2366,
	 -893,  8395, 27632, -2366,  -892,  8390, 27636, -2366,  -891,  8385, 27639, -2365,  -891,  8380, 27644, -2365,
	 -890,  8375, 27648, -2365,  -889,  8370, 27652, -2365,  -889,  8365, 27656, -2364,  -888,  8360, 27660, -2364,
	 -887,  8355, 27664, -2364,  -887,  8350, 27669, -2364,  -886,  8345, 27672, -2363,  -886,  8340, 27677, -2363,
	 -885,  8335, 27681, -2363,  -884,  8330, 27685, -2363,  -884,  8325, 27689, -2362,  -883,  8320, 27693, -2362,
	 -882,  8315, 27697, -2362,  -882,  8310, 27702, -2362,  -881,  8305, 27705, -2361,  -880,  8300, 27709, -2361,
	 -880,  8295, 27714, -2361,  -879,  8290, 27717, -2360,  -878,  8285, 27721, -2360,  -878,  8280, 27726, -2360,
	 -877,  8275, 27730, -2360,  -877,  8270, 27734, -2359,  -876,  8265, 27738, -2359,  -875,  8260, 27742, -2359,
	 -875,  8255, 27747, -2359,  -874,  8250, 27750, -2358,  -873,  8245, 27754, -2358,  -873,  8240, 27759, -2358,
	 -872,  8235, 27762, -2357,  -871,  8230, 27766, -2357,  -871,  8225, 27771, -2357,  -870,  8220, 27775, -2357,
	 -869,  8215, 27778, -2356,  -869,  8210, 27783, -2356,  -868,  8205, 27787, -2356,  -868,  8200, 27791, -2355,
	 -867,  8195, 27795, -2355,  -866,  8190, 27799, -2355,  -866,  8185, 27804, -2355,  -865,  8180, 27807, -2354,
	 -864,  8175, 27811, -2354,  -864,  8170, 27816, -2354,  -863,  8165, 27819, -2353,  -862,  8160, 27823, -2353,
	 -862,  8155, 27828, -2353,  -861,  8150, 27832, -2353,  -860,  8145, 27835, -2352,  -860,  8140, 27840, -2352,
	 -859,  8135, 27844, -2352,  -859,  8130, 27848, -2351,  -858,  8125, 27852, -2351,  -857,  8120, 27856, -2351,
	 -857,  8115, 27861, -2351,  -856,  8110, 27864, -2350,  -855,  8105, 27868, -2350,  -855,  8100, 27873, -2350,
	 -854,  8095, 27876, -2349,  -853,  8090, 27880, -2349,  -853,  8085, 27885, -2349,  -852,  8080, 27889, -2349,
	 -851,  8075, 27892, -2348,  -851,  8070, 27897, -2348,  -850,  8065, 27901, -2348,  -850,  8060, 27905, -2347,
	 -849,  8055, 27909, -2347,  -848,  8050, 27913, -2347,  -848,  8045, 27917, -2346,  -847,  8040, 27921, -2346,
	 -846,  8035, 27925, -2346,  -846,  8030, 27930, -2346,  -845,  8025, 27933, -2345,  -844,  8020, 27937, -2345,
	 -844,  8015, 27942, -2345,  -843,  8010, 27945, -2344,  -843,  8005, 27950, -2344,  -842,  8000, 27954, -2344,
	 -841,  7995, 27957, -2343,  -841,  7990, 27962, -2343,  -840,  7985, 27966, -2343,  -839,  7980, 27970, -2343,
	 -839,  7975, 27974, -2342,  -838,  7970, 27978, -2342,  -837,  7965, 27982, -2342,  -837,  7960, 27986, -2341,
	 -836,  7955, 27990, -2341,  -836,  7950, 27995, -2341,  -835,  7945, 27998, -2340,  -834,  7940, 28002, -2340,
	 -834,  7936, 28006, -2340,  -833,  7931, 28009, -2339,  -832,  7926, 28013, -2339,  -832,  7921, 28018, -2339,
	 -831,  7916, 28021, -2338,  -830,  7911, 28025, -2338,  -830,  7906, 28030, -2338,  -829,  7901, 28034, -2338,
	 -829,  7896, 28038, -2337,  -828,  7891, 28042, -2337,  -827,  7886, 28046, -2337,  -827,  7881, 28050, -2336,
	 -826,  7876, 28054, -2336,  -825,  7871, 28058, -2336,  -825,  7866, 28062, -2335,  -824,  7861, 28066, -2335,
	 -823,  7856, 28070, -2335,  -823,  7851, 28074, -2334,  -822,  7846, 28078, -2334,  -822,  7841, 28083, -2334,
	 -821,  7836, 28086, -2333,  -820,  7832, 28089, -2333,  -820,  7827, 28094, -2333,  -819,  7822, 28097, -2332,
	 -818,  7817, 28101, -2332,  -818,  7812, 28106, -2332,  -817,  7807, 28109, -2331,  -816,  7802, 28113, -2331,
	 -816,  7797, 28118, -2331,  -815,  7792, 28121, -2330,  -815,  7787, 28126, -2330,  -814,  7782, 28130, -2330,
	 -813,  7777, 28133, -2329,  -813,  7772, 28138, -2329,  -812,  7767, 28142, -2329,  -811,  7762, 28145, -2328,
	 -811,  7757, 28150, -2328,  -810,  7753, 28153, -2328,  -810,  7748, 28157, -2327,  -809,  7743, 28161, -2327,
	 -808,  7738, 28165, -2327,  -808,  7733, 28169, -2326,  -807,  7728, 28173, -2326,  -806,  7723, 28177, -2326,
	 -806,  7718, 28181, -2325,  -805,  7713, 28185, -2325,  -804,  7708, 28189, -2325,  -804,  7703, 28193, -2324,
	 -803,  7698, 28197, -2324,  -803,  7693, 28202, -2324,  -802,  7688, 28205, -2323,  -801,  7684, 28208, -2323,
	 -801,  7679, 28213, -2323,  -800,  7674, 28216, -2322,  -799,  7669, 28220, -2322,  -799,  7664, 28225, -2322,
	 -798,  7659, 28228, -2321,  -798,  7654, 28233, -2321,  -797,  7649, 28237, -2321,  -796,  7644, 28240, -2320,
	 -796,  7639, 28245, -2320,  -795,  7634, 28249, -2320,  -794,  7629, 28252, -2319,  -794,  7625, 28256, -2319,
	 -793,  7620, 28260, -2319,  -792,  7615, 28263, -2318,  -792,  7610, 28268, -2318,  -791,  7605, 28271, -2317,
	 -791,  7600, 28276, -2317,  -790,  7595, 28280, -2317,  -789,  7590, 28283, -2316,  -789,  7585, 28288, -2316,
	 -788,  7580, 28292, -2316,  -787,  7576, 28294, -2315,  -787,  7571, 28299, -2315,  -786,  7566, 28303, -2315,
	 -786,  7561, 28307, -2314,  -785,  7556, 28311, -2314,  -784,  7551, 28315, -2314,  -784,  7546, 28319, -2313,
	 -783,  7541, 28323, -2313,  -782,  7536, 28326, -2312,  -782,  7531, 28331, -2312,  -781,  7527, 28334, -2312,
	 -781,  7522, 28338, -2311,  -780,  7517, 28342, -2311,  -779,  7512, 28346, -2311,  -779,  7507, 28350, -2310,
	 -778,  7502, 28354, -2310,  -777,  7497, 28358, -2310,  -777,  7492, 28362, -2309,  -776,  7487, 28366, -2309,
	 -776,  7483, 28369, -2308,  -775,  7478, 28373, -2308,  -774,  7473, 28377, -2308,  -774,  7468, 28381, -2307,
	 -773,  7463, 28385, -2307,  -772,  7458, 28389, -2307,  -772,  7453, 28393, -2306,  -771,  7448, 28397, -2306,
	 -771,  7444, 28400, -2305,  -770,  7439, 28404, -2305,  -769,  7434, 28408, -2305,  -769,  7429, 28412, -2304,
	 -768,  7424, 28416, -2304,  -767,  7419, 28420, -2304,  -767,  7414, 28424, -2303,  -766,  7409, 28428, -2303,
	 -766,  7405, 28431, -2302,  -765,  7400, 28435, -2302,  -764,  7395, 28439, -2302,  -764,  7390, 28443, -2301,
	 -763,  7385, 28447, -2301,  -762,  7380, 28451, -2301,  -762,  7375, 28455, -2300,  -761,  7370, 28459, -2300,
	 -761,  7366, 28462, -2299,  -760,  7361, 28466, -2299,  -759,  7356, 28470, -2299,  -759,  7351, 28474, -2298,
	 -758,  7346, 28478, -2298,  -757,  7341, 28482, -2298,  -757,  7336, 28486, -2297,  -756,  7332, 28489, -2297,
	 -756,  7327, 28493, -2296,  -755,  7322, 28497, -2296,  -754,  7317, 28501, -2296,  -754,  7312, 28505, -2295,
	 -753,  7307, 28509, -2295,  -752,  7302, 28512, -2294,  -752,  7298, 28516, -2294,  -751,  7293, 28520, -2294,
	 -751,  7288, 28524, -2293,  -750,  7283, 28528, -2293,  -749,  7278, 28531, -2292,  -749,  7273, 28536, -2292,
	 -748,  7268, 28540, -2292,  -747,  7264, 28542, -2291,  -747,  7259, 28547, -2291,  -746,  7254, 28550, -2290,
	 -746,  7249, 28555, -2290,  -745,  7244, 28559, -2290,  -744,  7239, 28562, -2289,  -744,  7235, 28566, -2289,
	 -743,  7230, 28570, -2289,  -742,  7225, 28573, -2288,  -742,  7220, 28578, -2288,  -741,  7215, 28581, -2287,
	 -741,  7210, 28586, -2287,  -740,  7205, 28590, -2287,  -739,  7201, 28592, -2286,  -739,  7196, 28597, -2286,
	 -738,  7191, 28600, -2285,  -738,  7186, 28605, -2285,  -737,  7181, 28608, -2284,  -736,  7176, 28612, -2284,
	 -736,  7172, 28616, -2284,  -735,  7167, 28619, -2283,  -734,  7162, 28623, -2283,  -734,  7157, 28627, -2282,
	 -733,  7152, 28631, -2282,  -733,  7148, 28635, -2282,  -732,  7143, 28638, -2281,  -731,  7138, 28642, -2281,
	 -731,  7133, 28646, -2280,  -730,  7128, 28650, -2280,  -729,  7123, 28654, -2280,  -729,  7119, 28657, -2279,
	 -728,  7114, 28661, -2279,  -728,  7109, 28665, -2278,  -727,  7104, 28669, -2278,  -726,  7099, 28672, -2277,
	 -726,  7095, 28676, -2277,  -725,  7090, 28680, -2277,  -725,  7085, 28684, -2276,  -724,  7080, 28688, -2276,
	 -723,  7075, 28691, -2275,  -723,  7070, 28696, -2275,  -722,  7066, 28699, -2275,  -721,  7061, 28702, -2274,
	 -721,  7056, 28707, -2274,  -720,  7051, 28710, -2273,  -720,  7046, 28715, -2273,  -719,  7042, 28717, -2272,
	 -718,  7037, 28721, -2272,  -718,  7032, 28726, -2272,  -717,  7027, 28729, -2271,  -717,  7022, 28734, -2271,
	 -716,  7018, 28736, -2270,  -715,  7013, 28740, -2270,  -715,  7008, 28744, -2269,  -714,  7003, 28748, -2269,
	 -713,  6998, 28752, -2269,  -713,  6994, 28755, -2268,  -712,  6989, 28759, -2268,  -712,  6984, 28763, -2267,
	 -711,  6979, 28767, -2267,  -710,  6974, 28770, -2266,  -710,  6970, 28774, -2266,  -709,  6965, 28778, -2266,
	 -709,  6960, 28782, -2265,  -708,  6955, 28786, -2265,  -707,  6950, 28789, -2264,  -707,  6946, 28793, -2264,
	 -706,  6941, 28796, -2263,  -706,  6936, 28801, -2263,  -705,  6931, 28805, -2263,  -704,  6927, 28807, -2262,
	 -704,  6922, 28812, -2262,  -703,  6917, 28815, -2261,  -702,  6912, 28819, -2261,  -702,  6907, 28823, -2260,
	 -701,  6903, 28826, -2260,  -701,  6898, 28830, -2259,  -700,  6893, 28834, -2259,  -699,  6888, 28838, -2259,
	 -699,  6883, 28842, -2258,  -698,  6879, 28845, -2258,  -698,  6874, 28849, -2257,  -697,  6869, 28853, -2257,
	 -696,  6864, 28856, -2256,  -696,  6860, 28860, -2256,  -695,  6855, 28863, -2255,  -695,  6850, 28868, -2255,
	 -694,  6845, 28872, -2255,  -693,  6841, 28874, -2254,  -693,  6836, 28879, -2254,  -692,  6831, 28882, -2253,
	 -691,  6826, 28886, -2253,  -691,  6821, 28890, -2252,  -690,  6817, 28893, -2252,  -690,  6812, 28897, -2251,
	 -689,  6807, 28901, -2251,  -688,  6802, 28904, -2250,  -688,  6798, 28908, -2250,  -687,  6793, 28912, -2250,
	 -687,  6788, 28916, -2249,  -686,  6783, 28920, -2249,  -685,  6779, 28922, -2248,  -685,  6774, 28927, -2248,
	 -684,  6769, 28930, -2247,  -684,  6764, 28935, -2247,  -683,  6760, 28937, -2246,  -682,  6755, 28941, -2246,
	 -682,  6750, 28945, -2245,  -681,  6745, 28949, -2245,  -681,  6741, 28953, -2245,  -680,  6736, 28956, -2244,
	 -679,  6731, 28960, -2244,  -679,  6726, 28964, -2243,  -678,  6722, 28967, -2243,  -678,  6717, 28971, -2242,
	 -677,  6712, 28975, -2242,  -676,  6707, 28978, -2241,  -676,  6703, 28982, -2241,  -675,  6698, 28985, -2240,
	 -675,  6693, 28990, -2240,  -674,  6688, 28993, -2239,  -673,  6684, 28996, -2239,  -673,  6679, 29000, -2238,
	 -672,  6674, 29004, -2238,  -671,  6670, 29006, -2237,  -671,  6665, 29011, -2237,  -670,  6660, 29015, -2237,
	 -670,  6655, 29019, -2236,  -669,  6651, 29022, -2236,  -668,  6646, 29025, -2235,  -668,  6641, 29030, -2235,
	 -667,  6636, 29033, -2234,  -667,  6632, 29037, -2234,  -666,  6627, 29040, -2233,  -665,  6622, 29044, -2233,
	 -665,  6617, 29048, -2232,  -664,  6613, 29051, -2232,  -664,  6608, 29055, -2231,  -663,  6603, 29059, -2231,
	 -662,  6599, 29061, -2230,  -662,  6594, 29066, -2230,  -661,  6589, 29069, -2229,  -661,  6584, 29074, -2229,
	 -660,  6580, 29076, -2228,  -659,  6575, 29080, -2228,  -659,  6570, 29084, -2227,  -658,  6566, 29087, -2227,
	 -658,  6561, 29091, -2226,  -657,  6556, 29095, -2226,  -656,  6551, 29098, -2225,  -656,  6547, 29102, -2225,
	 -655,  6542, 29105, -2224,  -655,  6537, 29110, -2224,  -654,  6533, 29113, -2224,  -653,  6528, 29116, -2223,
	 -653,  6523, 29121, -2223,  -652,  6518, 29124, -2222,  -652,  6514, 29128, -2222,  -651,  6509, 29131, -2221,
	 -650,  6504, 29135, -2221,  -650,  6500, 29138, -2220,  -649,  6495, 29142, -2220,  -649,  6490, 29146, -2219,
	 -648,  6486, 29149, -2219,  -647,  6481, 29152, -2218,  -647,  6476, 29157, -2218,  -646,  6471, 29160, -2217,
	 -646,  6467, 29164, -2217,  -645,  6462, 29167, -2216,  -644,  6457, 29171, -2216,  -644,  6453, 29174, -2215,
	 -643,  6448, 29178, -2215,  -643,  6443, 29182, -2214,  -642,  6439, 29185, -2214,  -642,  6434, 29189, -2213,
	 -641,  6429, 29193, -2213,  -640,  6425, 29195, -2212,  -640,  6420, 29200, -2212,  -639,  6415, 29203, -2211,
	 -639,  6411, 29207, -2211,  -638,  6406, 29210, -2210,  -637,  6401, 29213, -2209,  -637,  6397, 29217, -2209,
	 -636,  6392, 29220, -2208,  -636,  6387, 29225, -2208,  -635,  6382, 29228, -2207,  -634,  6378, 29231, -2207,
	 -634,  6373, 29235, -2206,  -633,  6368, 29239, -2206,  -633,  6364, 29242, -2205,  -632,  6359, 29246, -2205,
	 -631,  6354, 29249, -2204,  -631,  6350, 29253, -2204,  -630,  6345, 29256, -2203,  -630,  6340, 29261, -2203,
	 -629,  6336, 29263, -2202,  -628,  6331, 29267, -2202,  -628,  6326, 29271, -2201,  -627,  6322, 29274, -2201,
	 -627,  6317, 29278, -2200,  -626,  6312, 29282, -2200,  -625,  6308, 29284, -2199,  -625,  6303, 29289, -2199,
	 -624,  6298, 29292, -2198,  -624,  6294, 29296, -2198,  -623,  6289, 29299, -2197,  -623,  6285, 29303, -2197,
	 -622,  6280, 29306, -2196,  -621,  6275, 29309, -2195,  -621,  6271, 29313, -2195,  -620,  6266, 29316, -2194,
	 -620,  6261, 29321, -2194,  -619,  6257, 29323, -2193,  -618,  6252, 29327, -2193,  -618,  6247, 29331, -2192,
	 -617,  6243, 29334, -2192,  -617,  6238, 29338, -2191,  -616,  6233, 29342, -2191,  -615,  6229, 29344, -2190,
	 -615,  6224, 29349, -2190,  -614,  6219, 29352, -2189,  -614,  6215, 29356, -2189,  -613,  6210, 29359, -2188,
	 -613,  6206, 29363, -2188,  -612,  6201, 29366, -2187,  -611,  6196, 29369, -2186,  -611,  6192, 29373, -2186,
	 -610,  6187, 29376, -2185,  -610,  6182, 29381, -2185,  -609,  6178, 29383, -2184,  -608,  6173, 29387, -2184,
	 -608,  6168, 29391, -2183,  -607,  6164, 29394, -2183,  -607,  6159, 29398, -2182,  -606,  6155, 29401, -2182,
	 -605,  6150, 29404, -2181,  -605,  6145, 29408, -2180,  -604,  6141, 29411, -2180,  -604,  6136, 29415, -2179,
	 -603,  6131, 29419, -2179,  -603,  6127, 29422, -2178,  -602,  6122, 29426, -2178,  -601,  6118, 29428, -2177,
	 -601,  6113, 29433, -2177,  -600,  6108, 29436, -2176,  -600,  6104, 29440, -2176,  -599,  6099, 29443, -2175,
	 -598,  6094, 29446, -2174,  -598,  6090, 29450, -2174,  -597,  6085, 29453, -2173,  -597,  6081, 29457, -2173,
	 -596,  6076, 29460, -2172,  -596,  6071, 29465, -2172,  -595,  6067, 29467, -2171,  -594,  6062, 29471, -2171,
	 -594,  6058, 29474, -2170,  -593,  6053, 29477, -2169,  -593,  6048, 29482, -2169,  -592,  6044, 29484, -2168,
	 -591,  6039, 29488, -2168,  -591,  6035, 29491, -2167,  -590,  6030, 29495, -2167,  -590,  6025, 29499, -2166,
	 -589,  6021, 29501, -2165,  -589,  6016, 29506, -2165,  -588,  6012, 29508, -2164,  -587,  6007, 29512, -2164,
	 -587,  6002, 29516, -2163,  -586,  5998, 29519, -2163,  -586,  5993, 29523, -2162,  -585,  5989, 29526, -2162,
	 -584,  5984, 29529, -2161,  -584,  5979, 29533, -2160,  -583,  5975, 29536, -2160,  -583,  5970, 29540, -2159,
	 -582,  5966, 29543, -2159,  -582,  5961, 29547, -2158,  -581,  5956, 29551, -2158,  -580,  5952, 29553, -2157,
	 -580,  5947, 29557, -2156,  -579,  5943, 29560, -2156,  -579,  5938, 29564, -2155,  -578,  5934, 29567, -2155,
	 -578,  5929, 29571, -2154,  -577,  5924, 29575, -2154,  -576,  5920, 29577, -2153,  -576,  5915, 29581, -2152,
	 -575,  5911, 29584, -2152,  -575,  5906, 29588, -2151,  -574,  5902, 29591, -2151,  -573,  5897, 29594, -2150,
	 -573,  5892, 29598, -2149,  -572,  5888, 29601, -2149,  -572,  5883, 29605, -2148,  -571,  5879, 29608, -2148,
	 -571,  5874, 29612, -2147,  -570,  5870, 29615, -2147,  -569,  5865, 29618, -2146,  -569,  5860, 29622, -2145,
	 -568,  5856, 29625, -2145,  -568,  5851, 29629, -2144,  -567,  5847, 29632, -2144,  -567,  5842, 29636, -2143,
	 -566,  5838, 29638, -2142,  -565,  5833, 29642, -2142,  -565,  5829, 29645, -2141,  -564,  5824, 29649, -2141,
	 -564,  5819, 29653, -2140,  -563,  5815, 29655, -2139,  -563,  5810, 29660, -2139,  -562,  5806, 29662, -2138,
	 -561,  5801, 29666, -2138,  -561,  5797, 29669, -2137,  -560,  5792, 29672, -2136,  -560,  5788, 29676, -2136,
	 -559,  5783, 29679, -2135,  -559,  5778, 29684, -2135,  -558,  5774, 29686, -2134,  -557,  5769, 29689, -2133,
	 -557,  5765, 29693, -2133,  -556,  5760, 29696, -2132,  -556,  5756, 29700, -2132,  -555,  5751, 29703, -2131,
	 -555,  5747, 29706, -2130,  -554,  5742, 29710, -2130,  -553,  5738, 29712, -2129,  -553,  5733, 29717, -2129,
	 -552,  5729, 29719, -2128,  -552,  5724, 29723, -2127,  -551,  5719, 29727, -2127,  -551,  5715, 29730, -2126,
	 -550,  5710, 29734, -2126,  -549,  5706, 29736, -2125,  -549,  5701, 29740, -2124,  -548,  5697, 29743, -2124,
	 -548,  5692, 29747, -2123,  -547,  5688, 29750, -2123,  -547,  5683, 29754, -2122,  -546,  5679, 29756, -2121,
	 -545,  5674, 29760, -2121,  -545,  5670, 29763, -2120,  -544,  5665, 29767, -2120,  -544,  5661, 29770, -2119,
	 -543,  5656, 29773, -2118,  -543,  5652, 29777, -2118,  -542,  5647, 29780, -2117,  -542,  5643, 29783, -2116,
	 -541,  5638, 29787, -2116,  -540,  5634, 29789, -2115,  -540,  5629, 29794, -2115,  -539,  5625, 29796, -2114,
	 -539,  5620, 29800, -2113,  -538,  5616, 29803, -2113,  -538,  5611, 29807, -2112,  -537,  5607, 29809, -2111,
	 -536,  5602, 29813, -2111,  -536,  5598, 29816, -2110,  -535,  5593, 29820, -2110,  -535,  5589, 29823, -2109,
	 -534,  5584, 29826, -2108,  -534,  5580, 29830, -2108,  -533,  5575, 29833, -2107,  -532,  5571, 29835, -2106,
	 -532,  5566, 29840, -2106,  -531,  5562, 29842, -2105,  -531,  5557, 29847, -2105,  -530,  5553, 29849, -2104,
	 -530,  5548, 29853, -2103,  -529,  5544, 29856, -2103,  -529,  5539, 29860, -2102,  -528,  5535, 29862, -2101,
	 -527,  5530, 29866, -2101,  -527,  5526, 29869, -2100,  -526,  5521, 29872, -2099,  -526,  5517, 29876, -2099,
	 -525,  5512, 29879, -2098,  -525,  5508, 29883, -2098,  -524,  5503, 29886, -2097,  -524,  5499, 29889, -2096,
	 -523,  5494, 29893, -2096,  -522,  5490, 29895, -2095,  -522,  5485, 29899, -2094,  -521,  5481, 29902, -2094,
	 -521,  5476, 29906, -2093,  -520,  5472, 29908, -2092,  -520,  5467, 29913, -2092,  -519,  5463, 29915, -2091,
	 -518,  5458, 29918, -2090,  -518,  5454, 29922, -2090,  -517,  5450, 29924, -2089,  -517,  5445, 29929, -2089,
	 -516,  5441, 29931, -2088,  -516,  5436, 29935, -2087,  -515,  5432, 29938, -2087,  -515,  5427, 29942, -2086,
	 -514,  5423, 29944, -2085,  -513,  5418, 29948, -2085,  -513,  5414, 29951, -2084,  -512,  5409, 29954, -2083,
	 -512,  5405, 29958, -2083,  -511,  5400, 29961, -2082,  -511,  5396, 29964, -2081,  -510,  5392, 29967, -2081,
	 -510,  5387, 29971, -2080,  -509,  5383, 29973, -2079,  -508,  5378, 29977, -2079,  -508,  5374, 29980, -2078,
	 -507,  5369, 29983, -2077,  -507,  5365, 29987, -2077,  -506,  5360, 29990, -2076,  -506,  5356, 29993, -2075,
	 -505,  5352, 29996, -2075,  -505,  5347, 30000, -2074,  -504,  5343, 30002, -2073,  -503,  5338, 30006, -2073,
	 -503,  5334, 30009, -2072,  -502,  5329, 30012, -2071,  -502,  5325, 30016, -2071,  -501,  5320, 30019, -2070,
	 -501,  5316, 30022, -2069,  -500,  5312, 30025, -2069,  -500,  5307, 30029, -2068,  -499,  5303, 30031, -2067,
	 -499,  5298, 30036, -2067,  -498,  5294, 30038, -2066,  -497,  5289, 30041, -2065,  -497,  5285, 30045, -2065,
	 -496,  5281, 30047, -2064,  -496,  5276, 30051, -2063,  -495,  5272, 30054, -2063,  -495,  5267, 30058, -2062,
	 -494,  5263, 30060, -2061,  -494,  5258, 30065, -2061,  -493,  5254, 30067, -2060,  -492,  5250, 30069, -2059,
	 -492,  5245, 30074, -2059,  -491,  5241, 30076, -2058,  -491,  5236, 30080, -2057,  -490,  5232, 30083, -2057,
	 -490,  5228, 30086, -2056,  -489,  5223, 30089, -2055,  -489,  5219, 30093, -2055,  -488,  5214, 30096, -2054,
	 -488,  5210, 30099, -2053,  -487,  5206, 30101, -2052,  -486,  5201, 30105, -2052,  -486,  5197, 30108, -2051,
	 -485,  5192, 30111, -2050,  -485,  5188, 30115, -2050,  -484,  5184, 30117, -2049,  -484,  5179, 30121, -2048,
	 -483,  5175, 30124, -2048,  -483,  5170, 30128, -2047,  -482,  5166, 30130, -2046,  -482,  5162, 30134, -2046,
	 -481,  5157, 30137, -2045,  -480,  5153, 30139, -2044,  -480,  5148, 30143, -2043,  -479,  5144, 30146, -2043,
	 -479,  5140, 30149, -2042,  -478,  5135, 30152, -2041,  -478,  5131, 30156, -2041,  -477,  5126, 30159, -2040,
	 -477,  5122, 30162, -2039,  -476,  5118, 30165, -2039,  -476,  5113, 30169, -2038,  -475,  5109, 30171, -2037,
	 -474,  5104, 30174, -2036,  -474,  5100, 30178, -2036,  -473,  5096, 30180, -2035,  -473,  5091, 30184, -2034,
	 -472,  5087, 30187, -2034,  -472,  5083, 30190, -2033,  -471,  5078, 30193, -2032,  -471,  5074, 30197, -2032,
	 -470,  5069, 30200, -2031,  -470,  5065, 30203, -2030,  -469,  5061, 30205, -2029,  -469,  5056, 30210, -2029,
	 -468,  5052, 30212, -2028,  -467,  5048, 30214, -2027,  -467,  5043, 30219, -2027,  -466,  5039, 30221, -2026,
	 -466,  5035, 30224, -2025,  -465,  5030, 30227, -2024,  -465,  5026, 30231, -2024,  -464,  5021, 30234, -2023,
	 -464,  5017, 30237, -2022,  -463,  5013, 30240, -2022,  -463,  5008, 30244, -2021,  -462,  5004, 30246, -2020,
	 -462,  5000, 30249, -2019,  -461,  4995, 30253, -2019,  -460,  4991, 30255, -2018,  -460,  4987, 30258, -2017,
	 -459,  4982, 30262, -2017,  -459,  4978, 30265, -2016,  -458,  4974, 30267, -2015,  -458,  4969, 30271, -2014,
	 -457,  4965, 30274, -2014,  -457,  4961, 30277, -2013,  -456,  4956, 30280, -2012,  -456,  4952, 30283, -2011,
	 -455,  4948, 30286, -2011,  -455,  4943, 30290, -2010,  -454,  4939, 30292, -2009,  -454,  4934, 30297, -2009,
	 -453,  4930, 30299, -2008,  -452,  4926, 30301, -2007,  -452,  4921, 30305, -2006,  -451,  4917, 30308, -2006,
	 -451,  4913, 30311, -2005,  -450,  4909, 30313, -2004,  -450,  4904, 30317, -2003,  -449,  4900, 30320, -2003,
	 -449,  4896, 30323, -2002,  -448,  4891, 30326, -2001,  -448,  4887, 30329, -2000,  -447,  4883, 30332, -2000,
	 -447,  4878, 30336, -1999,  -446,  4874, 30338, -1998,  -446,  4870, 30342, -1998,  -445,  4865, 30345, -1997,
	 -444,  4861, 30347, -1996,  -444,  4857, 30350, -1995,  -443,  4852, 30354, -1995,  -443,  4848, 30357, -1994,
	 -442,  4844, 30359, -1993,  -442,  4839, 30363, -1992,  -441,  4835, 30366, -1992,  -441,  4831, 30369, -1991,
	 -440,  4826, 30372, -1990,  -440,  4822, 30375, -1989,  -439,  4818, 30378, -1989,  -439,  4814, 30381, -1988,
	 -438,  4809, 30384, -1987,  -438,  4805, 30387, -1986,  -437,  4801, 30390, -1986,  -437,  4796, 30394, -1985,
	 -436,  4792, 30396, -1984,  -436,  4788, 30399, -1983,  -435,  4783, 30403, -1983,  -434,  4779, 30405, -1982,
	 -434,  4775, 30408, -1981,  -433,  4771, 30410, -1980,  -433,  4766, 30415, -1980,  -432,  4762, 30417, -1979,
	 -432,  4758, 30420, -1978,  -431,  4753, 30423, -1977,  -431,  4749, 30427, -1977,  -430,  4745, 30429, -1976,
	 -430,  4741, 30432, -1975,  -429,  4736, 30435, -1974,  -429,  4732, 30438, -1973,  -428,  4728, 30441, -1973,
	 -428,  4723, 30445, -1972,  -427,  4719, 30447, -1971,  -427,  4715, 30450, -1970,  -426,  4711, 30453, -1970,
	 -426,  4706, 30457, -1969,  -425,  4702, 30459, -1968,  -425,  4698, 30462, -1967,  -424,  4693, 30466, -1967,
	 -423,  4689, 30468, -1966,  -423,  4685, 30471, -1965,  -422,  4681, 30473, -1964,  -422,  4676, 30477, -1963,
	 -421,  4672, 30480, -1963,  -421,  4668, 30483, -1962,  -420,  4664, 30485, -1961,  -420,  4659, 30489, -1960,
	 -419,  4655, 30492, -1960,  -419,  4651, 30495, -1959,  -418,  4647, 30497, -1958,  -418,  4642, 30501, -1957,
	 -417,  4638, 30503, -1956,  -417,  4634, 30507, -1956,  -416,  4630, 30509, -1955,  -416,  4625, 30513, -1954,
	 -415,  4621, 30515, -1953,  -415,  4617, 30519, -1953,  -414,  4613, 30521, -1952,  -414,  4608, 30525, -1951,
	 -413,  4604, 30527, -1950,  -413,  4600, 30530, -1949,  -412,  4596, 30533, -1949,  -412,  4591, 30537, -1948,
	 -411,  4587, 30539, -1947,  -411,  4583, 30542, -1946,  -410,  4579, 30545, -1946,  -410,  4574, 30549, -1945,
	 -409,  4570, 30551, -1944,  -408,  4566, 30553, -1943,  -408,  4562, 30556, -1942,  -407,  4557, 30560, -1942,
	 -407,  4553, 30563, -1941,  -406,  4549, 30565, -1940,  -406,  4545, 30568, -1939,  -405,  4540, 30571, -1938,
	 -405,  4536, 30575, -1938,  -404,  4532, 30577, -1937,  -404,  4528, 30580, -1936,  -403,  4524, 30582, -1935,
	 -403,  4519, 30586, -1934,  -402,  4515, 30589, -1934,  -402,  4511, 30592, -1933,  -401,  4507, 30594, -1932,
	 -401,  4502, 30598, -1931,  -400,  4498, 30600, -1930,  -400,  4494, 30604, -1930,  -399,  4490, 30606, -1929,
	 -399,  4486, 30609, -1928,  -398,  4481, 30612, -1927,  -398,  4477, 30615, -1926,  -397,  4473, 30618, -1926,
	 -397,  4469, 30621, -1925,  -396,  4465, 30623, -1924,  -396,  4460, 30627, -1923,  -395,  4456, 30629, -1922,
	 -395,  4452, 30633, -1922,  -394,  4448, 30635, -1921,  -394,  4443, 30639, -1920,  -393,  4439, 30641, -1919,
	 -393,  4435, 30644, -1918,  -392,  4431, 30646, -1917,  -392,  4427, 30650, -1917,  -391,  4423, 30652, -1916,
	 -391,  4418, 30656, -1915,  -390,  4414, 30658, -1914,  -390,  4410, 30661, -1913,  -389,  4406, 30664, -1913,
	 -389,  4402, 30667, -1912,  -388,  4397, 30670, -1911,  -388,  4393, 30673, -1910,  -387,  4389, 30675, -1909,
	 -387,  4385, 30678, -1908,  -386,  4381, 30681, -1908,  -386,  4376, 30685, -1907,  -385,  4372, 30687, -1906,
	 -385,  4368, 30690, -1905,  -384,  4364, 30692, -1904,  -384,  4360, 30695, -1903,  -383,  4356, 30698, -1903,
	 -383,  4351, 30702, -1902,  -382,  4347, 30704, -1901,  -382,  4343, 30707, -1900,  -381,  4339, 30709, -1899,
	 -381,  4335, 30713, -1899,  -380,  4331, 30715, -1898,  -380,  4326, 30719, -1897,  -379,  4322, 30721, -1896,
	 -379,  4318, 30724, -1895,  -378,  4314, 30726, -1894,  -378,  4310, 30730, -1894,  -377,  4306, 30732, -1893,
	 -377,  4301, 30736, -1892,  -376,  4297, 30738, -1891,  -376,  4293, 30741, -1890,  -375,  4289, 30743, -1889,
	 -375,  4285, 30746, -1888,  -374,  4281, 30749, -1888,  -374,  4276, 30753, -1887,  -373,  4272, 30755, -1886,
	 -373,  4268, 30758, -1885,  -372,  4264, 30760, -1884,  -372,  4260, 30763, -1883,  -371,  4256, 30766, -1883,
	 -371,  4252, 30769, -1882,  -370,  4247, 30772, -1881,  -370,  4243, 30775, -1880,  -369,  4239, 30777, -1879,
	 -369,  4235, 30780, -1878,  -368,  4231, 30783, -1878,  -368,  4227, 30786, -1877,  -367,  4223, 30788, -1876,
	 -367,  4218, 30792, -1875,  -366,  4214, 30794, -1874,  -366,  4210, 30797, -1873,  -365,  4206, 30799, -1872,
	 -365,  4202, 30803, -1872,  -364,  4198, 30805, -1871,  -364,  4194, 30808, -1870,  -363,  4189, 30811, -1869,
	 -363,  4185, 30814, -1868,  -362,  4181, 30816, -1867,  -362,  4177, 30819, -1866,  -361,  4173, 30822, -1866,
	 -361,  4169, 30825, -1865,  -360,  4165, 30827, -1864,  -360,  4161, 30830, -1863,  -359,  4156, 30833, -1862,
	 -359,  4152, 30836, -1861,  -358,  4148, 30838, -1860,  -358,  4144, 30841, -1859,  -357,  4140, 30844, -1859,
	 -357,  4136, 30847, -1858,  -356,  4132, 30849, -1857,  -356,  4128, 30852, -1856,  -355,  4124, 30854, -1855,
	 -355,  4119, 30858, -1854,  -354,  4115, 30860, -1853,  -354,  4111, 30864, -1853,  -353,  4107, 30866, -1852,
	 -353,  4103, 30869, -1851,  -352,  4099, 30871, -1850,  -352,  4095, 30874, -1849,  -351,  4091, 30876, -1848,
	 -351,  4087, 30879, -1847,  -351,  4083, 30882, -1846,  -350,  4079, 30885, -1846,  -350,  4074, 30889, -1845,
	 -349,  4070, 30891, -1844,  -349,  4066, 30894, -1843,  -348,  4062, 30896, -1842,  -348,  4058, 30899, -1841,
	 -347,  4054, 30901, -1840,  -347,  4050, 30904, -1839,  -346,  4046, 30907, -1839,  -346,  4042, 30910, -1838,
	 -345,  4038, 30912, -1837,  -345,  4034, 30915, -1836,  -344,  4029, 30918, -1835,  -344,  4025, 30921, -1834,
	 -343,  4021, 30923, -1833,  -343,  4017, 30926, -1832,  -342,  4013, 30928, -1831,  -342,  4009, 30932, -1831,
	 -341,  4005, 30934, -1830,  -341,  4001, 30937, -1829,  -340,  3997, 30939, -1828,  -340,  3993, 30942, -1827,
	 -339,  3989, 30944, -1826,  -339,  3985, 30947, -1825,  -338,  3981, 30949, -1824,  -338,  3977, 30952, -1823,
	 -338,  3973, 30956, -1823,  -337,  3968, 30959, -1822,  -337,  3964, 30962, -1821,  -336,  3960, 30964, -1820,
	 -336,  3956, 30967, -1819,  -335,  3952, 30969, -1818,  -335,  3948, 30972, -1817,  -334,  3944, 30974, -1816,
	 -334,  3940, 30977, -1815,  -333,  3936, 30979, -1814,  -333,  3932, 30982, -1813,  -332,  3928, 30985, -1813,
	 -332,  3924, 30988, -1812,  -331,  3920, 30990, -1811,  -331,  3916, 30993, -1810,  -330,  3912, 30995, -1809,
	 -330,  3908, 30998, -1808,  -329,  3904, 31000, -1807,  -329,  3900, 31003, -1806,  -328,  3896, 31005, -1805,
	 -328,  3892, 31008, -1804,  -328,  3888, 31012, -1804,  -327,  3883, 31015, -1803,  -327,  3879, 31018, -1802,
	 -326,  3875, 31020, -1801,  -326,  3871, 31023, -1800,  -325,  3867, 31025, -1799,  -325,  3863, 31028, -1798,
	 -324,  3859, 31030, -1797,  -324,  3855, 31033, -1796,  -323,  3851, 31035, -1795,  -323,  3847, 31038, -1794,
	 -322,  3843, 31040, -1793,  -322,  3839, 31044, -1793,  -321,  3835, 31046, -1792,  -321,  3831, 31049, -1791,
	 -320,  3827, 31051, -1790,  -320,  3823, 31054, -1789,  -320,  3819, 31057, -1788,  -319,  3815, 31059, -1787,
	 -319,  3811, 31062, -1786,  -318,  3807, 31064, -1785,  -318,  3803, 31067, -1784,  -317,  3799, 31069, -1783,
	 -317,  3795, 31072, -1782,  -316,  3791, 31074, -1781,  -316,  3787, 31077, -1780,  -315,  3783, 31080, -1780,
	 -315,  3779, 31083, -1779,  -314,  3775, 31085, -1778,  -314,  3771, 31088, -1777,  -313,  3767, 31090, -1776,
	 -313,  3763, 31093, -1775,  -313,  3759, 31096, -1774,  -312,  3755, 31098, -1773,  -312,  3751, 31101, -1772,
	 -311,  3747, 31103, -1771,  -311,  3743, 31106, -1770,  -310,  3739, 31108, -1769,  -310,  3735, 31111, -1768,
	 -309,  3731, 31113, -1767,  -309,  3727, 31116, -1766,  -308,  3723, 31118, -1765,  -308,  3719, 31122, -1765,
	 -307,  3715, 31124, -1764,  -307,  3711, 31127, -1763,  -306,  3707, 31129, -1762,  -306,  3703, 31132, -1761,
	 -306,  3699, 31135, -1760,  -305,  3695, 31137, -1759,  -305,  3691, 31140, -1758,  -304,  3687, 31142, -1757,
	 -304,  3683, 31145, -1756,  -303,  3679, 31147, -1755,  -303,  3676, 31149, -1754,  -302,  3672, 31151, -1753,
	 -302,  3668, 31154, -1752,  -301,  3664, 31156, -1751,  -301,  3660, 31159, -1750,  -301,  3656, 31162, -1749,
	 -300,  3652, 31164, -1748,  -300,  3648, 31167, -1747,  -299,  3644, 31169, -1746,  -299,  3640, 31172, -1745,
	 -298,  3636, 31175, -1745,  -298,  3632, 31178, -1744,  -297,  3628, 31180, -1743,  -297,  3624, 31183, -1742,
	 -296,  3620, 31185, -1741,  -296,  3616, 31188, -1740,  -296,  3612, 31191, -1739,  -295,  3608, 31193, -1738,
	 -295,  3604, 31196, -1737,  -294,  3600, 31198, -1736,  -294,  3596, 31201, -1735,  -293,  3593, 31202, -1734,
	 -293,  3589, 31205, -1733,  -292,  3585, 31207, -1732,  -292,  3581, 31210, -1731,  -291,  3577, 31212, -1730,
	 -291,  3573, 31215, -1729,  -291,  3569, 31218, -1728,  -290,  3565, 31220, -1727,  -290,  3561, 31223, -1726,
	 -289,  3557, 31225, -1725,  -289,  3553, 31228, -1724,  -288,  3549, 31230, -1723,  -288,  3545, 31233, -1722,
	 -287,  3541, 31235, -1721,  -287,  3538, 31237, -1720,  -286,  3534, 31239, -1719,  -286,  3530, 31242, -1718,
	 -286,  3526, 31245, -1717,  -285,  3522, 31247, -1716,  -285,  3518, 31250, -1715,  -284,  3514, 31252, -1714,
	 -284,  3510, 31255, -1713,  -283,  3506, 31257, -1712,  -283,  3502, 31260, -1711,  -282,  3498, 31262, -1710,
	 -282,  3495, 31264, -1709,  -282,  3491, 31267, -1708,  -281,  3487, 31270, -1708,  -281,  3483, 31273, -1707,
	 -280,  3479, 31275, -1706,  -280,  3475, 31278, -1705,  -279,  3471, 31280, -1704,  -279,  3467, 31283, -1703,
	 -278,  3463, 31285, -1702,  -278,  3459, 31288, -1701,  -278,  3456, 31290, -1700,  -277,  3452, 31292, -1699,
	 -277,  3448, 31295, -1698,  -276,  3444, 31297, -1697,  -276,  3440, 31300, -1696,  -275,  3436, 31302, -1695,
	 -275,  3432, 31305, -1694,  -274,  3428, 31307, -1693,  -274,  3424, 31310, -1692,  -274,  3421, 31312, -1691,
	 -273,  3417, 31314, -1690,  -273,  3413, 31317, -1689,  -272,  3409, 31319, -1688,  -272,  3405, 31322, -1687,
	 -271,  3401, 31324, -1686,  -271,  3397, 31327, -1685,  -270,  3393, 31329, -1684,  -270,  3390, 31331, -1683,
	 -270,  3386, 31334, -1682,  -269,  3382, 31336, -1681,  -269,  3378, 31339, -1680,  -268,  3374, 31341, -1679,
	 -268,  3370, 31343, -1677,  -267,  3366, 31345, -1676,  -267,  3363, 31347, -1675,  -267,  3359, 31350, -1674,
	 -266,  3355, 31352, -1673,  -266,  3351, 31355, -1672,  -265,  3347, 31357, -1671,  -265,  3343, 31360, -1670,
	 -264,  3339, 31362, -1669,  -264,  3336, 31364, -1668,  -264,  3332, 31367, -1667,  -263,  3328, 31369, -1666,
	 -263,  3324, 31372, -1665,  -262,  3320, 31374, -1664,  -262,  3316, 31377, -1663,  -261,  3312, 31379, -1662,
	 -261,  3309, 31381, -1661,  -260,  3305, 31383, -1660,  -260,  3301, 31386, -1659,  -260,  3297, 31389, -1658,
	 -259,  3293, 31391, -1657,  -259,  3289, 31394, -1656,  -258,  3286, 31395, -1655,  -258,  3282, 31398, -1654,
	 -257,  3278, 31400, -1653,  -257,  3274, 31403, -1652,  -257,  3270, 31406, -1651,  -256,  3266, 31408, -1650,
	 -256,  3263, 31410, -1649,  -255,  3259, 31412, -1648,  -255,  3255, 31415, -1647,  -254,  3251, 31417, -1646,
	 -254,  3247, 31420, -1645,  -254,  3244, 31422, -1644,  -253,  3240, 31424, -1643,  -253,  3236, 31427, -1642,
	 -252,  3232, 31429, -1641,  -252,  3228, 31432, -1640,  -251,  3224, 31433, -1638,  -251,  3221, 31435, -1637,
	 -251,  3217, 31438, -1636,  -250,  3213, 31440, -1635,  -250,  3209, 31443, -1634,  -249,  3205, 31445, -1633,
	 -249,  3202, 31447, -1632,  -248,  3198, 31449, -1631,  -248,  3194, 31452, -1630,  -248,  3190, 31455, -1629,
	 -247,  3186, 31457, -1628,  -247,  3183, 31459, -1627,  -246,  3179, 31461, -1626,  -246,  3175, 31464, -1625,
	 -246,  3171, 31467, -1624,  -245,  3167, 31469, -1623,  -245,  3164, 31471, -1622,  -244,  3160, 31473, -1621,
	 -244,  3156, 31476, -1620,  -243,  3152, 31478, -1619,  -243,  3149, 31479, -1617,  -243,  3145, 31482, -1616,
	 -242,  3141, 31484, -1615,  -242,  3137, 31487, -1614,  -241,  3133, 31489, -1613,  -241,  3130, 31491, -1612,
	 -240,  3126, 31493, -1611,  -240,  3122, 31496, -1610,  -240,  3118, 31499, -1609,  -239,  3115, 31500, -1608,
	 -239,  3111, 31503, -1607,  -238,  3107, 31505, -1606,  -238,  3103, 31508, -1605,  -238,  3099, 31511, -1604,
	 -237,  3096, 31512, -1603,  -237,  3092, 31515, -1602,  -236,  3088, 31516, -1600,  -236,  3084, 31519, -1599,
	 -235,  3081, 31520, -1598,  -235,  3077, 31523, -1597,  -235,  3073, 31526, -1596,  -234,  3069, 31528, -1595,
	 -234,  3066, 31530, -1594,  -233,  3062, 31532, -1593,  -233,  3058, 31535, -1592,  -233,  3054, 31538, -1591,
	 -232,  3051, 31539, -1590,  -232,  3047, 31542, -1589,  -231,  3043, 31544, -1588,  -231,  3039, 31546, -1586,
	 -231,  3036, 31548, -1585,  -230,  3032, 31550, -1584,  -230,  3028, 31553, -1583,  -229,  3024, 31555, -1582,
	 -229,  3021, 31557, -1581,  -228,  3017, 31559, -1580,  -228,  3013, 31562, -1579,  -228,  3010, 31564, -1578,
	 -227,  3006, 31566, -1577,  -227,  3002, 31569, -1576,  -226,  2998, 31571, -1575,  -226,  2995, 31572, -1573,
	 -226,  2991, 31575, -1572,  -225,  2987, 31577, -1571,  -225,  2983, 31580, -1570,  -224,  2980, 31581, -1569,
	 -224,  2976, 31584, -1568,  -224,  2972, 31587, -1567,  -223,  2969, 31588, -1566,  -223,  2965, 31591, -1565,
	 -222,  2961, 31593, -1564,  -222,  2957, 31596, -1563,  -222,  2954, 31597, -1561,  -221,  2950, 31599, -1560,
	 -221,  2946, 31602, -1559,  -220,  2943, 31603, -1558,  -220,  2939, 31606, -1557,  -220,  2935, 31609, -1556,
	 -219,  2931, 31611, -1555,  -219,  2928, 31613, -1554,  -218,  2924, 31615, -1553,  -218,  2920, 31618, -1552,
	 -218,  2917, 31619, -1550,  -217,  2913, 31621, -1549,  -217,  2909, 31624, -1548,  -216,  2906, 31625, -1547,
	 -216,  2902, 31628, -1546,  -216,  2898, 31631, -1545,  -215,  2895, 31632, -1544,  -215,  2891, 31635, -1543,
	 -214,  2887, 31637, -1542,  -214,  2883, 31639, -1540,  -214,  2880, 31641, -1539,  -213,  2876, 31643, -1538,
	 -213,  2872, 31646, -1537,  -212,  2869, 31647, -1536,  -212,  2865, 31650, -1535,  -212,  2861, 31653, -1534,
	 -211,  2858, 31654, -1533,  -211,  2854, 31656, -1531,  -210,  2850, 31658, -1530,  -210,  2847, 31660, -1529,
	 -210,  2843, 31663, -1528,  -209,  2839, 31665, -1527,  -209,  2836, 31667, -1526,  -208,  2832, 31669, -1525,
	 -208,  2828, 31672, -1524,  -208,  2825, 31673, -1522,  -207,  2821, 31675, -1521,  -207,  2817, 31678, -1520,
	 -206,  2814, 31679, -1519,  -206,  2810, 31682, -1518,  -206,  2806, 31685, -1517,  -205,  2803, 31686, -1516,
	 -205,  2799, 31689, -1515,  -204,  2795, 31690, -1513,  -204,  2792, 31692, -1512,  -204,  2788, 31695, -1511,
	 -203,  2785, 31696, -1510,  -203,  2781, 31699, -1509,  -203,  2777, 31702, -1508,  -202,  2774, 31703, -1507,
	 -202,  2770, 31706, -1506,  -201,  2766, 31707, -1504,  -201,  2763, 31709, -1503,  -201,  2759, 31712, -1502,
	 -200,  2755, 31714, -1501,  -200,  2752, 31716, -1500,  -199,  2748, 31718, -1499,  -199,  2745, 31720, -1498,
	 -199,  2741, 31722, -1496,  -198,  2737, 31724, -1495,  -198,  2734, 31726, -1494,  -197,  2730, 31728, -1493,
	 -197,  2726, 31731, -1492,  -197,  2723, 31733, -1491,  -196,  2719, 31734, -1489,  -196,  2716, 31736, -1488,
	 -196,  2712, 31739, -1487,  -195,  2708, 31741, -1486,  -195,  2705, 31743, -1485,  -194,  2701, 31745, -1484,
	 -194,  2697, 31748, -1483,  -194,  2694, 31749, -1481,  -193,  2690, 31751, -1480,  -193,  2687, 31753, -1479,
	 -192,  2683, 31755, -1478,  -192,  2679, 31758, -1477,  -192,  2676, 31760, -1476,  -191,  2672, 31761, -1474,
	 -191,  2669, 31763, -1473,  -191,  2665, 31766, -1472,  -190,  2661, 31768, -1471,  -190,  2658, 31770, -1470,
	 -189,  2654, 31772, -1469,  -189,  2651, 31773, -1467,  -189,  2647, 31776, -1466,  -188,  2643, 31778, -1465,
	 -188,  2640, 31780, -1464,  -188,  2636, 31783, -1463,  -187,  2633, 31784, -1462,  -187,  2629, 31786, -1460,
	 -186,  2626, 31787, -1459,  -186,  2622, 31790, -1458,  -186,  2618, 31793, -1457,  -185,  2615, 31794, -1456,
	 -185,  2611, 31797, -1455,  -185,  2608, 31798, -1453,  -184,  2604, 31800, -1452,  -184,  2601, 31802, -1451,
	 -183,  2597, 31804, -1450,  -183,  2593, 31807, -1449,  -183,  2590, 31809, -1448,  -182,  2586, 31810, -1446,
	 -182,  2583, 31812, -1445,  -182,  2579, 31815, -1444,  -181,  2576, 31816, -1443,  -181,  2572, 31819, -1442,
	 -180,  2568, 31820, -1440,  -180,  2565, 31822, -1439,  -180,  2561, 31825, -1438,  -179,  2558, 31826, -1437,
	 -179,  2554, 31829, -1436,  -179,  2551, 31831, -1435,  -178,  2547, 31832, -1433,  -178,  2544, 31834, -1432,
	 -177,  2540, 31836, -1431,  -177,  2536, 31839, -1430,  -177,  2533, 31841, -1429,  -176,  2529, 31842, -1427,
	 -176,  2526, 31844, -1426,  -176,  2522, 31847, -1425,  -175,  2519, 31848, -1424,  -175,  2515, 31851, -1423,
	 -175,  2512, 31852, -1421,  -174,  2508, 31854, -1420,  -174,  2505, 31856, -1419,  -173,  2501, 31858, -1418,
	 -173,  2498, 31860, -1417,  -173,  2494, 31862, -1415,  -172,  2491, 31863, -1414,  -172,  2487, 31866, -1413,
	 -172,  2483, 31869, -1412,  -171,  2480, 31870, -1411,  -171,  2476, 31872, -1409,  -171,  2473, 31874, -1408,
	 -170,  2469, 31876, -1407,  -170,  2466, 31878, -1406,  -169,  2462, 31880, -1405,  -169,  2459, 31881, -1403,
	 -169,  2455, 31884, -1402,  -168,  2452, 31885, -1401,  -168,  2448, 31888, -1400,  -168,  2445, 31890, -1399,
	 -167,  2441, 31891, -1397,  -167,  2438, 31893, -1396,  -167,  2434, 31896, -1395,  -166,  2431, 31897, -1394,
	 -166,  2427, 31899, -1392,  -166,  2424, 31901, -1391,  -165,  2420, 31903, -1390,  -165,  2417, 31905, -1389,
	 -164,  2413, 31907, -1388,  -164,  2410, 31908, -1386,  -164,  2406, 31911, -1385,  -163,  2403, 31912, -1384,
	 -163,  2399, 31915, -1383,  -163,  2396, 31916, -1381,  -162,  2392, 31918, -1380,  -162,  2389, 31920, -1379,
	 -162,  2385, 31923, -1378,  -161,  2382, 31924, -1377,  -161,  2378, 31926, -1375,  -161,  2375, 31928, -1374,
	 -160,  2371, 31930, -1373,  -160,  2368, 31932, -1372,  -159,  2365, 31932, -1370,  -159,  2361, 31935, -1369,
	 -159,  2358, 31937, -1368,  -158,  2354, 31939, -1367,  -158,  2351, 31941, -1366,  -158,  2347, 31943, -1364,
	 -157,  2344, 31944, -1363,  -157,  2340, 31947, -1362,  -157,  2337, 31949, -1361,  -156,  2333, 31950, -1359,
	 -156,  2330, 31952, -1358,  -156,  2326, 31955, -1357,  -155,  2323, 31956, -1356,  -155,  2320, 31957, -1354,
	 -155,  2316, 31960, -1353,  -154,  2313, 31961, -1352,  -154,  2309, 31964, -1351,  -154,  2306, 31965, -1349,
	 -153,  2302, 31967, -1348,  -153,  2299, 31969, -1347,  -153,  2295, 31972, -1346,  -152,  2292, 31972, -1344,
	 -152,  2289, 31974, -1343,  -151,  2285, 31976, -1342,  -151,  2282, 31978, -1341,  -151,  2278, 31980, -1339,
	 -150,  2275, 31981, -1338,  -150,  2271, 31984, -1337,  -150,  2268, 31986, -1336,  -149,  2264, 31987, -1334,
	 -149,  2261, 31989, -1333,  -149,  2258, 31991, -1332,  -148,  2254, 31993, -1331,  -148,  2251, 31994, -1329,
	 -148,  2247, 31997, -1328,  -147,  2244, 31998, -1327,  -147,  2241, 32000, -1326,  -147,  2237, 32002, -1324,
	 -146,  2234, 32003, -1323,  -146,  2230, 32006, -1322,  -146,  2227, 32008, -1321,  -145,  2223, 32009, -1319,
	 -145,  2220, 32011, -1318,  -145,  2217, 32013, -1317,  -144,  2213, 32014, -1315,  -144,  2210, 32016, -1314,
	 -144,  2206, 32019, -1313,  -143,  2203, 32020, -1312,  -143,  2200, 32021, -1310,  -143,  2196, 32024, -1309,
	 -142,  2193, 32025, -1308,  -142,  2189, 32028, -1307,  -142,  2186, 32029, -1305,  -141,  2183, 32030, -1304,
	 -141,  2179, 32033, -1303,  -141,  2176, 32034, -1301,  -140,  2172, 32036, -1300,  -140,  2169, 32038, -1299,
	 -140,  2166, 32040, -1298,  -139,  2162, 32041, -1296,  -139,  2159, 32043, -1295,  -139,  2156, 32045, -1294,
	 -138,  2152, 32047, -1293,  -138,  2149, 32048, -1291,  -138,  2145, 32051, -1290,  -137,  2142, 32052, -1289,
	 -137,  2139, 32053, -1287,  -137,  2135, 32056, -1286,  -136,  2132, 32057, -1285,  -136,  2129, 32059, -1284,
	 -136,  2125, 32061, -1282,  -135,  2122, 32062, -1281,  -135,  2118, 32065, -1280,  -135,  2115, 32066, -1278,
	 -134,  2112, 32067, -1277,  -134,  2108, 32070, -1276,  -134,  2105, 32071, -1274,  -133,  2102, 32072, -1273,
	 -133,  2098, 32075, -1272,  -133,  2095, 32077, -1271,  -132,  2092, 32077, -1269,  -132,  2088, 32080, -1268,
	 -132,  2085, 32082, -1267,  -131,  2082, 32082, -1265,  -131,  2078, 32085, -1264,  -131,  2075, 32087, -1263,
	 -131,  2072, 32089, -1262,  -130,  2068, 32090, -1260,  -130,  2065, 32092, -1259,  -130,  2061, 32095, -1258,
	 -129,  2058, 32095, -1256,  -129,  2055, 32097, -1255,  -129,  2051, 32100, -1254,  -128,  2048, 32100, -1252,
	 -128,  2045, 32102, -1251,  -128,  2041, 32105, -1250,  -127,  2038, 32105, -1248,  -127,  2035, 32107, -1247,
	 -127,  2032, 32109, -1246,  -126,  2028, 32110, -1244,  -126,  2025, 32112, -1243,  -126,  2022, 32114, -1242,
	 -125,  2018, 32116, -1241,  -125,  2015, 32117, -1239,  -125,  2012, 32119, -1238,  -124,  2008, 32121, -1237,
	 -124,  2005, 32122, -1235,  -124,  2002, 32124, -1234,  -123,  1998, 32126, -1233,  -123,  1995, 32127, -1231,
	 -123,  1992, 32129, -1230,  -123,  1988, 32132, -1229,  -122,  1985, 32132, -1227,  -122,  1982, 32134, -1226,
	 -122,  1979, 32136, -1225,  -121,  1975, 32137, -1223,  -121,  1972, 32139, -1222,  -121,  1969, 32141, -1221,
	 -120,  1965, 32142, -1219,  -120,  1962, 32144, -1218,  -120,  1959, 32146, -1217,  -119,  1955, 32147, -1215,
	 -119,  1952, 32149, -1214,  -119,  1949, 32151, -1213,  -119,  1946, 32152, -1211,  -118,  1942, 32154, -1210,
	 -118,  1939, 32156, -1209,  -118,  1936, 32157, -1207,  -117,  1933, 32158, -1206,  -117,  1929, 32161, -1205,
	 -117,  1926, 32162, -1203,  -116,  1923, 32163, -1202,  -116,  1919, 32166, -1201,  -116,  1916, 32167, -1199,
	 -115,  1913, 32168, -1198,  -115,  1910, 32170, -1197,  -115,  1906, 32172, -1195,  -115,  1903, 32174, -1194,
	 -114,  1900, 32175, -1193,  -114,  1897, 32176, -1191,  -114,  1893, 32179, -1190,  -113,  1890, 32180, -1189,
	 -113,  1887, 32181, -1187,  -113,  1884, 32183, -1186,  -112,  1880, 32185, -1185,  -112,  1877, 32186, -1183,
	 -112,  1874, 32188, -1182,  -112,  1871, 32189, -1180,  -111,  1867, 32191, -1179,  -111,  1864, 32193, -1178,
	 -111,  1861, 32194, -1176,  -110,  1858, 32195, -1175,  -110,  1854, 32198, -1174,  -110,  1851, 32199, -1172,
	 -109,  1848, 32200, -1171,  -109,  1845, 32202, -1170,  -109,  1841, 32204, -1168,  -109,  1838, 32206, -1167,
	 -108,  1835, 32207, -1166,  -108,  1832, 32208, -1164,  -108,  1828, 32211, -1163,  -107,  1825, 32211, -1161,
	 -107,  1822, 32213, -1160,  -107,  1819, 32215, -1159,  -106,  1816, 32215, -1157,  -106,  1812, 32218, -1156,
	 -106,  1809, 32220, -1155,  -106,  1806, 32221, -1153,  -105,  1803, 32222, -1152,  -105,  1799, 32224, -1150,
	 -105,  1796, 32226, -1149,  -104,  1793, 32227, -1148,  -104,  1790, 32228, -1146,  -104,  1787, 32230, -1145,
	 -104,  1783, 32233, -1144,  -103,  1780, 32233, -1142,  -103,  1777, 32235, -1141,  -103,  1774, 32236, -1139,
	 -102,  1771, 32237, -1138,  -102,  1767, 32240, -1137,  -102,  1764, 32241, -1135,  -101,  1761, 32242, -1134,
	 -101,  1758, 32244, -1133,  -101,  1755, 32245, -1131,  -101,  1751, 32248, -1130,  -100,  1748, 32248, -1128,
	 -100,  1745, 32250, -1127,  -100,  1742, 32252, -1126,   -99,  1739, 32252, -1124,   -99,  1736, 32254, -1123,
	  -99,  1732, 32256, -1121,   -99,  1729, 32258, -1120,   -98,  1726, 32259, -1119,   -98,  1723, 32260, -1117,
	  -98,  1720, 32262, -1116,   -97,  1717, 32262, -1114,   -97,  1713, 32265, -1113,   -97,  1710, 32267, -1112,
	  -97,  1707, 32268, -1110,   -96,  1704, 32269, -1109,   -96,  1701, 32270, -1107,   -96,  1698, 32272, -1106,
	  -96,  1694, 32275, -1105,   -95,  1691, 32275, -1103,   -95,  1688, 32277, -1102,   -95,  1685, 32278, -1100,
	  -94,  1682, 32279, -1099,   -94,  1679, 32281, -1098,   -94,  1675, 32283, -1096,   -94,  1672, 32285, -1095,
	  -93,  1669, 32285, -1093,   -93,  1666, 32287, -1092,   -93,  1663, 32289, -1091,   -92,  1660, 32289, -1089,
	  -92,  1657, 32291, -1088,   -92,  1653, 32293, -1086,   -92,  1650, 32295, -1085,   -91,  1647, 32296, -1084,
	  -91,  1644, 32297, -1082,   -91,  1641, 32299, -1081,   -91,  1638, 32300, -1079,   -90,  1635, 32301, -1078,
	  -90,  1631, 32303, -1076,   -90,  1628, 32305, -1075,   -89,  1625, 32306, -1074,   -89,  1622, 32307, -1072,
	  -89,  1619, 32309, -1071,   -89,  1616, 32310, -1069,   -88,  1613, 32311, -1068,   -88,  1610, 32313, -1067,
	  -88,  1607, 32314, -1065,   -88,  1603, 32317, -1064,   -87,  1600, 32317, -1062,   -87,  1597, 32319, -1061,
	  -87,  1594, 32320, -1059,   -86,  1591, 32321, -1058,   -86,  1588, 32323, -1057,   -86,  1585, 32324, -1055,
	  -86,  1582, 32326, -1054,   -85,  1579, 32326, -1052,   -85,  1575, 32329, -1051,   -85,  1572, 32330, -1049,
	  -85,  1569, 32332, -1048,   -84,  1566, 32333, -1047,   -84,  1563, 32334, -1045,   -84,  1560, 32336, -1044,
	  -84,  1557, 32337, -1042,   -83,  1554, 32338, -1041,   -83,  1551, 32339, -1039,   -83,  1548, 32341, -1038,
	  -82,  1545, 32341, -1036,   -82,  1541, 32344, -1035,   -82,  1538, 32346, -1034,   -82,  1535, 32347, -1032,
	  -81,  1532, 32348, -1031,   -81,  1529, 32349, -1029,   -81,  1526, 32351, -1028,   -81,  1523, 32352, -1026,
	  -80,  1520, 32353, -1025,   -80,  1517, 32354, -1023,   -80,  1514, 32356, -1022,   -80,  1511, 32358, -1021,
	  -79,  1508, 32358, -1019,   -79,  1505, 32360, -1018,   -79,  1502, 32361, -1016,   -79,  1499, 32363, -1015,
	  -78,  1495, 32364, -1013,   -78,  1492, 32366, -1012,   -78,  1489, 32367, -1010,   -78,  1486, 32369, -1009,
	  -77,  1483, 32369, -1007,   -77,  1480, 32371, -1006,   -77,  1477, 32372, -1004,   -77,  1474, 32374, -1003,
	  -76,  1471, 32375, -1002,   -76,  1468, 32376, -1000,   -76,  1465, 32378,  -999,   -76,  1462, 32379,  -997,
	  -75,  1459, 32380,  -996,   -75,  1456, 32381,  -994,   -75,  1453, 32383,  -993,   -75,  1450, 32384,  -991,
	  -74,  1447, 32385,  -990,   -74,  1444, 32386,  -988,   -74,  1441, 32388,  -987,   -74,  1438, 32389,  -985,
	  -73,  1435, 32390,  -984,   -73,  1432, 32391,  -982,   -73,  1429, 32393,  -981,   -73,  1426, 32395,  -980,
	  -72,  1423, 32395,  -978,   -72,  1420, 32397,  -977,   -72,  1417, 32398,  -975,   -72,  1414, 32400,  -974,
	  -71,  1411, 32400,  -972,   -71,  1408, 32402,  -971,   -71,  1405, 32403,  -969,   -71,  1402, 32405,  -968,
	  -70,  1399, 32405,  -966,   -70,  1396, 32407,  -965,   -70,  1393, 32408,  -963,   -70,  1390, 32410,  -962,
	  -69,  1387, 32410,  -960,   -69,  1384, 32412,  -959,   -69,  1381, 32413,  -957,   -69,  1378, 32415,  -956,
	  -68,  1375, 32415,  -954,   -68,  1372, 32417,  -953,   -68,  1369, 32418,  -951,   -68,  1366, 32420,  -950,
	  -67,  1363, 32420,  -948,   -67,  1360, 32422,  -947,   -67,  1357, 32423,  -945,   -67,  1354, 32425,  -944,
	  -66,  1351, 32425,  -942,   -66,  1348, 32427,  -941,   -66,  1345, 32428,  -939,   -66,  1342, 32430,  -938,
	  -66,  1339, 32431,  -936,   -65,  1336, 32432,  -935,   -65,  1333, 32433,  -933,   -65,  1330, 32435,  -932,
	  -65,  1327, 32436,  -930,   -64,  1324, 32437,  -929,   -64,  1321, 32438,  -927,   -64,  1318, 32440,  -926,
	  -64,  1315, 32441,  -924,   -63,  1312, 32442,  -923,   -63,  1309, 32443,  -921,   -63,  1306, 32445,  -920,
	  -63,  1303, 32446,  -918,   -63,  1300, 32448,  -917,   -62,  1297, 32448,  -915,   -62,  1294, 32450,  -914,
	  -62,  1291, 32451,  -912,   -62,  1289, 32452,  -911,   -61,  1286, 32452,  -909,   -61,  1283, 32454,  -908,
	  -61,  1280, 32455,  -906,   -61,  1277, 32457,  -905,   -60,  1274, 32457,  -903,   -60,  1271, 32459,  -902,
	  -60,  1268, 32460,  -900,   -60,  1265, 32461,  -898,   -60,  1262, 32463,  -897,   -59,  1259, 32463,  -895,
	  -59,  1256, 32465,  -894,   -59,  1253, 32466,  -892,   -59,  1250, 32468,  -891,   -58,  1248, 32467,  -889,
	  -58,  1245, 32469,  -888,   -58,  1242, 32470,  -886,   -58,  1239, 32472,  -885,   -58,  1236, 32473,  -883,
	  -57,  1233, 32474,  -882,   -57,  1230, 32475,  -880,   -57,  1227, 32477,  -879,   -57,  1224, 32478,  -877,
	  -56,  1221, 32479,  -876,   -56,  1218, 32480,  -874,   -56,  1216, 32480,  -872,   -56,  1213, 32482,  -871,
	  -56,  1210, 32483,  -869,   -55,  1207, 32484,  -868,   -55,  1204, 32485,  -866,   -55,  1201, 32487,  -865,
	  -55,  1198, 32488,  -863,   -54,  1195, 32489,  -862,   -54,  1192, 32490,  -860,   -54,  1190, 32491,  -859,
	  -54,  1187, 32492,  -857,   -54,  1184, 32493,  -855,   -53,  1181, 32494,  -854,   -53,  1178, 32495,  -852,
	  -53,  1175, 32497,  -851,   -53,  1172, 32498,  -849,   -53,  1169, 32500,  -848,   -52,  1166, 32500,  -846,
	  -52,  1164, 32501,  -845,   -52,  1161, 32502,  -843,   -52,  1158, 32503,  -841,   -51,  1155, 32504,  -840,
	  -51,  1152, 32505,  -838,   -51,  1149, 32507,  -837,   -51,  1146, 32508,  -835,   -51,  1144, 32509,  -834,
	  -50,  1141, 32509,  -832,   -50,  1138, 32511,  -831,   -50,  1135, 32512,  -829,   -50,  1132, 32513,  -827,
	  -50,  1129, 32515,  -826,   -49,  1126, 32515,  -824,   -49,  1124, 32516,  -823,   -49,  1121, 32517,  -821,
	  -49,  1118, 32519,  -820,   -49,  1115, 32520,  -818,   -48,  1112, 32520,  -816,   -48,  1109, 32522,  -815,
	  -48,  1107, 32522,  -813,   -48,  1104, 32524,  -812,   -48,  1101, 32525,  -810,   -47,  1098, 32526,  -809,
	  -47,  1095, 32527,  -807,   -47,  1092, 32528,  -805,   -47,  1090, 32529,  -804,   -47,  1087, 32530,  -802,
	  -46,  1084, 32531,  -801,   -46,  1081, 32532,  -799,   -46,  1078, 32534,  -798,   -46,  1076, 32534,  -796,
	  -46,  1073, 32535,  -794,   -45,  1070, 32536,  -793,   -45,  1067, 32537,  -791,   -45,  1064, 32539,  -790,
	  -45,  1061, 32540,  -788,   -45,  1059, 32540,  -786,   -44,  1056, 32541,  -785,   -44,  1053, 32542,  -783,
	  -44,  1050, 32544,  -782,   -44,  1047, 32545,  -780,   -44,  1045, 32545,  -778,   -43,  1042, 32546,  -777,
	  -43,  1039, 32547,  -775,   -43,  1036, 32549,  -774,   -43,  1033, 32550,  -772,   -43,  1031, 32550,  -770,
	  -42,  1028, 32551,  -769,   -42,  1025, 32552,  -767,   -42,  1022, 32554,  -766,   -42,  1020, 32554,  -764,
	  -42,  1017, 32555,  -762,   -41,  1014, 32556,  -761,   -41,  1011, 32557,  -759,   -41,  1008, 32559,  -758,
	  -41,  1006, 32559,  -756,   -41,  1003, 32560,  -754,   -40,  1000, 32561,  -753,   -40,   997, 32562,  -751,
	  -40,   995, 32563,  -750,   -40,   992, 32564,  -748,   -40,   989, 32565,  -746,   -40,   986, 32567,  -745,
	  -39,   984, 32566,  -743,   -39,   981, 32568,  -742,   -39,   978, 32569,  -740,   -39,   975, 32570,  -738,
	  -39,   972, 32572,  -737,   -38,   970, 32571,  -735,   -38,   967, 32573,  -734,   -38,   964, 32574,  -732,
	  -38,   961, 32575,  -730,   -38,   959, 32576,  -729,   -38,   956, 32577,  -727,   -37,   953, 32577,  -725,
	  -37,   951, 32578,  -724,   -37,   948, 32579,  -722,   -37,   945, 32581,  -721,   -37,   942, 32582,  -719,
	  -36,   940, 32581,  -717,   -36,   937, 32583,  -716,   -36,   934, 32584,  -714,   -36,   931, 32585,  -712,
	  -36,   929, 32586,  -711,   -36,   926, 32587,  -709,   -35,   923, 32588,  -708,   -35,   921, 32588,  -706,
	  -35,   918, 32589,  -704,   -35,   915, 32591,  -703,   -35,   912, 32592,  -701,   -34,   910, 32591,  -699,
	  -34,   907, 32593,  -698,   -34,   904, 32594,  -696,   -34,   902, 32594,  -694,   -34,   899, 32596,  -693,
	  -34,   896, 32597,  -691,   -33,   893, 32597,  -689,   -33,   891, 32598,  -688,   -33,   888, 32599,  -686,
	  -33,   885, 32601,  -685,   -33,   883, 32601,  -683,   -33,   880, 32602,  -681,   -32,   877, 32603,  -680,
	  -32,   875, 32603,  -678,   -32,   872, 32604,  -676,   -32,   869, 32606,  -675,   -32,   866, 32607,  -673,
	  -32,   864, 32607,  -671,   -31,   861, 32608,  -670,   -31,   858, 32609,  -668,   -31,   856, 32609,  -666,
	  -31,   853, 32611,  -665,   -31,   850, 32612,  -663,   -31,   848, 32612,  -661,   -30,   845, 32613,  -660,
	  -30,   842, 32614,  -658,   -30,   840, 32614,  -656,   -30,   837, 32616,  -655,   -30,   834, 32617,  -653,
	  -30,   832, 32617,  -651,   -29,   829, 32618,  -650,   -29,   826, 32619,  -648,   -29,   824, 32619,  -646,
	  -29,   821, 32621,  -645,   -29,   818, 32622,  -643,   -29,   816, 32622,  -641,   -28,   813, 32623,  -640,
	  -28,   810, 32624,  -638,   -28,   808, 32624,  -636,   -28,   805, 32626,  -635,   -28,   803, 32626,  -633,
	  -28,   800, 32627,  -631,   -28,   797, 32629,  -630,   -27,   795, 32628,  -628,   -27,   792, 32629,  -626,
	  -27,   789, 32631,  -625,   -27,   787, 32631,  -623,   -27,   784, 32632,  -621,   -27,   781, 32634,  -620,
	  -26,   779, 32633,  -618,   -26,   776, 32634,  -616,   -26,   774, 32635,  -615,   -26,   771, 32636,  -613,
	  -26,   768, 32637,  -611,   -26,   766, 32638,  -610,   -26,   763, 32639,  -608,   -25,   761, 32638,  -606,
	  -25,   758, 32640,  -605,   -25,   755, 32641,  -603,   -25,   753, 32641,  -601,   -25,   750, 32642,  -599,
	  -25,   747, 32644,  -598,   -24,   745, 32643,  -596,   -24,   742, 32644,  -594,   -24,   740, 32645,  -593,
	  -24,   737, 32646,  -591,   -24,   734, 32647,  -589,   -24,   732, 32648,  -588,   -24,   729, 32649,  -586,
	  -23,   727, 32648,  -584,   -23,   724, 32649,  -582,   -23,   722, 32650,  -581,   -23,   719, 32651,  -579,
	  -23,   716, 32652,  -577,   -23,   714, 32653,  -576,   -23,   711, 32654,  -574,   -22,   709, 32653,  -572,
	  -22,   706, 32655,  -571,   -22,   703, 32656,  -569,   -22,   701, 32656,  -567,   -22,   698, 32657,  -565,
	  -22,   696, 32658,  -564,   -22,   693, 32659,  -562,   -21,   691, 32658,  -560,   -21,   688, 32660,  -559,
	  -21,   685, 32661,  -557,   -21,   683, 32661,  -555,   -21,   680, 32662,  -553,   -21,   678, 32663,  -552,
	  -21,   675, 32664,  -550,   -20,   673, 32663,  -548,   -20,   670, 32665,  -547,   -20,   668, 32665,  -545,
	  -20,   665, 32666,  -543,   -20,   662, 32667,  -541,   -20,   660, 32668,  -540,   -20,   657, 32669,  -538,
	  -20,   655, 32669,  -536,   -19,   652, 32669,  -534,   -19,   650, 32670,  -533,   -19,   647, 32671,  -531,
	  -19,   645, 32671,  -529,   -19,   642, 32673,  -528,   -19,   640, 32673,  -526,   -19,   637, 32674,  -524,
	  -18,   635, 32673,  -522,   -18,   632, 32675,  -521,   -18,   630, 32675,  -519,   -18,   627, 32676,  -517,
	  -18,   625, 32676,  -515,   -18,   622, 32678,  -514,   -18,   619, 32679,  -512,   -18,   617, 32679,  -510,
	  -17,   614, 32679,  -508,   -17,   612, 32680,  -507,   -17,   609, 32681,  -505,   -17,   607, 32681,  -503,
	  -17,   604, 32683,  -502,   -17,   602, 32683,  -500,   -17,   599, 32684,  -498,   -17,   597, 32684,  -496,
	  -16,   594, 32685,  -495,   -16,   592, 32685,  -493,   -16,   589, 32686,  -491,   -16,   587, 32686,  -489,
	  -16,   584, 32688,  -488,   -16,   582, 32688,  -486,   -16,   579, 32689,  -484,   -16,   577, 32689,  -482,
	  -16,   575, 32690,  -481,   -15,   572, 32690,  -479,   -15,   570, 32690,  -477,   -15,   567, 32691,  -475,
	  -15,   565, 32691,  -473,   -15,   562, 32693,  -472,   -15,   560, 32693,  -470,   -15,   557, 32694,  -468,
	  -15,   555, 32694,  -466,   -14,   552, 32695,  -465,   -14,   550, 32695,  -463,   -14,   547, 32696,  -461,
	  -14,   545, 32696,  -459,   -14,   542, 32698,  -458,   -14,   540, 32698,  -456,   -14,   537, 32699,  -454,
	  -14,   535, 32699,  -452,   -14,   533, 32700,  -451,   -13,   530, 32700,  -449,   -13,   528, 32700,  -447,
	  -13,   525, 32701,  -445,   -13,   523, 32701,  -443,   -13,   520, 32703,  -442,   -13,   518, 32703,  -440,
	  -13,   515, 32704,  -438,   -13,   513, 32704,  -436,   -13,   511, 32705,  -435,   -12,   508, 32705,  -433,
	  -12,   506, 32705,  -431,   -12,   503, 32706,  -429,   -12,   501, 32706,  -427,   -12,   498, 32708,  -426,
	  -12,   496, 32708,  -424,   -12,   494, 32708,  -422,   -12,   491, 32709,  -420,   -12,   489, 32709,  -418,
	  -11,   486, 32710,  -417,   -11,   484, 32710,  -415,   -11,   481, 32711,  -413,   -11,   479, 32711,  -411,
	  -11,   477, 32712,  -410,   -11,   474, 32713,  -408,   -11,   472, 32713,  -406,   -11,   469, 32714,  -404,
	  -11,   467, 32714,  -402,   -11,   465, 32715,  -401,   -10,   462, 32715,  -399,   -10,   460, 32715,  -397,
	  -10,   457, 32716,  -395,   -10,   455, 32716,  -393,   -10,   453, 32717,  -392,   -10,   450, 32718,  -390,
	  -10,   448, 32718,  -388,   -10,   445, 32719,  -386,   -10,   443, 32719,  -384,   -10,   441, 32720,  -383,
	  -10,   438, 32721,  -381,    -9,   436, 32720,  -379,    -9,   434, 32720,  -377,    -9,   431, 32721,  -375,
	   -9,   429, 32721,  -373,    -9,   426, 32723,  -372,    -9,   424, 32723,  -370,    -9,   422, 32723,  -368,
	   -9,   419, 32724,  -366,    -9,   417, 32724,  -364,    -9,   415, 32725,  -363,    -9,   412, 32726,  -361,
	   -8,   410, 32725,  -359,    -8,   408, 32725,  -357,    -8,   405, 32726,  -355,    -8,   403, 32726,  -353,
	   -8,   401, 32727,  -352,    -8,   398, 32728,  -350,    -8,   396, 32728,  -348,    -8,   393, 32729,  -346,
	   -8,   391, 32729,  -344,    -8,   389, 32730,  -343,    -8,   386, 32731,  -341,    -7,   384, 32730,  -339,
	   -7,   382, 32730,  -337,    -7,   379, 32731,  -335,    -7,   377, 32731,  -333,    -7,   375, 32732,  -332,
	   -7,   372, 32733,  -330,    -7,   370, 32733,  -328,    -7,   368, 32733,  -326,    -7,   365, 32734,  -324,
	   -7,   363, 32734,  -322,    -7,   361, 32735,  -321,    -7,   359, 32735,  -319,    -7,   356, 32736,  -317,
	   -6,   354, 32735,  -315,    -6,   352, 32735,  -313,    -6,   349, 32736,  -311,    -6,   347, 32736,  -309,
	   -6,   345, 32737,  -308,    -6,   342, 32738,  -306,    -6,   340, 32738,  -304,    -6,   338, 32738,  -302,
	   -6,   335, 32739,  -300,    -6,   333, 32739,  -298,    -6,   331, 32740,  -297,    -6,   329, 32740,  -295,
	   -6,   326, 32741,  -293,    -5,   324, 32740,  -291,    -5,   322, 32740,  -289,    -5,   319, 32741,  -287,
	   -5,   317, 32741,  -285,    -5,   315, 32742,  -284,    -5,   313, 32742,  -282,    -5,   310, 32743,  -280,
	   -5,   308, 32743,  -278,    -5,   306, 32743,  -276,    -5,   303, 32744,  -274,    -5,   301, 32744,  -272,
	   -5,   299, 32745,  -271,    -5,   297, 32745,  -269,    -5,   294, 32746,  -267,    -5,   292, 32746,  -265,
	   -4,   290, 32745,  -263,    -4,   288, 32745,  -261,    -4,   285, 32746,  -259,    -4,   283, 32746,  -257,
	   -4,   281, 32747,  -256,    -4,   279, 32747,  -254,    -4,   276, 32748,  -252,    -4,   274, 32748,  -250,
	   -4,   272, 32748,  -248,    -4,   270, 32748,  -246,    -4,   267, 32749,  -244,    -4,   265, 32749,  -242,
	   -4,   263, 32750,  -241,    -4,   261, 32750,  -239,    -4,   258, 32751,  -237,    -4,   256, 32751,  -235,
	   -3,   254, 32750,  -233,    -3,   252, 32750,  -231,    -3,   249, 32751,  -229,    -3,   247, 32751,  -227,
	   -3,   245, 32751,  -225,    -3,   243, 32752,  -224,    -3,   241, 32752,  -222,    -3,   238, 32753,  -220,
	   -3,   236, 32753,  -218,    -3,   234, 32753,  -216,    -3,   232, 32753,  -214,    -3,   229, 32754,  -212,
	   -3,   227, 32754,  -210,    -3,   225, 32754,  -208,    -3,   223, 32755,  -207,    -3,   221, 32755,  -205,
	   -3,   218, 32756,  -203,    -3,   216, 32756,  -201,    -3,   214, 32756,  -199,    -2,   212, 32755,  -197,
	   -2,   210, 32755,  -195,    -2,   207, 32756,  -193,    -2,   205, 32756,  -191,    -2,   203, 32756,  -189,
	   -2,   201, 32757,  -188,    -2,   199, 32757,  -186,    -2,   197, 32757,  -184,    -2,   194, 32758,  -182,
	   -2,   192, 32758,  -180,    -2,   190, 32758,  -178,    -2,   188, 32758,  -176,    -2,   186, 32758,  -174,
	   -2,   184, 32758,  -172,    -2,   181, 32759,  -170,    -2,   179, 32759,  -168,    -2,   177, 32759,  -166,
	   -2,   175, 32760,  -165,    -2,   173, 32760,  -163,    -2,   171, 32760,  -161,    -2,   168, 32761,  -159,
	   -2,   166, 32761,  -157,    -2,   164, 32761,  -155,    -1,   162, 32760,  -153,    -1,   160, 32760,  -151,
	   -1,   158, 32760,  -149,    -1,   155, 32761,  -147,    -1,   153, 32761,  -145,    -1,   151, 32761,  -143,
	   -1,   149, 32761,  -141,    -1,   147, 32762,  -140,    -1,   145, 32762,  -138,    -1,   143, 32762,  -136,
	   -1,   140, 32763,  -134,    -1,   138, 32763,  -132,    -1,   136, 32763,  -130,    -1,   134, 32763,  -128,
	   -1,   132, 32763,  -126,    -1,   130, 32763,  -124,    -1,   128, 32763,  -122,    -1,   126, 32763,  -120,
	   -1,   123, 32764,  -118,    -1,   121, 32764,  -116,    -1,   119, 32764,  -114,    -1,   117, 32764,  -112,
	   -1,   115, 32764,  -110,    -1,   113, 32765,  -109,    -1,   111, 32765,  -107,    -1,   109, 32765,  -105,
	   -1,   107, 32765,  -103,    -1,   105, 32765,  -101,    -1,   102, 32766,   -99,    -1,   100, 32766,   -97,
	   -1,    98, 32766,   -95,    -1,    96, 32766,   -93,    -1,    94, 32766,   -91,     0,    92, 32765,   -89,
	    0,    90, 32765,   -87,     0,    88, 32765,   -85,     0,    86, 32765,   -83,     0,    84, 32765,   -81,
	    0,    82, 32765,   -79,     0,    79, 32766,   -77,     0,    77, 32766,   -75,     0,    75, 32766,   -73,
	    0,    73, 32766,   -71,     0,    71, 32766,   -69,     0,    69, 32766,   -67,     0,    67, 32766,   -65,
	    0,    65, 32767,   -64,     0,    63, 32767,   -62,     0,    61, 32767,   -60,     0,    59, 32767,   -58,
	    0,    57, 32767,   -56,     0,    55, 32767,   -54,     0,    53, 32767,   -52,     0,    51, 32767,   -50,
	    0,    49, 32767,   -48,     0,    47, 32767,   -46,     0,    44, 32767,   -44,     0,    42, 32767,   -42,
	    0,    40, 32767,   -40,     0,    38, 32767,   -38,     0,    36, 32767,   -36,     0,    34, 32767,   -34,
	    0,    32, 32767,   -32,     0,    30, 32767,   -30,     0,    28, 32767,   -28,     0,    26, 32767,   -26,
	    0,    24, 32767,   -24,     0,    22, 32767,   -22,     0,    20, 32767,   -20,     0,    18, 32767,   -18,
	    0,    16, 32767,   -16,     0,    14, 32767,   -14,     0,    12, 32767,   -12,     0,    10, 32767,   -10,
	    0,     8, 32767,    -8,     0,     6, 32767,    -6,     0,     4, 32767,    -4,     0,     2, 32767,    -2
};

#else

// for non-x86_64 CPUs: 15-bit precision, 512 phases

const int16_t cubicSplineTable[CUBIC_WIDTH * CUBIC_PHASES] =
{
	    0, 32767,     0,     0,   -32, 32767,    32,     0,   -64, 32767,    65,     0,   -95, 32766,    98,    -1,
	 -126, 32763,   132,    -1,  -157, 32761,   166,    -2,  -188, 32757,   201,    -2,  -218, 32753,   236,    -3,
	 -248, 32748,   272,    -4,  -278, 32743,   308,    -5,  -308, 32737,   345,    -6,  -337, 32730,   382,    -7,
	 -366, 32724,   419,    -9,  -395, 32716,   457,   -10,  -424, 32708,   496,   -12,  -452, 32699,   535,   -14,
	 -481, 32690,   575,   -16,  -508, 32679,   614,   -17,  -536, 32669,   655,   -20,  -564, 32658,   696,   -22,
	 -591, 32646,   737,   -24,  -618, 32633,   779,   -26,  -645, 32621,   821,   -29,  -671, 32607,   864,   -32,
	 -698, 32593,   907,   -34,  -724, 32578,   951,   -37,  -750, 32563,   995,   -40,  -775, 32547,  1039,   -43,
	 -801, 32531,  1084,   -46,  -826, 32515,  1129,   -50,  -851, 32497,  1175,   -53,  -876, 32479,  1221,   -56,
	 -900, 32460,  1268,   -60,  -924, 32441,  1315,   -64,  -948, 32420,  1363,   -67,  -972, 32400,  1411,   -71,
	 -996, 32380,  1459,   -75, -1019, 32358,  1508,   -79, -1042, 32337,  1557,   -84, -1065, 32314,  1607,   -88,
	-1088, 32291,  1657,   -92, -1110, 32268,  1707,   -97, -1133, 32244,  1758,  -101, -1155, 32220,  1809,  -106,
	-1176, 32194,  1861,  -111, -1198, 32168,  1913,  -115, -1219, 32142,  1965,  -120, -1241, 32116,  2018,  -125,
	-1262, 32089,  2072,  -131, -1282, 32061,  2125,  -136, -1303, 32033,  2179,  -141, -1323, 32003,  2234,  -146,
	-1343, 31974,  2289,  -152, -1363, 31944,  2344,  -157, -1383, 31915,  2399,  -163, -1402, 31884,  2455,  -169,
	-1421, 31852,  2512,  -175, -1440, 31820,  2568,  -180, -1459, 31787,  2626,  -186, -1478, 31755,  2683,  -192,
	-1496, 31722,  2741,  -199, -1515, 31689,  2799,  -205, -1533, 31654,  2858,  -211, -1550, 31619,  2917,  -218,
	-1568, 31584,  2976,  -224, -1585, 31548,  3036,  -231, -1603, 31512,  3096,  -237, -1620, 31476,  3156,  -244,
	-1636, 31438,  3217,  -251, -1653, 31400,  3278,  -257, -1669, 31362,  3339,  -264, -1686, 31324,  3401,  -271,
	-1702, 31285,  3463,  -278, -1717, 31245,  3526,  -286, -1733, 31205,  3589,  -293, -1748, 31164,  3652,  -300,
	-1764, 31124,  3715,  -307, -1779, 31083,  3779,  -315, -1793, 31040,  3843,  -322, -1808, 30998,  3908,  -330,
	-1823, 30956,  3973,  -338, -1837, 30912,  4038,  -345, -1851, 30869,  4103,  -353, -1865, 30825,  4169,  -361,
	-1878, 30780,  4235,  -369, -1892, 30736,  4301,  -377, -1905, 30690,  4368,  -385, -1918, 30644,  4435,  -393,
	-1931, 30598,  4502,  -401, -1944, 30551,  4570,  -409, -1956, 30503,  4638,  -417, -1969, 30457,  4706,  -426,
	-1981, 30408,  4775,  -434, -1993, 30359,  4844,  -442, -2005, 30311,  4913,  -451, -2017, 30262,  4982,  -459,
	-2028, 30212,  5052,  -468, -2039, 30162,  5122,  -477, -2050, 30111,  5192,  -485, -2061, 30060,  5263,  -494,
	-2072, 30009,  5334,  -503, -2083, 29958,  5405,  -512, -2093, 29906,  5476,  -521, -2103, 29853,  5548,  -530,
	-2113, 29800,  5620,  -539, -2123, 29747,  5692,  -548, -2133, 29693,  5765,  -557, -2142, 29638,  5838,  -566,
	-2152, 29584,  5911,  -575, -2161, 29529,  5984,  -584, -2170, 29474,  6058,  -594, -2179, 29419,  6131,  -603,
	-2188, 29363,  6206,  -613, -2196, 29306,  6280,  -622, -2204, 29249,  6354,  -631, -2213, 29193,  6429,  -641,
	-2221, 29135,  6504,  -650, -2228, 29076,  6580,  -660, -2236, 29019,  6655,  -670, -2244, 28960,  6731,  -679,
	-2251, 28901,  6807,  -689, -2258, 28842,  6883,  -699, -2265, 28782,  6960,  -709, -2272, 28721,  7037,  -718,
	-2279, 28661,  7114,  -728, -2285, 28600,  7191,  -738, -2292, 28540,  7268,  -748, -2298, 28478,  7346,  -758,
	-2304, 28416,  7424,  -768, -2310, 28354,  7502,  -778, -2316, 28292,  7580,  -788, -2321, 28228,  7659,  -798,
	-2327, 28165,  7738,  -808, -2332, 28101,  7817,  -818, -2337, 28038,  7896,  -829, -2342, 27974,  7975,  -839,
	-2347, 27909,  8055,  -849, -2352, 27844,  8135,  -859, -2356, 27778,  8215,  -869, -2361, 27714,  8295,  -880,
	-2365, 27648,  8375,  -890, -2369, 27581,  8456,  -900, -2373, 27516,  8536,  -911, -2377, 27449,  8617,  -921,
	-2381, 27382,  8699,  -932, -2384, 27314,  8780,  -942, -2387, 27246,  8861,  -952, -2391, 27179,  8943,  -963,
	-2394, 27110,  9025,  -973, -2397, 27042,  9107,  -984, -2399, 26972,  9189,  -994, -2402, 26904,  9271, -1005,
	-2405, 26834,  9354, -1015, -2407, 26764,  9437, -1026, -2409, 26693,  9520, -1036, -2411, 26623,  9603, -1047,
	-2413, 26553,  9686, -1058, -2415, 26482,  9769, -1068, -2417, 26411,  9853, -1079, -2419, 26340,  9936, -1089,
	-2420, 26268, 10020, -1100, -2421, 26196, 10104, -1111, -2422, 26123, 10188, -1121, -2424, 26052, 10272, -1132,
	-2424, 25978, 10357, -1143, -2425, 25905, 10441, -1153, -2426, 25832, 10526, -1164, -2426, 25758, 10611, -1175,
	-2427, 25684, 10696, -1185, -2427, 25610, 10781, -1196, -2427, 25536, 10866, -1207, -2427, 25461, 10951, -1217,
	-2427, 25386, 11037, -1228, -2427, 25312, 11122, -1239, -2427, 25236, 11208, -1249, -2426, 25160, 11294, -1260,
	-2426, 25085, 11380, -1271, -2425, 25008, 11466, -1281, -2424, 24932, 11552, -1292, -2423, 24855, 11638, -1302,
	-2422, 24779, 11724, -1313, -2421, 24702, 11811, -1324, -2419, 24624, 11897, -1334, -2418, 24547, 11984, -1345,
	-2416, 24469, 12071, -1356, -2415, 24391, 12158, -1366, -2413, 24314, 12244, -1377, -2411, 24234, 12332, -1387,
	-2409, 24156, 12419, -1398, -2407, 24077, 12506, -1408, -2405, 23999, 12593, -1419, -2402, 23918, 12681, -1429,
	-2400, 23840, 12768, -1440, -2397, 23759, 12856, -1450, -2395, 23681, 12943, -1461, -2392, 23600, 13031, -1471,
	-2389, 23520, 13119, -1482, -2386, 23440, 13206, -1492, -2383, 23360, 13294, -1503, -2380, 23279, 13382, -1513,
	-2377, 23198, 13470, -1523, -2373, 23117, 13558, -1534, -2370, 23035, 13647, -1544, -2366, 22953, 13735, -1554,
	-2362, 22872, 13823, -1565, -2359, 22791, 13911, -1575, -2355, 22708, 14000, -1585, -2351, 22626, 14088, -1595,
	-2347, 22544, 14177, -1606, -2342, 22461, 14265, -1616, -2338, 22378, 14354, -1626, -2334, 22296, 14442, -1636,
	-2329, 22212, 14531, -1646, -2325, 22130, 14619, -1656, -2320, 22046, 14708, -1666, -2315, 21962, 14797, -1676,
	-2310, 21879, 14885, -1686, -2305, 21795, 14974, -1696, -2300, 21711, 15063, -1706, -2295, 21626, 15152, -1715,
	-2290, 21542, 15241, -1725, -2284, 21458, 15329, -1735, -2279, 21374, 15418, -1745, -2274, 21289, 15507, -1754,
	-2268, 21204, 15596, -1764, -2262, 21119, 15685, -1774, -2257, 21034, 15774, -1783, -2251, 20949, 15863, -1793,
	-2245, 20863, 15952, -1802, -2239, 20779, 16040, -1812, -2233, 20693, 16129, -1821, -2227, 20607, 16218, -1830,
	-2220, 20521, 16307, -1840, -2214, 20435, 16396, -1849, -2208, 20349, 16485, -1858, -2201, 20262, 16574, -1867,
	-2195, 20177, 16662, -1876, -2188, 20091, 16751, -1886, -2181, 20004, 16840, -1895, -2174, 19917, 16929, -1904,
	-2168, 19831, 17018, -1913, -2161, 19744, 17106, -1921, -2154, 19657, 17195, -1930, -2146, 19569, 17284, -1939,
	-2139, 19483, 17372, -1948, -2132, 19395, 17461, -1956, -2125, 19309, 17549, -1965, -2117, 19221, 17638, -1974,
	-2110, 19134, 17726, -1982, -2102, 19046, 17815, -1991, -2095, 18959, 17903, -1999, -2087, 18871, 17991, -2007,
	-2079, 18783, 18080, -2016, -2072, 18696, 18168, -2024, -2064, 18608, 18256, -2032, -2056, 18520, 18344, -2040,
	-2048, 18432, 18432, -2048, -2040, 18344, 18520, -2056, -2032, 18256, 18608, -2064, -2024, 18168, 18696, -2072,
	-2016, 18080, 18783, -2079, -2007, 17991, 18871, -2087, -1999, 17903, 18959, -2095, -1991, 17815, 19046, -2102,
	-1982, 17726, 19134, -2110, -1974, 17638, 19221, -2117, -1965, 17549, 19309, -2125, -1956, 17461, 19395, -2132,
	-1948, 17372, 19483, -2139, -1939, 17284, 19569, -2146, -1930, 17195, 19657, -2154, -1921, 17106, 19744, -2161,
	-1913, 17018, 19831, -2168, -1904, 16929, 19917, -2174, -1895, 16840, 20004, -2181, -1886, 16751, 20091, -2188,
	-1876, 16662, 20177, -2195, -1867, 16574, 20262, -2201, -1858, 16485, 20349, -2208, -1849, 16396, 20435, -2214,
	-1840, 16307, 20521, -2220, -1830, 16218, 20607, -2227, -1821, 16129, 20693, -2233, -1812, 16040, 20779, -2239,
	-1802, 15952, 20863, -2245, -1793, 15863, 20949, -2251, -1783, 15774, 21034, -2257, -1774, 15685, 21119, -2262,
	-1764, 15596, 21204, -2268, -1754, 15507, 21289, -2274, -1745, 15418, 21374, -2279, -1735, 15329, 21458, -2284,
	-1725, 15241, 21542, -2290, -1715, 15152, 21626, -2295, -1706, 15063, 21711, -2300, -1696, 14974, 21795, -2305,
	-1686, 14885, 21879, -2310, -1676, 14797, 21962, -2315, -1666, 14708, 22046, -2320, -1656, 14619, 22130, -2325,
	-1646, 14531, 22212, -2329, -1636, 14442, 22296, -2334, -1626, 14354, 22378, -2338, -1616, 14265, 22461, -2342,
	-1606, 14177, 22544, -2347, -1595, 14088, 22626, -2351, -1585, 14000, 22708, -2355, -1575, 13911, 22791, -2359,
	-1565, 13823, 22872, -2362, -1554, 13735, 22953, -2366, -1544, 13647, 23035, -2370, -1534, 13558, 23117, -2373,
	-1523, 13470, 23198, -2377, -1513, 13382, 23279, -2380, -1503, 13294, 23360, -2383, -1492, 13206, 23440, -2386,
	-1482, 13119, 23520, -2389, -1471, 13031, 23600, -2392, -1461, 12943, 23681, -2395, -1450, 12856, 23759, -2397,
	-1440, 12768, 23840, -2400, -1429, 12681, 23918, -2402, -1419, 12593, 23999, -2405, -1408, 12506, 24077, -2407,
	-1398, 12419, 24156, -2409, -1387, 12332, 24234, -2411, -1377, 12244, 24314, -2413, -1366, 12158, 24391, -2415,
	-1356, 12071, 24469, -2416, -1345, 11984, 24547, -2418, -1334, 11897, 24624, -2419, -1324, 11811, 24702, -2421,
	-1313, 11724, 24779, -2422, -1302, 11638, 24855, -2423, -1292, 11552, 24932, -2424, -1281, 11466, 25008, -2425,
	-1271, 11380, 25085, -2426, -1260, 11294, 25160, -2426, -1249, 11208, 25236, -2427, -1239, 11122, 25312, -2427,
	-1228, 11037, 25386, -2427, -1217, 10951, 25461, -2427, -1207, 10866, 25536, -2427, -1196, 10781, 25610, -2427,
	-1185, 10696, 25684, -2427, -1175, 10611, 25758, -2426, -1164, 10526, 25832, -2426, -1153, 10441, 25905, -2425,
	-1143, 10357, 25978, -2424, -1132, 10272, 26052, -2424, -1121, 10188, 26123, -2422, -1111, 10104, 26196, -2421,
	-1100, 10020, 26268, -2420, -1089,  9936, 26340, -2419, -1079,  9853, 26411, -2417, -1068,  9769, 26482, -2415,
	-1058,  9686, 26553, -2413, -1047,  9603, 26623, -2411, -1036,  9520, 26693, -2409, -1026,  9437, 26764, -2407,
	-1015,  9354, 26834, -2405, -1005,  9271, 26904, -2402,  -994,  9189, 26972, -2399,  -984,  9107, 27042, -2397,
	 -973,  9025, 27110, -2394,  -963,  8943, 27179, -2391,  -952,  8861, 27246, -2387,  -942,  8780, 27314, -2384,
	 -932,  8699, 27382, -2381,  -921,  8617, 27449, -2377,  -911,  8536, 27516, -2373,  -900,  8456, 27581, -2369,
	 -890,  8375, 27648, -2365,  -880,  8295, 27714, -2361,  -869,  8215, 27778, -2356,  -859,  8135, 27844, -2352,
	 -849,  8055, 27909, -2347,  -839,  7975, 27974, -2342,  -829,  7896, 28038, -2337,  -818,  7817, 28101, -2332,
	 -808,  7738, 28165, -2327,  -798,  7659, 28228, -2321,  -788,  7580, 28292, -2316,  -778,  7502, 28354, -2310,
	 -768,  7424, 28416, -2304,  -758,  7346, 28478, -2298,  -748,  7268, 28540, -2292,  -738,  7191, 28600, -2285,
	 -728,  7114, 28661, -2279,  -718,  7037, 28721, -2272,  -709,  6960, 28782, -2265,  -699,  6883, 28842, -2258,
	 -689,  6807, 28901, -2251,  -679,  6731, 28960, -2244,  -670,  6655, 29019, -2236,  -660,  6580, 29076, -2228,
	 -650,  6504, 29135, -2221,  -641,  6429, 29193, -2213,  -631,  6354, 29249, -2204,  -622,  6280, 29306, -2196,
	 -613,  6206, 29363, -2188,  -603,  6131, 29419, -2179,  -594,  6058, 29474, -2170,  -584,  5984, 29529, -2161,
	 -575,  5911, 29584, -2152,  -566,  5838, 29638, -2142,  -557,  5765, 29693, -2133,  -548,  5692, 29747, -2123,
	 -539,  5620, 29800, -2113,  -530,  5548, 29853, -2103,  -521,  5476, 29906, -2093,  -512,  5405, 29958, -2083,
	 -503,  5334, 30009, -2072,  -494,  5263, 30060, -2061,  -485,  5192, 30111, -2050,  -477,  5122, 30162, -2039,
	 -468,  5052, 30212, -2028,  -459,  4982, 30262, -2017,  -451,  4913, 30311, -2005,  -442,  4844, 30359, -1993,
	 -434,  4775, 30408, -1981,  -426,  4706, 30457, -1969,  -417,  4638, 30503, -1956,  -409,  4570, 30551, -1944,
	 -401,  4502, 30598, -1931,  -393,  4435, 30644, -1918,  -385,  4368, 30690, -1905,  -377,  4301, 30736, -1892,
	 -369,  4235, 30780, -1878,  -361,  4169, 30825, -1865,  -353,  4103, 30869, -1851,  -345,  4038, 30912, -1837,
	 -338,  3973, 30956, -1823,  -330,  3908, 30998, -1808,  -322,  3843, 31040, -1793,  -315,  3779, 31083, -1779,
	 -307,  3715, 31124, -1764,  -300,  3652, 31164, -1748,  -293,  3589, 31205, -1733,  -286,  3526, 31245, -1717,
	 -278,  3463, 31285, -1702,  -271,  3401, 31324, -1686,  -264,  3339, 31362, -1669,  -257,  3278, 31400, -1653,
	 -251,  3217, 31438, -1636,  -244,  3156, 31476, -1620,  -237,  3096, 31512, -1603,  -231,  3036, 31548, -1585,
	 -224,  2976, 31584, -1568,  -218,  2917, 31619, -1550,  -211,  2858, 31654, -1533,  -205,  2799, 31689, -1515,
	 -199,  2741, 31722, -1496,  -192,  2683, 31755, -1478,  -186,  2626, 31787, -1459,  -180,  2568, 31820, -1440,
	 -175,  2512, 31852, -1421,  -169,  2455, 31884, -1402,  -163,  2399, 31915, -1383,  -157,  2344, 31944, -1363,
	 -152,  2289, 31974, -1343,  -146,  2234, 32003, -1323,  -141,  2179, 32033, -1303,  -136,  2125, 32061, -1282,
	 -131,  2072, 32089, -1262,  -125,  2018, 32116, -1241,  -120,  1965, 32142, -1219,  -115,  1913, 32168, -1198,
	 -111,  1861, 32194, -1176,  -106,  1809, 32220, -1155,  -101,  1758, 32244, -1133,   -97,  1707, 32268, -1110,
	  -92,  1657, 32291, -1088,   -88,  1607, 32314, -1065,   -84,  1557, 32337, -1042,   -79,  1508, 32358, -1019,
	  -75,  1459, 32380,  -996,   -71,  1411, 32400,  -972,   -67,  1363, 32420,  -948,   -64,  1315, 32441,  -924,
	  -60,  1268, 32460,  -900,   -56,  1221, 32479,  -876,   -53,  1175, 32497,  -851,   -50,  1129, 32515,  -826,
	  -46,  1084, 32531,  -801,   -43,  1039, 32547,  -775,   -40,   995, 32563,  -750,   -37,   951, 32578,  -724,
	  -34,   907, 32593,  -698,   -32,   864, 32607,  -671,   -29,   821, 32621,  -645,   -26,   779, 32633,  -618,
	  -24,   737, 32646,  -591,   -22,   696, 32658,  -564,   -20,   655, 32669,  -536,   -17,   614, 32679,  -508,
	  -16,   575, 32690,  -481,   -14,   535, 32699,  -452,   -12,   496, 32708,  -424,   -10,   457, 32716,  -395,
	   -9,   419, 32724,  -366,    -7,   382, 32730,  -337,    -6,   345, 32737,  -308,    -5,   308, 32743,  -278,
	   -4,   272, 32748,  -248,    -3,   236, 32753,  -218,    -2,   201, 32757,  -188,    -2,   166, 32761,  -157,
	   -1,   132, 32763,  -126,    -1,    98, 32766,   -95,     0,    65, 32767,   -64,     0,    32, 32767,   -32
};

#endif
