/*FreeMind - A Program for creating and viewing Mindmaps
 *Copyright (C) 2000-2001  Joerg Mueller <joergmueller@bigfoot.com>
 *See COPYING for Details
 *
 *This program is free software; you can redistribute it and/or
 *modify it under the terms of the GNU General Public License
 *as published by the Free Software Foundation; either version 2
 *of the License, or (at your option) any later version.
 *
 *This program is distributed in the hope that it will be useful,
 *but WITHOUT ANY WARRANTY; without even the implied warranty of
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *GNU General Public License for more details.
 *
 *You should have received a copy of the GNU General Public License
 *along with this program; if not, write to the Free Software
 *Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*$Id: BrowseToolBar.java,v 1.6 2003/11/03 11:00:13 sviles Exp $*/

package freemind.modes.browsemode;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JToolBar;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class BrowseToolBar extends JToolBar {

    private BrowseController c;
    JTextField urlfield = new JTextField();

    public BrowseToolBar(BrowseController controller) {
	
	this.c=controller;
        this.setRollover(true);

	urlfield.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    c.loadURL(urlfield.getText());		    
		}
	    });


	add(new JLabel("URL:"));
	add(urlfield);
    }

    void setURLField (String text) {
	urlfield.setText(text);
    }
}
