/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.expressions.CompoundExpression;
import oracle.toplink.essentials.internal.expressions.DataExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionIterator;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.ForUpdateClause;
import oracle.toplink.essentials.internal.expressions.FunctionExpression;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.ParameterExpression;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.expressions.RelationExpression;
import oracle.toplink.essentials.internal.expressions.SQLStatement;
import oracle.toplink.essentials.internal.expressions.TableAliasLookup;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateCollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectCollectionMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.platform.database.DB2MainframePlatform;
import oracle.toplink.essentials.queryframework.SQLCall;

public class SQLSelectStatement
extends SQLStatement {
    protected Vector fields = NonSynchronizedVector.newInstance(2);
    protected Vector nonSelectFields;
    protected Vector tables = NonSynchronizedVector.newInstance(4);
    protected short distinctState = 0;
    protected Vector orderByExpressions;
    protected Vector groupByExpressions;
    protected Expression havingExpression;
    protected ForUpdateClause forUpdateClause;
    protected boolean isAggregateSelect = false;
    protected Vector outerJoinedExpressions;
    protected Vector outerJoinedMappingCriteria;
    protected Vector outerJoinedAdditionalJoinCriteria;
    protected List descriptorsForMultitableInheritanceOnly;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected Vector orderSiblingsByExpressions;
    protected boolean requiresAliases = false;
    protected Hashtable tableAliases;
    protected DatabaseTable lastTable;
    protected DatabaseTable currentAlias;
    protected int currentAliasNumber = 0;
    protected SQLSelectStatement parentStatement;

    public void addField(DatabaseField field) {
        this.getFields().addElement(field);
    }

    public void addField(Expression expression) {
        if (expression instanceof FunctionExpression && ((FunctionExpression)expression).getOperator().isAggregateOperator()) {
            this.setIsAggregateSelect(true);
        }
        this.getFields().addElement(expression);
    }

    protected void addOrderByExpressionToSelectForDistinct() {
        Enumeration orderExpressionsEnum = this.getOrderByExpressions().elements();
        while (orderExpressionsEnum.hasMoreElements()) {
            Expression orderExpression = (Expression)orderExpressionsEnum.nextElement();
            Expression fieldExpression = null;
            fieldExpression = orderExpression.isFunctionExpression() && orderExpression.getOperator().isOrderOperator() ? ((FunctionExpression)orderExpression).getBaseExpression() : orderExpression;
            if (!fieldExpression.selectIfOrderedBy() || this.fieldsContainField(this.getFields(), fieldExpression)) continue;
            this.addField(fieldExpression);
        }
    }

    public void addTable(DatabaseTable table) {
        if (!this.getTables().contains(table)) {
            this.getTables().addElement(table);
        }
    }

    public void appendFromClauseForInformixOuterJoin(ExpressionSQLPrinter printer, Vector outerJoinedAliases) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        boolean firstTable = true;
        for (int index = 0; index < this.getOuterJoinExpressions().size(); ++index) {
            DatabaseTable newAlias;
            DatabaseTable newTarget;
            QueryKeyExpression outerExpression = (QueryKeyExpression)this.getOuterJoinExpressions().elementAt(index);
            CompoundExpression relationExpression = (CompoundExpression)this.getOuterJoinedMappingCriteria().elementAt(index);
            DatabaseTable targetTable = null;
            targetTable = outerExpression.getMapping().isDirectCollectionMapping() ? ((DirectCollectionMapping)outerExpression.getMapping()).getReferenceTable() : (DatabaseTable)outerExpression.getMapping().getReferenceDescriptor().getTables().firstElement();
            DatabaseTable sourceTable = (DatabaseTable)((ObjectExpression)outerExpression.getBaseExpression()).getDescriptor().getTables().firstElement();
            DatabaseTable sourceAlias = outerExpression.getBaseExpression().aliasForTable(sourceTable);
            DatabaseTable targetAlias = outerExpression.aliasForTable(targetTable);
            if (outerJoinedAliases.contains(sourceAlias) || outerJoinedAliases.contains(targetAlias)) continue;
            if (!firstTable) {
                writer.write(", ");
            }
            firstTable = false;
            writer.write(sourceTable.getQualifiedName());
            outerJoinedAliases.addElement(sourceAlias);
            writer.write(" ");
            writer.write(sourceAlias.getQualifiedName());
            if (outerExpression.getMapping().isManyToManyMapping()) {
                newTarget = ((ManyToManyMapping)outerExpression.getMapping()).getRelationTable();
                newAlias = relationExpression.aliasForTable(newTarget);
                writer.write(", OUTER ");
                writer.write(newTarget.getQualifiedName());
                writer.write(" ");
                outerJoinedAliases.addElement(newAlias);
                writer.write(newAlias.getQualifiedName());
                continue;
            }
            if (outerExpression.getMapping().isDirectCollectionMapping()) {
                newTarget = ((DirectCollectionMapping)outerExpression.getMapping()).getReferenceTable();
                newAlias = relationExpression.aliasForTable(newTarget);
                writer.write(", OUTER ");
                writer.write(newTarget.getQualifiedName());
                writer.write(" ");
                outerJoinedAliases.addElement(newAlias);
                writer.write(newAlias.getQualifiedName());
                continue;
            }
            Enumeration target = outerExpression.getMapping().getReferenceDescriptor().getTables().elements();
            while (target.hasMoreElements()) {
                DatabaseTable newTarget2 = (DatabaseTable)target.nextElement();
                QueryKeyExpression onExpression = outerExpression;
                DatabaseTable newAlias2 = outerExpression.aliasForTable(newTarget2);
                writer.write(", OUTER ");
                writer.write(newTarget2.getQualifiedName());
                writer.write(" ");
                outerJoinedAliases.addElement(newAlias2);
                writer.write(newAlias2.getQualifiedName());
            }
        }
    }

    public void appendFromClauseForOuterJoin(ExpressionSQLPrinter printer, Vector outerJoinedAliases) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        boolean firstTable = true;
        boolean requiresEscape = false;
        for (int index = 0; index < this.getOuterJoinExpressions().size(); ++index) {
            boolean hasAdditionalJoinExpressions;
            QueryKeyExpression outerExpression = (QueryKeyExpression)this.getOuterJoinExpressions().elementAt(index);
            DatabaseTable targetTable = null;
            DatabaseTable sourceTable = null;
            DatabaseTable sourceAlias = null;
            DatabaseTable targetAlias = null;
            if (outerExpression != null) {
                targetTable = outerExpression.getMapping().isDirectCollectionMapping() ? ((DirectCollectionMapping)outerExpression.getMapping()).getReferenceTable() : (DatabaseTable)outerExpression.getMapping().getReferenceDescriptor().getTables().firstElement();
                sourceTable = (DatabaseTable)((ObjectExpression)outerExpression.getBaseExpression()).getDescriptor().getTables().firstElement();
                sourceAlias = outerExpression.getBaseExpression().aliasForTable(sourceTable);
                targetAlias = outerExpression.aliasForTable(targetTable);
            } else {
                sourceTable = (DatabaseTable)((ClassDescriptor)this.getDescriptorsForMultitableInheritanceOnly().get(index)).getTables().firstElement();
                targetTable = (DatabaseTable)((ClassDescriptor)this.getDescriptorsForMultitableInheritanceOnly().get(index)).getInheritancePolicy().getChildrenTables().get(0);
                Expression exp = (Expression)((Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(index)).get(targetTable);
                sourceAlias = exp.aliasForTable(sourceTable);
                targetAlias = exp.aliasForTable(targetTable);
            }
            if (outerJoinedAliases.contains(targetAlias)) continue;
            if (!outerJoinedAliases.contains(sourceAlias)) {
                if (requiresEscape && session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write("}");
                }
                if (!firstTable) {
                    writer.write(",");
                }
                if (session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write(session.getPlatform().getJDBCOuterJoinString());
                }
                requiresEscape = true;
                firstTable = false;
                writer.write(sourceTable.getQualifiedName());
                outerJoinedAliases.addElement(sourceAlias);
                writer.write(" ");
                writer.write(sourceAlias.getQualifiedName());
            }
            if (outerExpression == null) {
                this.printAdditionalJoins(printer, outerJoinedAliases, (ClassDescriptor)this.getDescriptorsForMultitableInheritanceOnly().get(index), (Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(index));
                continue;
            }
            if (outerExpression.getMapping().isDirectCollectionMapping()) {
                Expression onExpression = (Expression)this.getOuterJoinedMappingCriteria().elementAt(index);
                DatabaseTable newAlias = onExpression.aliasForTable(targetTable);
                writer.write(" LEFT OUTER JOIN ");
                writer.write(targetTable.getQualifiedName());
                writer.write(" ");
                outerJoinedAliases.addElement(newAlias);
                writer.write(newAlias.getQualifiedName());
                writer.write(" ON ");
                if (session.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)onExpression).printSQLNoParens(printer);
                    continue;
                }
                onExpression.printSQL(printer);
                continue;
            }
            if (outerExpression.getMapping().isManyToManyMapping()) {
                DatabaseTable relationTable = ((ManyToManyMapping)outerExpression.getMapping()).getRelationTable();
                DatabaseTable relationAlias = ((Expression)this.getOuterJoinedMappingCriteria().elementAt(index)).aliasForTable(relationTable);
                writer.write(" LEFT OUTER JOIN (");
                writer.write(relationTable.getQualifiedName());
                writer.write(" ");
                outerJoinedAliases.addElement(relationAlias);
                writer.write(relationAlias.getQualifiedName());
                NonSynchronizedVector tablesInOrder = NonSynchronizedVector.newInstance(3);
                ((Vector)tablesInOrder).add(sourceTable);
                ((Vector)tablesInOrder).add(relationTable);
                ((Vector)tablesInOrder).add(targetTable);
                TreeMap indexToExpressionMap = new TreeMap();
                SQLSelectStatement.mapTableIndexToExpression((Expression)this.getOuterJoinedMappingCriteria().elementAt(index), indexToExpressionMap, tablesInOrder);
                Expression sourceToRelationJoin = (Expression)indexToExpressionMap.get(new Integer(1));
                Expression relationToTargetJoin = (Expression)indexToExpressionMap.get(new Integer(2));
                writer.write(" JOIN ");
                writer.write(targetTable.getQualifiedName());
                writer.write(" ");
                outerJoinedAliases.addElement(targetAlias);
                writer.write(targetAlias.getQualifiedName());
                writer.write(" ON ");
                if (session.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)relationToTargetJoin).printSQLNoParens(printer);
                } else {
                    relationToTargetJoin.printSQL(printer);
                }
                Map tablesJoinExpression = (Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(index);
                if (tablesJoinExpression != null && !tablesJoinExpression.isEmpty()) {
                    this.printAdditionalJoins(printer, outerJoinedAliases, outerExpression.getMapping().getReferenceDescriptor(), tablesJoinExpression);
                }
                writer.write(") ON ");
                if (session.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)sourceToRelationJoin).printSQLNoParens(printer);
                    continue;
                }
                sourceToRelationJoin.printSQL(printer);
                continue;
            }
            writer.write(" LEFT OUTER JOIN ");
            Map tablesJoinExpression = (Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(index);
            boolean bl = hasAdditionalJoinExpressions = tablesJoinExpression != null && !tablesJoinExpression.isEmpty();
            if (hasAdditionalJoinExpressions) {
                writer.write("(");
            }
            writer.write(targetTable.getQualifiedName());
            writer.write(" ");
            outerJoinedAliases.addElement(targetAlias);
            writer.write(targetAlias.getQualifiedName());
            if (hasAdditionalJoinExpressions) {
                this.printAdditionalJoins(printer, outerJoinedAliases, outerExpression.getMapping().getReferenceDescriptor(), tablesJoinExpression);
                writer.write(")");
            }
            writer.write(" ON ");
            Expression sourceToTargetJoin = (Expression)this.getOuterJoinedMappingCriteria().elementAt(index);
            if (session.getPlatform() instanceof DB2MainframePlatform) {
                ((RelationExpression)sourceToTargetJoin).printSQLNoParens(printer);
                continue;
            }
            sourceToTargetJoin.printSQL(printer);
        }
        if (requiresEscape && session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
            writer.write("}");
        }
    }

    protected void printAdditionalJoins(ExpressionSQLPrinter printer, Vector outerJoinedAliases, ClassDescriptor desc, Map tablesJoinExpressions) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        Vector descriptorTables = desc.getTables();
        int nDescriptorTables = descriptorTables.size();
        Vector tables = desc.hasInheritance() ? desc.getInheritancePolicy().getAllTables() : descriptorTables;
        int tablesSize = tables.size();
        for (int i = 1; i < tablesSize; ++i) {
            DatabaseTable table = (DatabaseTable)tables.elementAt(i);
            Expression onExpression = (Expression)tablesJoinExpressions.get(table);
            if (onExpression == null) continue;
            if (i < nDescriptorTables) {
                writer.write(" JOIN ");
            } else {
                writer.write(" LEFT OUTER JOIN ");
            }
            writer.write(table.getQualifiedName());
            writer.write(" ");
            DatabaseTable alias = onExpression.aliasForTable(table);
            outerJoinedAliases.addElement(alias);
            writer.write(alias.getQualifiedName());
            writer.write(" ON ");
            if (session.getPlatform() instanceof DB2MainframePlatform) {
                ((RelationExpression)onExpression).printSQLNoParens(printer);
                continue;
            }
            onExpression.printSQL(printer);
        }
    }

    public void appendFromClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        writer.write(" FROM ");
        boolean firstTable = true;
        Vector outerJoinedAliases = new Vector(1);
        if (this.hasOuterJoinExpressions()) {
            if (session.getPlatform().isInformixOuterJoin()) {
                this.appendFromClauseForInformixOuterJoin(printer, outerJoinedAliases);
            } else if (!session.getPlatform().shouldPrintOuterJoinInWhereClause()) {
                this.appendFromClauseForOuterJoin(printer, outerJoinedAliases);
            }
            firstTable = false;
        }
        if (this.getTableAliases().isEmpty()) {
            throw QueryException.invalidBuilderInQuery(null);
        }
        Enumeration aliasesEnum = this.getTableAliases().keys();
        while (aliasesEnum.hasMoreElements()) {
            DatabaseTable alias = (DatabaseTable)aliasesEnum.nextElement();
            if (outerJoinedAliases.contains(alias)) continue;
            DatabaseTable table = (DatabaseTable)this.getTableAliases().get(alias);
            if (this.requiresAliases()) {
                if (!firstTable) {
                    writer.write(", ");
                }
                firstTable = false;
                writer.write(table.getQualifiedName());
                writer.write(" ");
                writer.write(alias.getQualifiedName());
                continue;
            }
            writer.write(table.getQualifiedName());
        }
    }

    public void appendGroupByClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        if (this.getGroupByExpressions().isEmpty()) {
            return;
        }
        printer.getWriter().write(" GROUP BY ");
        Vector newFields = new Vector();
        printer.setIsFirstElementPrinted(false);
        Enumeration expressionsEnum = this.getGroupByExpressions().elements();
        while (expressionsEnum.hasMoreElements()) {
            Expression expression = (Expression)expressionsEnum.nextElement();
            this.writeFieldsFromExpression(printer, expression, newFields);
        }
    }

    public void appendHierarchicalQueryClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        Expression startWith = this.getStartWithExpression();
        Expression connectBy = this.getConnectByExpression();
        Vector orderSiblingsBy = this.getOrderSiblingsByExpressions();
        if (startWith != null) {
            printer.getWriter().write(" START WITH ");
            startWith.printSQL(printer);
        }
        if (connectBy != null) {
            if (!connectBy.isQueryKeyExpression()) {
                throw QueryException.illFormedExpression(connectBy);
            }
            printer.getWriter().write(" CONNECT BY ");
            DatabaseMapping mapping = ((QueryKeyExpression)connectBy).getMapping();
            ClassDescriptor descriptor = mapping.getDescriptor();
            Map foreignKeys = null;
            if (mapping.isOneToManyMapping()) {
                OneToManyMapping otm = (OneToManyMapping)mapping;
                foreignKeys = otm.getTargetForeignKeyToSourceKeys();
            } else if (mapping.isOneToOneMapping()) {
                OneToOneMapping oto = (OneToOneMapping)mapping;
                foreignKeys = oto.getSourceToTargetKeyFields();
            } else if (mapping.isAggregateCollectionMapping()) {
                AggregateCollectionMapping acm = (AggregateCollectionMapping)mapping;
                foreignKeys = acm.getTargetForeignKeyToSourceKeys();
            } else {
                throw QueryException.invalidQueryKeyInExpression(connectBy);
            }
            DatabaseTable defaultTable = descriptor.getDefaultTable();
            String tableName = "";
            tableName = this.requiresAliases() ? this.getBuilder().aliasForTable(defaultTable).getName() : defaultTable.getName();
            if (foreignKeys != null && !foreignKeys.isEmpty()) {
                Iterator sourceKeys = foreignKeys.keySet().iterator();
                if (foreignKeys.size() > 1) {
                    printer.getWriter().write("((");
                }
                DatabaseField source = (DatabaseField)sourceKeys.next();
                DatabaseField target = (DatabaseField)foreignKeys.get(source);
                if (mapping.isOneToOneMapping()) {
                    printer.getWriter().write("PRIOR " + tableName + "." + source.getName());
                    printer.getWriter().write(" = " + tableName + "." + target.getName());
                } else {
                    printer.getWriter().write(tableName + "." + source.getName());
                    printer.getWriter().write(" = PRIOR " + tableName + "." + target.getName());
                }
                while (sourceKeys.hasNext()) {
                    printer.getWriter().write(") AND (");
                    source = (DatabaseField)sourceKeys.next();
                    target = (DatabaseField)foreignKeys.get(source);
                    if (mapping.isOneToOneMapping()) {
                        printer.getWriter().write("PRIOR " + tableName + "." + source.getName());
                        printer.getWriter().write(" = " + tableName + "." + target.getName());
                        continue;
                    }
                    printer.getWriter().write(tableName + "." + source.getName());
                    printer.getWriter().write(" = PRIOR " + tableName + "." + target.getName());
                }
                if (foreignKeys.size() > 1) {
                    printer.getWriter().write("))");
                }
            }
        }
        if (orderSiblingsBy != null) {
            printer.getWriter().write(" ORDER SIBLINGS BY ");
            Enumeration expressionEnum = orderSiblingsBy.elements();
            while (expressionEnum.hasMoreElements()) {
                Expression ex = (Expression)expressionEnum.nextElement();
                ex.printSQL(printer);
                if (!expressionEnum.hasMoreElements()) continue;
                printer.getWriter().write(", ");
            }
        }
    }

    public void appendOrderClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        if (!this.hasOrderByExpressions()) {
            return;
        }
        printer.getWriter().write(" ORDER BY ");
        Enumeration expressionsEnum = this.getOrderByExpressions().elements();
        while (expressionsEnum.hasMoreElements()) {
            Expression expression = (Expression)expressionsEnum.nextElement();
            expression.printSQL(printer);
            if (!expressionsEnum.hasMoreElements()) continue;
            printer.getWriter().write(", ");
        }
    }

    public void assignAliases(Vector allExpressions) {
        this.currentAliasNumber = this.getCurrentAliasNumber();
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                SQLSelectStatement.this.currentAliasNumber = each.assignTableAliasesStartingAt(SQLSelectStatement.this.currentAliasNumber);
            }
        };
        if (allExpressions.isEmpty()) {
            if (this.getBuilder() != null && this.requiresAliases()) {
                this.getBuilder().assignTableAliasesStartingAt(this.currentAliasNumber);
            }
        } else {
            Enumeration expressionEnum = allExpressions.elements();
            while (expressionEnum.hasMoreElements()) {
                Expression expression = (Expression)expressionEnum.nextElement();
                iterator.iterateOn(expression);
            }
        }
        this.setCurrentAliasNumber(this.currentAliasNumber);
    }

    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnManyRows();
        CharArrayWriter writer = new CharArrayWriter(200);
        ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, this.requiresAliases());
        printer.setWriter(writer);
        call.setFields(this.printSQL(printer));
        call.setSQLString(((Object)writer).toString());
        return call;
    }

    public void computeDistinct() {
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isQueryKeyExpression() && ((QueryKeyExpression)expression).shouldQueryToManyRelationship() && !SQLSelectStatement.this.isDistinctComputed()) {
                    SQLSelectStatement.this.useDistinct();
                }
            }
        };
        if (this.getWhereClause() != null) {
            iterator.iterateOn(this.getWhereClause());
        }
    }

    public boolean isSubSelect() {
        return this.getParentStatement() != null;
    }

    public void computeTables() {
        Expression outerJoinCriteria;
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                TableAliasLookup aliases = each.getTableAliases();
                if (aliases != null && !aliases.haveBeenAddedToStatement()) {
                    aliases.addToHashtable((Hashtable)this.getResult());
                    aliases.setHaveBeenAddedToStatement(true);
                }
            }
        };
        iterator.setResult(new Hashtable(5));
        if (this.getWhereClause() != null) {
            iterator.iterateOn(this.getWhereClause());
        } else if (this.hasOuterJoinExpressions() && (outerJoinCriteria = (Expression)this.getOuterJoinedMappingCriteria().firstElement()) != null) {
            iterator.iterateOn(outerJoinCriteria);
        }
        for (Object field : this.getFields()) {
            if (!(field instanceof Expression)) continue;
            iterator.iterateOn((Expression)field);
        }
        iterator.iterateOn(this.getBuilder());
        Hashtable allTables = (Hashtable)iterator.getResult();
        this.setTableAliases(allTables);
        Enumeration e = allTables.elements();
        while (e.hasMoreElements()) {
            this.addTable((DatabaseTable)e.nextElement());
        }
    }

    public void computeTablesFromTables() {
        Hashtable<DatabaseTable, DatabaseTable> allTables = new Hashtable<DatabaseTable, DatabaseTable>();
        for (int index = 0; index < this.getTables().size(); ++index) {
            DatabaseTable next = (DatabaseTable)this.getTables().elementAt(index);
            DatabaseTable alias = new DatabaseTable("t" + index);
            allTables.put(alias, next);
        }
        this.setTableAliases(allTables);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
    }

    protected boolean fieldsContainField(Vector fields, Expression expression) {
        if (!(expression instanceof DataExpression)) {
            return false;
        }
        DatabaseField orderByField = ((DataExpression)expression).getField();
        Enumeration fieldsEnum = fields.elements();
        while (fieldsEnum.hasMoreElements()) {
            Object fieldOrExpression = fieldsEnum.nextElement();
            if (fieldOrExpression instanceof DatabaseField) {
                DatabaseField field = (DatabaseField)fieldOrExpression;
                DataExpression exp = (DataExpression)expression;
                if (!field.equals(orderByField) || exp.getBaseExpression() != this.getBuilder()) continue;
                return true;
            }
            Expression exp = (Expression)fieldOrExpression;
            DatabaseTable table = orderByField.getTable();
            if (!exp.getFields().contains(orderByField) || !expression.aliasForTable(table).equals(exp.aliasForTable(table))) continue;
            return true;
        }
        return false;
    }

    public int getCurrentAliasNumber() {
        if (this.getParentStatement() != null) {
            return this.getParentStatement().getCurrentAliasNumber();
        }
        return this.currentAliasNumber;
    }

    public Vector getFields() {
        return this.fields;
    }

    protected ForUpdateClause getForUpdateClause() {
        return this.forUpdateClause;
    }

    public Vector getGroupByExpressions() {
        if (this.groupByExpressions == null) {
            this.groupByExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.groupByExpressions;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public Vector getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public Vector getNonSelectFields() {
        return this.nonSelectFields;
    }

    public Vector getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.orderByExpressions;
    }

    public Vector getOuterJoinedAdditionalJoinCriteria() {
        if (this.outerJoinedAdditionalJoinCriteria == null) {
            this.outerJoinedAdditionalJoinCriteria = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedAdditionalJoinCriteria;
    }

    public Vector getOuterJoinedMappingCriteria() {
        if (this.outerJoinedMappingCriteria == null) {
            this.outerJoinedMappingCriteria = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedMappingCriteria;
    }

    public Vector getOuterJoinExpressions() {
        if (this.outerJoinedExpressions == null) {
            this.outerJoinedExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedExpressions;
    }

    public List getDescriptorsForMultitableInheritanceOnly() {
        if (this.descriptorsForMultitableInheritanceOnly == null) {
            this.descriptorsForMultitableInheritanceOnly = new ArrayList(3);
        }
        return this.descriptorsForMultitableInheritanceOnly;
    }

    public SQLSelectStatement getParentStatement() {
        return this.parentStatement;
    }

    public Hashtable getTableAliases() {
        return this.tableAliases;
    }

    public Vector getTables() {
        return this.tables;
    }

    protected boolean hasAliasForTable(DatabaseTable table) {
        if (this.tableAliases != null) {
            return this.getTableAliases().containsKey(table);
        }
        return false;
    }

    public boolean hasGroupByExpressions() {
        return this.groupByExpressions != null && !this.groupByExpressions.isEmpty();
    }

    public boolean hasHavingExpression() {
        return this.havingExpression != null;
    }

    public boolean hasStartWithExpression() {
        return this.startWithExpression != null;
    }

    public boolean hasConnectByExpression() {
        return this.connectByExpression != null;
    }

    public boolean hasOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions != null;
    }

    public boolean hasHierarchicalQueryExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null && !this.orderByExpressions.isEmpty();
    }

    public boolean hasNonSelectFields() {
        return this.nonSelectFields != null && !this.nonSelectFields.isEmpty();
    }

    public boolean hasOuterJoinedAdditionalJoinCriteria() {
        return this.outerJoinedAdditionalJoinCriteria != null && !this.outerJoinedAdditionalJoinCriteria.isEmpty();
    }

    public boolean hasOuterJoinExpressions() {
        return this.outerJoinedExpressions != null && !this.outerJoinedExpressions.isEmpty();
    }

    public boolean isAggregateSelect() {
        return this.isAggregateSelect;
    }

    public boolean isDistinctComputed() {
        return this.distinctState != 0;
    }

    public final void normalize(AbstractSession session, ClassDescriptor descriptor) {
        this.normalize(session, descriptor, new IdentityHashtable());
    }

    public void normalize(AbstractSession session, ClassDescriptor descriptor, Dictionary clonedExpressions) {
        if (this.getBuilder() == null) {
            if (this.getWhereClause() == null) {
                this.setBuilder(new ExpressionBuilder());
            } else {
                this.setBuilder(this.getWhereClause().getBuilder());
            }
        }
        ExpressionBuilder builder = this.getBuilder();
        if (this.getWhereClause() == builder) {
            this.setWhereClause(null);
        }
        builder.setSession(session);
        if (!builder.doesNotRepresentAnObjectInTheQuery() && descriptor != null) {
            builder.setQueryClass(descriptor.getJavaClass());
        }
        Vector<Expression> allExpressions = new Vector<Expression>();
        this.rebuildAndAddExpressions(this.getFields(), allExpressions, builder, clonedExpressions);
        if (this.hasNonSelectFields()) {
            this.rebuildAndAddExpressions(this.getNonSelectFields(), allExpressions, builder, clonedExpressions);
        }
        if (this.hasGroupByExpressions()) {
            this.rebuildAndAddExpressions(this.getGroupByExpressions(), allExpressions, builder, clonedExpressions);
        }
        if (this.hasHavingExpression()) {
            Expression expression = this.getHavingExpression();
            ExpressionBuilder originalBuilder = expression.getBuilder();
            if (originalBuilder != builder) {
                expression = clonedExpressions.get(originalBuilder) != null ? expression.copiedVersionFrom(clonedExpressions) : expression.rebuildOn(builder);
                this.setHavingExpression(expression);
            }
            allExpressions.addElement(expression);
        }
        if (this.hasOrderByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderByExpressions(), allExpressions, builder, clonedExpressions);
        }
        if (this.hasOuterJoinExpressions()) {
            this.rebuildAndAddExpressions(this.getOuterJoinedMappingCriteria(), allExpressions, builder, clonedExpressions);
            Iterator criterias = this.getOuterJoinedAdditionalJoinCriteria().iterator();
            while (criterias.hasNext()) {
                this.rebuildAndAddExpressions((Map)criterias.next(), allExpressions, builder, clonedExpressions);
            }
        }
        if (this.hasStartWithExpression()) {
            this.startWithExpression = this.getStartWithExpression().rebuildOn(builder);
            allExpressions.addElement(this.startWithExpression);
        }
        if (this.hasConnectByExpression()) {
            this.connectByExpression = this.getConnectByExpression().rebuildOn(builder);
        }
        if (this.hasOrderSiblingsByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderSiblingsByExpressions(), allExpressions, builder, clonedExpressions);
        }
        Expression oldRoot = this.getWhereClause();
        ExpressionNormalizer normalizer = new ExpressionNormalizer(this);
        normalizer.setSession(session);
        Expression newRoot = null;
        if (oldRoot != null) {
            newRoot = oldRoot.normalize(normalizer);
        }
        if (descriptor != null) {
            builder.normalize(normalizer);
        }
        for (int index = 0; index < allExpressions.size(); ++index) {
            Expression expression = (Expression)allExpressions.elementAt(index);
            expression.normalize(normalizer);
        }
        if (newRoot == null) {
            this.setNormalizedWhereClause(normalizer.getAdditionalExpression());
        } else {
            this.setNormalizedWhereClause(newRoot.and(normalizer.getAdditionalExpression()));
        }
        if (this.getWhereClause() != null) {
            allExpressions.addElement(this.getWhereClause());
        }
        if (descriptor != null) {
            allExpressions.addElement(builder);
        }
        if (this.hasOuterJoinExpressions()) {
            for (Expression criteria : this.getOuterJoinedMappingCriteria()) {
                if (criteria == null) continue;
                allExpressions.add(criteria);
            }
            for (Map map : this.getOuterJoinedAdditionalJoinCriteria()) {
                if (map == null) continue;
                for (Expression criteria : map.values()) {
                    if (criteria == null) continue;
                    allExpressions.add(criteria);
                }
            }
        }
        this.assignAliases(allExpressions);
        if (descriptor == null) {
            this.computeTablesFromTables();
        } else {
            this.computeTables();
        }
        if (normalizer.encounteredSubSelectExpressions()) {
            normalizer.normalizeSubSelects(clonedExpressions);
        }
        Class aClass = null;
        if (descriptor != null) {
            aClass = descriptor.getJavaClass();
        }
        if (session.getPlatform(aClass).isInformix() || this.shouldDistinctBeUsed() && this.hasOrderByExpressions()) {
            this.addOrderByExpressionToSelectForDistinct();
        }
    }

    public void normalizeForView(AbstractSession theSession, ClassDescriptor theDescriptor, Dictionary clonedExpressions) {
        ExpressionBuilder builder;
        this.setRequiresAliases(true);
        if (this.getWhereClause() != null) {
            builder = this.getWhereClause().getBuilder();
        } else {
            builder = new ExpressionBuilder();
            this.setBuilder(builder);
        }
        builder.setViewTable((DatabaseTable)this.getTables().firstElement());
        this.normalize(theSession, theDescriptor, clonedExpressions);
    }

    public Vector printSQL(ExpressionSQLPrinter printer) {
        try {
            Vector selectFields = null;
            printer.setRequiresDistinct(this.shouldDistinctBeUsed());
            printer.printString("SELECT ");
            if (this.shouldDistinctBeUsed()) {
                printer.printString("DISTINCT ");
            }
            selectFields = this.writeFieldsIn(printer);
            this.appendFromClauseToWriter(printer);
            if (this.getWhereClause() != null) {
                printer.printString(" WHERE ");
                printer.printExpression(this.getWhereClause());
            }
            if (this.hasHierarchicalQueryExpressions()) {
                this.appendHierarchicalQueryClauseToWriter(printer);
            }
            if (this.hasGroupByExpressions()) {
                this.appendGroupByClauseToWriter(printer);
            }
            if (this.hasHavingExpression()) {
                printer.printString(" HAVING ");
                printer.printExpression(this.getHavingExpression());
            }
            if (this.hasOrderByExpressions()) {
                this.appendOrderClauseToWriter(printer);
            }
            if (this.getForUpdateClause() != null) {
                this.getForUpdateClause().printSQL(printer, this);
            }
            return selectFields;
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void rebuildAndAddExpressions(Vector expressions, Vector allExpressions, ExpressionBuilder primaryBuilder, Dictionary clonedExpressions) {
        for (int index = 0; index < expressions.size(); ++index) {
            Object fieldOrExpression = expressions.elementAt(index);
            if (!(fieldOrExpression instanceof Expression)) continue;
            Expression expression = (Expression)fieldOrExpression;
            ExpressionBuilder originalBuilder = expression.getBuilder();
            if (originalBuilder != primaryBuilder) {
                if (clonedExpressions.get(originalBuilder) != null) {
                    expression = expression.copiedVersionFrom(clonedExpressions);
                }
                if (originalBuilder.wasQueryClassSetInternally()) {
                    expression = expression.rebuildOn(primaryBuilder);
                }
                expressions.setElementAt(expression, index);
            }
            allExpressions.addElement(expression);
        }
    }

    public void rebuildAndAddExpressions(Map expressions, Vector allExpressions, ExpressionBuilder primaryBuilder, Dictionary clonedExpressions) {
        for (Map.Entry entry : expressions.entrySet()) {
            Object fieldOrExpression = entry.getValue();
            if (!(fieldOrExpression instanceof Expression)) continue;
            Expression expression = (Expression)fieldOrExpression;
            ExpressionBuilder originalBuilder = expression.getBuilder();
            if (originalBuilder != primaryBuilder) {
                if (clonedExpressions.get(originalBuilder) != null) {
                    expression = expression.copiedVersionFrom(clonedExpressions);
                }
                if (originalBuilder.wasQueryClassSetInternally()) {
                    expression = expression.rebuildOn(primaryBuilder);
                }
                entry.setValue(expression);
            }
            allExpressions.addElement(expression);
        }
    }

    public void removeField(DatabaseField field) {
        this.getFields().removeElement(field);
    }

    public void removeTable(DatabaseTable table) {
        this.getTables().removeElement(table);
    }

    public boolean requiresAliases() {
        if (this.requiresAliases || this.hasOuterJoinExpressions()) {
            return true;
        }
        if (this.tableAliases != null) {
            return this.getTableAliases().size() > 1;
        }
        return false;
    }

    public void resetDistinct() {
        this.setDistinctState((short)0);
    }

    public void setCurrentAliasNumber(int currentAliasNumber) {
        if (this.getParentStatement() != null) {
            this.getParentStatement().setCurrentAliasNumber(currentAliasNumber);
        } else {
            this.currentAliasNumber = currentAliasNumber;
        }
    }

    public void setNonSelectFields(Vector nonSelectFields) {
        this.nonSelectFields = nonSelectFields;
    }

    public void setNormalizedWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public void setDistinctState(short distinctState) {
        this.distinctState = distinctState;
    }

    public void setFields(Vector fields) {
        Enumeration fieldsEnum = fields.elements();
        while (fieldsEnum.hasMoreElements()) {
            Object fieldOrExpression = fieldsEnum.nextElement();
            if (!(fieldOrExpression instanceof FunctionExpression) || !((FunctionExpression)fieldOrExpression).getOperator().isAggregateOperator()) continue;
            this.setIsAggregateSelect(true);
            break;
        }
        this.fields = fields;
    }

    public void setGroupByExpressions(Vector expressions) {
        this.groupByExpressions = expressions;
    }

    public void setHavingExpression(Expression expressions) {
        this.havingExpression = expressions;
    }

    public void setHierarchicalQueryExpressions(Expression startWith, Expression connectBy, Vector orderSiblingsExpressions) {
        this.startWithExpression = startWith;
        this.connectByExpression = connectBy;
        this.orderSiblingsByExpressions = orderSiblingsExpressions;
    }

    public void setIsAggregateSelect(boolean isAggregateSelect) {
        this.isAggregateSelect = isAggregateSelect;
    }

    protected void setForUpdateClause(ForUpdateClause clause) {
        this.forUpdateClause = clause;
    }

    public void setLockingClause(ForUpdateClause lockingClause) {
        this.forUpdateClause = lockingClause;
    }

    public void setOrderByExpressions(Vector orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
    }

    public void setOuterJoinedAdditionalJoinCriteria(Vector outerJoinedAdditionalJoinCriteria) {
        this.outerJoinedAdditionalJoinCriteria = outerJoinedAdditionalJoinCriteria;
    }

    public void setOuterJoinedMappingCriteria(Vector outerJoinedMappingCriteria) {
        this.outerJoinedMappingCriteria = outerJoinedMappingCriteria;
    }

    public void setOuterJoinExpressions(Vector outerJoinedExpressions) {
        this.outerJoinedExpressions = outerJoinedExpressions;
    }

    public void setParentStatement(SQLSelectStatement parentStatement) {
        this.parentStatement = parentStatement;
    }

    public void setRequiresAliases(boolean requiresAliases) {
        this.requiresAliases = requiresAliases;
    }

    protected void setTableAliases(Hashtable theTableAliases) {
        this.tableAliases = theTableAliases;
    }

    public void setTables(Vector theTables) {
        this.tables = theTables;
    }

    public boolean shouldDistinctBeUsed() {
        return this.distinctState == 1;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
    }

    protected void writeField(ExpressionSQLPrinter printer, DatabaseField field) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (printer.shouldPrintQualifiedNames()) {
            if (field.getTable() != this.lastTable) {
                this.lastTable = field.getTable();
                this.currentAlias = this.getBuilder().aliasForTable(this.lastTable);
                if (this.currentAlias == null) {
                    this.currentAlias = this.lastTable;
                }
            }
            printer.printString(this.currentAlias.getQualifiedName());
            printer.printString(".");
            printer.printString(field.getName());
        } else {
            printer.printString(field.getName());
        }
    }

    protected void writeFieldsFromExpression(ExpressionSQLPrinter printer, Expression expression, Vector newFields) {
        expression.writeFields(printer, newFields, this);
    }

    protected Vector writeFieldsIn(ExpressionSQLPrinter printer) {
        this.lastTable = null;
        NonSynchronizedVector newFields = NonSynchronizedVector.newInstance();
        Enumeration fieldsEnum = this.getFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            Object next = fieldsEnum.nextElement();
            if (next instanceof Expression) {
                this.writeFieldsFromExpression(printer, (Expression)next, newFields);
                continue;
            }
            this.writeField(printer, (DatabaseField)next);
            ((Vector)newFields).addElement(next);
        }
        return newFields;
    }

    protected static SortedSet mapTableIndexToExpression(Expression expression, SortedMap map, Vector tablesInOrder) {
        TreeSet<Integer> tables = new TreeSet<Integer>();
        if (expression instanceof DataExpression) {
            DataExpression de = (DataExpression)expression;
            if (de.getField() != null) {
                tables.add(new Integer(tablesInOrder.indexOf(de.getField().getTable())));
            }
        } else if (expression instanceof ParameterExpression) {
            ParameterExpression pe = (ParameterExpression)expression;
            if (pe.getField() != null) {
                tables.add(new Integer(tablesInOrder.indexOf(pe.getField().getTable())));
            }
        } else if (expression instanceof CompoundExpression) {
            CompoundExpression ce = (CompoundExpression)expression;
            tables.addAll(SQLSelectStatement.mapTableIndexToExpression(ce.getFirstChild(), map, tablesInOrder));
            tables.addAll(SQLSelectStatement.mapTableIndexToExpression(ce.getSecondChild(), map, tablesInOrder));
        } else if (expression instanceof FunctionExpression) {
            FunctionExpression fe = (FunctionExpression)expression;
            Iterator it = fe.getChildren().iterator();
            while (it.hasNext()) {
                tables.addAll(SQLSelectStatement.mapTableIndexToExpression((Expression)it.next(), map, tablesInOrder));
            }
        }
        if (tables.size() == 2) {
            map.put(tables.last(), expression);
        }
        return tables;
    }

    public static Map mapTableToExpression(Expression expression, Vector tablesInOrder) {
        TreeMap indexToExpressionMap = new TreeMap();
        SQLSelectStatement.mapTableIndexToExpression(expression, indexToExpressionMap, tablesInOrder);
        HashMap map = new HashMap(indexToExpressionMap.size());
        for (Map.Entry entry : indexToExpressionMap.entrySet()) {
            int index = (Integer)entry.getKey();
            map.put(tablesInOrder.elementAt(index), entry.getValue());
        }
        return map;
    }
}

