/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.appserv.management.base.MapCapable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DeploymentStatus
implements Serializable,
MapCapable {
    static final long serialVersionUID = -6130876961172599515L;
    public static final int FAILURE = 0;
    public static final int WARNING = 1;
    public static final int SUCCESS = 2;
    public static final int NOTINITIALIZED = 3;
    public static final String CONTEXT_ROOT = "ContextRoot";
    public static final String KEY_SEPARATOR = "_";
    public static final String MODULE_ID = "moduleid";
    public static final String MODULE_TYPE = "ModuleType";
    public static final String SUBMODULE_COUNT = "NumberOfSubModules";
    public static final String WSDL_PUBLISH_URL = "ClientPublishURL";
    public static final String WSDL_LOCATION = "WsdlFileLocation";
    public static final String WSDL_DIRECTORY = "WsdlDirectory";
    public static final String WSDL_FILE_ENTRIES = "WsdlFileEntries";
    public static final String COUNT = "NumberOfEntries";
    private String stageDescription;
    private int stageStatus = 3;
    private String stageStatusMessage = "";
    private Throwable stageException;
    private List subStages = new ArrayList();
    private DeploymentStatus parent = null;
    private Map additionalStatus = new Properties();
    private Properties props = null;

    public DeploymentStatus() {
    }

    public DeploymentStatus(DeploymentStatus parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent deployment status cannot be null");
        }
        parent.addSubStage(this);
    }

    public int getStatus() {
        int currentStatus = this.stageStatus;
        for (DeploymentStatus subStage : this.subStages) {
            int subStageStatus = subStage.getStatus();
            if (subStageStatus >= currentStatus) continue;
            currentStatus = subStageStatus;
        }
        return currentStatus;
    }

    public void addSubStage(DeploymentStatus subStage) {
        this.subStages.add(subStage);
        subStage.setParent(this);
    }

    public Iterator getSubStages() {
        return this.subStages.iterator();
    }

    public void setStageStatus(int status) {
        this.stageStatus = status;
    }

    public int getStageStatus() {
        return this.stageStatus;
    }

    public Throwable getStageException() {
        return this.stageException;
    }

    public String getStageIdentifier() {
        return this.stageDescription;
    }

    public String getStageDescription() {
        return this.stageDescription;
    }

    public String getStageStatusMessage() {
        return this.stageStatusMessage;
    }

    public void setStageException(Throwable throwable) {
        this.stageException = new Throwable(throwable.getMessage());
        this.stageException.setStackTrace(throwable.getStackTrace());
    }

    public void setStageDescription(String string) {
        this.stageDescription = string;
    }

    public void setStageStatusMessage(String string) {
        this.stageStatusMessage = string;
    }

    public DeploymentStatus getStageStatusForLevel(int level) {
        if (this.stageStatus == level) {
            return this;
        }
        for (DeploymentStatus subStage : this.subStages) {
            if (subStage.getStatus() != level) continue;
            return subStage;
        }
        return null;
    }

    public DeploymentStatus getParent() {
        return this.parent;
    }

    public void setParent(DeploymentStatus parent) {
        this.parent = parent;
    }

    public DeploymentStatus getMainStatus() {
        if (this.parent != null) {
            return this.parent.getMainStatus();
        }
        return this;
    }

    public void addProperty(String propertyName, String propertyValue) {
        this.additionalStatus.put(propertyName, propertyValue);
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) {
        if (this.additionalStatus.get(propertyName) != null) {
            return (String)this.additionalStatus.get(propertyName);
        }
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(propertyName);
    }

    public Map getAdditionalStatus() {
        return this.additionalStatus;
    }

    public void setAdditionalStatus(Map additionalStatus) {
        this.additionalStatus = additionalStatus;
    }

    public String toString() {
        return "Status " + this.stageStatus + " message " + this.stageStatusMessage + " \nException " + this.stageException;
    }

    public static Iterator getAllStageStatusForLevel(DeploymentStatus status, int level) {
        ArrayList<DeploymentStatus> stages = new ArrayList<DeploymentStatus>();
        if (status.getStageStatus() == level) {
            stages.add(status);
        }
        Iterator itr = status.getSubStages();
        while (itr.hasNext()) {
            DeploymentStatus subStage = (DeploymentStatus)itr.next();
            if (subStage.getStageStatus() == level) {
                stages.add(subStage);
            }
            Iterator itr2 = subStage.getSubStages();
            while (itr2.hasNext()) {
                DeploymentStatus subStage2 = (DeploymentStatus)itr2.next();
                if (subStage2.getStageStatus() == level) {
                    stages.add(subStage2);
                }
                Iterator itr3 = subStage2.getSubStages();
                while (itr3.hasNext()) {
                    DeploymentStatus subStage3 = (DeploymentStatus)itr3.next();
                    if (subStage3.getStageStatus() != level) continue;
                    stages.add(subStage3);
                }
            }
        }
        return stages.iterator();
    }

    public Map asMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("MapCapableClassName", "com.sun.appserv.management.deploy.DeploymentStatus");
        m.put("StatusCodeKey", new Integer(this.stageStatus));
        m.put("StageStatusMessage", this.stageStatusMessage);
        m.put("StageDescription", this.stageDescription);
        m.put("SubStages", this.subStagesToMapList());
        m.put("ThrowableKey", this.stageException);
        m.put("AdditionalStatus", this.additionalStatus);
        return m;
    }

    List subStagesToMapList() {
        ArrayList<Map> l = new ArrayList<Map>(this.subStages.size());
        for (MapCapable mc : this.subStages) {
            l.add(mc.asMap());
        }
        return l;
    }

    public String getMapClassName() {
        return "com.sun.appserv.management.deploy.DeploymentStatus";
    }

    public static void parseDeploymentStatus(DeploymentStatus status, PrintWriter pw) {
        if (status != null) {
            if (status.getStatus() == 0) {
                Iterator itr = DeploymentStatus.getAllStageStatusForLevel(status, 0);
                while (itr.hasNext()) {
                    DeploymentStatus stage = (DeploymentStatus)itr.next();
                    DeploymentStatus.printFailure(pw, stage);
                }
            } else if (status.getStatus() == 1) {
                Iterator itr = DeploymentStatus.getAllStageStatusForLevel(status, 1);
                while (itr.hasNext()) {
                    DeploymentStatus stage = (DeploymentStatus)itr.next();
                    String msg = stage.getStageStatusMessage();
                    if (msg == null) continue;
                    pw.println(msg);
                }
            }
            pw.flush();
        }
    }

    private static void printFailure(PrintWriter pw, DeploymentStatus status) {
        String msg = status.getStageStatusMessage();
        Throwable t = status.getStageException();
        if (msg != null && msg.trim().length() > 0) {
            pw.println(msg);
            if (t != null && t.getMessage() != null && !t.getMessage().equals(msg)) {
                pw.println(t);
            }
        } else if (t != null) {
            pw.println(t);
        }
    }
}

