/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OutputJarArchive
extends AbstractArchive {
    private String archiveUri;
    protected ZipOutputStream jos = null;
    private Manifest manifest = null;
    private Vector entries = new Vector();

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        return -1L;
    }

    public void close() throws IOException {
        if (this.jos != null) {
            this.jos.flush();
            this.jos.finish();
            this.jos.close();
            this.jos = null;
        }
    }

    public void create(String path) throws IOException {
        this.archiveUri = path;
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        this.jos = new ZipOutputStream(bos);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public InputStream getEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public void open(String path) throws IOException {
        throw new UnsupportedOperationException("Cannot read jar files");
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest != null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public boolean renameTo(String name) {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        OutputStream os = this.putNextEntry(name);
        ZipOutputStream jos = new ZipOutputStream(os);
        OutputJarArchive ja = new OutputJarArchive();
        ja.archiveUri = name;
        ja.jos = jos;
        return ja;
    }

    public void closeEntry(AbstractArchive os) throws IOException {
        if (os instanceof OutputJarArchive) {
            ((OutputJarArchive)os).jos.flush();
            ((OutputJarArchive)os).jos.finish();
        }
        this.jos.closeEntry();
    }

    public OutputStream putNextEntry(String name) throws IOException {
        if (this.jos != null) {
            ZipEntry ze = new ZipEntry(name);
            this.jos.putNextEntry(ze);
            this.entries.add(name);
        }
        return this.jos;
    }

    public void closeEntry() throws IOException {
        if (this.jos != null) {
            this.jos.flush();
            this.jos.closeEntry();
        }
    }

    public URI getURI() {
        try {
            return ArchiveFactory.prepareArchiveURI(this.getArchiveUri());
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

