/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.util.shared.ArchivistUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class MemoryMappedArchive
extends AbstractArchive {
    byte[] file;

    protected MemoryMappedArchive() {
    }

    public MemoryMappedArchive(InputStream is) throws IOException {
        this.read(is);
    }

    public byte[] getByteArray() {
        return this.file;
    }

    private void read(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArchivistUtils.copy(new BufferedInputStream(is), new BufferedOutputStream(baos));
        this.file = baos.toByteArray();
    }

    public void open(String path) throws IOException {
        File in = new File(path);
        if (!in.exists()) {
            throw new FileNotFoundException(path);
        }
        FileInputStream is = new FileInputStream(in);
        this.read(is);
    }

    public MemoryMappedArchive(AbstractArchive source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(baos));
        Enumeration elements = source.entries();
        while (elements.hasMoreElements()) {
            String elementName = (String)elements.nextElement();
            InputStream is = source.getEntry(elementName);
            jos.putNextEntry(new ZipEntry(elementName));
            ArchivistUtils.copyWithoutClose(is, jos);
            is.close();
            jos.flush();
            jos.closeEntry();
        }
        jos.close();
        this.file = baos.toByteArray();
    }

    public OutputStream putNextEntry(String name) throws IOException {
        return null;
    }

    public void close() throws IOException {
    }

    public void closeEntry(AbstractArchive os) throws IOException {
    }

    public void closeEntry() throws IOException {
    }

    public boolean delete() {
        return false;
    }

    public Enumeration entries() {
        Vector<String> entries = new Vector<String>();
        try {
            ZipEntry ze;
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
            while ((ze = jis.getNextEntry()) != null) {
                entries.add(ze.getName());
            }
            jis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public boolean exists() {
        return false;
    }

    public String getArchiveUri() {
        return null;
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        return this.file.length;
    }

    public URI getURI() {
        return null;
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        InputStream is = this.getEntry(name);
        if (is != null) {
            MemoryMappedArchive archive = new MemoryMappedArchive(is);
            is.close();
            return archive;
        }
        return null;
    }

    public InputStream getEntry(String name) throws IOException {
        ZipEntry ze;
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        while ((ze = jis.getNextEntry()) != null) {
            if (!ze.getName().equals(name)) continue;
            return new BufferedInputStream(jis);
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        Manifest m = jis.getManifest();
        jis.close();
        return m;
    }

    public boolean renameTo(String name) {
        return false;
    }
}

