/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.cluster.IIOPCluster;
import com.sun.enterprise.tools.upgrade.cluster.IIOPEndPoint;
import com.sun.enterprise.tools.upgrade.cluster.IIOPServerInstance;
import com.sun.enterprise.tools.upgrade.common.Appserver70DomainNamesResolver;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.VersionExtracter;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class UpgradeUtils {
    private static UpgradeUtils upgradeUtils;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    private static Logger logger;
    private static CommonInfoModel common;

    private UpgradeUtils(CommonInfoModel common) {
        UpgradeUtils.common = common;
    }

    public static UpgradeUtils getUpgradeUtils(CommonInfoModel cim) {
        if (upgradeUtils == null) {
            upgradeUtils = new UpgradeUtils(cim);
        } else {
            common = cim;
        }
        return upgradeUtils;
    }

    public Hashtable enlist70DomainsFromSource(CommonInfoModel cmi) {
        String source = cmi.getSourceInstallDir();
        Hashtable<String, DomainInfo> domainMapping = null;
        if (!this.checkSourceInputAsDomainRoot(source, cmi)) {
            cmi.getDomainList().clear();
            Appserver70DomainNamesResolver as = new Appserver70DomainNamesResolver(source);
            domainMapping = as.getDomainNamesPathMapping();
            cmi.setInstallConfig70(as.getConfigDir70(source));
            cmi.setDomainMapping(domainMapping);
            Enumeration ee = domainMapping.keys();
            while (ee.hasMoreElements()) {
                String domain = (String)ee.nextElement();
                cmi.addDomainName(domain);
                cmi.getTargetDomainNameMapping().put(domain, domain);
            }
        } else {
            File sourceDomain = new File(source);
            String[] dirs = sourceDomain.list();
            String domain = "";
            domainMapping = new Hashtable<String, DomainInfo>();
            for (int i = 0; i < dirs.length; ++i) {
                String domainPath = source + File.separator + dirs[i];
                File file = new File(domainPath);
                if (dirs[i].endsWith("8x") || file.isFile() || !this.isValid70Domain(domainPath)) continue;
                domain = dirs[i];
                domainMapping.put(domain, new DomainInfo(domain, domainPath));
                cmi.addDomainName(domain);
                if (new File(cmi.getSourceDomainRoot()).equals(new File(cmi.getTargetDomainRoot()))) {
                    cmi.getTargetDomainNameMapping().put(domain, domain + "_8x");
                    continue;
                }
                cmi.getTargetDomainNameMapping().put(domain, domain);
            }
        }
        System.setProperty("com.sun.aas.configRoot", cmi.getTargetInstallDir() + File.separator + "config");
        return domainMapping;
    }

    public Hashtable enlistDomainsFromDomainsDirectory(CommonInfoModel cmi, String domainsDirStr) {
        File domainsDir = new File(domainsDirStr);
        String[] dirs = domainsDir.list();
        return this.enlistDomains(cmi, dirs, domainsDirStr);
    }

    public Hashtable enlistDomains(CommonInfoModel cmi, String[] dirs, String domainRoot) {
        Hashtable<String, DomainInfo> domainMapping = new Hashtable<String, DomainInfo>();
        boolean domainRootSame = new File(cmi.getSourceDomainRoot()).equals(new File(cmi.getTargetDomainRoot()));
        for (int i = 0; i < dirs.length; ++i) {
            File domainFile;
            String domainPath;
            if (dirs[i].equals("backup") || new File((domainPath = domainRoot + File.separator + dirs[i]) + "_8x").exists() || (domainFile = new File(domainPath)).isFile()) continue;
            if (domainRootSame) {
                String latestdomain = this.findLatestDomainDir(cmi.getSourceDomainRoot(), dirs[i]);
                String backupDomainVersion = "";
                String actualDomainVersion = "garbage";
                if (latestdomain != null) {
                    backupDomainVersion = new VersionExtracter(latestdomain, cmi).getVersion();
                    String[] directories = new File(cmi.getSourceDomainRoot()).list();
                    String domainName = null;
                    for (int j = 0; j < directories.length; ++j) {
                        if (directories[j].equals("backup") || new File(cmi.getSourceDomainRoot() + File.separator + directories[j]).isFile()) continue;
                        domainName = directories[j];
                        break;
                    }
                    actualDomainVersion = new VersionExtracter(cmi.getSourceDomainRoot() + File.separator + dirs[i], cmi).getVersion();
                }
                if (!actualDomainVersion.equals(cmi.getTargetVersionAndEdition()) && !actualDomainVersion.equals(backupDomainVersion)) {
                    String timestamp = "" + System.currentTimeMillis();
                    String newDomainName = "";
                    String domainName = dirs[i];
                    if (dirs[i].endsWith("_8x")) {
                        newDomainName = dirs[i].substring(0, dirs[i].indexOf("_8x")) + "_" + timestamp;
                        domainName = dirs[i].substring(0, dirs[i].indexOf("_8x"));
                    } else {
                        newDomainName = domainName + "_" + timestamp;
                    }
                    String backup = cmi.getTargetDomainRoot() + File.separator + "backup";
                    File backupFile = new File(backup);
                    if (!backupFile.isDirectory()) {
                        backupFile.delete();
                        backupFile.mkdir();
                    }
                    File domainDir = new File(domainPath);
                    String sourceDomainPath = backup + File.separator + newDomainName;
                    if (new File(domainPath + "_8x").exists()) {
                        new File(domainPath + "_8x").renameTo(new File(sourceDomainPath));
                        domainDir.delete();
                    } else {
                        domainDir.renameTo(new File(sourceDomainPath));
                    }
                    domainMapping.put(domainName, new DomainInfo(domainName, sourceDomainPath));
                    cmi.addDomainName(domainName);
                    cmi.getTargetDomainNameMapping().put(domainName, domainName);
                    continue;
                }
                String latestDomain = this.findLatestDomainDir(cmi.getTargetDomainRoot(), dirs[i]);
                domainMapping.put(dirs[i], new DomainInfo(dirs[i], latestDomain));
                cmi.addDomainName(dirs[i]);
                cmi.getTargetDomainNameMapping().put(dirs[i], dirs[i]);
                continue;
            }
            domainMapping.put(dirs[i], new DomainInfo(dirs[i], domainPath));
            cmi.addDomainName(dirs[i]);
            cmi.getTargetDomainNameMapping().put(dirs[i], dirs[i]);
        }
        return domainMapping;
    }

    public Hashtable enlistDomainsFromUserDefinedDirectories(List srcDomainDirs) {
        Hashtable domainMapping = null;
        Iterator dIt = srcDomainDirs.iterator();
        while (dIt.hasNext()) {
            if (domainMapping == null) {
                domainMapping = new Hashtable();
            }
            String domainDirStr = (String)dIt.next();
            Hashtable dMaps = this.enlistDomainsFromDomainsDirectory(common, domainDirStr);
            if (dMaps == null) continue;
            Enumeration domainsEnum = dMaps.keys();
            while (domainsEnum.hasMoreElements()) {
                String dName = (String)domainsEnum.nextElement();
                domainMapping.put(dName, dMaps.get(dName));
            }
        }
        return domainMapping;
    }

    public String findLatestDomainDir(String domainRoot, String domainName) {
        File backupDir = new File(domainRoot + File.separator + "backup");
        String lastestDomainPath = null;
        long latestTimestamp = 0L;
        if (backupDir.isDirectory()) {
            String[] dirs = backupDir.list();
            for (int i = 0; i < dirs.length; ++i) {
                long timestamp;
                String time = dirs[i].substring(dirs[i].lastIndexOf("_") + 1);
                if (domainName != null && !dirs[i].startsWith(domainName) || (timestamp = Long.parseLong(time)) <= latestTimestamp) continue;
                latestTimestamp = timestamp;
                lastestDomainPath = domainRoot + File.separator + "backup" + File.separator + dirs[i];
            }
        }
        return lastestDomainPath;
    }

    public boolean checkSourceInputAsDomain() {
        File domainXML = new File(common.getSourceInstallDir() + File.separator + "config" + File.separator + "domain.xml");
        return domainXML.isFile();
    }

    public boolean checkSourceInputAsDomainRoot(String source, CommonInfoModel cmi) {
        if (source == null) {
            return false;
        }
        File sourceDomain = new File(source);
        File biDir = new File(source + File.separator + "bin");
        if (!biDir.isDirectory() && sourceDomain.isDirectory()) {
            String[] dirs = sourceDomain.list();
            if (dirs.length == 0) {
                cmi.setSourceDomainRootFlag(false);
                return false;
            }
            if (new File(source + File.separator + "backup").exists()) {
                cmi.setSourceDomainRootFlag(true);
                return true;
            }
            for (int i = 0; i < dirs.length; ++i) {
                File domainXML = new File(source + File.separator + dirs[i] + File.separator + "config" + File.separator + "domain.xml");
                if (!domainXML.isFile()) continue;
                cmi.setSourceDomainRootFlag(true);
                return true;
            }
            String domain = "";
            boolean domain70 = false;
            for (int i = 0; i < dirs.length; ++i) {
                if (dirs[i].endsWith("8x") || !new File(source + File.separator + dirs[i]).isDirectory() || !this.isValid70Domain(source + File.separator + dirs[i])) continue;
                domain = dirs[i];
                domain70 = true;
                break;
            }
            if (!domain70) {
                return false;
            }
            File domainDir = new File(source + File.separator + domain);
            String[] serverDirs = domainDir.list();
            String serverInstanceName = "";
            serverInstanceName = serverDirs[0].equals("admin-server") ? serverDirs[1] : serverDirs[0];
            File serverXML = new File(source + File.separator + domain + File.separator + serverInstanceName + File.separator + "config" + File.separator + "server.xml");
            if (serverXML.isFile()) {
                cmi.setSourceDomainRootFlag(true);
            } else {
                cmi.setSourceDomainRootFlag(false);
            }
        } else {
            cmi.setSourceDomainRootFlag(false);
        }
        return cmi.getSourceDomainRootFlag();
    }

    public boolean isValid70Domain(String domainPath) {
        File domainDir = new File(domainPath);
        boolean domain70 = false;
        String[] serverDirs = domainDir.list();
        String serverInstanceName = "";
        serverInstanceName = serverDirs[0].equals("admin-server") ? serverDirs[1] : serverDirs[0];
        File serverXML = new File(domainPath + File.separator + serverInstanceName + File.separator + "config" + File.separator + "server.xml");
        domain70 = serverXML.isFile();
        return domain70;
    }

    public boolean isDomain(String domainPath) {
        File domainXML = new File(domainPath + File.separator + "config" + File.separator + "domain.xml");
        return domainXML.exists();
    }

    public String versionString(String versionEditionString) {
        if ("as7xpe".equals(versionEditionString) || "as7xse".equals(versionEditionString) || "as7xee".equals(versionEditionString)) {
            return "7x";
        }
        if ("as80pe".equals(versionEditionString) || "as81se".equals(versionEditionString) || "as81ee".equals(versionEditionString)) {
            return "80";
        }
        if ("as81pe".equals(versionEditionString) || "as81ee".equals(versionEditionString)) {
            return "81";
        }
        if ("as90pe".equals(versionEditionString) || "as90se".equals(versionEditionString) || "as90ee".equals(versionEditionString)) {
            return "90";
        }
        return "";
    }

    public String editionString(String versionEditionString) {
        if ("as7xpe".equals(versionEditionString) || "as80pe".equals(versionEditionString) || "as81pe".equals(versionEditionString) || "as90pe".equals(versionEditionString)) {
            return "pe";
        }
        if ("as7xse".equals(versionEditionString) || "as81se".equals(versionEditionString) || "as90se".equals(versionEditionString)) {
            return "se";
        }
        if ("as7xee".equals(versionEditionString) || "as81ee".equals(versionEditionString) || "as81ee".equals(versionEditionString) || "as90ee".equals(versionEditionString)) {
            return "ee";
        }
        return "";
    }

    public boolean isValidSourcePath(String sourcePath) {
        File biDir = new File(sourcePath + File.separator + "bin");
        if (sourcePath.equals("") || !biDir.isDirectory()) {
            if (!this.checkSourceInputAsDomainRoot(sourcePath, common)) {
                return new File(sourcePath + File.separator + "config").isDirectory();
            }
            common.setSourceDomainRoot(sourcePath);
        }
        String as7xInstallFileName = "admingui.ear";
        File runtime70Jar = new File(sourcePath + File.separator + "lib" + File.separator + as7xInstallFileName);
        if (runtime70Jar != null && runtime70Jar.exists()) {
            return true;
        }
        String[] domainConfigDirs = new VersionExtracter(sourcePath, common).getDomainAndConfigDirs();
        if (domainConfigDirs == null || domainConfigDirs.length == 0) {
            return false;
        }
        String domainsDir = domainConfigDirs[0];
        return domainsDir != null;
    }

    public boolean isValidTargetPath(String targetPath) {
        return new File(targetPath).isDirectory();
    }

    public List getStandAloneInstances(Hashtable domainsMapping) {
        ArrayList stdAloneList = new ArrayList();
        for (DomainInfo dInfo : domainsMapping.values()) {
            for (String instName : dInfo.getInstanceNames()) {
                if (this.isInstanceInCluster(instName) || instName.equals("admin-server")) continue;
                Vector<Object> instDInfo = new Vector<Object>();
                instDInfo.add(instName);
                instDInfo.add(dInfo);
                stdAloneList.add(instDInfo);
            }
        }
        return stdAloneList;
    }

    public boolean isInstanceInCluster(String instName) {
        List clList = ClustersInfoManager.getClusterInfoManager().getClusterInfoList();
        if (clList == null) {
            return false;
        }
        for (ClusterInfo clInfo : clList) {
            Iterator instIt = clInfo.getClusteredInstanceList().iterator();
            while (instIt.hasNext()) {
                if (!((ClusteredInstance)instIt.next()).getInstanceName().equals(instName)) continue;
                return true;
            }
        }
        return false;
    }

    private Element getConfigElementFromDocumentElement(Element documentElement, String lookUpConfigName) {
        NodeList configEles = documentElement.getElementsByTagName("config");
        Element configEle = null;
        for (int lh = 0; lh < configEles.getLength(); ++lh) {
            String configName = ((Element)configEles.item(lh)).getAttribute("name");
            if (!configName.equals(lookUpConfigName)) continue;
            configEle = (Element)configEles.item(lh);
            break;
        }
        return configEle;
    }

    public boolean switchedIIOPPorts(String serverID, String portValue, Element documentElement) {
        Element configEle = this.getConfigElementFromDocumentElement(documentElement, "server-config");
        NodeList iiopService = configEle.getElementsByTagName("iiop-service");
        NodeList iiopListeners = ((Element)iiopService.item(0)).getElementsByTagName("iiop-listener");
        Element iiopListener = null;
        for (int ii = 0; ii < iiopListeners.getLength(); ++ii) {
            if (!((Element)iiopListeners.item(ii)).getAttribute("id").equals("orb-listener-1")) continue;
            iiopListener = (Element)iiopListeners.item(ii);
            break;
        }
        if (iiopListener != null) {
            String serverIIOPPort = this.getIIOPListenerPortForServer(iiopListener.getAttribute("port"), "server", documentElement);
            if (serverIIOPPort.equals("3700")) {
                String portValueFromServer = this.getIIOPListenerPortForServer(portValue, serverID, documentElement);
                if (portValueFromServer != null) {
                    iiopListener.setAttribute("port", portValueFromServer);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private String getIIOPListenerPortForServer(String portValue, String serverName, Element documentElement) {
        try {
            if (portValue != null) {
                int portIntValue = Integer.parseInt(portValue);
                return String.valueOf(portIntValue);
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        NodeList servers = documentElement.getElementsByTagName("servers");
        NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
        Object portValueFromServer = null;
        for (int lh = 0; lh < serverList.getLength(); ++lh) {
            if (!serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))) continue;
            Element serverElement = (Element)serverList.item(lh);
            Element sysProp = this.getSystemPropertyElement("IIOP_LISTENER_PORT", serverElement);
            if (sysProp != null) {
                return sysProp.getAttribute("value");
            }
            Element configElement = this.getConfigElementFromDocumentElement(documentElement, serverElement.getAttribute("config-ref"));
            if (configElement == null || (sysProp = this.getSystemPropertyElement("IIOP_LISTENER_PORT", configElement)) == null) continue;
            return sysProp.getAttribute("value");
        }
        return null;
    }

    private Element getSystemPropertyElement(String propertyName, Element parentForSysProp) {
        NodeList sysProps = parentForSysProp.getElementsByTagName("system-property");
        for (int sh = 0; sh < sysProps.getLength(); ++sh) {
            if (!propertyName.equals(((Element)sysProps.item(sh)).getAttribute("name"))) continue;
            return (Element)sysProps.item(sh);
        }
        return null;
    }

    public void updateDomainXMLWithIIOPCluster(CommonInfoModel cmnInfo, String domainXMLFile, IIOPCluster iiopCluster) {
        String clusterName = iiopCluster.getClusterName();
        List servInstances = iiopCluster.getIIOPServerInstanceList();
        boolean domainFileChanged = false;
        Document domainDoc = this.getDomainDocumentElement(domainXMLFile);
        for (int servIt = 0; servIt < servInstances.size(); ++servIt) {
            List endPoints = ((IIOPServerInstance)servInstances.get(servIt)).getIIOPEndPoints();
            String serverName = ((IIOPServerInstance)servInstances.get(servIt)).getName();
            int endPt = 0;
            if (endPt >= endPoints.size()) continue;
            IIOPEndPoint iiopEndPoint = (IIOPEndPoint)endPoints.get(endPt);
            if (domainDoc == null) continue;
            String propertyName = "IIOP_LISTENER_PORT";
            String propValue = iiopEndPoint.getPort();
            NodeList servers = domainDoc.getDocumentElement().getElementsByTagName("servers");
            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
            if (propValue.equals("3700")) {
                this.switchedIIOPPorts(serverName, null, domainDoc.getDocumentElement());
            }
            BaseElement baseElement = null;
            try {
                baseElement = ElementToObjectMapper.getMapper().getElementObject(domainDoc.getDocumentElement().getTagName());
            }
            catch (Exception ef) {
                // empty catch block
            }
            this.addOrUpdateSystemPropertyToServer(serverName, serverList, propertyName, propValue, baseElement);
            domainFileChanged = true;
        }
        if (domainFileChanged && domainDoc != null) {
            this.saveDocumentToDomainFile(domainXMLFile, domainDoc);
        }
    }

    public List updateClusterList(String domainXMLFile, String domainName, List clList) {
        NodeList clusterList;
        NodeList clusters;
        Document domainDoc = this.getDomainDocumentElement(domainXMLFile);
        if (domainDoc != null && (clusters = domainDoc.getDocumentElement().getElementsByTagName("clusters")) != null && (clusterList = ((Element)clusters.item(0)).getElementsByTagName("cluster")) != null && clusterList.getLength() > 0) {
            for (int lh = 0; lh < clusterList.getLength(); ++lh) {
                String clName = ((Element)clusterList.item(lh)).getAttribute("name");
                ClusterInfo clInfo = new ClusterInfo();
                clInfo.setClusterName(clName);
                clInfo.setDomainName(domainName);
                clList.add(clInfo);
            }
        }
        return clList;
    }

    private Document getDomainDocumentElement(String domainFileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document resultDoc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            resultDoc = builder.parse(new File(domainFileName));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.iiop_port_domain_doc"), ex);
        }
        return resultDoc;
    }

    private void saveDocumentToDomainFile(String domainFileName, Document resultDoc) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(domainFileName));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.iiop_port_domain_save_fail"), ex);
        }
    }

    public void recover() {
        List domainList = common.getDomainList();
        String sourceDir = common.getSourceDomainRoot();
        String targetDir = common.getTargetDomainRoot();
        if (domainList != null && sourceDir != null && targetDir != null) {
            for (String dname : domainList) {
                boolean domainRootSame = new File(sourceDir).equals(new File(targetDir));
                if (!domainRootSame || !new File(sourceDir + File.separator + "backup").isDirectory()) continue;
                common.setCurrentDomain(dname);
                String latestDomainPath = common.findLatestDomainDir(sourceDir);
                if (latestDomainPath == null) continue;
                new File(latestDomainPath).renameTo(new File(sourceDir + File.separator + dname));
                File backupdir = new File(sourceDir + File.separator + "backup");
                String[] dirs = backupdir.list();
                if (dirs.length != 0) continue;
                backupdir.delete();
            }
        }
    }

    public boolean validateUserDetails(String adminUserName, String adminPassword, String masterPassword) {
        try {
            RepositoryManager rManager = new RepositoryManager();
            String domainPath = common.getTargetDomainRoot();
            if (!new File(domainPath + File.separator + "domain1").exists() || common.getSourceInstallDir() != null && common.getTargetInstallDir() != null && (common.getSourceInstallDir().equalsIgnoreCase(common.getTargetInstallDir() + File.separator + "domains") || common.getSourceInstallDir().equalsIgnoreCase(common.getTargetInstallDir()))) {
                return true;
            }
            RepositoryConfig repConf = new RepositoryConfig("domain1", domainPath);
            rManager.validateAdminUserAndPassword(repConf, adminUserName, adminPassword);
            if (masterPassword != null) {
                if (!common.getTargetVersionAndEdition().equals("as81pe")) {
                    rManager.validateMasterPassword(repConf, masterPassword);
                }
            }
        }
        catch (RepositoryException re) {
            logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.generalException", (Object)re.getMessage()), re);
            return false;
        }
        return true;
    }

    public void updateDomainXMLWithPersistenceStoreProps(Properties props) {
    }

    public void updateListenerPortsForClusteredInstances(Element docElement, String propertyName, String portValue, BaseElement bElement) {
        NodeList servers = docElement.getElementsByTagName("servers");
        NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
        String clusterName = common.getCurrentCluster();
        for (ClusterInfo cInfo : ClustersInfoManager.getClusterInfoManager().getClusterInfoList()) {
            if (!cInfo.getClusterName().equals(clusterName)) continue;
            for (ClusteredInstance clInstance : cInfo.getClusteredInstanceList()) {
                if (portValue == null) {
                    this.addOrUpdateSystemPropertyToServer(clInstance.getInstanceName(), serverList, propertyName, clInstance.getInstancePort(), bElement);
                    continue;
                }
                this.addOrUpdateSystemPropertyToServer(clInstance.getInstanceName(), serverList, propertyName, portValue, bElement);
            }
        }
    }

    public void addOrUpdateSystemPropertyToServer(String serverName, NodeList serverList, String propertyName, String propertyValue, BaseElement bElement) {
        for (int lh = 0; lh < serverList.getLength(); ++lh) {
            if (!serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))) continue;
            Element serverElement = (Element)serverList.item(lh);
            Element sysProp = this.getSystemPropertyElement(propertyName, serverElement);
            if (sysProp != null) {
                sysProp.setAttribute("value", propertyValue);
                return;
            }
            if (sysProp == null && bElement != null) {
                sysProp = serverElement.getOwnerDocument().createElement("system-property");
                sysProp.setAttribute("name", propertyName);
                sysProp.setAttribute("value", propertyValue);
                bElement.appendElementToParent(serverElement, sysProp);
            }
            return;
        }
    }

    public void copyFile(String source, String target) throws IOException {
        this.copyFile(source, target, false);
    }

    public void copyFile(String source, String target, boolean append) throws IOException {
        int c;
        FileInputStream in = new FileInputStream(new File(source));
        FileOutputStream out = new FileOutputStream(new File(target), append);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public String getJvmOptionValueFromSourceConfig(String optionName) {
        String sourceConfig = common.getSourceConfigXMLFile();
        Document sourceDoc = this.getDomainDocumentElement(common.getSourceConfigXMLFile());
        NodeList serverList = sourceDoc.getElementsByTagName("server");
        String serverName = common.getCurrentSourceInstance();
        if (serverName == null || serverName == "") {
            serverName = "server";
        }
        String configName = null;
        String password = null;
        for (int i = 0; i < serverList.getLength(); ++i) {
            Node serverNode = serverList.item(i);
            NamedNodeMap attributes = serverNode.getAttributes();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (!serverName.equals(name)) continue;
            configName = attributes.getNamedItem("config-ref").getNodeValue();
        }
        if (configName != null) {
            NodeList jvmOptionList = sourceDoc.getElementsByTagName("jvm-options");
            for (int j = 0; j < jvmOptionList.getLength(); ++j) {
                Node jvmNode = jvmOptionList.item(j);
                String jvmOptions = this.getTextNodeData((Element)jvmNode);
                if (jvmOptions.indexOf(optionName) == -1) continue;
                password = jvmOptions.substring(jvmOptions.indexOf("=") + 1, jvmOptions.length());
            }
        } else {
            logger.warning(this.stringManager.getString("enterprise.tools.upgrade.configNotFound", configName));
        }
        return password;
    }

    public String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return "";
    }

    static {
        logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    }
}

