/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import com.sun.enterprise.tools.upgrade.transform.elements.GenericElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericResource
extends GenericElement {
    private boolean appendingResourceRefToCluster = false;
    private List insertStructureForResourceRefInCluster = null;

    public void transform(Element element, Element parentSource, Element parentResult) {
        String resourceTagName = element.getTagName();
        if (resourceTagName.equals("jms-resource")) {
            this.skipGenericElementTransform(element, parentSource, parentResult);
            return;
        }
        if (resourceTagName.equals("jdbc-connection-pool") && (element.getAttribute("name").equals("__TimerPool") || element.getAttribute("name").equals("PointBasePool"))) {
            return;
        }
        if (resourceTagName.equals("jdbc-resource") && element.getAttribute("pool-name").equals("PointBasePool")) {
            return;
        }
        super.transform(element, parentSource, parentResult);
        this.updateResourceRef(element, parentResult);
    }

    protected void updateResourceRef(Element element, Element parentResult) {
        if (!commonInfoModel.getSourceVersion().equals("7x")) {
            return;
        }
        Attr jndiAttr = element.getAttributeNode("jndi-name");
        if (jndiAttr != null) {
            NodeList servers = ((Element)parentResult.getParentNode()).getElementsByTagName("servers");
            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
            if (commonInfoModel.getTargetEdition().equals("pe")) {
                Element serverElement = (Element)serverList.item(0);
                this.addOrUpdateResourceRef(serverElement, element, parentResult);
            } else if (commonInfoModel.getCurrentCluster() == null) {
                String serverName = commonInfoModel.getCurrentSourceInstance();
                if (serverName == null || "".equals(serverName.trim())) {
                    serverName = "server";
                }
                if (serverName != null) {
                    for (int lh = 0; lh < serverList.getLength(); ++lh) {
                        if (!serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))) continue;
                        this.addOrUpdateResourceRef((Element)serverList.item(lh), element, parentResult);
                        break;
                    }
                }
            } else {
                String clusterName = commonInfoModel.getCurrentCluster();
                this.updateResourceRefsForCluster(clusterName, serverList, element, parentResult);
            }
        }
    }

    private void updateResourceRefsForCluster(String clusterName, NodeList serverRefList, Element element, Element parentResult) {
        for (ClusterInfo cInfo : ClustersInfoManager.getClusterInfoManager().getClusterInfoList()) {
            if (!cInfo.getClusterName().equals(clusterName)) continue;
            block1: for (ClusteredInstance clInstance : cInfo.getClusteredInstanceList()) {
                String clInstanceName = clInstance.getInstanceName();
                for (int lh = 0; lh < serverRefList.getLength(); ++lh) {
                    if (!clInstanceName.equals(((Element)serverRefList.item(lh)).getAttribute("name"))) continue;
                    this.addOrUpdateResourceRef((Element)serverRefList.item(lh), element, parentResult);
                    continue block1;
                }
            }
        }
        NodeList clusters = ((Element)parentResult.getParentNode()).getElementsByTagName("clusters");
        if (clusters != null && clusters.getLength() > 0) {
            NodeList clustersList = ((Element)clusters.item(0)).getElementsByTagName("cluster");
            for (int lh = 0; lh < clustersList.getLength(); ++lh) {
                if (!clusterName.equals(((Element)clustersList.item(lh)).getAttribute("name"))) continue;
                this.appendingResourceRefToCluster = true;
                this.addOrUpdateResourceRef((Element)clustersList.item(lh), element, parentResult);
                this.appendingResourceRefToCluster = false;
                break;
            }
        }
    }

    private void addOrUpdateResourceRef(Element parentForRef, Element element, Element parentResult) {
        NodeList resourceRefs = parentForRef.getElementsByTagName("resource-ref");
        Element resourceRef = null;
        for (int lh = 0; lh < resourceRefs.getLength(); ++lh) {
            if (!element.getAttribute("jndi-name").equals(((Element)resourceRefs.item(lh)).getAttribute("ref"))) continue;
            resourceRef = (Element)resourceRefs.item(lh);
            Attr enAttr = element.getAttributeNode("enabled");
            if (enAttr == null) break;
            resourceRef.setAttribute("enabled", element.getAttribute("enabled"));
            break;
        }
        if (resourceRef == null) {
            resourceRef = parentResult.getOwnerDocument().createElement("resource-ref");
            resourceRef.setAttribute("ref", element.getAttribute("jndi-name"));
            Attr enAttr = element.getAttributeNode("enabled");
            if (enAttr != null) {
                resourceRef.setAttribute("enabled", element.getAttribute("enabled"));
            }
            this.appendElementToParent(parentForRef, resourceRef);
        }
    }

    private void skipGenericElementTransform(Element element, Element parentSource, Element parentResult) {
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node aNode = childNodes.item(index);
            try {
                if (aNode.getNodeType() != 1) continue;
                BaseElement baseElement = ElementToObjectMapper.getMapper().getElementObject(aNode.getNodeName());
                baseElement.transform((Element)aNode, element, parentResult);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected List getInsertElementStructure(Element element, Element parentEle) {
        List insertStrucure = ElementToObjectMapper.getMapper().getInsertElementStructure(element.getTagName());
        if (element.getTagName().equals("resource-ref") && this.appendingResourceRefToCluster) {
            if (this.insertStructureForResourceRefInCluster == null) {
                this.insertStructureForResourceRefInCluster = new ArrayList();
                this.insertStructureForResourceRefInCluster.add("application-ref");
                this.insertStructureForResourceRefInCluster.add("system-property");
                this.insertStructureForResourceRefInCluster.add("property");
            }
            return this.insertStructureForResourceRefInCluster;
        }
        return insertStrucure;
    }
}

