/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.spi.AttributeStringHelper;
import com.sun.enterprise.admin.monitor.registry.spi.ManagedResourceIntrospector;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;

public class GeneratedMonitoringMBeanImpl
implements DynamicMBean {
    MBeanInfo mbeanInfo;
    Stats resourceInstance;
    public static final String LOGGER_NAME = "this.is.console";
    final Logger logger = Logger.getLogger("this.is.console");
    Hashtable attributeMap;

    public GeneratedMonitoringMBeanImpl(Stats stats) {
        this.resourceInstance = stats;
        this.attributeMap = new Hashtable();
    }

    MBeanInfo introspect() {
        ManagedResourceIntrospector mri = new ManagedResourceIntrospector(this);
        this.mbeanInfo = mri.introspect(this.resourceInstance);
        this.setUpAttributeMap();
        return this.mbeanInfo;
    }

    private void setUpAttributeMap() {
        MBeanAttributeInfo[] attrInfo = this.mbeanInfo.getAttributes();
        String attr = null;
        for (int i = 0; i < attrInfo.length; ++i) {
            attr = attrInfo[i].getName();
            this.attributeMap.put(attr, attr);
        }
    }

    public Object getAttribute(String str) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (str == null) {
            throw new NullPointerException("An attribute needs to be specified to get value");
        }
        if (this.mbeanInfo == null) {
            this.introspect();
        }
        if (!this.isValidAttribute(str)) {
            throw new AttributeNotFoundException("The requested attribute is not recognized");
        }
        Statistic a = null;
        Object retval = null;
        String[] attrParts = AttributeStringHelper.splitAttribute(str);
        this.logger.log(Level.INFO, "accessing the Stats object with attr=" + attrParts[0]);
        a = this.resourceInstance.getStatistic(attrParts[0]);
        if (a == null) {
            try {
                a = (Statistic)this.resourceInstance.getClass().getMethod("get" + str, new Class[0]).invoke((Object)this.resourceInstance, new Object[0]);
            }
            catch (Exception e) {
                this.logger.log(Level.INFO, e.getLocalizedMessage());
            }
        }
        if (a != null) {
            try {
                retval = a.getClass().getMethod("get" + attrParts[1], new Class[0]).invoke((Object)a, new Object[0]);
            }
            catch (Exception e) {
                this.logger.log(Level.INFO, e.getLocalizedMessage());
                this.logger.log(Level.FINE, e.getStackTrace().toString());
            }
        }
        return retval;
    }

    private boolean isValidAttribute(String str) {
        return this.attributeMap.containsValue(str);
    }

    public AttributeList getAttributes(String[] str) {
        if (this.mbeanInfo == null) {
            this.introspect();
        }
        AttributeList list = new AttributeList();
        try {
            for (int i = 0; i < str.length; ++i) {
                list.add(i, new Attribute(str[i], this.getAttribute(str[i])));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, e.getMessage() + "\n" + e.getCause().toString());
        }
        return list;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.introspect();
        }
        return this.mbeanInfo;
    }

    public Object invoke(String str, Object[] obj, String[] str2) throws MBeanException, ReflectionException {
        if (this.mbeanInfo == null) {
            this.introspect();
        }
        Object a = null;
        Class[] c = new Class[]{};
        for (int i = 0; i < str2.length; ++i) {
            c[i] = str2[i].getClass();
        }
        try {
            a = this.resourceInstance.getClass().getMethod(str, c).invoke((Object)this.resourceInstance, obj);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, e.getLocalizedMessage());
            this.logger.log(Level.FINE, e.getStackTrace().toString());
        }
        return a;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList();
    }

    public String[] listAttributes() {
        return (String[])this.attributeMap.values().toArray();
    }
}

