/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterRegistry;
import com.sun.enterprise.admin.wsmgmt.transform.TransformException;
import com.sun.enterprise.admin.wsmgmt.transform.TransformFilter;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class TransformHandler {
    private TransformFilter _filter = null;
    private String _endpointId = null;
    private String _applicationId = null;
    private static final String DELIM = "#";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(TransformHandler.class);

    public TransformHandler(WebServiceConfig wsc, String appId) throws TransformException {
        this._applicationId = appId;
        this._endpointId = wsc.getName();
    }

    public TransformHandler(String endpoint, String appId) {
        this._applicationId = appId;
        this._endpointId = endpoint;
    }

    public Filter registerFilter(WebServiceConfig wsc) throws TransformException {
        this._filter = new TransformFilter(this._applicationId, wsc);
        FilterRegistry fr = FilterRegistry.getInstance();
        String endpoint = this.getFQEndpointName();
        fr.registerFilter("PROCESS_REQUEST", endpoint, this._filter);
        fr.registerFilter("PROCESS_RESPONSE", endpoint, this._filter);
        return this._filter;
    }

    private void registerFilter() {
        this._filter = new TransformFilter(this._applicationId, this._endpointId);
        FilterRegistry fr = FilterRegistry.getInstance();
        String endpoint = this.getFQEndpointName();
        fr.registerFilter("PROCESS_REQUEST", endpoint, this._filter);
        fr.registerFilter("PROCESS_RESPONSE", endpoint, this._filter);
    }

    void destroy() {
        if (this._filter != null) {
            FilterRegistry fr = FilterRegistry.getInstance();
            String endpoint = this.getFQEndpointName();
            fr.unregisterFilter("PROCESS_REQUEST", endpoint, this._filter);
            fr.unregisterFilter("PROCESS_RESPONSE", endpoint, this._filter);
            this._filter = null;
        }
        _logger.finer("Transform handler destroyed for " + this.getEndpointName());
    }

    void unregisterFilter(String appId, WebServiceConfig wsc) {
        String fn = TransformFilter.getName(appId, wsc);
        FilterRegistry fr = FilterRegistry.getInstance();
        String endpoint = this.getFQEndpointName(appId, wsc);
        fr.unregisterFilterByName("PROCESS_REQUEST", endpoint, fn);
        fr.unregisterFilterByName("PROCESS_RESPONSE", endpoint, fn);
        _logger.finer("Transform handler destroyed for " + this.getEndpointName());
    }

    public Filter getFilter(String appId, WebServiceConfig wsc) {
        FilterRegistry fr = FilterRegistry.getInstance();
        String endpoint = this.getFQEndpointName(appId, wsc);
        _logger.finer("getFilter called for " + this.getEndpointName());
        List filterList = fr.getFilters("PROCESS_REQUEST", endpoint);
        if (filterList == null) {
            return null;
        }
        Iterator filterItr = filterList.iterator();
        if (filterItr == null) {
            return null;
        }
        while (filterItr.hasNext()) {
            Filter f = (Filter)filterItr.next();
            if (!(f instanceof TransformFilter)) continue;
            return f;
        }
        return null;
    }

    String getEndpointName() {
        return this._endpointId;
    }

    String getFQEndpointName() {
        return this._applicationId + DELIM + this._endpointId;
    }

    String getFQEndpointName(String appId, WebServiceConfig wsc) {
        return appId + DELIM + wsc.getName();
    }
}

