/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import java.util.Vector;

public class AttrString
extends AttrType {
    int maxLength = 0;
    Vector ee = null;
    String expr = null;

    public AttrString(String name, String type, boolean optional) {
        super(name, type, optional);
    }

    public void setRegExpression(String str) {
        this.expr = str;
    }

    public void setEnumstring(Vector vec) {
        this.ee = vec;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int max) {
        this.maxLength = max;
    }

    public void validate(Object o, ValidationContext valCtx) {
        super.validate(o, valCtx);
        if (o == null) {
            return;
        }
        String str = (String)o;
        if (0 != this.maxLength && str.length() > this.maxLength) {
            this.reportAttributeError(valCtx, "invalidStringLength", "Attribute[{0}={1}] : String {2} length is greather than maximum length {3}", new Object[]{valCtx.attrName, str, str, String.valueOf(this.maxLength)});
        }
        if (null != this.ee && !this.ee.contains(str)) {
            this.reportAttributeError(valCtx, "strInvalidEnum", "Attribute({0}={1}) : Invalid String - Required {2}", new Object[]{valCtx.attrName, str, this.ee.toString()});
        }
        if (null != this.expr && !str.matches(this.expr)) {
            String printOwnerName = GenericValidator.getConfigElementPrintName(this.getFutureXPathForValidatingAttribute(valCtx), false, false);
            String generic_descr = valCtx.smh.getLocalString("default_pattern_description", "Please refer to admin documentation.");
            String descr = valCtx.smh.getLocalString("pattern_description_for_" + this.expr.replaceAll("[\\\\=:]", "`"), generic_descr);
            this.reportAttributeError(valCtx, "regexpNotMatch", "Value \"{1}\" is not valid for attribute \"{0}\" of {2}. {3}", new Object[]{valCtx.attrName, str, printOwnerName, descr});
        }
    }
}

