/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanRegistrationListener;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.Output;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.OldConfigTypes;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import com.sun.enterprise.management.support.ParamNameMapper;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;
import com.sun.enterprise.management.support.oldconfig.OldResourcesMBean;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFactory {
    private final ConfigFactoryCallback mCallbacks;
    private ParamNameMapper mParamNameMapper = null;
    private final Output mDebug;
    protected static final String CONFIG_NAME_KEY = "Name";
    private static final Class[] ATTRS_ONLY_SIG = new Class[]{AttributeList.class};
    private static final Class[] ATTRS_AND_PROPS_SIG = new Class[]{AttributeList.class, Properties.class};
    protected static final Set<String> NO_OPTIONAL_KEYS = Collections.emptySet();
    private static final Class[] TYPE_AND_ATTRS_AND_PROPS_SIG = new Class[]{String.class, AttributeList.class, Properties.class};
    private static final Class[] TYPE_AND_ATTRS_SIG = new Class[]{String.class, AttributeList.class};

    public ConfigFactory(ConfigFactoryCallback callbacks) {
        this.mCallbacks = callbacks;
        this.mDebug = AMXDebug.getInstance().getOutput(this.getClass().getName());
    }

    protected final MBeanServer getMBeanServer() {
        return this.getCallbacks().getMBeanServer();
    }

    protected final void debug(Object o) {
        this.mDebug.println(o);
    }

    protected final ConfigFactoryCallback getCallbacks() {
        return this.mCallbacks;
    }

    protected static void putNonNull(Map<String, String> m, String key, Object value) {
        if (value != null) {
            m.put(key, "" + value);
        }
    }

    protected final String getConfigName() {
        return this.getCallbacks().getConfigName();
    }

    protected final String getContainerName() {
        String name = this.getFactoryContainer().getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return name;
    }

    protected final Logger getLogger() {
        return this.getCallbacks().getLogger();
    }

    protected final DomainRoot getDomainRoot() {
        return this.getCallbacks().getDomainRoot();
    }

    protected final QueryMgr getQueryMgr() {
        return this.getDomainRoot().getQueryMgr();
    }

    protected final DomainConfig getDomainConfig() {
        return this.getDomainRoot().getDomainConfig();
    }

    protected final Container getFactoryContainer() {
        return this.getCallbacks().getFactoryContainer();
    }

    protected final OldConfigProxies getOldConfigProxies() {
        return this.getCallbacks().getOldConfigProxies();
    }

    protected final void remove() {
        throw new RuntimeException("form 'remove()' no longer supported");
    }

    protected WaitForUnregistrationListener newWaitForUnregistrationListener(ObjectName objectName) {
        try {
            return new WaitForUnregistrationListener(objectName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void waitForUnregistration(WaitForUnregistrationListener l) {
        long SLEEP_MILLIS = 10L;
        long MAX_WAIT_MILLIS = 5000L;
        for (long total = 0L; total < 5000L && !l.done(); total += 10L) {
            this.sleepMillis(10L);
        }
        if (!l.done()) {
            throw new RuntimeException("MBean failed to unregister: " + JMXUtil.toString(l.getTarget()));
        }
    }

    public final void remove(ObjectName objectName) {
        if (objectName == null) {
            throw new RuntimeException(new InstanceNotFoundException());
        }
        WaitForUnregistrationListener l = this.newWaitForUnregistrationListener(objectName);
        this.internalRemove(objectName);
        this.waitForUnregistration(l);
        this.getCallbacks().sendConfigRemovedNotification(objectName);
    }

    protected void removeByName(String name) {
        throw new UnsupportedOperationException("removeByNameInternal");
    }

    protected void internalRemove(ObjectName objectName) {
        this.removeByName(Util.getName(objectName));
    }

    protected Map<String, String> getParamNameOverrides() {
        return Collections.emptyMap();
    }

    protected synchronized ParamNameMapper getParamNameMapper() {
        if (this.mParamNameMapper == null) {
            this.mParamNameMapper = new ParamNameMapper(this.getParamNameOverrides());
        }
        return this.mParamNameMapper;
    }

    protected boolean getBooleanOption(Map<String, String> m, String key) {
        String obj;
        boolean value = false;
        String string = obj = m == null ? null : m.get(key);
        if (obj != null) {
            if (obj instanceof Boolean) {
                value = (Boolean)((Object)obj);
            } else if (obj instanceof String) {
                value = Boolean.valueOf(obj);
            } else {
                throw new IllegalArgumentException("Illegal value for Boolean " + key);
            }
        }
        return value;
    }

    protected boolean requireValidReferences(Map<String, String> options) {
        return !this.getBooleanOption(options, "IgnoreMissingReferences");
    }

    protected final Method findAnyMethod(String methodName, Class[] sig) {
        Method m = null;
        try {
            m = this.getClass().getDeclaredMethod(methodName, sig);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return m;
    }

    protected final ObjectName createChild(Map<String, String> params) {
        return this.createNamedChild(null, params);
    }

    protected final ObjectName createNamedChild(String name, Map<String, String> params) {
        this.debug("createNamedChild: " + name + ":\n{\n" + this.stringify(params) + "\n}");
        AttributeList attrs = new AttributeList();
        Properties props = new Properties();
        this.translateParams(params, attrs, props);
        this.debug("createNamedChild: translated attrs:\n{\n" + this.stringify(attrs) + "\n}");
        if (props.keySet().size() != 0) {
            this.debug("createNamedChild: translated props:\n" + this.stringify(props));
        }
        ObjectName oldObjectName = null;
        boolean propertiesHandled = false;
        if (this.findAnyMethod("createOldChildConfig", ATTRS_AND_PROPS_SIG) != null) {
            this.debug("createNamedChild: calling createOldChildConfig using attrs\n" + this.stringify(attrs) + "\nand props \n" + this.stringify(props));
            oldObjectName = this.createOldChildConfig(attrs, props);
            propertiesHandled = true;
        } else if (this.findAnyMethod("createOldChildConfig", ATTRS_ONLY_SIG) != null) {
            this.debug("createNamedChild: calling createOldChildConfig using attrs\n" + this.stringify(attrs));
            oldObjectName = this.createOldChildConfig(attrs);
        } else {
            throw new UnsupportedOperationException("createOldChildConfig");
        }
        return this.finish(oldObjectName, propertiesHandled ? null : props);
    }

    protected final ObjectName finish(ObjectName oldObjectName, Properties props) {
        assert (oldObjectName != null);
        this.debug("createNamedChild: created: " + StringUtil.quote(oldObjectName.toString()));
        if (!this.getMBeanServer().isRegistered(oldObjectName)) {
            throw new RuntimeException(new InstanceNotFoundException(oldObjectName.toString()));
        }
        ObjectName amxName = this.getCallbacks().getLoader().sync(oldObjectName);
        this.debug("createNamedChild: amx object name: " + StringUtil.quote(amxName.toString()));
        if (props != null && props.size() > 0) {
            this.debug("Setting properties: " + this.stringify(props));
            this.setAllProperties(amxName, props);
        }
        this.getCallbacks().sendConfigCreatedNotification(amxName);
        return amxName;
    }

    protected Set<String> getLegalOptionalCreateKeys() {
        return NO_OPTIONAL_KEYS;
    }

    protected void checkLegalOptions(Map<String, String> options) {
        if (options != null) {
            Set<String> legalKeys = this.getLegalOptionalCreateKeys();
            if (legalKeys != null) {
                this.debug("Legal optional keys: " + this.stringify(legalKeys));
            }
            if (legalKeys != null) {
                HashMap<String, String> remaining = new HashMap<String, String>(options);
                remaining.keySet().removeAll(legalKeys);
                HashMap illegal = new HashMap();
                for (String key : remaining.keySet()) {
                    if (key.startsWith("property.")) continue;
                    illegal.put(key, remaining.get(key));
                }
                if (illegal.size() != 0) {
                    String msg = "Illegal optional keys: " + MapUtil.toString(illegal, ",");
                    this.debug(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
        }
    }

    protected final Map<String, String> initParams(String name, String[] required, Map<String, String> optional) {
        this.checkLegalOptions(optional);
        Map<String, String> m = this.initParams(required, optional);
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Illegal to have null or empty name");
        }
        m.put(CONFIG_NAME_KEY, name);
        return m;
    }

    protected final void validateParams(Map<String, ?> params) {
        for (String name : params.keySet()) {
            Object value = params.get(name);
            this.validateParam(name, value);
        }
    }

    protected final void validateParam(String name, Object value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("parameter name must be non-null and non-empty");
        }
        if (name.startsWith("property.") && !(value instanceof String)) {
            throw new IllegalArgumentException("Property value must be string: " + name + ", class =" + value.getClass().getName());
        }
    }

    protected final Map<String, String> initParams(String[] required, Map<String, String> optionalIn) {
        Map<String, String> optional = MapUtil.toStringStringMap(optionalIn);
        HashMap<String, String> m = new HashMap<String, String>();
        if (optional != null) {
            m.putAll(optional);
            m.remove("IgnoreMissingReferences");
        }
        if (required != null) {
            m.putAll(MapUtil.newMap(required));
        }
        this.validateParams(m);
        return m;
    }

    protected final Map<String, String> initParams(Map<String, String> optional) {
        return this.initParams(null, optional);
    }

    protected final void translateParams(Map<String, String> paramsToTranslate, AttributeList attrsOut, Properties propsOut) {
        ParamNameMapper mapper = this.getParamNameMapper();
        Iterator<String> iter = paramsToTranslate.keySet().iterator();
        String propertyPrefix = "property.";
        while (iter.hasNext()) {
            String key = iter.next();
            String value = paramsToTranslate.get(key);
            if (key.startsWith("property.")) {
                String name = key.substring("property.".length(), key.length());
                propsOut.put(name, value);
                continue;
            }
            String translatedName = mapper.mangleAttributeName(key);
            Attribute attr = new Attribute(translatedName, value);
            attrsOut.add(attr);
        }
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        throw new UnsupportedOperationException("createOldChildConfig( AttributeList )");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        throw new UnsupportedOperationException("createOldChildConfig( AttributeList, Properties)");
    }

    protected final void trace(Object o) {
        this.debug(o);
    }

    protected String stringify(Object o) {
        return SmartStringifier.toString(o);
    }

    protected ObjectName createOldChildByType(String oldChildType, AttributeList translatedAttrs) {
        throw new UnsupportedOperationException("createOldChildByType( String, AttributeList )");
    }

    protected ObjectName createOldChildByType(String oldChildType, AttributeList translatedAttrs, Properties props) {
        throw new UnsupportedOperationException("createOldChildByType( String, AttributeList, Properties )");
    }

    protected final ObjectName createChildByType(String childJ2EEType, Map<String, String> params) {
        String oldType = this.getOldTypeToJ2EETypeMapper().j2eeTypeToOldType(childJ2EEType);
        assert (oldType != null);
        Properties props = new Properties();
        AttributeList attrs = new AttributeList();
        this.translateParams(params, attrs, props);
        ObjectName oldObjectName = null;
        boolean propertiesHandled = false;
        if (this.findAnyMethod("createOldChildByType", TYPE_AND_ATTRS_AND_PROPS_SIG) != null) {
            oldObjectName = this.createOldChildByType(oldType, attrs, props);
            propertiesHandled = true;
        } else if (this.findAnyMethod("createOldChildByType", TYPE_AND_ATTRS_SIG) != null) {
            oldObjectName = this.createOldChildByType(oldType, attrs);
        } else if (this.findAnyMethod("createOldChildByType", ATTRS_ONLY_SIG) != null) {
            oldObjectName = this.createOldChildConfig(attrs);
        } else {
            throw new UnsupportedOperationException("createOldChildByType");
        }
        assert (oldObjectName != null);
        this.debug("createChildByType: oldObjectName: " + StringUtil.quote(oldObjectName.toString()));
        ObjectName amxName = this.getCallbacks().getLoader().sync(oldObjectName);
        this.debug("createChildByType: amx object name: " + StringUtil.quote(amxName.toString()));
        if (props.size() > 0 && !propertiesHandled) {
            this.setAllProperties(amxName, props);
        }
        this.getCallbacks().sendConfigCreatedNotification(amxName);
        return amxName;
    }

    protected final void setAllProperties(ObjectName amxObjectName, Properties props) {
        PropertiesAccess proxy = (PropertiesAccess)PropertiesAccess.class.cast(this.getCallbacks().getProxyFactory().getProxy(amxObjectName, AMX.class));
        this.setAllProperties(proxy, props);
    }

    protected final void setAllProperties(PropertiesAccess target, Properties props) {
        for (String string : props.keySet()) {
            target.setPropertyValue(string, (String)props.get(string));
        }
    }

    protected OldTypeToJ2EETypeMapper getOldTypeToJ2EETypeMapper() {
        return OldConfigTypes.getInstance();
    }

    protected ObjectName syncNewAMXMBeanWithOld(ObjectName oldObjectName) {
        ObjectName amxName = this.getCallbacks().getLoader().sync(oldObjectName);
        this.getCallbacks().sendConfigCreatedNotification(amxName);
        return amxName;
    }

    final OldResourcesMBean getOldResourcesMBean() {
        return this.getOldConfigProxies().getOldResourcesMBean();
    }

    protected static String quote(Object o) {
        return StringUtil.quote(o.toString());
    }

    protected void checkNonEmptyString(String s, String name) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Parameter may not be null or empty: " + ConfigFactory.quote(name));
        }
    }

    protected final Object getValue(Map<String, String> m, String key) {
        return m == null ? null : m.get(key);
    }

    protected final String getString(Map<String, String> m, String key) {
        return (String)this.getValue(m, key);
    }

    protected final Boolean getBoolean(Map<String, String> m, String key, Boolean defaultValue) {
        Object value = this.getValue(m, key);
        return value == null ? defaultValue : Boolean.valueOf("" + value);
    }

    protected boolean sleepMillis(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            interrupted = true;
        }
        return interrupted;
    }

    protected AMX requireItem(String j2eeType, String name) {
        Object item = this.getFactoryContainer().getContainee(j2eeType, name);
        if (item == null) {
            throw new IllegalArgumentException(j2eeType + "=" + name);
        }
        return item;
    }

    protected final class WaitForUnregistrationListener
    extends MBeanRegistrationListener {
        private final ObjectName mTarget;
        private boolean mDone;

        private WaitForUnregistrationListener(ObjectName objectName) throws InstanceNotFoundException, IOException {
            super(ConfigFactory.this.getMBeanServer(), null);
            this.mDone = false;
            this.mTarget = objectName;
        }

        public ObjectName getTarget() {
            return this.mTarget;
        }

        public boolean done() {
            return this.mDone;
        }

        protected void mbeanRegistered(ObjectName objectName) {
        }

        protected void mbeanUnregistered(ObjectName objectName) {
            if (this.mTarget.equals(objectName)) {
                this.mDone = true;
                this.cleanup();
            }
        }
    }
}

