/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.HealthCheckerConfigFactory;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.LBDeregistrationUtil;
import com.sun.enterprise.management.support.ObjectNames;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ServerRefConfigImpl
extends AMXConfigImplBase
implements ConfigFactoryCallback {
    ServerRefDeregistrationHelper mHelper = null;

    public ServerRefConfigImpl(Delegate delegate) {
        super(delegate);
    }

    public ObjectName getHealthCheckerConfigObjectName() {
        return this.getContaineeObjectName("X-HealthCheckerConfig");
    }

    private HealthCheckerConfigFactory getHealthCheckerConfigFactory() {
        return new HealthCheckerConfigFactory(this);
    }

    public ObjectName createHealthCheckerConfig(String url, String intervalInSeconds, String timeoutInSeconds) {
        return this.getHealthCheckerConfigFactory().create(url, intervalInSeconds, timeoutInSeconds);
    }

    public void removeHealthCheckerConfig(String name) {
        ObjectName item = this.getHealthCheckerConfigObjectName();
        this.getHealthCheckerConfigFactory().remove(item);
    }

    protected void unregisterMisc() {
        try {
            this.mHelper = new ServerRefDeregistrationHelper(this.getName(), this.getMBeanServer());
        }
        catch (Exception ex) {
            this.logWarning("ServerRefConfig unregisterMisc failed. ServerRefDeregistrationHelper creation failed");
        }
    }

    public void postDeregister() {
        super.postDeregister();
        try {
            if (this.getContainer() instanceof LBConfig) {
                String lbConfigName = ((LBConfig)this.getContainer()).getName();
                Map<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = this.mHelper.fetchLoadBalancerConfigs((LBConfig)this.getContainer());
                this.mHelper.unregisterMonitors(relevantLoadBalancerConfigMap);
            } else if (this.getContainer() instanceof ClusterConfig) {
                String clusterName = ((ClusterConfig)this.getContainer()).getName();
                Map<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = this.mHelper.fetchLoadBalancerConfigs((ClusterConfig)this.getContainer());
                this.mHelper.unregisterMonitors(clusterName, relevantLoadBalancerConfigMap);
            }
            this.mHelper = null;
        }
        catch (Exception ex) {
            this.logWarning("ServerRefConfig postDeregistration failed. Load Balancer Monitoring MBeans might be lying around");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerRefDeregistrationHelper {
        static final String J2EE_TYPE = "j2eeType";
        final ObjectNames objectNames = ObjectNames.getInstance("amx");
        String serverName = null;
        MBeanServer mbs = null;

        public ServerRefDeregistrationHelper(String serverName, MBeanServer mbs) {
            this.mbs = mbs;
            this.serverName = serverName;
        }

        void unregisterMonitors(Map<String, LoadBalancerConfig> relevantLoadBalancerConfigMap) throws JMException {
            this.unregisterMonitors(this.serverName, relevantLoadBalancerConfigMap);
        }

        void unregisterMonitors(String clusterName, Map<String, LoadBalancerConfig> relevantLoadBalancerConfigMap) throws JMException {
            for (String loadBalancerName : relevantLoadBalancerConfigMap.keySet()) {
                LoadBalancerMonitor loadBalancerMonitor = LBDeregistrationUtil.getInstance(this.mbs).fetchLBMonitoringRoot(loadBalancerName);
                Map<String, LoadBalancerClusterMonitor> loadBalancerClusterMonitorMap = loadBalancerMonitor.getLoadBalancerClusterMonitorMap();
                LoadBalancerClusterMonitor loadBalancerClusterMonitor = loadBalancerClusterMonitorMap.get(clusterName);
                Map<String, LoadBalancerServerMonitor> loadBalancerServerMonitorMap = loadBalancerClusterMonitor.getLoadBalancerServerMonitorMap();
                for (String serverName : loadBalancerServerMonitorMap.keySet()) {
                    LoadBalancerServerMonitor loadBalancerServerMonitor = loadBalancerServerMonitorMap.get(serverName);
                    Map<String, LoadBalancerApplicationMonitor> loadBalancerApplicationMonitorMap = loadBalancerServerMonitor.getLoadBalancerApplicationMonitorMap();
                    for (String appName : loadBalancerApplicationMonitorMap.keySet()) {
                        LoadBalancerApplicationMonitor loadBalancerApplicationMonitor = loadBalancerApplicationMonitorMap.get(appName);
                        Map<String, LoadBalancerContextRootMonitor> lbcrmm = loadBalancerApplicationMonitor.getLoadBalancerContextRootMonitorMap();
                        for (String ctxRootName : lbcrmm.keySet()) {
                            LoadBalancerContextRootMonitor loadBalancerContextRootMonitor = lbcrmm.get(ctxRootName);
                            ObjectName loadBalancerContextRootMonitorObjName = Util.getObjectName(loadBalancerContextRootMonitor);
                            this.mbs.unregisterMBean(loadBalancerContextRootMonitorObjName);
                        }
                        ObjectName loadBalancerApplicationMonitorObjName = Util.getObjectName(loadBalancerApplicationMonitor);
                        this.mbs.unregisterMBean(loadBalancerApplicationMonitorObjName);
                    }
                    ObjectName loadBalancerServerMonitorObjName = Util.getObjectName(loadBalancerServerMonitor);
                    this.mbs.unregisterMBean(loadBalancerServerMonitorObjName);
                }
                ObjectName loadBalancerClusterMonitorObjName = Util.getObjectName(loadBalancerClusterMonitor);
                this.mbs.unregisterMBean(loadBalancerClusterMonitorObjName);
            }
        }

        Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(LBConfig lbConfig) {
            HashMap<String, LBConfig> lbConfigMap = new HashMap<String, LBConfig>();
            lbConfigMap.put(lbConfig.getName(), lbConfig);
            return this.fetchLoadBalancerConfigs(lbConfigMap);
        }

        Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(ClusterConfig clusterConfig) {
            String clusterName = clusterConfig.getName();
            Map<String, LBConfig> allLBConfigMap = ServerRefConfigImpl.this.getDomainRoot().getDomainConfig().getLBConfigMap();
            HashMap<String, LBConfig> relevantLBConfigMap = new HashMap<String, LBConfig>();
            block0: for (String lbConfigName : allLBConfigMap.keySet()) {
                LBConfig lbConfig = allLBConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> clusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                for (String clusterRef : clusterRefConfigMap.keySet()) {
                    if (!clusterRef.equals(clusterName)) continue;
                    relevantLBConfigMap.put(lbConfigName, lbConfig);
                    continue block0;
                }
            }
            return this.fetchLoadBalancerConfigs(relevantLBConfigMap);
        }

        private Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(Map<String, LBConfig> lbConfigMap) {
            HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap<String, LoadBalancerConfig>();
            for (String lbConfigName : lbConfigMap.keySet()) {
                Map<String, LoadBalancerConfig> allLoadBalancerConfigMap = ServerRefConfigImpl.this.getDomainRoot().getDomainConfig().getLoadBalancerConfigMap();
                for (String loadBalancerName : allLoadBalancerConfigMap.keySet()) {
                    LoadBalancerConfig loadBalancerConfig = allLoadBalancerConfigMap.get(loadBalancerName);
                    if (!loadBalancerConfig.getLbConfigName().equals(lbConfigName)) continue;
                    relevantLoadBalancerConfigMap.put(loadBalancerName, loadBalancerConfig);
                }
            }
            return relevantLoadBalancerConfigMap;
        }
    }
}

