/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.enterprise.management.support.DelegateBase;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DelegateToMBeanDelegate
extends DelegateBase {
    private final ObjectName mTarget;
    private final MBeanServerConnection mConn;
    private final MBeanInfo mTargetMBeanInfo;

    public DelegateToMBeanDelegate(MBeanServerConnection conn, ObjectName target) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        super("DelegateToMBeanDelegate." + target.toString(), null);
        this.mConn = conn;
        this.mTarget = target;
        this.mTargetMBeanInfo = this.mConn.getMBeanInfo(target);
    }

    public DelegateToMBeanDelegate(MBeanServer server, ObjectName target) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        super("DelegateToMBeanDelegate." + target.toString(), null);
        this.mConn = server;
        this.mTarget = target;
        this.mTargetMBeanInfo = server.getMBeanInfo(target);
    }

    public ObjectName getTarget() {
        return this.mTarget;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mConn;
    }

    public Object getAttribute(String attrName) throws AttributeNotFoundException {
        try {
            Object value = this.getMBeanServerConnection().getAttribute(this.mTarget, attrName);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        try {
            this.getMBeanServerConnection().setAttribute(this.mTarget, attr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mTargetMBeanInfo;
    }

    private void delegateFailed(Throwable t) {
        if (this.getOwner() != null) {
            this.getOwner().delegateFailed(t);
        }
    }

    public final Object invoke(String operationName, Object[] args, String[] types) {
        try {
            Object result = this.getMBeanServerConnection().invoke(this.getTarget(), operationName, args, types);
            return result;
        }
        catch (InstanceNotFoundException e) {
            this.delegateFailed(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            try {
                this.getMBeanServerConnection().isRegistered(this.getTarget());
            }
            catch (IOException ee) {
                this.delegateFailed(e);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

