/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.appserv.management.monitor.MonitoringRoot;
import com.sun.enterprise.management.ext.lb.LoadBalancerImpl;
import com.sun.enterprise.management.monitor.LoadBalancerMonitorImpl;
import com.sun.enterprise.management.support.LBBaseMBeanRegistrationListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class LoadBalancerRegistrationListener
extends LBBaseMBeanRegistrationListener {
    static final String MONITORING_ENABLED = "MonitoringEnabled";

    public LoadBalancerRegistrationListener(MBeanServer mBeanServer) throws InstanceNotFoundException, IOException {
        super(mBeanServer);
    }

    LoadBalancer registerLoadBalancer(String name) {
        DomainRoot domainRoot = ProxyFactory.getInstance(this.getConn()).getDomainRoot();
        ObjectName domainRootObjName = Util.getObjectName(domainRoot);
        ObjectName loadBalancerObjName = this.objectNames.buildContaineeObjectName(domainRootObjName, domainRoot.getFullType(), "X-LoadBalancer", name);
        LoadBalancerImpl loadBalancerImpl = new LoadBalancerImpl(this.getConn());
        try {
            ((MBeanServer)this.getConn()).registerMBean(loadBalancerImpl, loadBalancerObjName);
        }
        catch (JMException ex) {
            this.logWarning("LoadBalancerRegistrationListener registerLoadBalancer failed. Exception = ", ex);
        }
        return ProxyFactory.getInstance(this.getConn()).getProxy(loadBalancerObjName, LoadBalancer.class);
    }

    protected void mbeanRegistered(ObjectName objectName) {
        try {
            if ("X-LoadBalancerConfig".equals(Util.getJ2EEType(objectName))) {
                LoadBalancerConfig loadBalancerConfig = ProxyFactory.getInstance(this.getConn()).getProxy(objectName, LoadBalancerConfig.class);
                String name = loadBalancerConfig.getName();
                String loadBalancerConfigName = loadBalancerConfig.getName();
                LoadBalancer loadBalancer = this.registerLoadBalancer(loadBalancerConfig.getName());
                String lbConfigName = loadBalancerConfig.getLbConfigName();
                LBConfig lbConfig = this.getDomainConfig().getLBConfigMap().get(lbConfigName);
                this.addLBConfigListener(name, lbConfig);
                if (lbConfig.getMonitoringEnabled()) {
                    this.enableMonitoring(name, lbConfig);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logWarning("LoadBalancerRegistrationListener mbeanRegistered failed. Exception = ", ex);
        }
    }

    private LoadBalancerMonitor registerLoadBalancerMonitor(String name) {
        MonitoringRoot monitoringRoot = ProxyFactory.getInstance(this.getConn()).getDomainRoot().getMonitoringRoot();
        ObjectName monitoringRootObjName = Util.getObjectName(monitoringRoot);
        ObjectName loadBalancerMonitorObjName = this.objectNames.buildContaineeObjectName(monitoringRootObjName, monitoringRoot.getFullType(), "X-LoadBalancerMonitor", name);
        LoadBalancerMonitorImpl loadBalancerMonitorImpl = new LoadBalancerMonitorImpl();
        try {
            ((MBeanServer)this.getConn()).registerMBean(loadBalancerMonitorImpl, loadBalancerMonitorObjName);
        }
        catch (JMException ex) {
            this.logWarning("LoadBalancerRegistrationListener registerLoadBalancerMonitor failed. Exception = ", ex);
        }
        return ProxyFactory.getInstance(this.getConn()).getProxy(loadBalancerMonitorObjName, LoadBalancerMonitor.class);
    }

    void enableMonitoring(String name, LBConfig lbConfig) throws Exception {
        Map<String, ClusterRefConfig> clusterRefConfigMap;
        LoadBalancerMonitor lbm = this.registerLoadBalancerMonitor(name);
        Map<String, ServerRefConfig> serverRefConfigMap = lbConfig.getServerRefConfigMap();
        if (!serverRefConfigMap.isEmpty()) {
            Map<String, StandaloneServerConfig> ssConfigMap = this.getDomainConfig().getStandaloneServerConfigMap();
            HashMap<String, ServerConfig> serverConfigMap = new HashMap<String, ServerConfig>();
            for (String key : ssConfigMap.keySet()) {
                serverConfigMap.put(key, ssConfigMap.get(key));
            }
            for (String serverName : serverRefConfigMap.keySet()) {
                LoadBalancerClusterMonitor lbcm = this.registerLoadBalancerClusterMonitor(lbm, serverName);
                this.registerLoadBalancerServerMonitorTree(lbcm, serverConfigMap, serverName);
            }
        }
        if (!(clusterRefConfigMap = lbConfig.getClusterRefConfigMap()).isEmpty()) {
            for (String clusterName : clusterRefConfigMap.keySet()) {
                this.registerLoadBalancerClusterMonitorTree(lbm, clusterName);
            }
        }
    }

    void disableMonitoring(String loadBalancerName) throws Exception {
        LoadBalancerMonitor lbm = this.getLBDeregistrationUtil((MBeanServer)this.getConn()).fetchLBMonitoringRoot(loadBalancerName);
        Map<String, LoadBalancerClusterMonitor> lbcmMap = lbm.getLoadBalancerClusterMonitorMap();
        for (LoadBalancerClusterMonitor lbcm : lbcmMap.values()) {
            Map<String, LoadBalancerServerMonitor> lbsmMap = lbcm.getLoadBalancerServerMonitorMap();
            for (LoadBalancerServerMonitor lbsm : lbsmMap.values()) {
                Map<String, LoadBalancerApplicationMonitor> lbamMap = lbsm.getLoadBalancerApplicationMonitorMap();
                for (LoadBalancerApplicationMonitor lbam : lbamMap.values()) {
                    Map<String, LoadBalancerContextRootMonitor> lbcrmMap = lbam.getLoadBalancerContextRootMonitorMap();
                    for (LoadBalancerContextRootMonitor lbcrm : lbcrmMap.values()) {
                        ObjectName lbcrmObjName = Util.getObjectName(lbcrm);
                        ((MBeanServer)this.getConn()).unregisterMBean(lbcrmObjName);
                    }
                    ObjectName lbamObjName = Util.getObjectName(lbam);
                    ((MBeanServer)this.getConn()).unregisterMBean(lbamObjName);
                }
                ObjectName loadBalancerServerMonitorObjName = Util.getObjectName(lbsm);
                ((MBeanServer)this.getConn()).unregisterMBean(loadBalancerServerMonitorObjName);
            }
            ObjectName lbcmObjName = Util.getObjectName(lbcm);
            ((MBeanServer)this.getConn()).unregisterMBean(lbcmObjName);
        }
        ObjectName lbmObjName = Util.getObjectName(lbm);
        ((MBeanServer)this.getConn()).unregisterMBean(lbmObjName);
    }

    void addLBConfigListener(String loadBalancerName, LBConfig lbConfig) {
        LBConfigListener mLBConfigListener = new LBConfigListener(loadBalancerName);
        this.getLBDeregistrationUtil((MBeanServer)this.getConn()).addLBConfigListener(loadBalancerName, mLBConfigListener, lbConfig);
    }

    private final class LBConfigListener
    implements NotificationListener {
        String mLoadBalancerConfigName;

        public LBConfigListener(String name) {
            this.mLoadBalancerConfigName = name;
        }

        public void handleNotification(Notification notif, Object handback) {
            try {
                AttributeChangeNotification attrChangeNotif;
                if (notif.getType().equals("jmx.attribute.change") && LoadBalancerRegistrationListener.MONITORING_ENABLED.equals((attrChangeNotif = (AttributeChangeNotification)notif).getAttributeName()) && (Boolean)attrChangeNotif.getNewValue() != (Boolean)attrChangeNotif.getOldValue()) {
                    if (attrChangeNotif.getNewValue().equals(Boolean.TRUE)) {
                        ObjectName lbConfigObjName = (ObjectName)notif.getSource();
                        LBConfig lbConfig = ProxyFactory.getInstance(LoadBalancerRegistrationListener.this.getConn()).getProxy(lbConfigObjName, LBConfig.class);
                        LoadBalancerRegistrationListener.this.enableMonitoring(this.mLoadBalancerConfigName, lbConfig);
                    } else {
                        LoadBalancerRegistrationListener.this.disableMonitoring(this.mLoadBalancerConfigName);
                    }
                }
            }
            catch (Exception ex) {
                LoadBalancerRegistrationListener.this.logWarning("LBBootstrapUtil$LBConfigListener handleNotification failed. Exception = ", ex);
            }
        }
    }
}

