/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.appserv.management.monitor.MonitoringRoot;
import com.sun.appserv.management.monitor.statistics.LoadBalancerContextRootStats;
import com.sun.appserv.management.monitor.statistics.LoadBalancerServerStats;
import com.sun.appserv.management.util.misc.Formatter;
import com.sun.appserv.management.util.misc.StringSourceBase;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LBConfigHelper {
    DomainConfig mDomainConfig = null;
    DomainRoot mDomainRoot = null;
    static final String LB_CONFIG_SUFFIX = "_LB_CONFIG";
    static final String LB_SUFFIX = "-lb-temp";
    Logger mLogger = null;
    ResourceBundle resBundle = null;
    Formatter formatter = null;
    public static final String RESPONSE_TIMEOUT = "responsetimeout";
    public static final String HTTPS_ROUTING = "httpsrouting";
    public static final String RELOAD_INTERVAL = "reloadinterval";
    public static final String MONITOR = "monitor";
    public static final String ROUTE_COOKIE = "routecookie";
    public static final String HEALTH_CHECKER_URL = "healthcheckerurl";
    public static final String HEALTH_CHECKER_TIMEOUT = "healthcheckertimeout";
    public static final String HEALTH_CHECKER_INTERVAL = "healthcheckerinterval";
    public static final String TARGET = "target";
    public static final String CONFIG = "config";
    public static final String LB_POLICY = "lbpolicy";
    public static final String LB_POLICY_MODULE = "lbpolicymodule";

    public LBConfigHelper(DomainRoot domainRoot) {
        this.mDomainConfig = domainRoot.getDomainConfig();
        this.mDomainRoot = domainRoot;
        this.mLogger = Logger.getLogger(domainRoot.getMBeanLoggerName());
        this.resBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".LocalStrings");
        this.formatter = new Formatter(new StringSourceBase());
    }

    public List<LBConfig> getLBConfigsForServer(String serverName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigMap();
        ArrayList<LBConfig> list = new ArrayList<LBConfig>();
        for (LBConfig config : lbconfigs.values()) {
            Map<String, ServerRefConfig> map = config.getServerRefConfigMap();
            for (String name : map.keySet()) {
                if (!name.equals(serverName)) continue;
                list.add(config);
            }
        }
        return list;
    }

    public List<LBConfig> getLBConfigsForCluster(String clusterName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigMap();
        ArrayList<LBConfig> list = new ArrayList<LBConfig>();
        for (LBConfig config : lbconfigs.values()) {
            Map<String, ClusterRefConfig> map = config.getClusterRefConfigMap();
            for (String name : map.keySet()) {
                if (!name.equals(clusterName)) continue;
                list.add(config);
            }
        }
        return list;
    }

    public Map<String, ServerRefConfig> getServersInLBConfig(String lbConfigName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigMap();
        LBConfig lbconfig = lbconfigs.get(lbConfigName);
        return lbconfig.getServerRefConfigMap();
    }

    public Map<String, ClusterRefConfig> getClustersInLBConfig(String lbConfigName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigMap();
        LBConfig lbconfig = lbconfigs.get(lbConfigName);
        return lbconfig.getClusterRefConfigMap();
    }

    public String[] listTargets() {
        Map<String, StandaloneServerConfig> ssConfigMap;
        HashSet<String> targetSet = new HashSet<String>();
        Map<String, ClusterConfig> cConfigMap = this.mDomainConfig.getClusterConfigMap();
        if (cConfigMap != null) {
            targetSet.addAll(cConfigMap.keySet());
        }
        if ((ssConfigMap = this.mDomainConfig.getStandaloneServerConfigMap()) != null) {
            targetSet.addAll(ssConfigMap.keySet());
        }
        String[] targetArr = new String[targetSet.size()];
        return targetSet.toArray(targetArr);
    }

    public String[] listTargets(String lbName) {
        Map<String, ServerRefConfig> sRefMap;
        HashSet<String> targetSet = new HashSet<String>();
        Map<String, LoadBalancerConfig> lbMap = this.mDomainConfig.getLoadBalancerConfigMap();
        if (lbMap == null) {
            return null;
        }
        LoadBalancerConfig lb = lbMap.get(lbName);
        if (lb == null) {
            return null;
        }
        String lbConfigName = lb.getLbConfigName();
        Map<String, LBConfig> lbConfigMap = this.mDomainConfig.getLBConfigMap();
        if (lbConfigMap == null || lbConfigName == null) {
            return null;
        }
        LBConfig lbConfig = lbConfigMap.get(lbConfigName);
        if (lbConfig == null) {
            return null;
        }
        Map<String, ClusterRefConfig> cRefMap = lbConfig.getClusterRefConfigMap();
        if (cRefMap != null) {
            targetSet.addAll(cRefMap.keySet());
        }
        if ((sRefMap = lbConfig.getServerRefConfigMap()) != null) {
            targetSet.addAll(sRefMap.keySet());
        }
        String[] targetArr = new String[targetSet.size()];
        return targetSet.toArray(targetArr);
    }

    public LoadBalancerConfig createLoadbalancer(String loadbalancerName, boolean autoApplyEnabled, String[] targets, Map<String, String> params) {
        if (loadbalancerName == null) {
            throw new IllegalArgumentException("loadbalancerName can not be null");
        }
        String lbConfigName = loadbalancerName + LB_CONFIG_SUFFIX;
        Map<String, LBConfig> lbconfigMap = this.mDomainConfig.getLBConfigMap();
        if (lbconfigMap != null) {
            int i = 1;
            while (lbconfigMap.get(lbConfigName) != null) {
                lbConfigName = loadbalancerName + LB_CONFIG_SUFFIX + "_" + i;
                ++i;
            }
        }
        LBConfig lbConfig = this.mDomainConfig.createLBConfig(lbConfigName, params);
        if (targets != null) {
            for (int idx = 0; idx < targets.length; ++idx) {
                String targetName = targets[idx];
                if (this.isCluster(targetName)) {
                    lbConfig.createClusterRefConfig(targetName, null);
                    continue;
                }
                if (!this.isStandaloneServer(targetName)) continue;
                lbConfig.createServerRefConfig(targetName, null);
            }
        }
        return this.mDomainConfig.createLoadBalancerConfig(loadbalancerName, lbConfigName, autoApplyEnabled, null);
    }

    public void removeLoadbalancer(String loadbalancerName) {
        Map<String, LoadBalancerConfig> lbMap = this.mDomainConfig.getLoadBalancerConfigMap();
        if (lbMap == null) {
            return;
        }
        LoadBalancerConfig loadbalancerConfig = lbMap.get(loadbalancerName);
        if (loadbalancerConfig == null) {
            return;
        }
        String lbConfigName = loadbalancerConfig.getLbConfigName();
        this.mDomainConfig.removeLoadBalancerConfig(loadbalancerName);
        lbMap = this.mDomainConfig.getLoadBalancerConfigMap();
        if (lbMap == null) {
            return;
        }
        for (LoadBalancerConfig lbConfig : lbMap.values()) {
            if (!lbConfig.getLbConfigName().equals(lbConfigName)) continue;
            return;
        }
        this.mDomainConfig.removeLBConfig(lbConfigName);
    }

    public void disableServer(String target, int timeout) {
        this.setServerStatus(target, timeout, false);
    }

    public void enableServer(String target) {
        this.setServerStatus(target, 0, true);
    }

    public void disableApplication(String target, String appName, int timeout) {
        this.setApplicationStatus(target, appName, timeout, false);
    }

    public void enableApplication(String target, String appName) {
        this.setApplicationStatus(target, appName, 0, true);
    }

    public Map<String, LoadBalancerServerStats> getInstanceStats(String targetLoadBalancer, String target, boolean allTargets) {
        if (targetLoadBalancer == null) {
            throw new IllegalArgumentException("Load Balancer Name can not be null");
        }
        if (!allTargets && target == null) {
            throw new IllegalArgumentException("Specify AllTargets or atleast one target");
        }
        HashMap<String, LoadBalancerServerStats> loadBalancerServerStatsMap = new HashMap<String, LoadBalancerServerStats>();
        Map<String, LoadBalancerServerMonitor> instanceMonitorMap = this.getInstanceMonitors(targetLoadBalancer, target, allTargets);
        for (String serverFQName : instanceMonitorMap.keySet()) {
            LoadBalancerServerMonitor loadBalancerServerMonitor = instanceMonitorMap.get(serverFQName);
            LoadBalancerServerStats loadBalancerServerStats = loadBalancerServerMonitor.getLoadBalancerServerStats();
            loadBalancerServerStatsMap.put(serverFQName, loadBalancerServerStats);
        }
        return loadBalancerServerStatsMap;
    }

    public Map<String, LoadBalancerContextRootStats> getInstanceStats(String targetLoadBalancer, String contextRoot, String target, boolean allTargets) {
        if (contextRoot == null) {
            throw new IllegalArgumentException("ContextRoot can not be null");
        }
        if (targetLoadBalancer == null) {
            throw new IllegalArgumentException("Load Balancer Name can not be null");
        }
        if (!allTargets && target == null) {
            throw new IllegalArgumentException("Specify AllTargets or atleast one target");
        }
        HashMap<String, LoadBalancerContextRootStats> loadBalancerContextRootStatsMap = new HashMap<String, LoadBalancerContextRootStats>();
        Map<String, LoadBalancerServerMonitor> instanceMonitorMap = this.getInstanceMonitors(targetLoadBalancer, target, allTargets);
        for (String serverFQName : instanceMonitorMap.keySet()) {
            LoadBalancerServerMonitor loadBalancerServerMonitor = instanceMonitorMap.get(serverFQName);
            Map<String, LoadBalancerApplicationMonitor> loadBalancerApplicationMonitorMap = loadBalancerServerMonitor.getLoadBalancerApplicationMonitorMap();
            for (String appName : loadBalancerApplicationMonitorMap.keySet()) {
                LoadBalancerApplicationMonitor loadBalancerApplicationMonitor = loadBalancerApplicationMonitorMap.get(appName);
                Map<String, LoadBalancerContextRootMonitor> loadBalancerContextRootMonitorMap = loadBalancerApplicationMonitor.getLoadBalancerContextRootMonitorMap();
                LoadBalancerContextRootMonitor loadBalancerContextRootMonitor = loadBalancerContextRootMonitorMap.get(contextRoot);
                loadBalancerContextRootStatsMap.put(serverFQName, (LoadBalancerContextRootStats)loadBalancerContextRootMonitor.getStats());
            }
        }
        return loadBalancerContextRootStatsMap;
    }

    public String configureHTTPLBConfig(String configName, String target, Map<String, String> options, String filePath) throws MBeanException {
        String healthCheckerUrl = options.get(HEALTH_CHECKER_URL);
        String healthCheckerInterval = options.get(HEALTH_CHECKER_INTERVAL);
        String healthCheckerTimeout = options.get(HEALTH_CHECKER_TIMEOUT);
        String lbPolicy = options.get(LB_POLICY);
        String lbPolicyModule = options.get(LB_POLICY_MODULE);
        boolean isCluster = this.isCluster(target);
        Map<String, String> params = this.getParams(options);
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigMap();
        if (lbconfigs.get(configName) != null) {
            String msg = this.formatter.format(this.resBundle.getString("LbConfigExists"), configName);
            throw new MBeanException(new RuntimeException(msg));
        }
        if (!(isCluster || lbPolicy == null && lbPolicyModule == null)) {
            String msg = this.formatter.format(this.resBundle.getString("NotCluster"), target);
            throw new MBeanException(new RuntimeException(msg));
        }
        LBConfig lbConfig = this.mDomainConfig.createLBConfig(configName, params);
        if (isCluster) {
            ClusterRefConfig clusterRefConfig = lbConfig.createClusterRefConfig(target, null, null);
            if (lbPolicy != null) {
                clusterRefConfig.setLBPolicy(lbPolicy);
            }
            if (lbPolicyModule != null) {
                clusterRefConfig.setLBPolicyModule(lbPolicyModule);
            }
            clusterRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
            this.enableServer(target);
        } else {
            ServerRefConfig serverRefConfig = lbConfig.createServerRefConfig(target, null, true, true);
            serverRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
        }
        this.enableAllApplications(target);
        if (filePath != null) {
            LoadBalancer lb = this.createLoadBalancer(configName);
            String lbxml = lb.getLoadBalancerXML();
            this.mDomainConfig.removeLoadBalancerConfig(configName + LB_SUFFIX);
            return this.writeToFile(lbxml, filePath);
        }
        return null;
    }

    public void configureLBWeight(String clusterName, Map instanceVsWeights) {
        Map<String, ClusterConfig> clusterConfigMap = this.mDomainConfig.getClusterConfigMap();
        ClusterConfig clusterConfig = clusterConfigMap.get(clusterName);
        if (clusterConfig == null) {
            throw new IllegalArgumentException(this.formatter.format(this.resBundle.getString("InvalidCluster"), clusterName));
        }
        Map<String, ClusteredServerConfig> clusteredServerConfigMap = clusterConfig.getClusteredServerConfigMap();
        for (Object instance : instanceVsWeights.keySet()) {
            ClusteredServerConfig clusteredServerConfig = clusteredServerConfigMap.get(instance);
            if (clusteredServerConfig == null) {
                throw new IllegalArgumentException(this.formatter.format(this.resBundle.getString("InvalidInstance"), instance, clusterName));
            }
            clusteredServerConfig.setLBWeight(instanceVsWeights.get(instance).toString());
        }
    }

    public void enableAllApplications(String target) {
        Map<String, ServerConfig> serverConfigMap = this.mDomainConfig.getServerConfigMap();
        ServerConfig serverConfig = serverConfigMap.get(target);
        if (serverConfig != null) {
            Map<String, DeployedItemRefConfig> deployedItemRefConfigMap = serverConfig.getDeployedItemRefConfigMap();
            for (DeployedItemRefConfig deployedItemRefConfig : deployedItemRefConfigMap.values()) {
                J2EEApplicationConfig app = this.mDomainConfig.getJ2EEApplicationConfigMap().get(deployedItemRefConfig.getName());
                if (app == null || !app.getObjectType().equals("user")) continue;
                deployedItemRefConfig.setLBEnabled(true);
            }
        }
    }

    boolean isCluster(String name) {
        Map<String, ClusterConfig> cConfigMap = this.mDomainConfig.getClusterConfigMap();
        if (cConfigMap == null) {
            return false;
        }
        ClusterConfig cConfig = cConfigMap.get(name);
        return cConfig != null;
    }

    boolean isStandaloneServer(String name) {
        Map<String, StandaloneServerConfig> ssConfigMap = this.mDomainConfig.getStandaloneServerConfigMap();
        if (ssConfigMap == null) {
            return false;
        }
        StandaloneServerConfig ssConfig = ssConfigMap.get(name);
        return ssConfig != null;
    }

    private void setServerStatus(String target, int timeout, boolean status) {
        if (timeout < 0 && !status) {
            String msg = this.resBundle.getString("InvalidNumber");
            throw new IllegalArgumentException(msg);
        }
        try {
            if (this.isCluster(target)) {
                ClusterConfig cRef = this.mDomainConfig.getClusterConfigMap().get(target);
                if (cRef == null) {
                    this.mLogger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                    String msg = this.formatter.format(this.resBundle.getString("ServerNotDefined"), target);
                    throw new MBeanException(new RuntimeException(msg));
                }
                for (ServerRefConfig sRef : cRef.getServerRefConfigMap().values()) {
                    this.setLBEnabled(sRef, status, timeout, target);
                }
            } else {
                ServerRefConfig sRef = null;
                boolean foundTarget = false;
                Map<String, LBConfig> lbConfigs = this.mDomainConfig.getLBConfigMap();
                for (LBConfig lbConfig : lbConfigs.values()) {
                    Map<String, ServerRefConfig> serverRefs = lbConfig.getServerRefConfigMap();
                    sRef = serverRefs.get(target);
                    if (sRef == null) {
                        this.mLogger.log(Level.FINEST, " server " + target + " does not exist in " + serverRefs);
                        continue;
                    }
                    foundTarget = true;
                    break;
                }
                if (!foundTarget && (sRef = this.getServerRefConfigFromCluster(target)) == null) {
                    this.mLogger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                    String msg = this.formatter.format(this.resBundle.getString("ServerNotDefined"), target);
                    throw new MBeanException(new RuntimeException(msg));
                }
                this.setLBEnabled(sRef, status, timeout, target);
            }
        }
        catch (Exception ce) {
            ce.printStackTrace();
            throw new RuntimeException(ce);
        }
    }

    private void setLBEnabled(ServerRefConfig sRef, boolean status, int timeout, String target) throws MBeanException {
        int curTout = sRef.getDisableTimeoutInMinutes();
        boolean enabled = sRef.getLBEnabled();
        if (!status) {
            if (!enabled && curTout == timeout) {
                String msg = this.formatter.format(this.resBundle.getString("ServerDisabled"), sRef.getRef());
                throw new MBeanException(new Exception(msg));
            }
            sRef.setDisableTimeoutInMinutes(timeout);
            sRef.setLBEnabled(false);
            this.mLogger.log(Level.INFO, this.formatter.format(this.resBundle.getString("http_lb_admin.ServerDisabled"), target));
        } else {
            if (enabled) {
                String msg = this.formatter.format(this.resBundle.getString("ServerEnabled"), sRef.getRef());
                throw new MBeanException(new Exception("ServerEnabled"));
            }
            sRef.setLBEnabled(true);
            this.mLogger.log(Level.INFO, this.formatter.format(this.resBundle.getString("http_lb_admin.ServerEnabled"), target));
        }
    }

    private void setApplicationStatus(String target, String appName, int timeout, boolean status) {
        if (timeout < 0 && !status) {
            String msg = this.resBundle.getString("InvalidNumber");
            throw new IllegalArgumentException(msg);
        }
        try {
            String msg;
            DeployedItemRefConfig dRef = null;
            if (this.isCluster(target)) {
                Map<String, ClusterConfig> clusterConfigs = this.mDomainConfig.getClusterConfigMap();
                ClusterConfig clusterConfig = clusterConfigs.get(target);
                dRef = clusterConfig.getDeployedItemRefConfigMap().get(appName);
            } else {
                Map<String, StandaloneServerConfig> ssConfigMap = this.mDomainConfig.getStandaloneServerConfigMap();
                StandaloneServerConfig ssc = ssConfigMap.get(target);
                if (ssc == null) {
                    ClusteredServerConfig s = this.mDomainConfig.getClusteredServerConfigMap().get(target);
                    dRef = s.getDeployedItemRefConfigMap().get(appName);
                } else {
                    dRef = ssc.getDeployedItemRefConfigMap().get(appName);
                }
            }
            if (dRef == null) {
                this.mLogger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                String msg2 = this.formatter.format(this.resBundle.getString("AppRefNotDefined"), target);
                throw new MBeanException(new RuntimeException(msg2));
            }
            int curTout = Integer.parseInt(dRef.getDisableTimeoutInMinutes());
            boolean enabled = dRef.getLBEnabled();
            if (!status) {
                if (!enabled && curTout == timeout) {
                    msg = this.resBundle.getString("AppDisabledOnServer");
                    throw new MBeanException(new Exception(msg));
                }
                dRef.setDisableTimeoutInMinutes("" + timeout);
                dRef.setLBEnabled(false);
                this.mLogger.log(Level.INFO, this.resBundle.getString("http_lb_admin.ApplicationDisabled"));
            } else {
                if (enabled) {
                    msg = this.resBundle.getString("AppEnabledOnServer");
                    throw new MBeanException(new Exception(msg));
                }
                dRef.setLBEnabled(true);
                this.mLogger.log(Level.INFO, this.resBundle.getString("http_lb_admin.ApplicationEnabled"));
            }
        }
        catch (Exception ce) {
            throw new RuntimeException(ce);
        }
    }

    private ServerRefConfig getServerRefConfigFromCluster(String target) throws MBeanException {
        Map<String, LBConfig> lbConfigs = this.mDomainConfig.getLBConfigMap();
        for (LBConfig lbConfig : lbConfigs.values()) {
            Map<String, ClusterRefConfig> clusterRefs = lbConfig.getClusterRefConfigMap();
            for (ClusterRefConfig clusterRef : clusterRefs.values()) {
                String clusterName = clusterRef.getReferencedClusterName();
                Map<String, ClusterConfig> clusterConfigs = this.mDomainConfig.getClusterConfigMap();
                ClusterConfig config = clusterConfigs.get(clusterName);
                Map<String, ServerRefConfig> serverRefConfigs = config.getServerRefConfigMap();
                for (ServerRefConfig serverRefConfig : serverRefConfigs.values()) {
                    if (!serverRefConfig.getName().equals(target)) continue;
                    return serverRefConfig;
                }
            }
        }
        return null;
    }

    public Map<String, LoadBalancerServerMonitor> getInstanceMonitors(String targetLoadBalancer, String target, boolean allTargets) {
        HashMap<String, LoadBalancerServerMonitor> loadBalancerServerMonitorMap = new HashMap<String, LoadBalancerServerMonitor>();
        MonitoringRoot mRoot = this.mDomainRoot.getMonitoringRoot();
        Map<String, LoadBalancerMonitor> loadBalancerMonitorMap = mRoot.getLoadBalancerMonitorMap();
        LoadBalancerMonitor loadBalancerMonitor = loadBalancerMonitorMap.get(targetLoadBalancer);
        Map<String, LoadBalancerClusterMonitor> loadBalancerClusterMonitorMap = loadBalancerMonitor.getLoadBalancerClusterMonitorMap();
        if (!allTargets) {
            LoadBalancerClusterMonitor loadBalancerClusterMonitor = loadBalancerClusterMonitorMap.get(target);
            this.populateLoadBalancerServerMonitorMap(target, loadBalancerServerMonitorMap, loadBalancerClusterMonitor);
        } else {
            for (String clusterName : loadBalancerClusterMonitorMap.keySet()) {
                LoadBalancerClusterMonitor loadBalancerClusterMonitor = loadBalancerClusterMonitorMap.get(clusterName);
                this.populateLoadBalancerServerMonitorMap(target, loadBalancerServerMonitorMap, loadBalancerClusterMonitor);
            }
        }
        return loadBalancerServerMonitorMap;
    }

    public Map<String, LoadBalancerServerMonitor> getInstanceAggregateStats(String serverName) {
        Collection<LoadBalancerConfig> loadBalancers = this.getLoadBalancers(serverName, false).values();
        HashMap<String, LoadBalancerServerMonitor> loadBalancerServerMonitorMap = new HashMap<String, LoadBalancerServerMonitor>();
        MonitoringRoot mRoot = this.mDomainRoot.getMonitoringRoot();
        Map<String, LoadBalancerMonitor> loadBalancerMonitorMap = mRoot.getLoadBalancerMonitorMap();
        for (LoadBalancerConfig loadBalancer : loadBalancers) {
            String targetLoadBalancer = loadBalancer.getName();
            LoadBalancerMonitor loadBalancerMonitor = loadBalancerMonitorMap.get(targetLoadBalancer);
            Map<String, LoadBalancerClusterMonitor> loadBalancerClusterMonitorMap = loadBalancerMonitor.getLoadBalancerClusterMonitorMap();
            for (String clusterName : loadBalancerClusterMonitorMap.keySet()) {
                LoadBalancerClusterMonitor loadBalancerClusterMonitor = loadBalancerClusterMonitorMap.get(clusterName);
                LoadBalancerServerMonitor loadBalancerServerMonitor = loadBalancerClusterMonitor.getLoadBalancerServerMonitorMap().get(serverName);
                loadBalancerServerMonitorMap.put(targetLoadBalancer, loadBalancerServerMonitor);
            }
        }
        return loadBalancerServerMonitorMap;
    }

    public Map<String, LoadBalancerConfig> getLoadBalancers(String targetName, boolean isCluster) {
        Map<String, LBConfig> lbConfigMap = this.fetchLBConfigs(targetName, isCluster);
        return this.fetchLoadBalancerConfigs(lbConfigMap);
    }

    private Map<String, LBConfig> fetchLBConfigs(String targetName, boolean isCluster) {
        HashMap<String, LBConfig> result = new HashMap<String, LBConfig>();
        Map<String, LBConfig> lbConfigMap = this.mDomainConfig.getLBConfigMap();
        if (isCluster) {
            block0: for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> lbClusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                for (String clusterRef : lbClusterRefConfigMap.keySet()) {
                    if (!clusterRef.equals(targetName)) continue;
                    result.put(lbConfigName, lbConfig);
                    continue block0;
                }
            }
        } else if (this.isStandaloneServer(targetName)) {
            block2: for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ServerRefConfig> lbServerRefConfigMap = lbConfig.getServerRefConfigMap();
                for (String serverRef : lbServerRefConfigMap.keySet()) {
                    if (!serverRef.equals(targetName)) continue;
                    result.put(lbConfigName, lbConfig);
                    continue block2;
                }
            }
        } else {
            for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> lbClusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                Map<String, ClusterConfig> clusterConfigMap = this.mDomainConfig.getClusterConfigMap();
                HashMap<String, ClusterConfig> relevantClusterConfigMap = new HashMap<String, ClusterConfig>();
                for (String clusterRef : lbClusterRefConfigMap.keySet()) {
                    relevantClusterConfigMap.put(clusterRef, clusterConfigMap.get(clusterRef));
                }
                block6: for (String clusterName : relevantClusterConfigMap.keySet()) {
                    ClusterConfig clusterConfig = (ClusterConfig)relevantClusterConfigMap.get(clusterName);
                    Map<String, ServerRefConfig> clusteredServerRefConfigMap = clusterConfig.getServerRefConfigMap();
                    for (String serverRef : clusteredServerRefConfigMap.keySet()) {
                        if (!serverRef.equals(targetName)) continue;
                        result.put(lbConfigName, lbConfig);
                        continue block6;
                    }
                }
            }
        }
        return result;
    }

    private Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(Map<String, LBConfig> lbConfigMap) {
        HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap<String, LoadBalancerConfig>();
        for (String lbConfigName : lbConfigMap.keySet()) {
            Map<String, LoadBalancerConfig> allLoadBalancerConfigMap = this.mDomainRoot.getDomainConfig().getLoadBalancerConfigMap();
            for (String loadBalancerName : allLoadBalancerConfigMap.keySet()) {
                LoadBalancerConfig loadBalancerConfig = allLoadBalancerConfigMap.get(loadBalancerName);
                if (!loadBalancerConfig.getLbConfigName().equals(lbConfigName)) continue;
                relevantLoadBalancerConfigMap.put(loadBalancerName, loadBalancerConfig);
            }
        }
        return relevantLoadBalancerConfigMap;
    }

    private void populateLoadBalancerServerMonitorMap(String target, Map<String, LoadBalancerServerMonitor> loadBalancerServerMonitorMap, LoadBalancerClusterMonitor loadBalancerClusterMonitor) {
        Map<String, LoadBalancerServerMonitor> tmpLoadBalancerServerMonitorMap = loadBalancerClusterMonitor.getLoadBalancerServerMonitorMap();
        for (String serverName : tmpLoadBalancerServerMonitorMap.keySet()) {
            LoadBalancerServerMonitor loadBalancerServerMonitor = tmpLoadBalancerServerMonitorMap.get(serverName);
            if (this.isStandaloneServer(serverName)) {
                loadBalancerServerMonitorMap.put(serverName, loadBalancerServerMonitor);
                continue;
            }
            loadBalancerServerMonitorMap.put(loadBalancerClusterMonitor.getName() + "." + target, loadBalancerServerMonitor);
        }
    }

    private LoadBalancer createLoadBalancer(String configName) {
        this.mDomainConfig.createLoadBalancerConfig(configName + LB_SUFFIX, configName, false, null);
        Map<String, LoadBalancer> lbs = this.mDomainRoot.getLoadBalancerMap();
        LoadBalancer lb = lbs.get(configName + LB_SUFFIX);
        return lb;
    }

    private Map<String, String> getParams(Map<String, String> options) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("https-routing", options.get(HTTPS_ROUTING));
        params.put("monitoring-enabled", options.get(MONITOR));
        params.put("reload-poll-interval-in-seconds", options.get(RELOAD_INTERVAL));
        params.put("response-timeout-in-seconds", options.get(RESPONSE_TIMEOUT));
        params.put("route-cookie-enabled", options.get(ROUTE_COOKIE));
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToFile(String lbxml, String filePath) {
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(filePath);
            fo.write(lbxml.getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                fo.close();
            }
            catch (IOException e) {}
        }
        return filePath;
    }
}

