/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.component.design.ComponentDesignAction;
import com.iplanet.jato.component.design.ComponentDesignContext;
import com.iplanet.jato.component.design.DesignActionException;
import com.iplanet.jato.component.design.objmodel.ConfigPropertyNode;
import com.iplanet.jato.component.design.objmodel.ConfigPropertyNodeContainer;
import com.iplanet.jato.component.design.objmodel.ExtensibleComponentNode;
import com.iplanet.jato.component.design.objmodel.command.CommandNode;
import com.iplanet.jato.component.design.objmodel.model.ModelNode;
import com.iplanet.jato.component.design.objmodel.view.ChildViewNode;
import com.iplanet.jato.component.design.objmodel.view.ContainerViewNode;
import com.iplanet.jato.component.design.objmodel.view.RootViewNode;
import java.io.IOException;

class ModelComponentDesignActionSupport
implements ComponentDesignAction {
    private long startEpoch = System.currentTimeMillis();
    private boolean showTimeTrace = true;
    private boolean showDebug = true;
    private ComponentDesignContext context;
    private String name;

    public String getName() {
        return this.name;
    }

    protected void setName(String value) {
        this.name = value;
    }

    public void performAction(ComponentDesignContext context) throws DesignActionException {
        this.setContext(context);
        if (!this.isModel()) {
            throw new DesignActionException("Object Model is not a Model");
        }
    }

    protected Object getConfigPropertyValue(String name) {
        if (null != this.getContext().getConfigPropertyContext()) {
            return this.getContext().getConfigPropertyContext().getPropertyValue(name);
        }
        return null;
    }

    protected boolean isExtensibleComponent() {
        return this.getContext().getObjectModel() instanceof ExtensibleComponentNode;
    }

    protected boolean isPrimaryObjectModel() {
        return this.getContext().getObjectModel() == this.getContext().getPrimaryObjectModel();
    }

    protected ModelNode getModelNode() {
        return (ModelNode)this.getContext().getObjectModel();
    }

    protected boolean isModel() {
        return this.getContext().getObjectModel() instanceof ModelNode;
    }

    protected boolean isChildView() {
        return this.getContext().getObjectModel() instanceof ChildViewNode;
    }

    protected boolean isRootView() {
        return this.getContext().getObjectModel() instanceof RootViewNode;
    }

    protected boolean isContainerView() {
        return this.getContext().getObjectModel() instanceof ContainerViewNode;
    }

    protected boolean isCommand() {
        return this.getContext().getObjectModel() instanceof CommandNode;
    }

    protected void debugContextInfo() {
        try {
            this.verboseDebug("EnvironmentInfo=" + this.getContext().getEnvironmentInfo());
            this.verboseDebug("ComponentLogicalName=" + this.getContext().getComponentLogicalName());
            this.verboseDebug("PrimaryComponentFile=" + this.getContext().getPrimaryComponentFile().getCanonicalPath());
            this.verboseDebug("WebInfDirectory=" + this.getContext().getWebInfDirectory().getCanonicalPath());
            this.debugConfigProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void debugConfigProperties() {
        if (!(this.getContext().getPrimaryObjectModel() instanceof ConfigPropertyNodeContainer)) {
            this.verboseDebug("cannot dump config properties because primary objmodel is not a ConfigPropertyContainer");
            return;
        }
        ConfigPropertyNode[] props = ((ConfigPropertyNodeContainer)this.getContext().getPrimaryObjectModel()).getConfigPropertyNode();
        if (null == props) {
            this.verboseDebug("null config properties");
            return;
        }
        if (props.length == 0) {
            this.verboseDebug("zero config properties");
            return;
        }
        int i = 0;
        while (i < props.length) {
            this.debugConfigProperty(props[i]);
            ++i;
        }
    }

    protected void debugConfigProperty(ConfigPropertyNode prop) {
        StringBuffer info = new StringBuffer();
        prop.dump(info, "  ");
        this.verboseDebug("\n" + info.toString());
    }

    public void debug(String msg) {
        if (!this.isShowDebug()) {
            return;
        }
        String trace = "";
        if (this.isShowTimeTrace()) {
            trace = " " + (System.currentTimeMillis() - this.startEpoch) + "ms";
        }
        this.getContext().getDebugLogWriter().println(trace + "," + msg);
    }

    public void verboseDebug(String msg) {
        if (!this.isShowDebug()) {
            return;
        }
        String trace = "";
        if (this.isShowTimeTrace()) {
            trace = " " + (System.currentTimeMillis() - this.startEpoch) + "ms";
        }
        this.getContext().getDebugLogWriter().println("DesignAction[" + this.getComponentName() + ":" + this.getName() + " {" + this.getContext().getComponentLogicalName() + "}" + trace + "]" + msg);
    }

    public void log(String msg) {
        String trace = "";
        if (this.isShowTimeTrace()) {
            trace = " " + (System.currentTimeMillis() - this.startEpoch) + "ms";
        }
        this.getContext().getDebugLogWriter().println(trace + "," + msg);
    }

    public void verboseLog(String msg) {
        String trace = "";
        if (this.isShowTimeTrace()) {
            trace = " " + (System.currentTimeMillis() - this.startEpoch) + "ms";
        }
        this.getContext().getDebugLogWriter().println("DesignAction[" + this.getComponentName() + ":" + this.getName() + " {" + this.getContext().getComponentLogicalName() + "}" + trace + "]" + msg);
    }

    public String getComponentName() {
        return this.getContext().getComponentInfo().getComponentDescriptor().getName();
    }

    protected void setContext(ComponentDesignContext context) {
        this.context = context;
    }

    public ComponentDesignContext getContext() {
        return this.context;
    }

    protected void setShowTimeTrace(boolean flag) {
        this.showTimeTrace = flag;
    }

    public boolean isShowTimeTrace() {
        return this.showTimeTrace;
    }

    protected void setShowDebug(boolean flag) {
        this.showDebug = flag;
    }

    public boolean isShowDebug() {
        return this.showDebug;
    }
}

