/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.command.Command;
import com.iplanet.jato.command.CommandDescriptor;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.command.CommandFactory;
import com.iplanet.jato.command.ExceptionCommandEvent;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.ModelFieldBinding;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.util.WrapperRuntimeException;
import com.iplanet.jato.view.BasicChoiceDisplayField;
import com.iplanet.jato.view.Choice;
import com.iplanet.jato.view.SimpleChoice;
import com.iplanet.jato.view.View;
import java.text.MessageFormat;
import java.util.ArrayList;

public class DataDrivenChoiceDisplayField
extends BasicChoiceDisplayField {
    public static final int CACHE_POLICY_MANUAL = 0;
    public static final int CACHE_POLICY_APPLICATION = 1;
    public static final int CACHE_POLICY_SESSION = 2;
    public static final int CACHE_POLICY_REQUEST = 3;
    public static final int CACHE_POLICY_MANUAL_NO_EXECUTE = 4;
    public static final int CACHE_POLICY_APPLICATION_NO_EXECUTE = 5;
    public static final int CACHE_POLICY_SESSION_NO_EXECUTE = 6;
    public static final int CACHE_POLICY_REQUEST_NO_EXECUTE = 7;
    private static final int FIRST_CACHE_POLICY_TYPE = 0;
    private static final int LAST_CACHE_POLICY_TYPE = 7;
    private static final int FIRST_EXECUTE_MODEL_POLICY_TYPE = 0;
    private static final int LAST_EXECUTE_MODEL_POLICY_TYPE = 3;
    protected static final String DEFAULT_CHOICES_ATTRIBUTE_PREFIX = "jato:";
    protected static final String DEFAULT_CHOICES_ATTRIBUTE_DELIMITER = "/";
    private ModelReference choicesModelReference;
    private ModelFieldBinding choicesValueBinding;
    private ModelFieldBinding[] choicesLabelBinding;
    private CommandDescriptor choicesExceptionHandler;
    private ModelExecutionContext choicesRetrievalExecutionContext;
    private String choicesLabelMessageFormat = null;
    private String cachedChoicesAttributeName = null;
    private int choicesCachePolicy = 3;
    static /* synthetic */ Class class$com$iplanet$jato$model$DatasetModel;
    static /* synthetic */ Class class$com$iplanet$jato$model$RetrievingModel;

    public DataDrivenChoiceDisplayField() {
    }

    public DataDrivenChoiceDisplayField(View parent, String name) {
        super(parent, name);
    }

    public ModelReference getChoicesModelReference() {
        return this.choicesModelReference;
    }

    public void setChoicesModelReference(ModelReference value) {
        this.choicesModelReference = value;
    }

    public ModelFieldBinding[] getChoicesLabelBinding() {
        return this.choicesLabelBinding;
    }

    public void setChoicesLabelBinding(ModelFieldBinding[] value) {
        this.choicesLabelBinding = value;
    }

    public ModelFieldBinding getChoicesValueBinding() {
        return this.choicesValueBinding;
    }

    public void setChoicesValueBinding(ModelFieldBinding value) {
        this.choicesValueBinding = value;
    }

    public Choice[] getChoices() {
        Choice[] choices = super.getChoices();
        if (choices != null || this.getChoicesCachePolicy() == 0 || this.getChoicesCachePolicy() == 4) {
            return choices;
        }
        choices = this.getCachedChoices();
        if (choices != null) {
            super.setChoices(choices);
        } else {
            try {
                this.retrieveChoices();
            }
            catch (ModelControlException e) {
                throw new WrapperRuntimeException("Exception getting choices", e);
            }
        }
        return super.getChoices();
    }

    public void setChoices(Choice[] value) {
        if (value != null) {
            this.setCachedChoices(value);
        } else {
            this.removeCachedChoices();
        }
        super.setChoices(value);
    }

    public String getChoicesLabelMessageFormat() {
        return this.choicesLabelMessageFormat;
    }

    public void setChoicesLabelMessageFormat(String value) {
        this.choicesLabelMessageFormat = value;
    }

    public int getChoicesCachePolicy() {
        return this.choicesCachePolicy;
    }

    public void setChoicesCachePolicy(int policy) {
        if (policy < 0 || policy > 7) {
            throw new IllegalArgumentException("Unrecognized choices retrieve policy (value = " + policy + ")");
        }
        this.choicesCachePolicy = policy;
    }

    public String getCachedChoicesAttributeName() {
        if (this.cachedChoicesAttributeName == null || this.cachedChoicesAttributeName.trim().length() == 0) {
            this.cachedChoicesAttributeName = this.generateCachedChoicesAttributeName();
        }
        return this.cachedChoicesAttributeName;
    }

    public void setCachedChoicesAttributeName(String name) {
        this.cachedChoicesAttributeName = name;
    }

    protected Choice[] getCachedChoices() {
        String attribute = this.getCachedChoicesAttributeName();
        if (attribute == null) {
            return null;
        }
        Choice[] result = null;
        switch (this.getChoicesCachePolicy()) {
            case 3: 
            case 7: {
                result = (Choice[])RequestManager.getRequestContext().getRequest().getAttribute(attribute);
                break;
            }
            case 2: 
            case 6: {
                result = (Choice[])RequestManager.getRequestContext().getRequest().getSession().getAttribute(attribute);
                break;
            }
            case 1: 
            case 5: {
                result = (Choice[])RequestManager.getRequestContext().getServletContext().getAttribute(attribute);
                break;
            }
        }
        return result;
    }

    protected void setCachedChoices(Choice[] choices) {
        String attribute = this.getCachedChoicesAttributeName();
        if (attribute == null || choices == null) {
            return;
        }
        switch (this.getChoicesCachePolicy()) {
            case 3: 
            case 7: {
                RequestManager.getRequestContext().getRequest().setAttribute(attribute, (Object)choices);
                break;
            }
            case 2: 
            case 6: {
                RequestManager.getRequestContext().getRequest().getSession().setAttribute(attribute, (Object)choices);
                break;
            }
            case 1: 
            case 5: {
                RequestManager.getRequestContext().getServletContext().setAttribute(attribute, (Object)choices);
                break;
            }
        }
    }

    protected void removeCachedChoices() {
        String attribute = this.getCachedChoicesAttributeName();
        if (attribute == null) {
            return;
        }
        switch (this.getChoicesCachePolicy()) {
            case 3: 
            case 7: {
                RequestManager.getRequestContext().getRequest().removeAttribute(attribute);
                break;
            }
            case 2: 
            case 6: {
                RequestManager.getRequestContext().getRequest().getSession().removeAttribute(attribute);
                break;
            }
            case 1: 
            case 5: {
                RequestManager.getRequestContext().getServletContext().removeAttribute(attribute);
                break;
            }
        }
    }

    public ModelExecutionContext getChoicesRetrievalExecutionContext() {
        return this.choicesRetrievalExecutionContext;
    }

    public void setChoicesRetrievalExecutionContext(ModelExecutionContext value) {
        this.choicesRetrievalExecutionContext = value;
    }

    protected void executeChoicesModel(Model model) throws ModelControlException {
        ((RetrievingModel)model).retrieve(this.getChoicesRetrievalExecutionContext());
    }

    public void retrieveChoices() throws ModelControlException {
        if (this.getChoicesModelReference() == null || this.getChoicesValueBinding() == null || this.getChoicesLabelBinding() == null || this.getChoicesLabelBinding().length == 0) {
            throw new UnsupportedOperationException("Component <" + this.getName() + "> " + " Choice configuration is incomplete. " + " Make sure required properties are all set to valid values");
        }
        Model m = this.getChoicesModelReference().getModel();
        if (!(m instanceof DatasetModel)) {
            throw new UnsupportedOperationException("Component <" + this.getName() + "> " + " Choice model must be of type " + (class$com$iplanet$jato$model$DatasetModel == null ? (class$com$iplanet$jato$model$DatasetModel = DataDrivenChoiceDisplayField.class$("com.iplanet.jato.model.DatasetModel")) : class$com$iplanet$jato$model$DatasetModel).getName());
        }
        try {
            if (this.getChoicesCachePolicy() >= 0 && this.getChoicesCachePolicy() <= 3) {
                if (!(m instanceof RetrievingModel)) {
                    throw new UnsupportedOperationException("Component <" + this.getName() + "> " + "Current choices cache policy requires this component to " + " be configured with a choice model of type " + (class$com$iplanet$jato$model$RetrievingModel == null ? (class$com$iplanet$jato$model$RetrievingModel = DataDrivenChoiceDisplayField.class$("com.iplanet.jato.model.RetrievingModel")) : class$com$iplanet$jato$model$RetrievingModel).getName());
                }
                this.executeChoicesModel(m);
            }
            ArrayList<SimpleChoice> items = new ArrayList<SimpleChoice>();
            DatasetModel model = (DatasetModel)m;
            model.beforeFirst();
            while (model.next()) {
                Object choiceValue = this.getChoicesValueBinding().getValue(this.getChoicesModelReference());
                String formattedLabel = "";
                ArrayList<String> labelList = new ArrayList<String>();
                int i = 0;
                while (i < this.getChoicesLabelBinding().length) {
                    labelList.add(TypeConverter.asString(this.getChoicesLabelBinding()[i].getValue(this.getChoicesModelReference())));
                    ++i;
                }
                if (this.getChoicesLabelMessageFormat() != null && this.getChoicesLabelMessageFormat().length() > 0) {
                    formattedLabel = MessageFormat.format(this.getChoicesLabelMessageFormat(), labelList.toArray(new String[labelList.size()]));
                } else {
                    StringBuffer buffer = new StringBuffer();
                    int i2 = 0;
                    while (i2 < labelList.size()) {
                        buffer.append((String)labelList.get(i2));
                        ++i2;
                    }
                    formattedLabel = buffer.toString();
                }
                items.add(new SimpleChoice(formattedLabel, choiceValue));
            }
            model.beforeFirst();
            this.setChoices(items.toArray(new Choice[items.size()]));
        }
        catch (ModelControlException e) {
            this.onRetrieveChoicesException(e);
        }
        catch (RuntimeException e) {
            this.onRetrieveChoicesException(e);
        }
    }

    public CommandDescriptor getRetrieveChoicesExceptionHandler() {
        return this.choicesExceptionHandler;
    }

    public void setRetrieveChoicesExceptionHandler(CommandDescriptor value) {
        this.choicesExceptionHandler = value;
    }

    protected void onRetrieveChoicesException(Exception exception) throws ModelControlException {
        CommandDescriptor descriptor = this.getRetrieveChoicesExceptionHandler();
        if (descriptor != null) {
            Command command = descriptor.getCommand();
            if (command == null) {
                command = CommandFactory.getCommand(descriptor.getCommandClass());
            }
            if (command != null) {
                try {
                    command.execute(new ExceptionCommandEvent(this, RequestManager.getRequestContext(), descriptor.getOperationName(), descriptor.getParameters(), exception));
                }
                catch (CommandException e) {
                    throw new WrapperRuntimeException("Exception executingchoice retrieval exception handler", e, new Throwable[]{exception});
                }
                return;
            }
        }
        if (exception instanceof ModelControlException) {
            throw (ModelControlException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
    }

    protected String generateCachedChoicesAttributeName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(DEFAULT_CHOICES_ATTRIBUTE_PREFIX);
        buffer.append(this.getParent().getClass().getName());
        buffer.append(DEFAULT_CHOICES_ATTRIBUTE_DELIMITER);
        buffer.append(this.getName());
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CACHE_POLICY_MANUAL = 0;
        CACHE_POLICY_APPLICATION = 1;
        CACHE_POLICY_SESSION = 2;
        CACHE_POLICY_REQUEST = 3;
        CACHE_POLICY_MANUAL_NO_EXECUTE = 4;
        CACHE_POLICY_APPLICATION_NO_EXECUTE = 5;
        CACHE_POLICY_SESSION_NO_EXECUTE = 6;
        CACHE_POLICY_REQUEST_NO_EXECUTE = 7;
        FIRST_CACHE_POLICY_TYPE = 0;
        LAST_CACHE_POLICY_TYPE = 7;
        FIRST_EXECUTE_MODEL_POLICY_TYPE = 0;
        LAST_EXECUTE_MODEL_POLICY_TYPE = 3;
        DEFAULT_CHOICES_ATTRIBUTE_PREFIX = DEFAULT_CHOICES_ATTRIBUTE_PREFIX;
        DEFAULT_CHOICES_ATTRIBUTE_DELIMITER = DEFAULT_CHOICES_ATTRIBUTE_DELIMITER;
    }
}

