/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.naming;

import com.sun.appserv.naming.GroupInfoServiceObserverImpl;
import com.sun.appserv.naming.RoundRobinPolicy;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.util.ORBManager;
import com.sun.jndi.cosnaming.CNCtxFactory;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;

public class S1ASCtxFactory
extends CNCtxFactory {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static RoundRobinPolicy rrPolicy = null;
    private static final String IIOP_URL = "iiop:1.2@";
    private static final String CORBALOC = "corbaloc:";
    public static final String LOAD_BALANCING_PROPERTY = "com.sun.appserv.iiop.loadbalancingpolicy";
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    private Hashtable defaultEnv;
    private static GroupInfoService gis;
    public static final String IC_BASED_WEIGHTED = "ic-based-weighted";
    public static final String IC_BASED = "ic-based";

    public S1ASCtxFactory() {
        this.defaultEnv = new Hashtable();
    }

    public S1ASCtxFactory(Hashtable env) {
        this.defaultEnv = env;
    }

    public static RoundRobinPolicy getRRPolicy() {
        return rrPolicy;
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        String[] temp_list;
        String policy = null;
        if (SerialContext.getSticky() != null) {
            Context ctx = SerialContext.getStickyContext();
            return ctx;
        }
        if (env == null) {
            env = this.defaultEnv;
        }
        String propertyValue = (String)env.get(LOAD_BALANCING_PROPERTY);
        String[] commaDelimitedValues = null;
        String host = null;
        String port = null;
        if (propertyValue != null) {
            commaDelimitedValues = propertyValue.split(",");
            if (commaDelimitedValues != null && (commaDelimitedValues[0].trim().equals(IC_BASED) || commaDelimitedValues[0].trim().equals(IC_BASED_WEIGHTED))) {
                policy = commaDelimitedValues[0];
            }
            if (policy != null) {
                System.setProperty(LOAD_BALANCING_PROPERTY, policy);
            }
        }
        String[] stringArray = temp_list = (propertyValue = (String)env.get(IIOP_ENDPOINTS_PROPERTY)) == null || propertyValue.length() == 0 ? null : propertyValue.split(",");
        if ((temp_list == null || temp_list.length == 0) && commaDelimitedValues != null) {
            temp_list = new String[commaDelimitedValues.length - 1];
            for (int i = 0; i < temp_list.length; ++i) {
                temp_list[i] = commaDelimitedValues[i + 1];
            }
        }
        if (System.getProperty(IIOP_ENDPOINTS_PROPERTY) == null && (temp_list == null || temp_list.length == 0)) {
            if (env.get("java.naming.provider.url") != null) {
                temp_list = rrPolicy.getEndpointForProviderURL((String)env.get("java.naming.provider.url"));
            }
            if (temp_list == null || temp_list.length == 0) {
                if (env.get("org.omg.CORBA.ORBInitialHost") != null && env.get("org.omg.CORBA.ORBInitialPort") != null) {
                    host = (String)env.get("org.omg.CORBA.ORBInitialHost");
                    port = (String)env.get("org.omg.CORBA.ORBInitialPort");
                } else {
                    host = System.getProperty("org.omg.CORBA.ORBInitialHost");
                    port = System.getProperty("org.omg.CORBA.ORBInitialPort");
                }
                if (host != null && port != null) {
                    temp_list = rrPolicy.getAddressPortList(host, port);
                    _logger.log(Level.WARNING, "no.endpoints.selected", new Object[]{host, port});
                } else {
                    _logger.log(Level.SEVERE, "no.endpoints");
                    throw new RuntimeException("Cannot Proceed. No Endpoints specified.");
                }
            }
        }
        if (temp_list != null && temp_list.length > 0) {
            rrPolicy.setClusterInstanceInfo(temp_list);
        }
        Object[] list = rrPolicy.getNextRotation();
        if (_logger.isLoggable(Level.FINE)) {
            rrPolicy.print();
        }
        String corbalocURL = "";
        for (int i = 0; i < list.length; ++i) {
            _logger.fine("list[i] ==> " + list[i]);
            corbalocURL = corbalocURL.equals("") ? IIOP_URL + ((String)list[i]).trim() : corbalocURL + "," + IIOP_URL + ((String)list[i]).trim();
        }
        _logger.fine("corbaloc url ==> " + corbalocURL);
        env.put("com.sun.appserv.ee.iiop.endpointslist", CORBALOC + corbalocURL);
        env.put("java.naming.corba.orb", ORBManager.getORB());
        return new SerialContext(env);
    }

    static {
        String[] list = null;
        String[] commaDelimitedValues = null;
        String policy = null;
        String propertyValue = System.getProperty(LOAD_BALANCING_PROPERTY);
        if (propertyValue != null) {
            commaDelimitedValues = propertyValue.split(",");
            if (commaDelimitedValues != null && (commaDelimitedValues[0].trim().equals(IC_BASED) || commaDelimitedValues[0].trim().equals(IC_BASED_WEIGHTED))) {
                policy = commaDelimitedValues[0];
            }
            if (policy != null) {
                System.setProperty(LOAD_BALANCING_PROPERTY, policy);
            }
        }
        if ((list = (propertyValue = System.getProperty(IIOP_ENDPOINTS_PROPERTY)) == null || propertyValue.length() == 0 ? null : propertyValue.split(",")) == null && commaDelimitedValues != null && commaDelimitedValues.length > 1) {
            list = new String[commaDelimitedValues.length - 1];
            for (int i = 0; i < list.length; ++i) {
                list[i] = commaDelimitedValues[i + 1];
            }
        }
        rrPolicy = new RoundRobinPolicy(list);
        try {
            String[] services;
            for (String str : services = ORBManager.getORB().list_initial_services()) {
                if (!str.equals("FolbClientGroupInfoService")) continue;
                gis = (GroupInfoService)ORBManager.getORB().resolve_initial_references("FolbClientGroupInfoService");
                gis.addObserver(new GroupInfoServiceObserverImpl(gis));
                break;
            }
            if (gis == null) {
                _logger.fine("GroupInfoService not available. This is PE");
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "groupinfoservice.lookup.problem", new Object[]{e.getMessage()});
        }
    }
}

