/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.threadpool.TimeoutException;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.ee.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ThreadPoolImpl
implements ThreadPool {
    private static int threadCounter = 0;
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.transport");
    private WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private int minWorkerThreads = 0;
    private int maxWorkerThreads = 0;
    private long inactivityTimeout = 120000L;
    private boolean boundedThreadPool = false;
    private long processedCount = 1L;
    private long totalTimeTaken = 0L;
    private Object lock = new Object();
    private String name;
    private MonitoredObject threadpoolMonitoredObject;
    private final ThreadGroup threadGroup;

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = tg;
        this.name = threadpoolName;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this.inactivityTimeout = timeout;
        this.minWorkerThreads = minSize;
        this.maxWorkerThreads = maxSize;
        this.boundedThreadPool = true;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = Thread.currentThread().getThreadGroup();
        this.name = threadpoolName;
        for (int i = 0; i < this.minWorkerThreads; ++i) {
            this.createWorkerThread();
        }
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        MonitoredObject root = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject threadPoolMonitoringObjectRoot = root.getChild("threadpool");
        if (threadPoolMonitoringObjectRoot == null) {
            threadPoolMonitoringObjectRoot = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            root.addChild(threadPoolMonitoringObjectRoot);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        threadPoolMonitoringObjectRoot.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentNumberOfThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfAvailableThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfBusyThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b3);
        LongMonitoredAttributeBase b4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.averageWorkCompletionTime());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b4);
        LongMonitoredAttributeBase b5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentProcessedCount());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyForAvailableWork(WorkQueue aWorkQueue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.availableWorkerThreads == 0) {
                this.createWorkerThread();
            } else {
                aWorkQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createWorkerThread() {
        Object object = this.lock;
        synchronized (object) {
            final String name = this.getName();
            if (this.boundedThreadPool) {
                if (this.currentThreadCount >= this.maxWorkerThreads) return;
                ++this.currentThreadCount;
            } else {
                ++this.currentThreadCount;
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WorkerThread thread = new WorkerThread(ThreadPoolImpl.this.threadGroup, name);
                    thread.setDaemon(true);
                    wrapper.workerThreadCreated(thread, thread.getContextClassLoader());
                    thread.start();
                    return null;
                }
            });
            return;
        }
    }

    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int currentNumberOfThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfAvailableThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfBusyThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount - this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long averageWorkCompletionTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalTimeTaken / this.processedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long currentProcessedCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.processedCount;
        }
    }

    public String getName() {
        return this.name;
    }

    public int numberOfWorkQueues() {
        return 1;
    }

    private static synchronized int getUniqueThreadId() {
        return threadCounter++;
    }

    private class WorkerThread
    extends Thread {
        private ClassLoader workerThreadClassLoader;
        private Work currentWork;
        private int threadId;
        private String threadPoolName;
        private StringBuffer workerThreadName;

        private void setClassLoader() {
            ClassLoader oldClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread thr = Thread.currentThread();
                    ClassLoader result = thr.getContextClassLoader();
                    thr.setContextClassLoader(WorkerThread.this.workerThreadClassLoader);
                    return result;
                }
            });
            wrapper.workerThreadDone(Thread.currentThread(), oldClassLoader, this.workerThreadClassLoader);
        }

        WorkerThread(ThreadGroup tg, String threadPoolName) {
            super(tg, "Idle");
            this.threadId = 0;
            this.workerThreadName = new StringBuffer();
            this.threadId = ThreadPoolImpl.getUniqueThreadId();
            this.threadPoolName = threadPoolName;
            this.setName(this.composeWorkerThreadName(threadPoolName, "Idle"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WorkerThread.this.workerThreadClassLoader = Thread.currentThread().getContextClassLoader();
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                try {
                    while (true) {
                        Object object2 = ThreadPoolImpl.this.lock;
                        synchronized (object2) {
                            ThreadPoolImpl.this.availableWorkerThreads++;
                        }
                        this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                        object2 = ThreadPoolImpl.this.lock;
                        synchronized (object2) {
                            ThreadPoolImpl.this.availableWorkerThreads--;
                            if (ThreadPoolImpl.this.availableWorkerThreads == 0 && ThreadPoolImpl.this.workQueue.workItemsInQueue() > 0) {
                                ThreadPoolImpl.this.createWorkerThread();
                            }
                        }
                        this.setName(this.composeWorkerThreadName(this.threadPoolName, Integer.toString(this.threadId)));
                        long start = System.currentTimeMillis();
                        try {
                            this.currentWork.doWork();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        long end = System.currentTimeMillis();
                        Object object3 = ThreadPoolImpl.this.lock;
                        synchronized (object3) {
                            ThreadPoolImpl.this.totalTimeTaken += end - start;
                            ThreadPoolImpl.this.processedCount++;
                        }
                        this.currentWork = null;
                        this.setClassLoader();
                        this.setName(this.composeWorkerThreadName(this.threadPoolName, "Idle"));
                    }
                }
                catch (TimeoutException e) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                        if (ThreadPoolImpl.this.currentThreadCount > ThreadPoolImpl.this.minWorkerThreads) {
                            ThreadPoolImpl.this.currentThreadCount--;
                            return;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                    }
                }
                catch (Throwable e) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                    }
                }
            }
        }

        private String composeWorkerThreadName(String poolName, String workerName) {
            this.workerThreadName.setLength(0);
            this.workerThreadName.append("p: ").append(poolName);
            this.workerThreadName.append("; w: ").append(workerName);
            return this.workerThreadName.toString();
        }
    }
}

