/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.EventHandler;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import java.nio.channels.SelectionKey;
import org.omg.CORBA.INTERNAL;

public abstract class EventHandlerBase
implements EventHandler {
    protected ORB orb;
    protected Work work;
    protected boolean useWorkerThreadForEvent;
    protected boolean useSelectThreadToWait;
    protected SelectionKey selectionKey;

    public void setUseSelectThreadToWait(boolean x) {
        this.useSelectThreadToWait = x;
    }

    public boolean shouldUseSelectThreadToWait() {
        return this.useSelectThreadToWait;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public void handleEvent() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent->: " + this);
        }
        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & ~this.getInterestOps());
        if (this.shouldUseWorkerThreadForEvent()) {
            Exception throwable = null;
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: addWork to pool: 0");
                }
                this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(this.getWork());
            }
            catch (NoSuchThreadPoolException e) {
                throwable = e;
            }
            catch (NoSuchWorkQueueException e) {
                throwable = e;
            }
            if (throwable != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: " + throwable);
                }
                INTERNAL i = new INTERNAL("NoSuchThreadPoolException");
                i.initCause((Throwable)throwable);
                throw i;
            }
        } else {
            if (this.orb.transportDebugFlag) {
                this.dprint(".handleEvent: doWork");
            }
            this.getWork().doWork();
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent<-: " + this);
        }
    }

    public boolean shouldUseWorkerThreadForEvent() {
        return this.useWorkerThreadForEvent;
    }

    public void setUseWorkerThreadForEvent(boolean x) {
        this.useWorkerThreadForEvent = x;
    }

    public void setWork(Work work) {
        this.work = work;
    }

    public Work getWork() {
        return this.work;
    }

    private void dprint(String msg) {
        ORBUtility.dprint("EventHandlerBase", msg);
    }
}

