/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb;

import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.containers.util.cache.PassivatedSessionCache;
import com.sun.ejb.spi.monitorable.sfsb.MonitorableSFSBStore;
import com.sun.ejb.spi.sfsb.SFSBBeanState;
import com.sun.ejb.spi.sfsb.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.SFSBStoreManagerException;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFileStoreManager
implements SFSBStoreManager,
MonitorableSFSBStore,
CacheListener {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected File baseDir;
    protected String storeManagerName;
    protected int passivationTimeoutInSeconds;
    private int loadCount;
    private int loadSuccessCount;
    private int loadErrorCount;
    private int storeCount;
    private int storeSuccessCount;
    private int storeErrorCount;
    private int expiredSessionCount;
    private boolean shutdown;
    private PassivatedSessionCache passivatedSessions;
    private Level TRACE_LEVEL = Level.FINE;
    private ClassLoader classLoader;

    public void initSessionStore(Map storeEnv) {
        String baseDirName = (String)storeEnv.get("com.sun.ejb.spi.sfsb.passivation.directory.name");
        if (baseDirName == null) {
            baseDirName = ".";
        }
        this.baseDir = new File(baseDirName);
        this.storeManagerName = (String)storeEnv.get("com.sun.ejb.spi.sfsb.store.manager.name");
        this.classLoader = (ClassLoader)storeEnv.get("com.sun.ejb.spi.sfsb.classloader");
        try {
            Integer sessionTimeout = (Integer)storeEnv.get("com.sun.ejb.spi.sfsb.session.timeout.in.seconds");
            this.passivationTimeoutInSeconds = sessionTimeout;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (!this.baseDir.mkdirs() && !this.baseDir.isDirectory()) {
                _logger.log(Level.WARNING, "ejb.sfsb_storemgr_mdirs_failed", new Object[]{baseDirName});
            }
            this.passivatedSessions = new PassivatedSessionCache(this.passivationTimeoutInSeconds * 1000);
            this.passivatedSessions.init(8192, null);
            this.passivatedSessions.addCacheListener(this);
            this.onInitialization();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_init_failed", new Object[]{baseDirName});
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_init_exception", ex);
        }
    }

    protected void onInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SFSBBeanState getState(Object sessionKey) {
        String fileName = sessionKey.toString();
        SFSBBeanState beanState = null;
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBStore] Attempting to load session: " + sessionKey);
        }
        if (this.passivatedSessions.remove(fileName) == null) {
            if (!_logger.isLoggable(this.TRACE_LEVEL)) return null;
            _logger.log(this.TRACE_LEVEL, "[SFSBStore] Could not find state for session: " + sessionKey);
            return null;
        }
        File file = new File(this.baseDir, fileName);
        if (file.exists()) {
            int dataSize = (int)file.length();
            byte[] data = new byte[dataSize];
            BufferedInputStream bis = null;
            FileInputStream fis = null;
            try {
                int count;
                ++this.loadCount;
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                int offset = 0;
                for (int toRead = dataSize; toRead > 0; toRead -= count) {
                    count = bis.read(data, offset, toRead);
                    offset += count;
                }
                beanState = new SFSBBeanState(sessionKey, -1L, false, data);
                ++this.loadSuccessCount;
                if (!_logger.isLoggable(this.TRACE_LEVEL)) return beanState;
                _logger.log(this.TRACE_LEVEL, "[SFSBStore] Successfully Loaded session: " + sessionKey);
                return beanState;
            }
            catch (Exception ex) {
                ++this.loadErrorCount;
                _logger.log(Level.WARNING, "ejb.sfsb_storemgr_loadstate_failed", new Object[]{fileName});
                _logger.log(Level.WARNING, "ejb.sfsb_storemgr_loadstate_exception", ex);
                this.remove(sessionKey);
                return beanState;
            }
            finally {
                try {
                    bis.close();
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Error while closing buffered input stream", ex);
                }
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Error while closing file input stream", ex);
                }
            }
        }
        if (!_logger.isLoggable(this.TRACE_LEVEL)) return beanState;
        _logger.log(this.TRACE_LEVEL, "[SFSBStore] Could not find passivated file for: " + sessionKey);
        return beanState;
    }

    public void checkpointSave(SFSBBeanState[] beanStates, boolean transactionFlag) {
    }

    public void passivateSave(SFSBBeanState beanState) {
        this.saveState(beanState, true);
    }

    public void remove(Object sessionKey) {
        try {
            this.passivatedSessions.remove(sessionKey);
            this.removeFile(new File(this.baseDir, sessionKey.toString()));
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removestate_failed", new Object[]{sessionKey.toString()});
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removestate_exception", ex);
        }
    }

    public void removeExpired() {
        if (this.shutdown) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBStore] Server is being shutdown hence method cannot be executed");
            }
            return;
        }
        this.passivatedSessions.trimExpiredEntries(Integer.MAX_VALUE);
    }

    public void removeAll() {
        try {
            String[] fileNames = this.baseDir.list();
            for (int i = 0; i < fileNames.length; ++i) {
                this.remove(fileNames[i]);
            }
            if (!this.baseDir.delete()) {
                Object[] params = new Object[]{this.baseDir.getAbsolutePath()};
                _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removedir_failed", params);
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removeall_exception", th);
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public MonitorableSFSBStore getMonitorableSFSBStore() {
        return this;
    }

    public int getCurrentSize() {
        return this.passivatedSessions.getEntryCount();
    }

    public int getLoadCount() {
        return this.loadCount;
    }

    public int getLoadSuccessCount() {
        return this.loadSuccessCount;
    }

    public int getLoadErrorCount() {
        return this.loadErrorCount;
    }

    public int getPassivationCount() {
        return this.storeCount;
    }

    public int getPassivationSuccessCount() {
        return this.storeSuccessCount;
    }

    public int getPassivationErrorCount() {
        return this.storeErrorCount;
    }

    public int getCheckpointCount() {
        return this.storeCount;
    }

    public int getCheckpointSuccessCount() {
        return this.storeSuccessCount;
    }

    public int getCheckpointErrorCount() {
        return this.storeErrorCount;
    }

    public int getExpiredSessionCount() {
        return this.expiredSessionCount;
    }

    private void saveState(SFSBBeanState beanState, boolean isPassivated) {
        Object sessionKey = beanState.getId();
        String fileName = sessionKey.toString();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBStore] Attempting to save session: " + sessionKey);
        }
        File file = null;
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            ++this.storeCount;
            file = new File(this.baseDir, fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            byte[] data = beanState.getState();
            ((BufferedOutputStream)bos).write(data, 0, data.length);
            ++this.storeSuccessCount;
            if (isPassivated) {
                this.passivatedSessions.put(fileName, new Long(beanState.getLastAccess()));
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    _logger.log(this.TRACE_LEVEL, "[SFSBStore] Successfully saved session: " + sessionKey);
                }
            }
        }
        catch (Exception ex) {
            ++this.storeErrorCount;
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_savestate_failed", new Object[]{fileName});
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_savestate_exception", ex);
            try {
                this.removeFile(file);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            String errMsg = "Could not save session: " + beanState.getId();
            throw new SFSBStoreManagerException(errMsg, ex);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Error while closing buffered output stream", ex);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Error while closing file output stream", ex);
            }
        }
    }

    private void removeFile(File file) {
        final File localFile = file;
        Boolean temp = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(localFile.delete());
            }
        });
        boolean success = temp;
        if (!success) {
            _logger.log(Level.WARNING, "ejb.sfsb_storemgr_removestate_failed", new Object[]{file.getName()});
        } else if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBStore] Removed session: " + file.getName());
        }
    }

    protected void addPassivatedSession(String fileName, long lastAccessTime) {
        this.passivatedSessions.add(fileName, new Long(lastAccessTime));
    }

    public void trimEvent(Object sessionKey, Object lastAccessedAt) {
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBStore] Removing expired session: " + sessionKey);
        }
        this.remove(sessionKey);
        ++this.expiredSessionCount;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

