/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import sun.rmi.rmic.IndentingWriter;

public class WrapperGenerator
extends Generator {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WrapperGenerator.class);
    private static Logger _logger = null;
    public static final String REMOTE_SUFFIX = "_EJBObjectImpl";
    public static final String LOCAL_SUFFIX = "_EJBLocalObjectImpl";
    private Class bean;
    private Class componentInterface;
    private Method[] bizMethods;
    private String wrapperBase;
    private String wrapperImpl;
    private EjbDescriptor dd;
    private boolean isLocal;

    public String getGeneratedClass() {
        String pname = this.getPackageName(this.bean.getName());
        if (pname != null) {
            return pname + "." + this.wrapperImpl;
        }
        return this.wrapperImpl;
    }

    public static String getDefaultEJBObjectImplClassName(EjbDescriptor desc) {
        return desc.getEjbImplClassName() + REMOTE_SUFFIX;
    }

    public WrapperGenerator(DeploymentContext context, EjbDescriptor dd, boolean isLocal, Vector existingClassNames) throws GeneratorException {
        String suffix;
        String compIntfName;
        this.dd = dd;
        this.isLocal = isLocal;
        ClassLoader cl = context.getClassLoader();
        try {
            this.bean = cl.loadClass(dd.getEjbImplClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.bean_class_not_found", "Bean class not found "));
        }
        if (isLocal) {
            compIntfName = dd.getLocalClassName();
            this.ejbClassSymbol = MethodDescriptor.EJB_LOCAL;
        } else {
            compIntfName = dd.getRemoteClassName();
            this.ejbClassSymbol = MethodDescriptor.EJB_REMOTE;
        }
        try {
            this.componentInterface = cl.loadClass(compIntfName);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Remote interface not found "));
        }
        if (isLocal) {
            this.wrapperBase = "com.sun.ejb.containers.EJBLocalObjectImpl";
            suffix = LOCAL_SUFFIX;
        } else {
            this.wrapperBase = "com.sun.ejb.containers.EJBObjectImpl";
            suffix = REMOTE_SUFFIX;
        }
        String wrapperClassName = this.getUniqueClassName(context, this.bean.getName(), suffix, existingClassNames);
        this.wrapperImpl = this.getBaseName(wrapperClassName);
        this.bizMethods = this.removeDups(this.componentInterface.getMethods());
        this.bizMethods = this.removeEJBObjectMethods(this.bizMethods);
    }

    private Method[] removeEJBObjectMethods(Method[] methods) {
        ArrayList<Method> newArray = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (this.isEJBObjectMethod(methods[i])) continue;
            newArray.add(methods[i]);
        }
        Method[] newMethods = new Method[newArray.size()];
        return newArray.toArray(newMethods);
    }

    private boolean isEJBObjectMethod(Method methodToCheck) {
        Class ejbObjectClz = this.isLocal ? EJBLocalObject.class : EJBObject.class;
        return this.isEJBIntfMethod(ejbObjectClz, methodToCheck);
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        String packageName = this.getPackageName(this.bean.getName());
        if (packageName != null) {
            p.pln("package " + packageName + ";");
        }
        p.plnI("public final class " + this.wrapperImpl + " extends " + this.wrapperBase + " implements " + this.componentInterface.getName() + " {");
        String[] methodVariables = this.printStaticMethodInit(p, this.componentInterface, this.bizMethods);
        p.plnI("public " + this.wrapperImpl + "() " + (this.isLocal ? "" : "throws java.rmi.RemoteException ") + "{");
        p.pOln("}");
        for (int i = 0; i < this.bizMethods.length; ++i) {
            this.printMethodImpl(p, this.bizMethods[i], methodVariables[i]);
        }
        p.pOln("}");
        p.close();
    }

    private void printMethodImpl(IndentingWriter p, Method m, String methodVar) throws IOException {
        int i;
        p.pln("");
        p.p("public " + this.printType(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 != 0) {
                p.p(", ");
            }
            p.p(this.printType(params[i2]) + " param" + i2);
        }
        p.p(") ");
        Class<?>[] exceptions = m.getExceptionTypes();
        for (i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                p.p("throws ");
            } else {
                p.p(", ");
            }
            p.p(exceptions[i].getName());
        }
        p.plnI("{");
        p.pln("com.sun.ejb.Invocation i = new com.sun.ejb.Invocation();");
        if (this.isLocal) {
            p.pln("i.isLocal = true;");
            p.pln("i.transactionAttribute = com.sun.ejb.Container." + this.getTxAttribute(this.dd, m) + ";");
            p.pln("i.securityPermissions = com.sun.ejb.Container." + this.getSecurityAttribute(this.dd, m) + ";");
        }
        p.pln("i.ejbObject = this;");
        p.pln("i.method = " + methodVar + ";");
        if (!m.getReturnType().isPrimitive()) {
            p.pln(this.printType(m.getReturnType()) + " $retVal = null;");
        } else if (m.getReturnType() != Void.TYPE) {
            if (m.getReturnType() == Boolean.TYPE) {
                p.pln(this.printType(m.getReturnType()) + " $retVal = false;");
            } else {
                p.pln(this.printType(m.getReturnType()) + " $retVal = 0;");
            }
        }
        p.pln("try {");
        p.pln("\tObject[] objarr = new Object[" + params.length + "];");
        p.p("\n");
        for (i = 0; i < params.length; ++i) {
            p.p("objarr[" + i + "] = ");
            Class<?> clazz = params[i];
            p.p(this.marshallPrimitiveToObject(clazz, i));
        }
        p.pln("\t\ti.methodParams = objarr;\n");
        p.pln("\tthis.getContainer().preInvoke(i);");
        p.pln("\tClass ejbClass = i.ejb.getClass();");
        p.pln("\tjava.lang.reflect.Method beanMethod = ejbClass.getMethod(i.method.getName(), i.method.getParameterTypes());");
        p.pln("\tObject obj = com.sun.enterprise.security.SecurityUtil.runMethod(beanMethod, i, i.ejb , objarr, this.getContainer());");
        Class<?> clazz = m.getReturnType();
        p.p(this.marshallObjectToPrimitive(clazz, "obj", "$retVal"));
        p.p("\n");
        p.pln("} catch(Throwable c) {");
        p.pln("\ti.exception = c;");
        p.pln("} finally {");
        p.pln("\tthis.getContainer().postInvoke(i);");
        p.pln("}");
        p.plnI("if (i.exception != null) {");
        p.pln("if(i.exception instanceof java.lang.RuntimeException) {");
        p.pln("\tthrow (java.lang.RuntimeException)i.exception; ");
        p.p("} ");
        if (!this.isLocal) {
            p.pln("else if(i.exception instanceof java.rmi.RemoteException) {");
            p.pln("\tthrow (java.rmi.RemoteException)i.exception; ");
            p.p("} ");
        }
        for (int i3 = 0; i3 < exceptions.length; ++i3) {
            if (exceptions[i3].getName().equals("java.rmi.RemoteException")) continue;
            p.pln("else if(i.exception instanceof " + exceptions[i3].getName() + ") {");
            p.pln("\tthrow (" + exceptions[i3].getName() + ")i.exception;");
            p.p("} ");
        }
        if (this.isLocal) {
            p.pln("else if (i.exception instanceof Exception) {");
            p.pln("\tthrow new javax.ejb.EJBException(\"Unknown exception\", (Exception)i.exception);");
            p.pln("}");
            p.pln("else {");
            p.pln("\tthrow new javax.ejb.EJBException(i.exception.getMessage());");
            p.pln("}");
        } else {
            p.pln("else {");
            p.pln("\tthrow new java.rmi.RemoteException(\"Unknown exception\", i.exception);");
            p.pln("}");
        }
        p.pOln("}");
        if (m.getReturnType() != Void.TYPE) {
            p.pln("return $retVal;");
        }
        p.pOln("}");
    }

    private String marshallPrimitiveToObject(Class clazz, int i) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return " new java.lang.Integer(param" + i + ");\n";
            }
            if (clazz == Boolean.TYPE) {
                return " java.lang.Boolean.valueOf(param" + i + ");\n";
            }
            if (clazz == Byte.TYPE) {
                return " new java.lang.Byte(param" + i + ");\n";
            }
            if (clazz == Short.TYPE) {
                return " new java.lang.Short(param" + i + ");\n";
            }
            if (clazz == Long.TYPE) {
                return " new java.lang.Long(param" + i + ");\n";
            }
            if (clazz == Float.TYPE) {
                return " new java.lang.Float(param" + i + ");\n";
            }
            if (clazz == Double.TYPE) {
                return " new java.lang.Double(param" + i + ");\n";
            }
            if (clazz == Character.TYPE) {
                return " new java.lang.Character(param" + i + ");\n";
            }
        }
        return "(java.lang.Object)param" + i + ";\n";
    }

    private String marshallObjectToPrimitive(Class clazz, String obj, String retVal) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return retVal + "= ((java.lang.Integer)" + obj + ").intValue();\n";
            }
            if (clazz == Boolean.TYPE) {
                return retVal + " = ((java.lang.Boolean)" + obj + ").booleanValue();\n";
            }
            if (clazz == Byte.TYPE) {
                return retVal + " = ((java.lang.Byte)" + obj + ").byteValue();\n";
            }
            if (clazz == Short.TYPE) {
                return retVal + " = ((java.lang.Short)" + obj + ").shortValue();\n";
            }
            if (clazz == Long.TYPE) {
                return retVal + " = ((java.lang.Long)" + obj + ").longValue();\n";
            }
            if (clazz == Float.TYPE) {
                return retVal + " = ((java.lang.Float)" + obj + ").floatValue();\n";
            }
            if (clazz == Double.TYPE) {
                return retVal + " = ((java.lang.Double)" + obj + ").doubleValue();\n";
            }
            if (clazz == Character.TYPE) {
                return retVal + " = ((java.lang.Character)" + obj + ").charValue();\n";
            }
            if (clazz == Void.TYPE) {
                return "\n";
            }
        }
        return retVal + "= (" + this.printType(clazz) + ") " + obj + ";\n";
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

