/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class LongHashMap {
    protected static final int DEFAULT_CAPACITY = 128;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static boolean debug = false;
    protected transient Entry[] table;
    protected float loadFactor;
    protected transient int size;
    protected int bucketmask;
    protected int capacity;
    protected int threshold;

    public LongHashMap() {
        this(128, 0.75f);
    }

    public LongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new Entry[this.capacity];
        this.bucketmask = this.capacity - 1;
    }

    public boolean contains(long key) {
        int index = (int)key & this.bucketmask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(long key) {
        int index = (int)key & this.bucketmask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(long key, Object value) {
        int index = (int)key & this.bucketmask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.table[index] = new Entry(key, value, this.table[index]);
        if (this.size++ >= this.threshold) {
            int newCapacity = 2 * this.capacity;
            Entry[] newTable = new Entry[newCapacity];
            this.transfer(newTable);
            this.table = newTable;
            this.capacity = newCapacity;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.bucketmask = this.capacity - 1;
        }
        return null;
    }

    private void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        int bucketmask = newCapacity - 1;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int index = (int)e.key & bucketmask;
                e.next = newTable[index];
                newTable[index] = e;
            } while ((e = next) != null);
        }
    }

    public Object remove(long key) {
        Entry prev;
        int index = (int)key & this.bucketmask;
        Entry e = prev = this.table[index];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                --this.size;
                if (prev == e) {
                    this.table[index] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public Enumeration elements() {
        Vector<Object> keyList = new Vector<Object>();
        for (int index = 0; index < this.capacity; ++index) {
            Entry e = this.table[index];
            while (e != null) {
                keyList.addElement(e.value);
                e = e.next;
            }
        }
        return keyList.elements();
    }

    public Iterator values() {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int index = 0; index < this.capacity; ++index) {
            Entry e = this.table[index];
            while (e != null) {
                keyList.add(e.value);
                e = e.next;
            }
        }
        return keyList.iterator();
    }

    public Iterator keys() {
        ArrayList<Long> keyList = new ArrayList<Long>();
        for (int index = 0; index < this.capacity; ++index) {
            Entry e = this.table[index];
            while (e != null) {
                keyList.add(new Long(e.key));
                e = e.next;
            }
        }
        return keyList.iterator();
    }

    static class Entry {
        final long key;
        Object value;
        Entry next;

        Entry(long k, Object v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }

        public int hashCode() {
            return (int)this.key;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

