/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.DomainStatusMBean;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DomainStatusHelper {
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager localStrings = StringManager.getManager(DomainStatusHelper.class);
    private static final Class[] DOMAIN_STATUS_INTERFACES = new Class[]{DomainStatusMBean.class};

    public DomainStatusHelper() {
    }

    public DomainStatusHelper(String serverName) {
    }

    public void setstate(String serverName, int state) {
        sLogger.log(Level.FINE, "DomainStatusHelper setstate for " + serverName);
        try {
            this.getDomainStatus().setstate(serverName, new Integer(state));
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "DomainStatusHelper setstate exception for server " + serverName, e);
        }
    }

    public int getstate(String serverName) throws Exception {
        sLogger.log(Level.FINE, "DomainStatusHelper getstate for " + serverName);
        return this.getDomainStatus().getstate(serverName);
    }

    protected DomainStatusMBean getDomainStatus() {
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        ObjectName on = null;
        try {
            on = DomainStatusHelper.getDomainStatusObjectName();
        }
        catch (MalformedObjectNameException mone) {
            sLogger.log(Level.WARNING, "DomainStatusHelper getDomainStatus ObjectName exception", mone);
        }
        DomainStatusMBean domainStatus = null;
        try {
            domainStatus = MBeanServerInvocationHandler.newProxyInstance(mbs, on, DomainStatusMBean.class, false);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "DomainStatusHelper getDomainStatus io exception", e);
        }
        return domainStatus;
    }

    public static ObjectName getDomainStatusObjectName() throws MalformedObjectNameException {
        ObjectName on = new ObjectName(ApplicationServer.getServerContext().getDefaultDomainName() + ":" + "name=domain-status");
        return on;
    }

    public static ObjectName getServersConfigObjectName() throws MalformedObjectNameException {
        ObjectName on = new ObjectName(ApplicationServer.getServerContext().getDefaultDomainName() + ":" + "type=servers,category=config");
        return on;
    }
}

